/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.handler;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.ui.dlg.FindingsSelectionDialog;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FindingCreateHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FindingsTemplate selection;
        FindingsSelectionDialog findingsSelectionDialog = new FindingsSelectionDialog(Display.getDefault().getActiveShell(), FindingsServiceHolder.findingsTemplateService.getFindingsTemplates("Standard Vorlagen"), Collections.emptyList(), false, null, false);
        if (findingsSelectionDialog.open() == 0 && (selection = findingsSelectionDialog.getSingleSelection()) != null) {
            try {
                IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
                if (patient != null) {
                    IFinding iFinding = FindingsServiceHolder.findingsTemplateService.createFinding(patient, selection);
                    Boolean okPressed = (Boolean)FindingsUiUtil.executeCommand((String)"ch.elexis.core.findings.ui.commandEdit", (IFinding)iFinding);
                    if (okPressed.booleanValue()) {
                        return iFinding;
                    }
                    try {
                        FindingsUiUtil.deleteFinding((IFinding)iFinding);
                    }
                    catch (ElexisException e) {
                        MessageDialog.openError((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Fehler", (String)e.getMessage());
                    }
                }
            }
            catch (ElexisException e) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Befunde Vorlagen", (String)e.getMessage());
            }
        }
        return null;
    }
}

