/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.util.internal;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LabPathologicEvaluator {
    private static Pattern refValuesPattern = Pattern.compile("\\((.*?)\\)");
    private final String SMALLER = "<";
    private final String BIGGER = ">";
    public static final String REFVAL_INCONCLUSIVE = "inconclusive";

    public EvaluationResult evaluate(ILabResult labResult) {
        ILabItem item = labResult.getItem();
        if (this.isNoReferenceValueItem(item)) {
            return new EvaluationResult(true, false, new PathologicDescription(PathologicDescription.Description.PATHO_REF_ITEM, Messages.LabResultEvaluator_LabItemNoRefValue));
        }
        if (LabItemTyp.ABSOLUTE == item.getTyp()) {
            return this.evaluateTextualResult(labResult, true);
        }
        if (LabItemTyp.TEXT == item.getTyp()) {
            return this.evaluateTextualResult(labResult, false);
        }
        if (LabItemTyp.DOCUMENT == item.getTyp()) {
            return new EvaluationResult(true, false, null);
        }
        return new EvaluationResult(false);
    }

    public boolean isPathologic(ILabResult labResult) {
        return this.isPathologic(labResult, true);
    }

    public boolean isPathologic(ILabResult labResult, boolean updateDescription) {
        String nr;
        if (labResult.getResult() == null) {
            return false;
        }
        EvaluationResult er = this.evaluate(labResult);
        if (er.isFinallyDetermined()) {
            if (updateDescription && er.getPathologicDescription() != null) {
                labResult.setPathologicDescription(er.getPathologicDescription());
            }
            return er.isPathologic();
        }
        boolean usedItemRef = false;
        if (labResult.getPatient().getGender() == Gender.MALE) {
            nr = labResult.getReferenceMale();
            usedItemRef = this.isUsingItemRef(labResult, Gender.MALE);
        } else {
            nr = labResult.getReferenceFemale();
            usedItemRef = this.isUsingItemRef(labResult, Gender.FEMALE);
        }
        List<String> refStrings = this.parseRefString(nr);
        if (labResult.getResult() != null && !refStrings.isEmpty() && !refStrings.get(0).isEmpty()) {
            Boolean testResult;
            if (updateDescription) {
                if (usedItemRef) {
                    labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_REF_ITEM, refStrings.get(0)));
                } else {
                    labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_REF, refStrings.get(0)));
                }
            }
            if ((testResult = this.testRef(refStrings.get(0), labResult.getResult())) != null) {
                return testResult;
            }
            if (updateDescription) {
                labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_NOREF, refStrings.get(0)));
            }
            return false;
        }
        if (updateDescription) {
            labResult.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_NOREF));
        }
        return false;
    }

    private boolean isUsingItemRef(ILabResult labResult, Gender gender) {
        boolean useLocalRefs = ModelUtil.isUserConfig(ModelUtil.getActiveUserContact().orElse(null), "lab/localRefValues", true);
        String localRef = "";
        String ref = "";
        if (gender == Gender.MALE) {
            localRef = labResult.getItem().getReferenceMale();
            ref = labResult.getReferenceMale();
        } else {
            localRef = labResult.getItem().getReferenceFemale();
            ref = labResult.getReferenceFemale();
        }
        if (useLocalRefs && localRef != null && !localRef.isEmpty()) {
            return true;
        }
        return ref == null || ref.isEmpty();
    }

    private boolean isNoReferenceValueItem(ILabItem item) {
        return REFVAL_INCONCLUSIVE.equals(item.getReferenceMale()) && REFVAL_INCONCLUSIVE.equals(item.getReferenceFemale());
    }

    private Object[] getReferenceValueForLabResult(ILabResult labResult) {
        Gender gender = labResult.getPatient().getGender();
        PathologicDescription.Description description = PathologicDescription.Description.PATHO_REF;
        String refValue = "";
        if (Gender.MALE == gender) {
            refValue = labResult.getReferenceMale();
            if (StringUtils.isEmpty((CharSequence)refValue)) {
                description = PathologicDescription.Description.PATHO_REF_ITEM;
                refValue = labResult.getItem().getReferenceMale();
            }
        } else {
            refValue = labResult.getReferenceFemale();
            if (StringUtils.isEmpty((CharSequence)refValue)) {
                description = PathologicDescription.Description.PATHO_REF_ITEM;
                refValue = labResult.getItem().getReferenceFemale();
            }
        }
        return new Object[]{refValue, description};
    }

    private EvaluationResult evaluateTextualResult(ILabResult labResult, boolean isAbsoluteItem) {
        String SELECTED_BASE;
        PathologicDescription.Description description;
        String lcResult = labResult.getResult().trim();
        Object[] ref = this.getReferenceValueForLabResult(labResult);
        String refValue = (String)ref[0];
        PathologicDescription.Description description2 = description = isAbsoluteItem ? PathologicDescription.Description.PATHO_ABSOLUT : (PathologicDescription.Description)ref[1];
        if (lcResult.equals(refValue)) {
            return new EvaluationResult(true, false, new PathologicDescription(description, lcResult));
        }
        if (isAbsoluteItem && (lcResult.toLowerCase().startsWith("pos") || lcResult.toLowerCase().startsWith("+"))) {
            return new EvaluationResult(true, true, new PathologicDescription(description, lcResult));
        }
        String string = SELECTED_BASE = isAbsoluteItem ? "lab/eval/tAbsolut/" : "lab/eval/tText/";
        if (ModelUtil.isConfig(String.valueOf(SELECTED_BASE) + "refValNonEqualResValMeansPath", false) && !lcResult.equalsIgnoreCase(refValue)) {
            return new EvaluationResult(true, true, new PathologicDescription(description, lcResult));
        }
        return new EvaluationResult(true, false, new PathologicDescription(PathologicDescription.Description.UNKNOWN, lcResult));
    }

    private List<String> parseRefString(String ref) {
        ArrayList<String> result = new ArrayList<String>();
        if (ref != null && !ref.isEmpty()) {
            Matcher m = refValuesPattern.matcher(ref);
            while (m.find()) {
                result.add(m.group(1).trim());
            }
            if (result.isEmpty()) {
                result.add(ref.trim());
            }
        }
        return result;
    }

    private Boolean testRef(String ref, String result) {
        try {
            String[] range;
            if (ref.trim().startsWith("<") || ref.trim().startsWith(">")) {
                String resultSign = null;
                double refVal = Double.parseDouble(ref.substring(1).trim());
                if (result.trim().startsWith("<") || result.trim().startsWith(">")) {
                    resultSign = result.substring(0, 1).trim();
                    result = result.substring(1).trim();
                }
                double val = Double.parseDouble(result);
                if (ref.trim().startsWith("<")) {
                    if (val >= refVal && (val != refVal || !"<".equals(resultSign))) {
                        return true;
                    }
                    return false;
                }
                if (val <= refVal && (val != refVal || !">".equals(resultSign))) {
                    return true;
                }
                return false;
            }
            if (ref.contains("-") && (range = ref.split("\\s*-\\s*")).length == 2) {
                double lower = Double.parseDouble(range[0]);
                double upper = Double.parseDouble(range[1]);
                double val = Double.parseDouble(result);
                if (!(val < lower) && !(val > upper)) {
                    return false;
                }
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static class EvaluationResult {
        private boolean finallyDetermined;
        private boolean isPathologic;
        private PathologicDescription pathologicDescription;

        public EvaluationResult(boolean finallyDetermined) {
            this.finallyDetermined = finallyDetermined;
        }

        public EvaluationResult(boolean finallyDetermined, boolean isPathologic, PathologicDescription pathologicDescription) {
            this.finallyDetermined = finallyDetermined;
            this.isPathologic = isPathologic;
            this.pathologicDescription = pathologicDescription;
        }

        public boolean isFinallyDetermined() {
            return this.finallyDetermined;
        }

        public PathologicDescription getPathologicDescription() {
            return this.pathologicDescription;
        }

        public boolean isPathologic() {
            return this.isPathologic;
        }
    }
}

