/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Role;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.rgw.tools.PasswordEncryptionService;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.slf4j.LoggerFactory;

public class User
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.User>
implements IdentifiableWithXid,
IUser {
    public User(ch.elexis.core.jpa.entities.User entity) {
        super((EntityWithId)entity);
    }

    public String getUsername() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).getId();
    }

    public void setUsername(String value) {
        ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setId(value);
    }

    public String getHashedPassword() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).getHashedPassword();
    }

    public void setHashedPassword(String value) {
        ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setHashedPassword(value);
    }

    public IContact getAssignedContact() {
        return ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.User)this.getEntity()).getKontakt(), IContact.class, true);
    }

    public void setAssignedContact(IContact value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setKontakt((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setKontakt(null);
        }
    }

    public List<IRole> getRoles() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).getRoles().parallelStream().map(r -> ModelUtil.getAdapter((EntityWithId)r, IRole.class)).collect(Collectors.toList());
    }

    public IRole addRole(IRole role) {
        if (role instanceof AbstractIdDeleteModelAdapter) {
            HashSet<Role> roles = new HashSet<Role>(((ch.elexis.core.jpa.entities.User)this.getEntity()).getRoles());
            roles.add((Role)((AbstractIdDeleteModelAdapter)role).getEntity());
            ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setRoles(roles);
        }
        return role;
    }

    public void removeRole(IRole role) {
        if (role instanceof AbstractIdDeleteModelAdapter) {
            HashSet roles = new HashSet(((ch.elexis.core.jpa.entities.User)this.getEntity()).getRoles());
            roles.remove(((AbstractIdDeleteModelAdapter)role).getEntity());
            ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setRoles(roles);
        }
    }

    public String getSalt() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).getSalt();
    }

    public void setSalt(String value) {
        ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setSalt(value);
    }

    public boolean isActive() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).isActive();
    }

    public void setActive(boolean value) {
        ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setActive(value);
    }

    public boolean isAllowExternal() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).isAllowExternal();
    }

    public void setAllowExternal(boolean value) {
        ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setAllowExternal(value);
    }

    public boolean isAdministrator() {
        return ((ch.elexis.core.jpa.entities.User)this.getEntity()).isAdministrator();
    }

    public void setAdministrator(boolean value) {
        ((ch.elexis.core.jpa.entities.User)this.getEntityMarkDirty()).setAdministrator(value);
    }

    public String getLabel() {
        return this.getId();
    }

    public IUser login(String username, char[] password) {
        if (this.isDeleted() || !username.equals(this.getUsername()) || !this.isActive()) {
            return null;
        }
        try {
            if (!new PasswordEncryptionService().authenticate(password, this.getHashedPassword(), this.getSalt())) {
                return null;
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
            LoggerFactory.getLogger(IUser.class).error("Error verifying password", e);
        }
        return this;
    }

    public boolean isInternal() {
        return true;
    }

    public Set<String> getContactIdsOfExecutiveDoctorsWorkingFor() {
        String mandators = (String)this.getAssignedContact().getExtInfo((Object)"Mandant");
        if (mandators == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(mandators.split(",")));
    }
}

