/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.types.Country;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.StringType;

public class IContactHelper
extends AbstractHelper {
    public String getOrganizationName(IOrganization organization) {
        StringBuilder sb = new StringBuilder();
        if (organization.isOrganization()) {
            if (organization.getDescription1() != null) {
                sb.append(organization.getDescription1());
            }
            if (organization.getDescription2() != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(organization.getDescription2());
            }
        }
        return sb.toString();
    }

    public List<Address> getAddresses(IContact contact) {
        ArrayList<Address> ret = new ArrayList<Address>();
        Address address = new Address();
        address.setUse(Address.AddressUse.HOME);
        address.setType(Address.AddressType.PHYSICAL);
        address.setCity(contact.getCity());
        address.setPostalCode(contact.getZip());
        address.setCountry(contact.getCountry() != null ? contact.getCountry().name() : null);
        ArrayList<StringType> lines = new ArrayList<StringType>();
        lines.add(new StringType(contact.getStreet()));
        address.setLine(lines);
        ret.add(address);
        Address postalAddress = new Address();
        postalAddress.setUse(Address.AddressUse.HOME);
        postalAddress.setType(Address.AddressType.POSTAL);
        postalAddress.setText(contact.getPostalAddress());
        ret.add(postalAddress);
        return ret;
    }

    public List<ContactPoint> getContactPoints(IContact contact) {
        ContactPoint contactPoint;
        ArrayList<ContactPoint> ret = new ArrayList<ContactPoint>();
        if (contact.getPhone1() != null && !contact.getPhone1().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            contactPoint.setRank(1);
            contactPoint.setValue(contact.getPhone1());
            ret.add(contactPoint);
        }
        if (contact.getPhone2() != null && !contact.getPhone2().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            contactPoint.setValue(contact.getPhone2());
            contactPoint.setRank(2);
            ret.add(contactPoint);
        }
        if (contact.getMobile() != null && !contact.getMobile().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            contactPoint.setUse(ContactPoint.ContactPointUse.MOBILE);
            contactPoint.setValue(contact.getMobile());
            ret.add(contactPoint);
        }
        if (contact.getEmail() != null && !contact.getEmail().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.EMAIL);
            contactPoint.setValue(contact.getEmail());
            ret.add(contactPoint);
        }
        if (contact.getWebsite() != null && !contact.getWebsite().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.URL);
            contactPoint.setValue(contact.getWebsite());
            ret.add(contactPoint);
        }
        if (contact.getFax() != null && !contact.getFax().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.FAX);
            contactPoint.setValue(contact.getFax());
            ret.add(contactPoint);
        }
        return ret;
    }

    public List<Identifier> getIdentifiers(IContact contact, IXidService xidService) {
        ArrayList<Identifier> ret = new ArrayList<Identifier>();
        List xids = xidService.getXids((Identifiable)contact);
        for (IXid xid : xids) {
            Identifier identifier = new Identifier();
            identifier.setSystem(xid.getDomain());
            identifier.setValue(xid.getDomainId());
            ret.add(identifier);
        }
        return ret;
    }

    public void mapIdentifiers(List<Identifier> identifiers, IContact target) {
        for (Identifier identifier : identifiers) {
            switch (identifier.getSystem()) {
                case "urn:oid:2.16.756.5.32": 
                case "www.ahv.ch/xid": {
                    target.addXid("www.ahv.ch/xid", identifier.getValue(), true);
                    break;
                }
                case "www.xid.ch/id/ean": {
                    target.addXid("www.xid.ch/id/ean", identifier.getValue(), true);
                    break;
                }
                case "urn:oid:2.51.1.3": {
                    target.addXid("www.xid.ch/id/recipient_ean", identifier.getValue(), true);
                    break;
                }
                case "https://www.bag.admin.ch/bag/bsv-nummer": {
                    target.addXid("www.xid.ch/id/kknum", identifier.getValue(), true);
                    break;
                }
            }
        }
    }

    public void mapAddress(List<Address> sourceAdresses, IContact target) {
        target.setCity(null);
        target.setZip(null);
        target.setStreet(null);
        target.setCountry(null);
        target.setPostalAddress(null);
        for (Address address : sourceAdresses) {
            if (address.getUse() == null) {
                address.setUse(Address.AddressUse.HOME);
            }
            if (address.getType() == null) {
                address.setType(Address.AddressType.PHYSICAL);
            }
            if (!Address.AddressUse.HOME.equals((Object)address.getUse())) continue;
            if (Address.AddressType.PHYSICAL.equals((Object)address.getType())) {
                target.setCity(address.getCity());
                target.setZip(address.getPostalCode());
                if (address.hasLine()) {
                    StringBuilder sb = new StringBuilder();
                    address.getLine().forEach(e -> {
                        StringBuilder stringBuilder2 = sb.append(e);
                    });
                    target.setStreet(sb.toString());
                }
                Country country = null;
                try {
                    country = Country.valueOf((String)address.getCountry());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
                target.setCountry(country);
            }
            if (!Address.AddressType.POSTAL.equals((Object)address.getType())) continue;
            String postalAddressText = address.getText();
            if (StringUtils.equals((CharSequence)target.getPostalAddress(), (CharSequence)postalAddressText)) continue;
            target.setPostalAddress(postalAddressText);
        }
    }

    public void mapTelecom(List<ContactPoint> sourceTelecoms, IContact target) {
        target.setMobile(null);
        target.setPhone1(null);
        target.setPhone2(null);
        target.setEmail(null);
        target.setFax(null);
        target.setWebsite(null);
        for (ContactPoint contactPoint : sourceTelecoms) {
            if (ContactPoint.ContactPointSystem.PHONE.equals((Object)contactPoint.getSystem())) {
                if (ContactPoint.ContactPointUse.MOBILE.equals((Object)contactPoint.getUse())) {
                    target.setMobile(contactPoint.getValue());
                    continue;
                }
                if (contactPoint.getRank() == 0 || 1 == contactPoint.getRank()) {
                    target.setPhone1(contactPoint.getValue());
                    continue;
                }
                if (2 != contactPoint.getRank()) continue;
                target.setPhone2(contactPoint.getValue());
                continue;
            }
            if (ContactPoint.ContactPointSystem.EMAIL.equals((Object)contactPoint.getSystem())) {
                target.setEmail(contactPoint.getValue());
                continue;
            }
            if (ContactPoint.ContactPointSystem.FAX.equals((Object)contactPoint.getSystem())) {
                target.setFax(contactPoint.getValue());
                continue;
            }
            if (!ContactPoint.ContactPointSystem.URL.equals((Object)contactPoint.getSystem())) continue;
            target.setWebsite(contactPoint.getValue());
        }
    }

    public Attachment mapContactImage(IContact source) {
        IImage image = source.getImage();
        Attachment contactImage = null;
        if (image != null) {
            Attachment _image = new Attachment();
            MimeType mimeType = image.getMimeType();
            _image.setContentType(mimeType != null ? mimeType.getContentType() : null);
            _image.setData(image.getImage());
            contactImage = _image;
        }
        return contactImage;
    }

    public void mapContactImage(IModelService coreModelService, Attachment photo, IPerson target) {
        if (photo != null && !photo.isEmpty()) {
            Attachment fhirImage = photo;
            IImage image = (IImage)coreModelService.create(IImage.class);
            image.setDate(LocalDate.now());
            String contentType = fhirImage.getContentTypeElement().asStringValue();
            MimeType mimeType = MimeType.getByContentType((String)contentType);
            image.setMimeType(mimeType);
            image.setImage(fhirImage.getData());
            target.setImage(image);
        } else {
            target.setImage(null);
        }
    }
}

