/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.internal;

import ch.elexis.core.mail.IMailClient;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IMessageTransporter;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.status.ObjectStatus;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class MailTransporter
implements IMessageTransporter {
    @Reference
    private IConfigService configService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IMailClient mailClient;

    public String getUriScheme() {
        return "mailto";
    }

    public boolean isExternal() {
        return true;
    }

    public IStatus send(TransientMessage transientMessage) {
        String jobID = UUID.randomUUID().toString();
        String receiver = transientMessage.getReceiver();
        String text = transientMessage.getMessageText();
        Map messageCodes = transientMessage.getMessageCodes();
        String subject = null;
        String search = "Subject:";
        int index = text.indexOf(search);
        if (index != -1) {
            int startIndex = index + search.length();
            int endIndex = text.indexOf("\n", startIndex);
            if (endIndex == -1) {
                endIndex = text.length();
            }
            subject = text.substring(startIndex, endIndex).trim();
        }
        String onlyText = text.substring(text.indexOf("\n") + 1);
        Optional<MailAccount> account = this.mailClient.getAccount((String)messageCodes.get("account.id"));
        if (account.get() == null) {
            String defaultAccount = this.configService.get("account", null);
            account = this.mailClient.getAccount(defaultAccount);
        }
        if (StringUtils.isEmpty((CharSequence)receiver)) {
            return new Status(4, MailTransporter.class.getPackageName(), "Patient hat keine E-Mail Adresse");
        }
        MailMessage message = new MailMessage().to(receiver).subject(subject).text(onlyText);
        this.mailClient.sendMail(account.get(), message);
        return ObjectStatus.OK_STATUS((Object)("mail send: " + jobID));
    }
}

