/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.XidQuality;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.services.XidDomain;
import ch.elexis.core.services.internal.TransientXid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class XidService
implements IXidService {
    private Logger logger = LoggerFactory.getLogger(XidService.class);
    private HashMap<String, XidDomain> domains = new HashMap();
    private HashMap<String, String> domainMap = new HashMap();
    @Reference
    private IConfigService configService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAccessControlService accessControlService;

    @Activate
    private void activate() {
        this.accessControlService.doPrivileged(() -> this.loadDomains());
    }

    public IXidService.IXidDomain getDomain(String name) {
        String dom = this.domainMap.get(name);
        if (dom != null) {
            name = dom;
        }
        return this.domains.get(name);
    }

    public List<IXidService.IXidDomain> getDomains() {
        return new ArrayList<IXidService.IXidDomain>(this.domains.values());
    }

    private void loadDomains() {
        String storedDomains = this.configService.get("LocalXIDDomains", null);
        if (storedDomains != null) {
            this.loadDomainsSplitString(storedDomains);
        }
        this.localRegisterXIDDomainIfNotExists("www.elexis.ch/xid", "UUID", 5, "ch.elexis.data.PersistentObject");
        this.localRegisterXIDDomainIfNotExists("www.ahv.ch/xid", "AHV", 2, "ch.elexis.data.Person");
        this.localRegisterXIDDomainIfNotExists("www.xid.ch/id/oid", "OID", 7, "ch.elexis.data.PersistentObject");
        this.localRegisterXIDDomainIfNotExists("www.xid.ch/id/ean", "EAN", 2, "ch.elexis.data.Kontakt,ch.elexis.data.Person,ch.elexis.data.Organisation");
        this.localRegisterXIDDomainIfNotExists("www.xid.ch/id/kknum", "BSV-Nummer", 2, "ch.elexis.data.Organisation");
        this.localRegisterXIDDomainIfNotExists("www.xid.ch/id/recipient_ean", "rEAN", 2, "ch.elexis.data.Kontakt,ch.elexis.data.Person,ch.elexis.data.Organisation");
    }

    private void loadDomainsSplitString(String storedDomains) {
        String[] stringArray = storedDomains.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String domainString = stringArray[n2];
            String[] spl = domainString.split("#");
            if (spl.length < 2) {
                this.logger.error("Fehler in XID-Domain " + domainString);
            }
            String simpleName = "";
            if (spl.length >= 3) {
                simpleName = spl[2];
            }
            String displayOptions = "Kontakt";
            if (spl.length >= 4) {
                displayOptions = spl[3];
            }
            this.domains.put(spl[0], new XidDomain(spl[0], simpleName, Integer.parseInt(spl[1]), displayOptions));
            this.domainMap.put(simpleName, spl[0]);
            ++n2;
        }
    }

    private void storeDomains() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.domains.keySet()) {
            XidDomain xd = this.domains.get(k);
            sb.append(k).append("#").append(xd.getQuality()).append("#").append(xd.getSimpleName()).append("#").append(xd.getDisplayOptions()).append(";");
        }
        this.configService.set("LocalXIDDomains", sb.toString());
    }

    public IXidService.IXidDomain localRegisterXIDDomain(String domainName, String simpleName, int quality) {
        return this.localRegisterXIDDomain(domainName, simpleName, quality, "");
    }

    private IXidService.IXidDomain localRegisterXIDDomain(String domainName, String simpleName, int quality, String displayOptions) {
        if (this.domains.containsKey(domainName)) {
            this.logger.error("XID Domain " + domainName + " bereits registriert");
        } else if (domainName.matches(".*[;#].*")) {
            this.logger.error("XID Domain " + domainName + " ung\u00fcltig");
        } else {
            XidDomain created = new XidDomain(domainName, simpleName == null ? "" : simpleName, quality, displayOptions);
            this.domains.put(domainName, created);
            if (simpleName != null) {
                this.domainMap.put(simpleName, domainName);
            }
            this.storeDomains();
            return created;
        }
        return null;
    }

    public IXidService.IXidDomain localRegisterXIDDomainIfNotExists(String domainName, String simpleName, int quality) {
        return this.localRegisterXIDDomain(domainName, simpleName, quality, "");
    }

    private IXidService.IXidDomain localRegisterXIDDomainIfNotExists(String domainName, String simpleName, int quality, String displayOptions) {
        XidDomain existing = this.domains.get(domainName);
        if (existing == null) {
            return this.localRegisterXIDDomain(domainName, simpleName, quality, displayOptions);
        }
        return existing;
    }

    public <T> Optional<T> findObject(String domainName, String domainId, Class<T> clazz) {
        List<T> ret = this.findObjects(domainName, domainId, clazz);
        if (ret.size() == 1) {
            return Optional.of(ret.get(0));
        }
        if (ret.size() > 1) {
            throw new IllegalStateException("Found more than one object for [" + domainName + "] [" + domainId + "]");
        }
        return Optional.empty();
    }

    public <T> List<T> findObjects(String domainName, String domainId, Class<T> clazz) {
        String dom = this.domainMap.get(domainName);
        if (dom != null) {
            domainName = dom;
        }
        INamedQuery query = this.coreModelService.getNamedQuery(IXid.class, new String[]{"domain", "domainid"});
        List xids = query.executeWithParameters(query.getParameterMap(new Object[]{"domain", domainName, "domainid", domainId}));
        List ret = xids.parallelStream().map(iXid -> iXid.getObject(clazz)).filter(Objects::nonNull).collect(Collectors.toList());
        return ret;
    }

    public String getDomainName(String domainName) {
        String dom = this.domainMap.get(domainName);
        if (dom != null) {
            return dom;
        }
        return domainName;
    }

    public boolean addXid(Identifiable identifiable, String domain, String id, boolean updateIfExists) {
        IXid existing = this.getXid(identifiable, domain = this.getDomainName(domain));
        if (existing != null) {
            if (updateIfExists) {
                IXid xid = existing;
                xid.setDomain(domain);
                xid.setDomainId(id);
                xid.setObject((Object)identifiable);
                this.coreModelService.save((Identifiable)xid);
                return true;
            }
        } else {
            int val;
            IXid xid = (IXid)this.coreModelService.create(IXid.class);
            xid.setDomain(domain);
            xid.setDomainId(id);
            xid.setObject((Object)identifiable);
            XidDomain xidDomain = this.domains.get(domain);
            if (xidDomain != null) {
                val = xidDomain.getQuality();
                if (val > 9) {
                    val = (val & 7) + 4;
                }
            } else {
                this.logger.error("XID Domain " + domain + " is not registered");
                return false;
            }
            xid.setQuality(XidQuality.ofValue((int)val));
            this.coreModelService.save((Identifiable)xid);
            return true;
        }
        return false;
    }

    public IXid getXid(Identifiable identifiable, String domain) {
        if ("www.elexis.ch/xid".equals(domain)) {
            return new TransientXid("www.elexis.ch/xid", identifiable.getId(), XidQuality.ASSIGNMENT_LOCAL_QUALITY_GUID, identifiable);
        }
        INamedQuery query = this.coreModelService.getNamedQuery(IXid.class, new String[]{"domain", "objectid"});
        List xids = query.executeWithParameters(query.getParameterMap(new Object[]{"domain", domain, "objectid", identifiable.getId()}));
        if (xids.size() > 0) {
            if (xids.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).error("XID [" + domain + "] [" + identifiable.getId() + "] on multiple objects, returning first.");
            }
            return (IXid)xids.get(0);
        }
        return null;
    }

    public List<IXid> getXids(Identifiable identifiable) {
        INamedQuery query = this.coreModelService.getNamedQuery(IXid.class, new String[]{"objectid"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"objectid", identifiable.getId()}));
    }
}

