/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import bsh.EvalError;
import bsh.Interpreter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.ILabService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.LabItemTyp;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LabService
implements ILabService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern varPattern = Pattern.compile("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]");

    public Result<String> evaluate(ILabResult labResult) {
        if (LabItemTyp.FORMULA != labResult.getItem().getTyp()) {
            return Result.OK((String)labResult.getResult());
        }
        ILabItem item = labResult.getItem();
        if (item == null) {
            return Result.ERROR((String)"Missing LabItem");
        }
        String evaluationResult = null;
        IQuery query = this.modelService.getQuery(ILabOrder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__RESULT, IQuery.COMPARATOR.EQUALS, (Object)labResult);
        Optional labOrder = query.executeSingleResult();
        if (labOrder.isPresent()) {
            List<ILabResult> labresults = this.findAllLabResultsForLabOrderIdGroup((ILabOrder)labOrder.get());
            evaluationResult = this.evaluate(((ILabOrder)labOrder.get()).getItem(), labResult.getPatient(), labresults);
        }
        if (evaluationResult == null || evaluationResult.equals("?formel?")) {
            evaluationResult = this.evaluate(labResult.getItem(), labResult.getPatient(), new TimeTool(labResult.getObservationTime()));
        }
        if (evaluationResult == null || "".equals(evaluationResult) || "?formel?".equals(evaluationResult)) {
            return Result.ERROR((String)evaluationResult);
        }
        return Result.OK((String)evaluationResult);
    }

    private List<ILabResult> findAllLabResultsForLabOrderIdGroup(ILabOrder labOrder) {
        List<ILabOrder> ordersWithResult = this.getLabOrdersInSameOrderIdGroup(labOrder, true);
        return ordersWithResult.stream().map(owr -> owr.getResult()).filter(result -> !result.isDeleted()).collect(Collectors.toList());
    }

    private String evaluate(ILabItem labItem, IPatient patient, TimeTool date) {
        IQuery qbe = this.modelService.getQuery(ILabResult.class);
        qbe.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        qbe.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__DATE, IQuery.COMPARATOR.EQUALS, (Object)date.toLocalDate());
        List results = qbe.execute();
        return this.evaluate(labItem, patient, results);
    }

    public List<ILabOrder> getLabOrdersInSameOrderIdGroup(ILabOrder labOrder, boolean nonEmptyResultsOnly) {
        IQuery query = this.modelService.getQuery(ILabOrder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)labOrder.getPatient());
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__ORDER_ID, IQuery.COMPARATOR.EQUALS, (Object)labOrder.getOrderId());
        if (nonEmptyResultsOnly) {
            query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__RESULT, IQuery.COMPARATOR.NOT_EQUALS, null);
        }
        return query.execute();
    }

    private String evaluate(ILabItem labItem, IPatient patient, List<ILabResult> labresults) {
        String var;
        String formula = labItem.getFormula();
        this.log.trace("Evaluating formula [" + formula + "]");
        if (formula.startsWith("SCRIPT:")) {
            this.log.warn("Script elements currently not supported, returning empty String. LabItem [" + labItem.getId() + "]");
            return "";
        }
        boolean bMatched = false;
        labresults = this.sortResultsDescending(labresults);
        for (ILabResult result : labresults) {
            var = result.getItem().getVariableName();
            if (formula.indexOf(var) == -1 || result.getResult() == null || result.getResult().isEmpty() || result.getResult().equals("?")) continue;
            formula = formula.replaceAll(var, result.getResult());
            bMatched = true;
        }
        Matcher matcher = varPattern.matcher(formula);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            var = matcher.group();
            String[] fields = var.split("\\.");
            if (fields.length <= 1) continue;
            String val = this.getPersistentObjectAttributeMapping(patient, fields[1].replaceFirst("\\]", ""));
            String repl = "\"" + val + "\"";
            matcher.appendReplacement(sb, repl);
            bMatched = true;
        }
        matcher.appendTail(sb);
        if (!bMatched) {
            return null;
        }
        try {
            Interpreter bshInterpreter = new Interpreter();
            return bshInterpreter.eval(sb.toString()).toString();
        }
        catch (Exception e) {
            if (e instanceof EvalError) {
                this.log.info("Error evaluating formula [{}], returning ?formel?.", (Object)sb.toString());
            } else {
                this.log.warn("Error evaluating formula [{}], returning ?formel?.", (Object)sb.toString(), (Object)e);
            }
            return "?formel?";
        }
    }

    private List<ILabResult> sortResultsDescending(List<ILabResult> results) {
        Collections.sort(results, new Comparator<ILabResult>(){

            @Override
            public int compare(ILabResult lr1, ILabResult lr2) {
                int var2Length;
                int var1Length = lr1.getItem().getVariableName().length();
                if (var1Length < (var2Length = lr2.getItem().getVariableName().length())) {
                    return 1;
                }
                if (var1Length > var2Length) {
                    return -1;
                }
                return 0;
            }
        });
        return results;
    }

    private String getPersistentObjectAttributeMapping(IPatient patient, String value) {
        switch (value = value.toLowerCase()) {
            case "geschlecht": {
                return patient.getGender().name();
            }
            case "alter": {
                return Integer.toString(patient.getAgeInYears());
            }
        }
        this.log.warn("Could not map attribute Patient@[" + value + "], returning empty string.");
        return "";
    }

    public Optional<ILabMapping> getLabMappingByContactAndItem(IContact contact, ILabItem item) {
        IQuery qbe = this.modelService.getQuery(ILabMapping.class);
        qbe.and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ORIGIN, IQuery.COMPARATOR.EQUALS, (Object)contact);
        qbe.and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ITEM, IQuery.COMPARATOR.EQUALS, (Object)item);
        return qbe.executeSingleResult();
    }

    public List<ILabResult> getLabResultsForPatientWithItemType(IPatient patient, LabItemTyp type, boolean includeDeleted) {
        INamedQuery query = this.modelService.getNamedQuery(ILabResult.class, new String[]{"patient", "itemtype", "includesDeleted"});
        Map parameterMap = query.getParameterMap(new Object[]{"patient", patient, "itemtype", type});
        List results = query.executeWithParameters(parameterMap);
        if (!includeDeleted) {
            return results.stream().filter(lr -> !lr.isDeleted()).collect(Collectors.toList());
        }
        return results;
    }
}

