/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mail.ui.dialogs.SendMailDialog;
import ch.elexis.core.mail.ui.handlers.SendMailTaskWithProgress;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.TaskState;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.handlers.HandlerUtil;

public class SendMailHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String text;
        String subject;
        String to;
        String documents;
        SendMailDialog sendMailDialog = new SendMailDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        String attachments = event.getParameter("ch.elexis.core.mail.ui.sendMail.attachments");
        if (attachments != null) {
            sendMailDialog.setAttachmentsString(attachments);
        }
        if ((documents = event.getParameter("ch.elexis.core.mail.ui.sendMail.documents")) != null) {
            sendMailDialog.setDocumentsString(documents);
        }
        if ((to = event.getParameter("ch.elexis.core.mail.ui.sendMail.to")) != null) {
            sendMailDialog.setTo(to);
        }
        if ((subject = event.getParameter("ch.elexis.core.mail.ui.sendMail.subject")) != null) {
            sendMailDialog.setSubject(subject);
        }
        if ((text = event.getParameter("ch.elexis.core.mail.ui.sendMail.text")) != null) {
            sendMailDialog.setText(text);
        }
        if (sendMailDialog.open() == 0) {
            MailMessage message = new MailMessage().to(sendMailDialog.getTo()).cc(sendMailDialog.getCc()).subject(sendMailDialog.getSubject()).text(sendMailDialog.getText());
            message.setAttachments(sendMailDialog.getAttachmentsString());
            message.setDocuments(sendMailDialog.getDocumentsString());
            Optional taskDescriptor = TaskUtil.createSendMailTaskDescriptor((String)sendMailDialog.getAccount().getId(), (MailMessage)message);
            if (taskDescriptor.isPresent()) {
                ITask task = new SendMailTaskWithProgress().execute(HandlerUtil.getActiveShell((ExecutionEvent)event), (ITaskDescriptor)taskDescriptor.get());
                if (task.getState() == TaskState.COMPLETED) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

