/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.util;

import ch.elexis.core.model.IImage;
import ch.elexis.core.model.ISticker;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class CoreUiUtil
implements EventHandler {
    private static Logger logger = LoggerFactory.getLogger(CoreUiUtil.class);
    private static Object lock = new Object();
    private static List<Object> delayedInjection = new ArrayList<Object>();
    private static IEclipseContext applicationContext;
    private static IEclipseContext serviceContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        logger.info("APPLICATION STARTUP COMPLETE");
        Object object = lock;
        synchronized (object) {
            Object property = event.getProperty("org.eclipse.e4.data");
            if (property instanceof MApplication) {
                MApplication application = (MApplication)property;
                applicationContext = application.getContext();
                if (!delayedInjection.isEmpty()) {
                    for (Object object2 : delayedInjection) {
                        Display.getDefault().asyncExec(() -> CoreUiUtil.injectServices(object2));
                    }
                    delayedInjection.clear();
                }
            }
        }
    }

    private static IEclipseContext getServiceContext() {
        BundleContext bundleContext = FrameworkUtil.getBundle(CoreUiUtil.class).getBundleContext();
        return EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
    }

    public static void injectServices(Object object) {
        if (applicationContext != null) {
            try {
                ContextInjectionFactory.inject((Object)object, (IEclipseContext)applicationContext);
                return;
            }
            catch (InjectionException e) {
                logger.warn("Application context injection failure ", (Throwable)e);
            }
        }
        if (serviceContext == null) {
            serviceContext = CoreUiUtil.getServiceContext();
        }
        try {
            ContextInjectionFactory.inject((Object)object, (IEclipseContext)serviceContext);
        }
        catch (InjectionException e) {
            logger.warn("Service injection failure ", (Throwable)e);
        }
    }

    public static void uninjectServices(Object object) {
        if (serviceContext == null) {
            serviceContext = CoreUiUtil.getServiceContext();
        }
        try {
            ContextInjectionFactory.uninject((Object)object, (IEclipseContext)serviceContext);
        }
        catch (InjectionException e) {
            logger.warn("Service injection failure ", (Throwable)e);
        }
        if (applicationContext != null) {
            try {
                ContextInjectionFactory.uninject((Object)object, (IEclipseContext)applicationContext);
            }
            catch (InjectionException e) {
                logger.warn("Application context injection failure ", (Throwable)e);
            }
        }
    }

    public static void injectServices(Object object, IEclipseContext context) {
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
    }

    public static void uninjectServices(Object object, IEclipseContext context) {
        ContextInjectionFactory.uninject((Object)object, (IEclipseContext)context);
    }

    public static boolean isActiveControl(Control control) {
        return control != null && !control.isDisposed() && control.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectServicesWithContext(Object object) {
        Object object2 = lock;
        synchronized (object2) {
            if (applicationContext != null) {
                CoreUiUtil.injectServices(object);
            } else {
                delayedInjection.add(object);
            }
        }
    }

    public static void updateFixLayout(MPart part, boolean state) {
        part.setCloseable(state);
        part.setCloseable(!state);
        if (state) {
            if (!part.getTags().contains("NoMove")) {
                part.getTags().add("NoMove");
            }
        } else {
            part.getTags().remove("NoMove");
        }
    }

    public static Color getColorForString(String colorString) {
        colorString = StringUtils.leftPad((String)colorString, (int)6, (char)'0');
        if (!JFaceResources.getColorRegistry().hasValueFor(colorString)) {
            RGB rgb;
            try {
                rgb = new RGB(Integer.parseInt(colorString.substring(0, 2), 16), Integer.parseInt(colorString.substring(2, 4), 16), Integer.parseInt(colorString.substring(4, 6), 16));
            }
            catch (NumberFormatException nex) {
                logger.warn("Error parsing color string [" + colorString + "]", (Throwable)nex);
                rgb = new RGB(100, 100, 100);
            }
            JFaceResources.getColorRegistry().put(colorString, rgb);
        }
        return JFaceResources.getColorRegistry().get(colorString);
    }

    public static Image getImageAsIcon(IImage image) {
        Image origImage;
        Image ret = JFaceResources.getImageRegistry().get(String.valueOf(image.getId()) + "_16x16");
        if (ret == null && (ret = CoreUiUtil.getImageScaledTo(origImage = CoreUiUtil.getImage(image), 16, 16, false)) != null) {
            JFaceResources.getImageRegistry().put(String.valueOf(image.getId()) + "_16x16", ret);
        }
        return ret;
    }

    private static Image getImageScaledTo(Image orig, int width, int height, boolean bShrinkOnly) {
        ImageData idata = orig.getImageData();
        if (idata.width != width || idata.height != height) {
            idata = idata.scaledTo(width, height);
        }
        Image ret = new Image((Device)Display.getDefault(), idata);
        return ret;
    }

    public static Image getImage(IImage image) {
        Image ret = JFaceResources.getImageRegistry().get(image.getId());
        if (ret == null) {
            byte[] in = image.getImage();
            ByteArrayInputStream bais = new ByteArrayInputStream(in);
            try {
                ImageData idata = new ImageData((InputStream)bais);
                ret = new Image((Device)Display.getDefault(), idata);
                if (ret != null) {
                    JFaceResources.getImageRegistry().put(image.getId(), ret);
                }
            }
            catch (Exception ex) {
                logger.error("Error loading image [" + image.getId() + "]", (Throwable)ex);
            }
        }
        return ret;
    }

    public static Composite createForm(Composite parent, ISticker iSticker) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Image img = null;
        if (iSticker.getImage() != null) {
            img = CoreUiUtil.getImageAsIcon(iSticker.getImage());
        }
        GridData gd1 = null;
        GridData gd2 = null;
        Composite cImg = new Composite(ret, 0);
        if (img != null) {
            cImg.setBackgroundImage(img);
            gd1 = new GridData(img.getBounds().width, img.getBounds().height);
            gd2 = new GridData(-1, img.getBounds().height);
        } else {
            gd1 = new GridData(10, 10);
            gd2 = new GridData(-1, -1);
        }
        cImg.setLayoutData((Object)gd1);
        Label lbl = new Label(ret, 0);
        lbl.setLayoutData((Object)gd2);
        lbl.setText(iSticker.getLabel());
        lbl.setForeground(CoreUiUtil.getColorForString(iSticker.getForeground()));
        lbl.setBackground(CoreUiUtil.getColorForString(iSticker.getBackground()));
        return ret;
    }

    public static StructuredSelection getCommandSelection(String commandId) {
        return CoreUiUtil.getCommandSelection(commandId, true);
    }

    public static StructuredSelection getCommandSelection(String commandId, boolean remove) {
        StructuredSelection selection = (StructuredSelection)applicationContext.get(commandId.concat(".selection"));
        if (remove) {
            applicationContext.remove(commandId.concat(".selection"));
        }
        return selection;
    }

    public static void setCommandSelection(String commandId, Object[] selection) {
        applicationContext.set(commandId.concat(".selection"), (Object)new StructuredSelection(selection));
    }

    public static void removeCommandSelection(String commandId) {
        applicationContext.remove(commandId.concat(".selection"));
    }

    public static void setCommandSelection(String commandId, List<?> selection) {
        CoreUiUtil.setCommandSelection(commandId, selection.toArray());
    }

    private static Control getAsControl(Object object) {
        if (object != null) {
            if (object instanceof Control) {
                return (Control)object;
            }
            if (object instanceof Viewer) {
                return ((Viewer)object).getControl();
            }
            try {
                if (object.getClass().getMethod("getViewerWidget", new Class[0]) != null) {
                    Method method = object.getClass().getMethod("getViewerWidget", null);
                    Object viewerWidget = method.invoke(object, null);
                    if (viewerWidget instanceof StructuredViewer) {
                        return ((StructuredViewer)viewerWidget).getControl();
                    }
                    if (viewerWidget instanceof Control) {
                        return (Control)viewerWidget;
                    }
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(CoreUiUtil.class).warn("Error getting viewer widget of [" + object + "]", (Throwable)e);
            }
            LoggerFactory.getLogger(CoreUiUtil.class).warn("Can not get Control from [" + object + "]");
        }
        return null;
    }

    public static void runAsyncIfActive(Runnable runnable, Object object) {
        Control control = CoreUiUtil.getAsControl(object);
        if (control != null) {
            Display.getDefault().asyncExec(() -> {
                if (CoreUiUtil.isActiveControl(control)) {
                    runnable.run();
                }
            });
        }
    }

    public static void runIfActive(Runnable runnable, Object object) {
        Control control = CoreUiUtil.getAsControl(object);
        if (control != null) {
            Display.getDefault().syncExec(() -> {
                if (CoreUiUtil.isActiveControl(control)) {
                    runnable.run();
                }
            });
        }
    }
}

