/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherMetafileBlip;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.ddf.EscherSplitMenuColorsRecord;
import org.apache.poi.ddf.EscherTertiaryOptRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.ddf.UnknownEscherRecord;
import org.apache.poi.util.LittleEndian;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherTertiaryOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord escherRecord;
        short recordId;
        short options = LittleEndian.getShort(data, offset);
        if (DefaultEscherRecordFactory.isContainer(options, recordId = LittleEndian.getShort(data, offset + 2))) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(recordId);
            r.setOptions(options);
            return r;
        }
        if (recordId >= EscherBlipRecord.RECORD_ID_START && recordId <= EscherBlipRecord.RECORD_ID_END) {
            EscherBlipRecord r = recordId == EscherBitmapBlip.RECORD_ID_DIB || recordId == EscherBitmapBlip.RECORD_ID_JPEG || recordId == EscherBitmapBlip.RECORD_ID_PNG ? new EscherBitmapBlip() : (recordId == EscherMetafileBlip.RECORD_ID_EMF || recordId == EscherMetafileBlip.RECORD_ID_WMF || recordId == EscherMetafileBlip.RECORD_ID_PICT ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(recordId);
            r.setOptions(options);
            return r;
        }
        Constructor<? extends EscherRecord> recordConstructor = recordsMap.get(recordId);
        if (recordConstructor == null) {
            return new UnknownEscherRecord();
        }
        try {
            escherRecord = recordConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new UnknownEscherRecord();
        }
        escherRecord.setRecordId(recordId);
        escherRecord.setOptions(options);
        return escherRecord;
    }

    protected static Map<Short, Constructor<? extends EscherRecord>> recordsToMap(Class<?>[] recClasses) {
        HashMap<Short, Constructor<? extends EscherRecord>> result = new HashMap<Short, Constructor<? extends EscherRecord>>();
        Class[] EMPTY_CLASS_ARRAY = new Class[]{};
        Class<?>[] classArray = recClasses;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor;
            short sid;
            Class<?> recClass;
            Class<?> recCls = recClass = classArray[i];
            try {
                sid = recCls.getField("RECORD_ID").getShort(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            try {
                constructor = recCls.getConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            result.put(sid, constructor);
        }
        return result;
    }

    public static boolean isContainer(short options, short recordId) {
        if (recordId >= EscherContainerRecord.DGG_CONTAINER && recordId <= EscherContainerRecord.SOLVER_CONTAINER) {
            return true;
        }
        if (recordId == EscherTextboxRecord.RECORD_ID) {
            return false;
        }
        return (options & 0xF) == 15;
    }
}

