/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers;

import ch.elexis.core.importer.div.importers.DefaultLabItemResolver;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.ILabItemResolver;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.Messages;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.HL7ReaderFactory;
import ch.elexis.hl7.model.AbstractData;
import ch.elexis.hl7.model.EncapsulatedData;
import ch.elexis.hl7.model.IValueType;
import ch.elexis.hl7.model.LabResultData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.model.TextData;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7Parser {
    private static final Logger logger = LoggerFactory.getLogger(HL7Parser.class);
    public static final String CFG_IMPORT_ENCDATA = "hl7Parser/importencdata";
    public static final String CFG_IMPORT_ENCDATA_CATEGORY = "hl7Parser/importencdataCategory";
    private HL7PatientResolver patientResolver;
    public String myLab = "?";
    public HL7Reader hl7Reader;
    private IPatient pat;
    private TimeTool date;
    private TimeTool commentDate;
    private ILabImportUtil labImportUtil;
    private ILabContactResolver labContactResolver;
    private ImportHandler importHandler;
    private boolean importEncapsulatedData;

    public HL7Parser(String mylab, HL7PatientResolver patientResolver, ImportHandler importHandler, ILabContactResolver labContactResolver, boolean importEncapsulatedData) {
        this(mylab, patientResolver, LabImportUtilHolder.get(), importHandler, labContactResolver, importEncapsulatedData);
    }

    public HL7Parser(String mylab, HL7PatientResolver patientResolver, ILabImportUtil labImportUtil, ImportHandler importHandler, ILabContactResolver labContactResolver, boolean importEncapsulatedData) {
        this.myLab = mylab;
        this.patientResolver = patientResolver;
        this.labImportUtil = labImportUtil;
        this.importHandler = importHandler;
        this.labContactResolver = labContactResolver;
        this.importEncapsulatedData = importEncapsulatedData;
    }

    public Result<Object> parse(HL7Reader hl7Reader, boolean createPatientIfNotFound) {
        return this.parse(hl7Reader, null, createPatientIfNotFound);
    }

    public Result<Object> parse(HL7Reader hl7Reader, ILabItemResolver labItemResolver, boolean createPatientIfNotFound) {
        return this.parse(hl7Reader, null, null, createPatientIfNotFound);
    }

    public Result<Object> parse(HL7Reader hl7Reader, ILabItemResolver labItemResolver, ILabContactResolver labContactResolver, boolean createPatientIfNotFound) {
        ILabContactResolver labResolver;
        TimeTool transmissionTime = new TimeTool();
        String orderId = "";
        ILabContactResolver iLabContactResolver = labResolver = labContactResolver != null ? labContactResolver : this.labContactResolver;
        if (labResolver == null) {
            throw new IllegalArgumentException("labContactResolver must not be null");
        }
        if (labItemResolver == null) {
            labItemResolver = new DefaultLabItemResolver();
        }
        try {
            ILaboratory labor = labResolver.getLabContact(this.myLab, hl7Reader.getSender());
            if (labor == null) {
                logger.warn("Exiting parsing process as labor is null");
                return new Result(Result.SEVERITY.ERROR, 2, "Labor contact is null", (Object)"", true);
            }
            ObservationMessage obsMessage = hl7Reader.readObservation(this.patientResolver, createPatientIfNotFound);
            IPatient patient = hl7Reader.getPatient();
            if (patient == null) {
                return new Result(Result.SEVERITY.ERROR, 2, Messages.HL7_PatientNotInDatabase, (Object)obsMessage.getPatientId(), true);
            }
            this.pat = this.labImportUtil.loadCoreModel(patient.getId(), IPatient.class).orElse(null);
            if (this.pat == null) {
                return new Result(Result.SEVERITY.ERROR, 2, Messages.HL7_PatientNotInDatabase, (Object)obsMessage.getPatientId(), true);
            }
            OrcMessage orcMessage = hl7Reader.getOrcMessage();
            if (orcMessage != null && orcMessage.getNames().isEmpty()) {
                logger.info("Cannot parse mandant name for ORC message");
            }
            int number = 0;
            ArrayList<TransientLabResult> results = new ArrayList<TransientLabResult>();
            List observations = obsMessage.getObservations();
            this.initCommentDate(obsMessage);
            TimeTool obrDateTime = null;
            TimeTool obxDateTime = null;
            for (IValueType iValueType : observations) {
                List<ILabResult> existingResults;
                TextData hl7TextData;
                if (iValueType instanceof LabResultData) {
                    TransientLabResult importedResult;
                    Integer flag;
                    boolean importAsLongText;
                    LabResultData hl7LabResult = (LabResultData)iValueType;
                    if (hl7LabResult.getDate() == null) {
                        if (obsMessage.getDateTimeOfMessage() != null) {
                            hl7LabResult.setDate(obsMessage.getDateTimeOfMessage());
                        } else {
                            hl7LabResult.setDate(transmissionTime.getTime());
                        }
                    }
                    this.date = new TimeTool(hl7LabResult.getDate());
                    if (hl7LabResult.getOBRDateTime() == null) {
                        hl7LabResult.setOBRDateTime(transmissionTime.toString(13));
                    }
                    obrDateTime = new TimeTool(hl7LabResult.getOBRDateTime());
                    obxDateTime = new TimeTool(hl7LabResult.getDate());
                    ILabItem labItem = this.labImportUtil.getLabItem(hl7LabResult.getCode(), labor);
                    if (labItem == null) {
                        LabItemTyp typ = LabItemTyp.NUMERIC;
                        if (!hl7LabResult.isNumeric()) {
                            typ = LabItemTyp.TEXT;
                        }
                        String refMale = "";
                        String refFemale = "";
                        if (this.pat.getGender().equals((Object)Gender.MALE)) {
                            refMale = hl7LabResult.getRange();
                        } else {
                            refFemale = hl7LabResult.getRange();
                        }
                        labItem = this.labImportUtil.createLabItem(hl7LabResult.getCode(), hl7LabResult.getName(), labor, refMale, refFemale, hl7LabResult.getUnit(), typ, labItemResolver.getTestGroupName((AbstractData)hl7LabResult), labItemResolver.getNextTestGroupSequence((AbstractData)hl7LabResult));
                        logger.debug("LabItem created [{}]", (Object)labItem);
                    }
                    boolean bl = importAsLongText = hl7LabResult.isFormatedText() || hl7LabResult.isPlainText();
                    if (importAsLongText && hl7LabResult.isNumeric()) {
                        importAsLongText = false;
                    }
                    if (importAsLongText && hl7LabResult.getValue().length() < 20) {
                        importAsLongText = false;
                    }
                    if (!importAsLongText && hl7LabResult.getValue().length() > 255) {
                        importAsLongText = true;
                    }
                    if (importAsLongText) {
                        flag = null;
                        if (hl7LabResult.getFlag() != null) {
                            flag = hl7LabResult.getFlag() != false ? 1 : 0;
                        }
                        importedResult = new TransientLabResult.Builder(this.pat, labor, labItem, "text").date(obrDateTime).comment(String.valueOf(StringTool.unNull((String)hl7LabResult.getValue())) + "\n" + StringTool.unNull((String)hl7LabResult.getComment())).flags(flag).rawAbnormalFlags(hl7LabResult.getRawAbnormalFlag()).unit(hl7LabResult.getUnit()).ref(hl7LabResult.getRange()).observationTime(obrDateTime).analyseTime(obxDateTime).transmissionTime(transmissionTime).orcMessage(orcMessage).subId(hl7LabResult.getSubId()).build(this.labImportUtil);
                        results.add(importedResult);
                        logger.debug(importedResult.toString());
                    } else {
                        flag = null;
                        if (hl7LabResult.getFlag() != null) {
                            flag = hl7LabResult.getFlag() != false ? 1 : 0;
                        }
                        importedResult = new TransientLabResult.Builder(this.pat, labor, labItem, hl7LabResult.getValue()).date(obrDateTime).comment(StringTool.unNull((String)hl7LabResult.getComment())).flags(flag).rawAbnormalFlags(hl7LabResult.getRawAbnormalFlag()).unit(hl7LabResult.getUnit()).ref(hl7LabResult.getRange()).observationTime(obrDateTime).analyseTime(obxDateTime).transmissionTime(transmissionTime).orcMessage(orcMessage).subId(hl7LabResult.getSubId()).build(this.labImportUtil);
                        results.add(importedResult);
                        logger.debug(importedResult.toString());
                    }
                } else if (iValueType instanceof EncapsulatedData && this.importEncapsulatedData) {
                    String liName;
                    String liShort;
                    ILabItem labItem;
                    String[] split;
                    EncapsulatedData hl7EncData = (EncapsulatedData)iValueType;
                    if (hl7EncData.getDate() == null) {
                        if (obsMessage.getDateTimeOfMessage() != null) {
                            hl7EncData.setDate(obsMessage.getDateTimeOfMessage());
                        } else {
                            hl7EncData.setDate(transmissionTime.getTime());
                        }
                    }
                    this.date = new TimeTool(hl7EncData.getDate());
                    String dateString = this.date.toString(14).replace(":", "");
                    dateString = dateString.replace("-", "");
                    String title = "Lab-" + dateString + "-" + hl7EncData.getSequence();
                    String fileType = "";
                    if (hl7EncData.getName().contains("/") && (split = hl7EncData.getName().split("/")).length == 2) {
                        fileType = split[1];
                        title = String.valueOf(title) + "." + fileType;
                    }
                    if ((labItem = (ILabItem)this.labImportUtil.getDocumentLabItem(liShort = "doc", liName = "Dokument", labor).orElse(null)) == null) {
                        labItem = this.labImportUtil.createLabItem(liShort, liName, labor, "", "", fileType, LabItemTyp.DOCUMENT, hl7EncData.getGroup(), "");
                    }
                    TransientLabResult importedResult = new TransientLabResult.Builder(this.pat, labor, labItem, title).date(this.date).orcMessage(orcMessage).build(this.labImportUtil);
                    results.add(importedResult);
                    this.labImportUtil.createDocumentManagerEntry(title, labor.getCode(), hl7EncData.getData(), hl7EncData.getName(), this.date, this.pat);
                }
                if (!(iValueType instanceof TextData) || !(hl7TextData = (TextData)iValueType).getName().equals("Kommentar")) continue;
                if (hl7TextData.getDate() == null) {
                    hl7TextData.setDate(this.commentDate.getTime());
                }
                TimeTool commentsDate = new TimeTool(hl7TextData.getDate());
                ILabItem labItem = this.labImportUtil.getLabItem("kommentar", "Kommentar", labor).orElse(null);
                if (labItem == null) {
                    labItem = this.labImportUtil.createLabItem("kommentar", "Kommentar", labor, "", "", "", LabItemTyp.TEXT, "00 Kommentar", Integer.toString(number));
                }
                if ((existingResults = this.labImportUtil.getLabResults(this.pat, labItem, commentsDate, null, null)).isEmpty()) {
                    StringBuilder comment = new StringBuilder();
                    if (hl7TextData.getText() != null) {
                        comment.append(hl7TextData.getText());
                    }
                    if (hl7TextData.getComment() != null) {
                        comment.append(hl7TextData.getComment());
                    }
                    TransientLabResult commentsResult = new TransientLabResult.Builder(this.pat, labor, labItem, "text").date(commentsDate).comment(comment.toString()).build(this.labImportUtil);
                    results.add(commentsResult);
                }
                ++number;
            }
            if (StringUtils.isNotBlank((CharSequence)obsMessage.getPatientNotesAndComments())) {
                ILabItem labItem = this.labImportUtil.getLabItem("NOTE", labor);
                if (labItem == null) {
                    labItem = this.labImportUtil.createLabItem("NOTE", Messages.HL7Parser_LabItem_Note_Name, labor, "", "", "", LabItemTyp.TEXT, "AA", "1");
                    logger.debug("LabItem created [{}]", (Object)labItem);
                }
                TransientLabResult patientNoteAndComment = new TransientLabResult.Builder(this.pat, labor, labItem, "text").comment(obsMessage.getPatientNotesAndComments()).date(obrDateTime).flags(0).observationTime(obrDateTime).analyseTime(obxDateTime).orcMessage(orcMessage).build(this.labImportUtil);
                results.add(patientNoteAndComment);
            }
            orderId = this.labImportUtil.importLabResults(results, this.importHandler);
        }
        catch (Exception e) {
            logger.error("Parsing HL7 failed", (Throwable)e);
            return new Result(Result.SEVERITY.ERROR, 2, Messages.Core_Error_while_importing_HL7, (Object)e.getMessage(), true);
        }
        return new Result(Result.SEVERITY.OK, 0, "OK", (Object)orderId, false);
    }

    private void initCommentDate(ObservationMessage obsMessage) {
        this.commentDate = obsMessage.getDateTimeOfTransaction() != null ? new TimeTool(obsMessage.getDateTimeOfTransaction()) : (obsMessage.getDateTimeOfMessage() != null ? new TimeTool(obsMessage.getDateTimeOfMessage()) : new TimeTool());
    }

    public Result<?> importFile(File file, File archiveDir, boolean bCreatePatientIfNotExists) throws IOException {
        return this.importFile(file, archiveDir, null, null, bCreatePatientIfNotExists);
    }

    public Result<?> importFile(File file, File archiveDir, ILabItemResolver labItemResolver, boolean bCreatePatientIfNotExists) throws IOException {
        return this.importFile(file, archiveDir, labItemResolver, null, bCreatePatientIfNotExists);
    }

    public Result<?> importFile(File hl7file, File archiveDir, ILabItemResolver labItemResolver, ILabContactResolver labContactResolver, boolean bCreatePatientIfNotExists) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = VirtualFilesystemServiceHolder.get().of(hl7file);
        IVirtualFilesystemService.IVirtualFilesystemHandle archiveDirHandle = VirtualFilesystemServiceHolder.get().of(archiveDir);
        return this.importFile(fileHandle, archiveDirHandle, labItemResolver, labContactResolver, bCreatePatientIfNotExists);
    }

    public Result<?> importFile(IVirtualFilesystemService.IVirtualFilesystemHandle file, IVirtualFilesystemService.IVirtualFilesystemHandle archiveDir, boolean bCreatePatientIfNotExists) throws IOException {
        return this.importFile(file, archiveDir, null, bCreatePatientIfNotExists);
    }

    public Result<?> importFile(IVirtualFilesystemService.IVirtualFilesystemHandle hl7file, IVirtualFilesystemService.IVirtualFilesystemHandle archiveDir, ILabItemResolver labItemResolver, ILabContactResolver labContactResolver, boolean bCreatePatientIfNotExists) throws IOException {
        if (labContactResolver != null) {
            this.labContactResolver = labContactResolver;
        }
        return this.importFile(hl7file, archiveDir, labItemResolver, bCreatePatientIfNotExists);
    }

    public Result<?> importFile(IVirtualFilesystemService.IVirtualFilesystemHandle file, IVirtualFilesystemService.IVirtualFilesystemHandle archiveDir, ILabItemResolver labItemResolver, boolean bCreatePatientIfNotExists) throws IOException {
        List hl7Readers = HL7ReaderFactory.INSTANCE.getReader(file);
        Iterator iterator = hl7Readers.iterator();
        if (iterator.hasNext()) {
            HL7Reader hl7Reader;
            this.hl7Reader = hl7Reader = (HL7Reader)iterator.next();
            Result<Object> ret = this.parse(hl7Reader, labItemResolver, this.labContactResolver, bCreatePatientIfNotExists);
            if (ret.isOK() && archiveDir != null && archiveDir.exists() && archiveDir.isDirectory() && file.exists() && !file.isDirectory() && file.canRead()) {
                IVirtualFilesystemService.IVirtualFilesystemHandle newFile = archiveDir.subFile(file.getName());
                if (newFile.exists()) {
                    String fnwts = String.valueOf(file.getName()) + "_" + new TimeTool().toString(13);
                    newFile = archiveDir.subFile(fnwts);
                }
                file.moveTo(newFile);
            }
            return ret;
        }
        return new Result(Result.SEVERITY.ERROR, 2, Messages.Core_Error_while_importing_HL7, (Object)"No reader for file", true);
    }

    public void importFromDir(IVirtualFilesystemService.IVirtualFilesystemHandle dir, IVirtualFilesystemService.IVirtualFilesystemHandle archiveDir, Result<?> res, boolean bCreatePatientIfNotExists) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle[] files;
        IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = files = dir.listHandles(handle -> {
            boolean isDirectory = false;
            try {
                isDirectory = handle.isDirectory();
            }
            catch (IOException e) {
                logger.warn("Error checking [" + handle + "], treating as file", (Throwable)e);
            }
            return isDirectory ? !handle.getName().equalsIgnoreCase(archiveDir.getName()) : "hl7".equalsIgnoreCase(handle.getExtension());
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualFilesystemService.IVirtualFilesystemHandle file = iVirtualFilesystemHandleArray[n2];
            if (file.isDirectory()) {
                this.importFromDir(file, archiveDir, res, bCreatePatientIfNotExists);
            } else {
                Result<?> r = this.importFile(file, archiveDir, bCreatePatientIfNotExists);
                if (res == null) {
                    res = r;
                } else {
                    res.add(r.getSeverity(), 1, "", null, true);
                }
            }
            ++n2;
        }
    }

    public Result<?> importFile(String filepath, boolean bCreatePatientIfNotExists) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = VirtualFilesystemServiceHolder.get().of(filepath);
        return this.importFile(fileHandle, null, bCreatePatientIfNotExists);
    }

    public Result<?> importMessage(String message, boolean bCreatePatientIfNotExists) throws IOException {
        HL7Reader hl7Reader;
        this.hl7Reader = hl7Reader = HL7ReaderFactory.INSTANCE.getReader(message);
        Result<Object> ret = this.parse(hl7Reader, bCreatePatientIfNotExists);
        if (ret.isOK()) {
            return new Result((Object)"OK");
        }
        return ret;
    }

    public IPatient getPatient() {
        return this.pat;
    }

    public void setPatient(IPatient pat) {
        this.pat = pat;
    }

    public TimeTool getDate() {
        return this.date;
    }

    public void setDate(TimeTool date) {
        this.date = date;
    }
}

