/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.datasource.internal;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.constants.ElexisEnvironmentPropertyConstants;
import ch.elexis.core.utils.CoreUtil;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConnectionParser {
    public static final String TEST_DBSERVER = "elexis.test.db.server";
    private int configSourceCode = -1;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Optional<DBConnection> parseAvailableParameters() {
        Optional dbType;
        boolean isTestMode = CoreUtil.isTestMode();
        boolean isRunFromScratch = "RunFromScratch".equals(System.getProperty("elexis-run-mode"));
        boolean traceActivated = Boolean.parseBoolean(System.getProperty("elexis.test.dbtrace"));
        boolean isServerMode = Boolean.parseBoolean(System.getProperty(TEST_DBSERVER));
        boolean isSkipDataSourceActivation = Boolean.parseBoolean(System.getProperty("elexis.skip.ds.activation"));
        if (isSkipDataSourceActivation) {
            return Optional.empty();
        }
        String prop_dbUser = System.getProperty("ch.elexis.dbUser");
        String prop_dbPassword = System.getProperty("ch.elexis.dbPw");
        if (prop_dbPassword == null) {
            prop_dbPassword = "";
        }
        String prop_dbFlavor = System.getProperty("ch.elexis.dbFlavor");
        String prop_dbConnSpec = System.getProperty("ch.elexis.dbSpec");
        if (StringUtils.isNotBlank((CharSequence)prop_dbConnSpec) && StringUtils.isBlank((CharSequence)prop_dbFlavor)) {
            prop_dbFlavor = this.determineFlavorFromJdbcString(prop_dbConnSpec);
        }
        File demoDBLocation = new File(CoreUtil.getWritableUserDir(), "demoDB");
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("demo.database.location"))) {
            demoDBLocation = new File(System.getProperty("demo.database.location"));
        }
        Map<String, String> env = System.getenv();
        String env_dbType = env.get(ElexisEnvironmentPropertyConstants.DB_TYPE);
        String env_dbHost = env.get(ElexisEnvironmentPropertyConstants.DB_HOST);
        String env_dbDatabase = env.get(ElexisEnvironmentPropertyConstants.DB_DATABASE);
        String env_dbUsername = env.get(ElexisEnvironmentPropertyConstants.DB_USERNAME);
        String env_dbPassword = env.get(ElexisEnvironmentPropertyConstants.DB_PASSWORD);
        String env_jdbcParameterString = env.get(ElexisEnvironmentPropertyConstants.DB_JDBC_PARAMETER_STRING);
        if (isTestMode || isRunFromScratch && StringUtils.isBlank((CharSequence)prop_dbConnSpec)) {
            String jdbcString = "jdbc:h2:mem:elexisFromScratch;DB_CLOSE_DELAY=-1";
            if (isServerMode) {
                jdbcString = "jdbc:h2:~/elexisTest/elexisTest;AUTO_SERVER=TRUE";
            }
            if (traceActivated) {
                jdbcString = String.valueOf(jdbcString) + ";TRACE_LEVEL_SYSTEM_OUT=2";
            }
            this.logger.info("Connecting to RunFromScratch H2 DB [" + jdbcString + "]");
            this.configSourceCode = 1;
            return Optional.of(new DBConnection(DBConnection.DBType.H2, jdbcString, "sa", new char[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)prop_dbConnSpec)) {
            this.logger.info("Connecting to DB (Prop) [{}]", (Object)prop_dbConnSpec);
            DBConnection.DBType dbType2 = (DBConnection.DBType)DBConnection.DBType.valueOfIgnoreCase((String)prop_dbFlavor).orElseThrow(() -> new IllegalStateException("Unknown ch.elexis.dbFlavor"));
            if (!isRunFromScratch && dbType2.dbType.equalsIgnoreCase("h2") && !prop_dbConnSpec.contains("AUTO_SERVER=TRUE")) {
                prop_dbConnSpec = String.valueOf(prop_dbConnSpec) + ";AUTO_SERVER=TRUE";
                this.logger.info("Added AUTO_SERVER [" + prop_dbConnSpec + "]");
            }
            this.configSourceCode = 2;
            return Optional.of(new DBConnection(dbType2, prop_dbConnSpec, prop_dbUser, prop_dbPassword.toCharArray()));
        }
        if (demoDBLocation.exists() && demoDBLocation.isDirectory()) {
            this.logger.info("Connecting to demoDB [{}]", (Object)demoDBLocation.getAbsolutePath());
            String jdbcLink = this.createH2Link(String.valueOf(demoDBLocation.getAbsolutePath()) + File.separator + "db");
            if (StringUtils.isBlank((CharSequence)prop_dbUser)) {
                prop_dbUser = "sa";
            }
            this.configSourceCode = 3;
            return Optional.of(new DBConnection(DBConnection.DBType.H2, jdbcLink, prop_dbUser, prop_dbPassword.toCharArray()));
        }
        if (StringUtils.isNotBlank((CharSequence)env_dbType) && StringUtils.isNotBlank((CharSequence)env_dbHost) && StringUtils.isNotBlank((CharSequence)env_dbDatabase) && StringUtils.isNotBlank((CharSequence)env_dbUsername) && StringUtils.isNotBlank((CharSequence)env_dbUsername) && (dbType = DBConnection.DBType.valueOfIgnoreCase((String)env_dbType)).isPresent()) {
            String env_jdbcLink = "jdbc:" + ((DBConnection.DBType)dbType.get()).dbType.toLowerCase() + "://" + env_dbHost + "/" + env_dbDatabase;
            if (StringUtils.isNotBlank((CharSequence)env_jdbcParameterString)) {
                env_jdbcLink = String.valueOf(env_jdbcLink) + "?" + env_jdbcParameterString;
            }
            this.logger.info("Connecting to DB (Env) [{}]", (Object)env_jdbcLink);
            this.configSourceCode = 4;
            return Optional.of(new DBConnection((DBConnection.DBType)dbType.get(), env_jdbcLink, env_dbUsername, env_dbPassword.toCharArray()));
        }
        return Optional.empty();
    }

    private String createH2Link(String database) {
        String prefix = "jdbc:h2:";
        if (database.contains(".zip!")) {
            prefix = String.valueOf(prefix) + "zip:";
        }
        String connectString = "";
        connectString = database.startsWith("jdbc:h2:mem:") ? database : String.valueOf(prefix) + database + ";AUTO_SERVER=TRUE";
        return connectString;
    }

    private String determineFlavorFromJdbcString(String prop_dbConnSpec) {
        String jdbcString = prop_dbConnSpec.trim().toLowerCase();
        if (jdbcString.startsWith("jdbc:h2")) {
            return "h2";
        }
        if (jdbcString.startsWith("jdbc:mysql")) {
            return "mysql";
        }
        if (jdbcString.startsWith("jdbc:postgresql")) {
            return "PostgreSQL";
        }
        return null;
    }

    public int getConfigSource() {
        return this.configSourceCode;
    }
}

