/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.ac.ACEAccessBitMap;
import ch.elexis.core.ac.AccessControlList;
import ch.elexis.core.ac.AccessControlListUtil;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.ac.SystemCommandEvaluatableACE;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.utils.CoreUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RoleBasedAccessControlService
implements IAccessControlService {
    private Logger logger;
    @Reference
    private IContextService contextService;
    @Reference
    private IUserService userService;
    @Reference
    private IStoreToStringService storeToStringService;
    private Map<String, AccessControlList> roleAclMap;
    private Map<IUser, AccessControlList> userAclMap;
    private ThreadLocal<Boolean> privileged;
    private String[] aoboObjects = new String[]{"IEncounter", "IDocumentLetter", "IInvoice"};

    public RoleBasedAccessControlService() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.roleAclMap = Collections.synchronizedMap(new HashMap());
        this.userAclMap = Collections.synchronizedMap(new HashMap());
        this.privileged = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    public boolean evaluate(EvaluatableACE evaluatableAce) {
        if (this.isPrivileged()) {
            return true;
        }
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent()) {
            if (!this.userAclMap.containsKey(user.get())) {
                this.refresh((IUser)user.get());
            }
            return this.evaluateACE((IUser)user.get(), this.userAclMap.get(user.get()), evaluatableAce);
        }
        this.logger.warn("No active user to evalute");
        return false;
    }

    public void refresh(IUser user) {
        AccessControlList userAccessControlList = this.determineUserAccessControlList(this.userService.getUserRoles(user));
        this.userAclMap.put(user, userAccessControlList);
        this.logger.info("ACE User=[{}] Roles=[{}]", (Object)user.getId(), this.userAclMap.get(user) != null ? this.userAclMap.get(user).getRolesRepresented() : "");
    }

    public boolean isPrivileged() {
        return this.privileged.get() != false || CoreUtil.isTestMode() && this.contextService.getNamed("testAccessControl").isEmpty();
    }

    private AccessControlList determineUserAccessControlList(List<IRole> roles) {
        if (roles.isEmpty()) {
            return null;
        }
        AccessControlList accessControlList = null;
        for (IRole role : roles) {
            if (accessControlList == null) {
                accessControlList = this.getOrLoadRoleAccessControlList(role);
                continue;
            }
            AccessControlList _accessControlList = this.roleAclMap.get(role.getId().toLowerCase());
            if (_accessControlList == null) {
                _accessControlList = this.getOrLoadRoleAccessControlList(role);
            }
            if (_accessControlList != null) {
                accessControlList = AccessControlListUtil.merge((AccessControlList)accessControlList, (AccessControlList)_accessControlList);
                continue;
            }
            this.logger.warn("Unknown role [" + role.getId() + "]");
        }
        return accessControlList;
    }

    private AccessControlList getOrLoadRoleAccessControlList(IRole iRole) {
        String _role = iRole.getId().toLowerCase();
        if (!this.roleAclMap.containsKey(_role)) {
            InputStream roleAccessDefaultUserFile = AccessControlList.class.getClassLoader().getResourceAsStream("/rsc/acl/" + _role + ".json");
            if (roleAccessDefaultUserFile != null) {
                try {
                    AccessControlList acl = (AccessControlList)new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).readValue(roleAccessDefaultUserFile, AccessControlList.class);
                    this.roleAclMap.put(_role, acl);
                }
                catch (Exception e) {
                    this.logger.error("Error loading role acl [{}]", (Object)_role, (Object)e);
                }
            } else {
                this.logger.warn("No role acl [{}] file", (Object)_role);
            }
        }
        return this.roleAclMap.get(_role);
    }

    private boolean evaluateACE(IUser user, AccessControlList acl, EvaluatableACE ace) {
        if (ace instanceof ObjectEvaluatableACE) {
            ObjectEvaluatableACE _ace = (ObjectEvaluatableACE)ace;
            ACEAccessBitMap useracebm = (ACEAccessBitMap)acl.getObject().get(_ace.getObject());
            if (useracebm != null) {
                byte[] aceBitMap = useracebm.getAccessRightMap();
                byte[] requested = _ace.getRequestedRightMap();
                byte[] evaluated = new byte[Right.values().length];
                short flattenedbitmap = 0;
                int i = 0;
                while (i < evaluated.length) {
                    if (aceBitMap[i] == 4) {
                        aceBitMap[i] = 1;
                        flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                    } else if (aceBitMap[i] == 2) {
                        if (StringUtils.isNotEmpty((CharSequence)_ace.getStoreToString()) && this.isAoboObject(_ace.getObject())) {
                            if (this.evaluateAobo(user, _ace)) {
                                aceBitMap[i] = 1;
                                flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                            } else {
                                aceBitMap[i] = 0;
                            }
                        } else {
                            aceBitMap[i] = 1;
                            flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                        }
                    }
                    evaluated[i] = (byte)(aceBitMap[i] & requested[i]);
                    ++i;
                }
                boolean result = (flattenedbitmap & _ace.getRequested()) == _ace.getRequested();
                return result;
            }
        } else if (ace instanceof SystemCommandEvaluatableACE) {
            SystemCommandEvaluatableACE _ace = (SystemCommandEvaluatableACE)ace;
            return this.evaluateSystemCommandACE(acl, _ace);
        }
        return false;
    }

    private boolean evaluateAobo(IUser user, ObjectEvaluatableACE _ace) {
        List<String> aoboIds = this.getAoboMandatorIds(user);
        Optional object = this.storeToStringService.loadFromString(_ace.getStoreToString());
        if (object.isPresent()) {
            String id = null;
            if (object.get() instanceof IEncounter) {
                if (((IEncounter)object.get()).getMandator() != null) {
                    id = ((IEncounter)object.get()).getMandator().getId();
                }
            } else if (object.get() instanceof IInvoice) {
                if (((IInvoice)object.get()).getMandator() != null) {
                    id = ((IInvoice)object.get()).getMandator().getId();
                }
            } else if (object.get() instanceof IDocumentLetter) {
                if (((IDocumentLetter)object.get()).getAuthor() != null) {
                    id = ((IDocumentLetter)object.get()).getAuthor().getId();
                }
            } else {
                this.logger.warn("Unknown aobo object [{}]", (Object)_ace.getStoreToString());
            }
            return id != null ? aoboIds.contains(id) : true;
        }
        this.logger.warn("Could not load aobo object [{}]", (Object)_ace.getStoreToString());
        return false;
    }

    private List<String> getAoboMandatorIds(IUser user) {
        ArrayList<String> ret = new ArrayList<String>();
        if (user.getAssignedContact() != null) {
            if (user.getAssignedContact().isMandator()) {
                ret.add(user.getAssignedContact().getId());
            }
            this.userService.getExecutiveDoctorsWorkingFor(user).stream().forEach(m -> {
                boolean bl = ret.add(m.getId());
            });
        }
        return ret;
    }

    public List<String> getAoboMandatorIds() {
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent()) {
            return this.getAoboMandatorIds((IUser)user.get());
        }
        return Collections.emptyList();
    }

    public List<String> getAoboMandatorIdsForSqlIn() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("-1");
        ret.addAll(this.getAoboMandatorIds());
        return ret;
    }

    private boolean isAoboObject(String object) {
        return Arrays.asList(this.aoboObjects).stream().filter(aobo -> object.endsWith((String)aobo)).findFirst().isPresent();
    }

    private boolean evaluateSystemCommandACE(AccessControlList acl, SystemCommandEvaluatableACE _ace) {
        if (acl.getSystemCommand().containsKey(_ace.getSystemCommandId())) {
            ACEAccessBitMap aceAccessBitMap = (ACEAccessBitMap)acl.getSystemCommand().get(_ace.getSystemCommandId());
            return aceAccessBitMap.grants(Right.EXECUTE);
        }
        return false;
    }

    public void doPrivileged(Runnable runnable) {
        try {
            this.privileged.set(Boolean.TRUE);
            this.logger.info("Executing priviledged [" + runnable + "]");
            runnable.run();
        }
        finally {
            this.privileged.set(Boolean.FALSE);
        }
    }

    public boolean isAobo(ObjectEvaluatableACE evaluatableAce) {
        if (this.isPrivileged()) {
            return false;
        }
        if (!this.isAoboObject(evaluatableAce.getObject())) {
            return false;
        }
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent()) {
            AccessControlList acl;
            ACEAccessBitMap useracebm;
            if (!this.userAclMap.containsKey(user.get())) {
                this.refresh((IUser)user.get());
            }
            if ((useracebm = (ACEAccessBitMap)(acl = this.userAclMap.get(user.get())).getObject().get(evaluatableAce.getObject())) != null) {
                byte[] aceBitMap = useracebm.getAccessRightMap();
                byte[] requested = evaluatableAce.getRequestedRightMap();
                int i = 0;
                while (i < requested.length) {
                    if (requested[i] == 1 && aceBitMap[i] != 2) {
                        return false;
                    }
                    ++i;
                }
            }
        } else {
            this.logger.warn("No active user to test aobo");
        }
        return true;
    }
}

