/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IXid;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.AnschriftEingabeDialog;
import ch.elexis.core.ui.dialogs.KontaktExtDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Labor;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class KontaktBlatt
extends Composite
implements IRefreshable,
IUnlockable {
    private static final String IS_USER = "istAnwender";
    private static final String MOBIL = Messages.Core_Mobilphone;
    private static final String VORNAME = Messages.Core_Firstname;
    private static final String NAME = Messages.Core_Name;
    private static final String TEL_DIREKT = Messages.KontaktBlatt_OhoneDirect;
    private static final String ANSPRECHPERSON = Messages.ContactPerson;
    private static final String ZUSATZ = Messages.Core_Additional;
    private static final String BEZEICHNUNG = Messages.Core_Description;
    static final String[] types = new String[]{"istOrganisation", "istLabor", "istPerson", "istPatient", "istAnwender", "istMandant"};
    static final String[] typLabels = new String[]{Messages.Core_Organisation, Messages.Core_Laboratory, Messages.Core_Person, Messages.Core_Patient, Messages.Core_User, Messages.Core_Mandator};
    private final Button[] bTypes = new Button[types.length];
    private final TypButtonAdapter tba = new TypButtonAdapter();
    private final IViewSite site;
    private final ScrolledForm form;
    private final FormToolkit tk;
    LabeledInputField.AutoForm afDetails;
    Listener mandantListener;
    Listener checkIfContactExistsListener;
    static final LabeledInputField.InputData[] def = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.Core_Description_1, "Bezeichnung1", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Description_2, "Bezeichnung2", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_Bez3, "Bezeichnung3", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Sex, "Geschlecht", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_LawCode, "TitelSuffix", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Street, "Strasse", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Postal_code, "Plz", LabeledInputField.InputData.Typ.STRING, null, 6), new LabeledInputField.InputData(Messages.Core_City, "Ort", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Country, "Land", LabeledInputField.InputData.Typ.STRING, null, 3), new LabeledInputField.InputData(Messages.KontaktBlatt_XMLName, "Allergien", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_Phone1, "Telefon1", LabeledInputField.InputData.Typ.STRING, null, 30), new LabeledInputField.InputData(Messages.KontaktBlatt_Phone2, "Telefon2", LabeledInputField.InputData.Typ.STRING, null, 30), new LabeledInputField.InputData(Messages.KontaktBlatt_Mobile, "NatelNr", LabeledInputField.InputData.Typ.STRING, null, 30), new LabeledInputField.InputData(Messages.Core_Fax, "Fax", LabeledInputField.InputData.Typ.STRING, null, 30), new LabeledInputField.InputData(Messages.KontaktBlatt_MediportSupport, "Gruppe", LabeledInputField.InputData.Typ.CHECKBOX, null), new LabeledInputField.InputData(Messages.Core_E_Mail, "E-Mail", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_Mail2, "email2", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_www, "Website", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_shortLabel, "Kuerzel", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Description_1, "Bezeichnung1", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Remark, "Bemerkung", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Title, "Titel", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.KontaktBlatt_extid, "UUID", new LabeledInputField.IContentProvider(){

        public void displayContent(Object po, LabeledInputField.InputData ltf) {
            StringBuilder sb = new StringBuilder();
            Kontakt k = (Kontakt)po;
            IXid xid = k.getXid();
            String dom = Xid.getSimpleNameForXIDDomain((String)xid.getDomain());
            sb.append(dom).append(": ").append(xid.getDomainId());
            ltf.setText(sb.toString());
        }

        public void reloadContent(Object po, LabeledInputField.InputData ltf) {
            ArrayList<String> extFlds = new ArrayList<String>();
            Kontakt k = (Kontakt)po;
            for (String dom : Xid.getXIDDomains()) {
                Xid.XIDDomain xd = Xid.getDomain((String)dom);
                if (k.istPerson() && xd.isDisplayedFor(Person.class) || k.istOrganisation() && xd.isDisplayedFor(Organisation.class)) {
                    extFlds.add(String.valueOf(Xid.getSimpleNameForXIDDomain((String)dom)) + "=" + dom);
                    continue;
                }
                if (!k.istOrganisation() || !xd.isDisplayedFor(Labor.class)) continue;
                extFlds.add(String.valueOf(Xid.getSimpleNameForXIDDomain((String)dom)) + "=" + dom);
            }
            KontaktExtDialog dlg = new KontaktExtDialog(UiDesk.getTopShell(), (IContact)NoPoUtil.loadAsIdentifiable((PersistentObject)((Kontakt)po), IContact.class).orElse(null), extFlds.toArray(new String[0]));
            dlg.open();
        }
    })};
    private Kontakt actKontakt;
    private final Label lbAnschrift;

    @Inject
    void activeContact(@Optional IContact contact) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Kontakt kontakt = (Kontakt)NoPoUtil.loadAsPersistentObject((Identifiable)contact);
            if (kontakt != null) {
                Kontakt deselectedKontakt = this.actKontakt;
                this.setKontakt(kontakt);
                if (deselectedKontakt != null) {
                    if (LocalLockServiceHolder.get().isLockedLocal((Object)deselectedKontakt)) {
                        LocalLockServiceHolder.get().releaseLock((Object)deselectedKontakt);
                    }
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    commandService.refreshElements("ch.elexis.core.ui.command.ToggleCurrentKontaktLockCommand", null);
                }
            } else {
                this.setEnabled(false);
            }
        }, (Object)this.form);
    }

    @Inject
    void lockedPatient(@Optional @UIEventTopic(value="info/elexis/locking/aquired") IContact contact) {
        Kontakt kontakt = (Kontakt)NoPoUtil.loadAsPersistentObject((Identifiable)contact);
        if (kontakt != null && kontakt.equals((Object)this.actKontakt)) {
            this.save();
            this.setUnlocked(true);
        }
    }

    @Inject
    void unlockedPatient(@Optional @UIEventTopic(value="info/elexis/locking/released") IContact contact) {
        Kontakt kontakt = (Kontakt)NoPoUtil.loadAsPersistentObject((Identifiable)contact);
        if (kontakt != null && kontakt.equals((Object)this.actKontakt)) {
            this.save();
            this.setUnlocked(false);
        }
    }

    public KontaktBlatt(Composite parent, int style, IViewSite vs) {
        super(parent, style);
        this.site = vs;
        this.tk = UiDesk.getToolkit();
        this.setLayout((Layout)new FillLayout());
        this.form = this.tk.createScrolledForm((Composite)this);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        Composite cTypes = this.tk.createComposite(body, 2048);
        int i = 0;
        while (i < types.length) {
            this.bTypes[i] = this.tk.createButton(cTypes, typLabels[i], 32);
            this.bTypes[i].addSelectionListener((SelectionListener)this.tba);
            this.bTypes[i].setData((Object)types[i]);
            if (types[i].equalsIgnoreCase(IS_USER)) {
                this.bTypes[i].setEnabled(false);
            }
            ++i;
        }
        cTypes.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cTypes.setLayout((Layout)new FillLayout());
        Composite bottom = this.tk.createComposite(body);
        bottom.setLayout((Layout)new FillLayout());
        bottom.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.actKontakt = (Kontakt)ElexisEventDispatcher.getSelected(Kontakt.class);
        this.afDetails = new LabeledInputField.AutoForm(bottom, def);
        this.mandantListener = new Listener(){

            public void handleEvent(Event event) {
                if (!MessageDialog.openConfirm((Shell)KontaktBlatt.this.getShell(), (String)"Mandant bearbeiten", (String)"Sie nehmen \u00c4nderungen an einem Mandanten vor\n\u00c4nderung speichern?")) {
                    event.doit = false;
                }
                int i = 0;
                while (i < def.length) {
                    def[i].getWidget().getControl().removeListener(1, KontaktBlatt.this.mandantListener);
                    ++i;
                }
            }
        };
        this.checkIfContactExistsListener = new Listener(){

            public void handleEvent(Event event) {
                Kontakt kontakt;
                List<Kontakt> list = KontaktBlatt.this.queryContact();
                if (list != null && !list.isEmpty() && (kontakt = list.get(0)).istPerson()) {
                    MessageDialog.openInformation((Shell)KontaktBlatt.this.getShell(), (String)"Kontakt existiert", (String)"Ein Kontakt mit diesen Daten existiert bereits in der Datenbank");
                }
            }
        };
        Composite cAnschrift = this.tk.createComposite(body);
        cAnschrift.setLayout((Layout)new GridLayout(2, false));
        cAnschrift.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Hyperlink hAnschrift = this.tk.createHyperlink(cAnschrift, Messages.Core_Postal_Address, 0);
        hAnschrift.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (KontaktBlatt.this.actKontakt != null) {
                    new AnschriftEingabeDialog(KontaktBlatt.this.getShell(), KontaktBlatt.this.actKontakt).open();
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)KontaktBlatt.this.actKontakt);
                }
            }
        });
        this.lbAnschrift = this.tk.createLabel(cAnschrift, "", 64);
        this.lbAnschrift.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.setOrganisationFieldsVisible(false);
        def[19].getWidget().setVisible(false);
        this.setUnlocked(false);
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    private List<Kontakt> queryContact() {
        String tName = def[0].getText();
        String tVorname = def[1].getText();
        String tSex = def[3].getText();
        Query qbe = new Query(Kontakt.class);
        qbe.add("Bezeichnung1", "=", tName);
        qbe.add("Bezeichnung2", "=", tVorname);
        qbe.add("Geschlecht", "=", tSex);
        List contactList = qbe.execute();
        return contactList;
    }

    public void dispose() {
        super.dispose();
    }

    private void setOrganisationFieldsVisible(boolean visible) {
        def[4].getWidget().setVisible(visible);
        def[9].getWidget().setVisible(visible);
        def[14].getWidget().setVisible(visible);
    }

    public void activation(boolean mode) {
        if (ElexisEventDispatcher.getSelected(Kontakt.class) == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private void setKontakt(Kontakt kontakt) {
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        this.actKontakt = kontakt;
        this.afDetails.reload((PersistentObject)this.actKontakt);
        if (this.actKontakt != null) {
            boolean updateRight = AccessControlServiceHolder.get().evaluate(EvACE.of(IContact.class, (Right)Right.UPDATE, (String)StoreToStringServiceHolder.getStoreToString((Object)this.actKontakt)));
            String[] ret = new String[types.length];
            this.actKontakt.get(types, ret);
            int i = 0;
            while (i < types.length) {
                this.bTypes[i].setSelection(ret[i] == null ? false : "1".equals(ret[i]));
                this.bTypes[i].setEnabled(updateRight);
                ++i;
            }
            if (this.bTypes[3].getSelection()) {
                def[17].getWidget().setEnabled(false);
            } else {
                def[17].getWidget().setEnabled(true);
            }
            if (this.bTypes[0].getSelection()) {
                def[0].setLabel(BEZEICHNUNG);
                def[1].setLabel(ZUSATZ);
                def[2].setLabel(ANSPRECHPERSON);
                def[3].setEditable(false);
                def[3].setText("");
                def[10].setLabel(TEL_DIREKT);
                this.setOrganisationFieldsVisible(true);
            } else {
                def[0].setLabel(NAME);
                def[1].setLabel(VORNAME);
                def[2].setLabel(ZUSATZ);
                def[3].setEditable(true);
                this.setOrganisationFieldsVisible(false);
            }
            this.lbAnschrift.setText(this.actKontakt.getPostAnschrift(false));
        }
        this.form.reflow(true);
        this.setUnlocked(LocalLockServiceHolder.get().isLockedLocal((Object)kontakt));
        this.addListener(this.actKontakt);
    }

    private void addListener(Kontakt kontakt) {
        try {
            boolean mandatorEditGuard = kontakt.istMandant();
            int i = 0;
            while (i < def.length) {
                def[i].getWidget().getControl().removeListener(1, this.mandantListener);
                def[i].getWidget().getControl().removeListener(2, this.checkIfContactExistsListener);
                ++i;
            }
            if (mandatorEditGuard) {
                i = 0;
                while (i < def.length) {
                    def[i].getWidget().getControl().addListener(1, this.mandantListener);
                    ++i;
                }
            } else {
                def[0].getWidget().getControl().addListener(2, this.checkIfContactExistsListener);
                def[1].getWidget().getControl().addListener(2, this.checkIfContactExistsListener);
                def[3].getWidget().getControl().addListener(2, this.checkIfContactExistsListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        this.afDetails.save();
    }

    public void setUnlocked(boolean unlocked) {
        this.afDetails.setUnlocked(unlocked);
    }

    public void refresh() {
        this.setKontakt((Kontakt)NoPoUtil.loadAsPersistentObject((Identifiable)ContextServiceHolder.get().getTyped(IContact.class).orElse(null)));
    }

    private final class TypButtonAdapter
    extends SelectionAdapter {
        ArrayList<String> alTypes = new ArrayList();
        ArrayList<String> alValues = new ArrayList();

        private TypButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            String type = (String)b.getData();
            if (b.getSelection()) {
                if (type.equals("istOrganisation")) {
                    this.select("1", "x", "0", "0", "x", "x");
                    def[0].setLabel(BEZEICHNUNG);
                    def[1].setLabel(ZUSATZ);
                    def[2].setLabel(ANSPRECHPERSON);
                    def[3].setText("");
                    def[10].setLabel(TEL_DIREKT);
                    KontaktBlatt.this.setOrganisationFieldsVisible(true);
                } else if (type.equals("istLabor")) {
                    this.select("1", "1", "0", "0", "0", "0");
                    def[0].setLabel(BEZEICHNUNG);
                    def[1].setLabel(ZUSATZ);
                    def[2].setLabel(Messages.Core_Laboratory_Admin);
                    def[10].setLabel(TEL_DIREKT);
                } else {
                    def[0].setLabel(NAME);
                    def[1].setLabel(VORNAME);
                    def[2].setLabel(ZUSATZ);
                    def[10].setLabel(MOBIL);
                    KontaktBlatt.this.setOrganisationFieldsVisible(false);
                    if ("istPerson".equals(type)) {
                        this.select("0", "0", "1", "x", "x", "x");
                    } else if (type.equals("istPatient")) {
                        this.select("0", "0", "1", "1", "x", "x");
                    } else if (type.equals(KontaktBlatt.IS_USER)) {
                        this.select("0", "0", "1", "x", "1", "x");
                    } else if (type.equals("istMandant")) {
                        this.select("0", "0", "1", "x", "1", "1");
                    }
                }
            } else {
                KontaktBlatt.this.actKontakt.set(type, "0");
            }
        }

        void select(String ... fields) {
            this.alTypes.clear();
            this.alValues.clear();
            int i = 0;
            while (i < fields.length) {
                if (!fields[i].equals("x")) {
                    this.alTypes.add(types[i]);
                    this.alValues.add(fields[i]);
                    KontaktBlatt.this.bTypes[i].setSelection(fields[i].equals("1"));
                }
                ++i;
            }
            KontaktBlatt.this.actKontakt.set(this.alTypes.toArray(new String[0]), this.alValues.toArray(new String[0]));
        }
    }
}

