/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.FormatValidator;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PatientErfassenDialog
extends TitleAreaDialog {
    HashMap<String, String> fld;
    Text tName;
    Text tVorname;
    Text tGebDat;
    Text tStrasse;
    Text tPlz;
    Text tOrt;
    Text tTel;
    Text tMail;
    Text tAHV;
    Combo cbSex;
    private IPatient patient;
    Object po;

    public IPatient getResult() {
        return this.patient;
    }

    public PatientErfassenDialog(Shell parent, HashMap<String, String> fields) {
        super(parent);
        this.fld = fields;
    }

    private String getField(String name) {
        String ret = this.fld.get(name);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(2, false));
        new Label(ret, 0).setText(Messages.Core_Name);
        this.tName = new Text(ret, 2048);
        this.tName.setText(this.getField("Name"));
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Core_Firstname);
        this.tVorname = new Text(ret, 2048);
        this.tVorname.setText(this.getField("Vorname"));
        this.tVorname.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Sex);
        this.cbSex = new Combo(ret, 4);
        String toolTip = String.format(Messages.Patient_male_female_tooltip, Messages.Patient_male_short, Messages.Patient_female_short, Messages.Patient_male_long, Messages.Patient_female_long);
        this.cbSex.setToolTipText(toolTip);
        this.cbSex.setItems(new String[]{Messages.Patient_male_short, Messages.Patient_female_short});
        if (StringTool.isNothing((Object)this.getField("Geschlecht"))) {
            this.cbSex.select(0);
        } else {
            this.cbSex.select(StringTool.isFemale((String)this.getField("Vorname")) ? 1 : 0);
        }
        new Label(ret, 0).setText(Messages.Core_Enter_Birthdate);
        this.tGebDat = new Text(ret, 2048);
        this.tGebDat.setText(this.getField("Geburtsdatum"));
        this.tGebDat.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Core_Street);
        this.tStrasse = new Text(ret, 2048);
        this.tStrasse.setText(this.getField("Strasse"));
        this.tStrasse.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Core_Postal_code);
        this.tPlz = new Text(ret, 2048);
        this.tPlz.setText(this.getField("Plz"));
        this.tPlz.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Core_City);
        this.tOrt = new Text(ret, 2048);
        this.tOrt.setText(this.getField("Ort"));
        this.tOrt.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Core_Phone);
        this.tTel = new Text(ret, 2048);
        this.tTel.setText(this.getField("Telefon1"));
        this.tTel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.Core_E_Mail);
        this.tMail = new Text(ret, 2048);
        this.tMail.setText(this.getField("E-Mail"));
        this.tMail.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Color defaultMailColor = this.tMail.getForeground();
        Color red = UiDesk.getColor((String)"rot");
        this.tMail.addModifyListener(e -> {
            String text = this.tMail.getText();
            if (!text.isEmpty() && !FormatValidator.isValidMailAddress((String)text)) {
                this.tMail.setForeground(red);
                this.setEnableOKButton(false);
                return;
            }
            this.tMail.setForeground(defaultMailColor);
            this.setEnableOKButton(true);
        });
        new Label(ret, 0).setText(Messages.Patientenblatt2_ahvNumber);
        this.tAHV = new Text(ret, 2048);
        this.tAHV.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Color defaultAHVColor = this.tAHV.getForeground();
        this.tAHV.setTextLimit(16);
        this.tAHV.setMessage("756.XXXX.XXXX.XX");
        this.tAHV.addVerifyListener(event -> {
            String text = this.tAHV.getText();
            if (StringUtils.isNumeric((CharSequence)event.text.replaceAll("\\.", ""))) {
                if (text.length() == 2 || text.length() == 7 || text.length() == 12) {
                    event.text = String.valueOf(event.text) + ".";
                    return;
                }
                text = String.valueOf(text) + event.text;
                boolean isValid = FormatValidator.isValidAHVNum((String)text);
                event.doit = text.length() <= 16 ? true : isValid;
            } else if (event.keyCode != 8) {
                event.doit = false;
            }
        });
        this.tAHV.addModifyListener(e -> {
            String text = this.tAHV.getText();
            if (!text.isEmpty() && !FormatValidator.isValidAHVNum((String)text)) {
                this.tAHV.setForeground(red);
                this.setEnableOKButton(false);
                return;
            }
            this.tAHV.setForeground(defaultAHVColor);
            this.setEnableOKButton(true);
        });
        return ret;
    }

    private void setEnableOKButton(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public void create() {
        super.create();
        this.setMessage(Messages.PatientErfassenDialog_pleaseEnterPersonalia);
        this.setTitle(Messages.PatientErfassenDialog_enterData);
        this.getShell().setText(Messages.PatientErfassenDialog_enterPatient);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        Gender gender = null;
        int idx = this.cbSex.getSelectionIndex();
        if (idx == 1 || this.cbSex.getText().contentEquals(Messages.Patient_female_short)) {
            gender = Gender.FEMALE;
        } else if (idx == 0 || this.cbSex.getText().contentEquals(Messages.Patient_male_short)) {
            gender = Gender.MALE;
        } else if (idx == -1) {
            SWTHelper.showError((String)Messages.PatientErfassenDialog_Error_Sex, (String)Messages.PatientErfassenDialog_Sex_must_be_specified);
            return;
        }
        try {
            Kontakt k;
            List list;
            TimeTool check = null;
            check = !StringTool.isNothing((Object)this.tGebDat.getText()) ? new TimeTool(this.tGebDat.getText(), true) : new TimeTool();
            Query qbe = new Query(Kontakt.class);
            qbe.add("Bezeichnung1", "=", this.tName.getText(), true);
            qbe.add("Bezeichnung2", "=", this.tVorname.getText(), true);
            if (check != null) {
                qbe.add("Geburtsdatum", "=", check.toDBString(false), true);
            }
            if ((list = qbe.execute()) != null && !list.isEmpty() && (k = (Kontakt)list.get(0)).istPerson()) {
                k.set("istPatient", "1");
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.PatientErfassenDialog_personExists, (String)Messages.PatientErfassenDialog_personWithThisNameExists)) {
                    super.cancelPressed();
                    return;
                }
            }
            this.patient = (IPatient)new IContactBuilder.PatientBuilder(CoreModelServiceHolder.get(), this.tVorname.getText(), this.tName.getText(), check.toLocalDate(), gender).build();
            this.patient.setStreet(this.tStrasse.getText());
            this.patient.setZip(this.tPlz.getText());
            this.patient.setCity(this.tOrt.getText());
            this.patient.setPhone1(this.tTel.getText());
            this.patient.setEmail(this.tMail.getText());
            CoreModelServiceHolder.get().save((Identifiable)this.patient);
            String formattedAHV = this.tAHV.getText();
            if (!formattedAHV.isEmpty()) {
                formattedAHV = FormatValidator.getFormattedAHVNum((String)formattedAHV);
                this.patient.addXid("www.ahv.ch/xid", formattedAHV, true);
            }
            super.okPressed();
        }
        catch (TimeTool.TimeFormatException e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.showError((String)"Falsches Datumsformat", (String)"Das Geburtsdatum kann nicht interpretiert werden");
            return;
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

