/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views;

import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class FindingsView
extends ViewPart
implements IRefreshable {
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);
    private TableViewer viewer;
    private FindingsComparator comparator;
    private String searchTitle;

    @Optional
    @Inject
    void crudFinding(@UIEventTopic(value="info/elexis/model/*") IFinding finding) {
        CoreUiUtil.runAsyncIfActive(() -> this.refresh(), (Object)this.viewer);
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> this.refresh(), (Object)this.viewer);
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)SWTHelper.createGridLayout((boolean)true, (int)1));
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text tSearch = new Text(main, 2048);
        tSearch.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        tSearch.setMessage("Suche");
        ModifyListener searchListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindingsView.this.searchTitle = tSearch.getText();
                FindingsView.this.refresh();
            }
        };
        tSearch.addModifyListener(searchListener);
        Composite c = new Composite(main, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        c.setLayout((Layout)tableColumnLayout);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(c, 68356);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.comparator = new FindingsComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.viewer.addFilter((ViewerFilter)new ViewFilterProvider());
        TableViewerColumn tableViewerColumnDateTime = new TableViewerColumn(this.viewer, 0);
        TableColumn tblcCol = tableViewerColumnDateTime.getColumn();
        tblcCol.setText("Erfassungsdatum");
        tableColumnLayout.setColumnData((Widget)tblcCol, (ColumnLayoutData)new ColumnWeightData(20, true));
        tblcCol.addSelectionListener((SelectionListener)this.getSelectionAdapter(tblcCol, 1));
        tableViewerColumnDateTime = new TableViewerColumn(this.viewer, 0);
        tblcCol = tableViewerColumnDateTime.getColumn();
        tblcCol.setText("Befund");
        tableColumnLayout.setColumnData((Widget)tblcCol, (ColumnLayoutData)new ColumnWeightData(80, true));
        tblcCol.addSelectionListener((SelectionListener)this.getSelectionAdapter(tblcCol, 3));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FindingsLabelProvider());
        this.refresh();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
                if (!structuredSelection.isEmpty() && (o = structuredSelection.getFirstElement()) instanceof IFinding) {
                    FindingsUiUtil.executeCommand("ch.elexis.core.findings.ui.commandEdit", (IFinding)o);
                }
            }
        });
        Transfer[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.viewer.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FindingsView.this.viewer.getSelection();
                StringBuilder sb = new StringBuilder();
                if (selection != null && !selection.isEmpty()) {
                    IObservation observation = (IObservation)selection.getFirstElement();
                    sb.append(((PersistentObject)observation).storeToString()).append(",");
                }
                event.data = sb.toString().replace(",$", "");
            }
        });
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void refresh() {
        this.viewer.setInput(this.getFindings(ContextServiceHolder.get().getActivePatient().orElse(null)));
    }

    public List<IFinding> getFindings(IPatient patient) {
        if (patient != null) {
            String patientId = patient.getId();
            List<IFinding> items = this.getObservations(patientId);
            return items;
        }
        return Collections.emptyList();
    }

    private List<IFinding> getObservations(String patientId) {
        return FindingsServiceComponent.getService().getPatientsFindings(patientId, IObservation.class).stream().filter(item -> {
            IObservation iObservation = item;
            IObservation.ObservationCategory category = iObservation.getCategory();
            if (category == IObservation.ObservationCategory.VITALSIGNS || category == IObservation.ObservationCategory.SOAP_SUBJECTIVE || category == IObservation.ObservationCategory.SOAP_OBJECTIVE) {
                return !iObservation.isReferenced();
            }
            return false;
        }).collect(Collectors.toList());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindingsView.this.comparator.setColumn(index);
                FindingsView.this.viewer.getTable().setSortDirection(FindingsView.this.comparator.getDirection());
                FindingsView.this.viewer.getTable().setSortColumn(column);
                FindingsView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    class FindingsComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IFinding p1 = (IFinding)e1;
            IFinding p2 = (IFinding)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: 
                case 1: {
                    LocalDateTime t1 = LocalDateTime.MIN;
                    LocalDateTime t2 = LocalDateTime.MIN;
                    if (p1 instanceof IObservation) {
                        t1 = ((IObservation)p1).getEffectiveTime().orElse(LocalDateTime.MIN);
                    }
                    if (p2 instanceof IObservation) {
                        t2 = ((IObservation)p2).getEffectiveTime().orElse(LocalDateTime.MIN);
                    }
                    rc = t1.compareTo(t2);
                    break;
                }
                case 2: {
                    String txt1 = p1.getText().orElse("");
                    String txt2 = p2.getText().orElse("");
                    rc = txt1.toLowerCase().compareTo(txt2.toLowerCase());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class FindingsLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        FindingsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFinding item = (IFinding)element;
            switch (columnIndex) {
                case 0: {
                    if (!(item instanceof IObservation)) break;
                    IObservation ob = (IObservation)item;
                    return ob.getEffectiveTime().isPresent() ? new TimeTool((LocalDateTime)ob.getEffectiveTime().get()).toString(0) : "";
                }
                case 1: {
                    return item.getText().isPresent() ? (String)item.getText().get() : "";
                }
            }
            return "";
        }
    }

    class ViewFilterProvider
    extends ViewerFilter {
        ViewFilterProvider() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (FindingsView.this.searchTitle != null && !FindingsView.this.searchTitle.isEmpty()) {
                IFinding iFinding;
                String text;
                String searchText = FindingsView.this.searchTitle.toLowerCase();
                return element instanceof IFinding && (text = (iFinding = (IFinding)element).getText().orElse("")).toLowerCase().contains(searchText);
            }
            return true;
        }
    }
}

