/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IdentifierSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.IPersonHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MaritalStatus;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class IPatientPatientAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IPatient, Patient> {
    private IPersonHelper personHelper = new IPersonHelper();
    private IModelService coreModelService;
    private IXidService xidService;

    public IPatientPatientAttributeMapper(IModelService coreModelService, IXidService xidService) {
        this.coreModelService = coreModelService;
        this.xidService = xidService;
    }

    @Override
    public void elexisToFhir(IPatient source, Patient target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt(Patient.class.getSimpleName(), source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)source, (DomainResource)target);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        List<Identifier> identifiers = this.personHelper.getIdentifiers((IContact)source, this.xidService);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)source));
        identifiers.add(this.getPatientNumberIdentifier(source));
        target.setIdentifier(identifiers);
        target.setName(this.personHelper.getHumanNames((IPerson)source));
        target.setGender(this.personHelper.getGender(source.getGender()));
        target.setBirthDate(this.personHelper.getBirthDate((IPerson)source));
        target.setAddress(this.personHelper.getAddresses((IContact)source));
        target.setTelecom(this.personHelper.getContactPoints((IContact)source));
        this.mapComments(source, target);
        this.mapMaritalStatus(source, target);
        this.mapRelatedContacts(source, target);
        Attachment contactImage = this.personHelper.mapContactImage((IContact)source);
        target.setPhoto(contactImage != null ? Collections.singletonList(contactImage) : null);
    }

    @Override
    public void fhirToElexis(Patient source, IPatient target) {
        this.personHelper.mapIdentifiers(source.getIdentifier(), (IContact)target);
        this.personHelper.mapHumanName(source.getName(), (IPerson)target);
        this.personHelper.mapGender(source.getGender(), (IPerson)target);
        this.personHelper.mapBirthDate(source.getBirthDate(), (IPerson)target);
        this.personHelper.mapAddress(source.getAddress(), (IContact)target);
        this.personHelper.mapTelecom(source.getTelecom(), (IContact)target);
        this.personHelper.mapContactImage(this.coreModelService, source.getPhoto() != null && !source.getPhoto().isEmpty() ? (Attachment)source.getPhoto().get(0) : null, (IPerson)target);
        this.mapComments(source, target);
        this.mapMaritalStatus(source, target);
    }

    private void mapRelatedContacts(IPatient source, Patient target) {
        ArrayList<Patient.ContactComponent> contacts = new ArrayList<Patient.ContactComponent>();
        IContact legalGuardian = source.getLegalGuardian();
        if (legalGuardian != null) {
            Patient.ContactComponent _legalGuardian = new Patient.ContactComponent();
            CodeableConcept addCoding = new CodeableConcept().addCoding(new Coding().setCode("N"));
            _legalGuardian.setRelationship(Collections.singletonList(addCoding));
            _legalGuardian.setId(legalGuardian.getId());
            if (legalGuardian.isPerson()) {
                IPerson legalGuardianPerson = (IPerson)CoreModelServiceHolder.get().load(legalGuardian.getId(), IPerson.class).get();
                List<HumanName> humanNames = this.personHelper.getHumanNames(legalGuardianPerson);
                _legalGuardian.setName(!humanNames.isEmpty() ? humanNames.get(0) : null);
                Enumerations.AdministrativeGender gender = this.personHelper.getGender(legalGuardianPerson.getGender());
                _legalGuardian.setGender(gender);
            } else if (legalGuardian.isOrganization()) {
                IOrganization legalGuardianOrganization = (IOrganization)CoreModelServiceHolder.get().load(legalGuardian.getId(), IOrganization.class).get();
                this.personHelper.getOrganizationName(legalGuardianOrganization);
            }
            List<Address> addresses = this.personHelper.getAddresses(legalGuardian);
            _legalGuardian.setAddress(!addresses.isEmpty() ? addresses.get(0) : null);
            List<ContactPoint> contactPoints = this.personHelper.getContactPoints(legalGuardian);
            _legalGuardian.setTelecom(contactPoints);
            contacts.add(_legalGuardian);
        }
        target.setContact(contacts);
    }

    private void mapMaritalStatus(IPatient source, Patient target) {
        MaritalStatus maritalStatus = source.getMaritalStatus();
        if (maritalStatus != null) {
            target.setMaritalStatus(new CodeableConcept().addCoding(new Coding().setCode(maritalStatus.getFhirCode())));
        }
    }

    private void mapMaritalStatus(Patient source, IPatient target) {
        CodeableConcept maritalStatus = source.getMaritalStatus();
        if (maritalStatus != null && !maritalStatus.getCoding().isEmpty()) {
            String code = ((Coding)maritalStatus.getCoding().get(0)).getCode();
            target.setMaritalStatus(MaritalStatus.byFhirCodeSafe((String)code));
        }
    }

    private void mapComments(Patient source, IPatient target) {
        List extensionsByUrl = source.getExtensionsByUrl("www.elexis.info/extensions/patient/notes");
        if (!extensionsByUrl.isEmpty()) {
            target.setComment(((Extension)extensionsByUrl.get(0)).getValue().toString());
        }
    }

    private void mapComments(IPatient source, Patient target) {
        Extension elexisPatientNote = new Extension();
        elexisPatientNote.setUrl("www.elexis.info/extensions/patient/notes");
        elexisPatientNote.setValue((Type)new StringType(source.getComment()));
        target.addExtension(elexisPatientNote);
    }

    private Identifier getPatientNumberIdentifier(IPatient source) {
        String patNr = source.getPatientNr();
        Identifier identifier = new Identifier();
        identifier.setSystem(IdentifierSystem.ELEXIS_PATNR.getSystem());
        identifier.setValue(patNr);
        return identifier;
    }
}

