/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IModelService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DocumentReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class DocumentReferenceIDocumentReferenceTransformer
implements IFhirTransformer<DocumentReference, IDocumentReference> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService codeModelService;
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;
    @Reference(target="(storeid=ch.elexis.data.store.omnivore)")
    private IDocumentStore omnivoreStore;
    @Reference
    private IFindingsService findingsService;
    private FindingsContentHelper contentHelper;

    @Activate
    public void activate() {
        this.contentHelper = new FindingsContentHelper();
    }

    @Override
    public Optional<DocumentReference> getFhirObject(IDocumentReference localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            DocumentReference ret = (DocumentReference)resource.get();
            if (ret.getContent().isEmpty()) {
                IDocument document = localObject.getDocument();
                if (document != null) {
                    ret.addCategory(new CodeableConcept(new Coding("http://elexis.info/document/storeid", document.getStoreId(), "")));
                    DocumentReference.DocumentReferenceContentComponent content = new DocumentReference.DocumentReferenceContentComponent();
                    Attachment attachment = new Attachment();
                    String title = document.getTitle();
                    String extension = FilenameUtils.getExtension((String)title);
                    String documentExtension = document.getExtension();
                    if (StringUtils.isEmpty((CharSequence)extension) || StringUtils.isNotBlank((CharSequence)documentExtension) && !documentExtension.equals(extension)) {
                        title = String.valueOf(title) + "." + documentExtension;
                    }
                    attachment.setTitle(title);
                    attachment.setUrl(this.getBinaryUrl(ret));
                    content.setAttachment(attachment);
                    ret.addContent(content);
                } else {
                    LoggerFactory.getLogger(this.getClass()).error("No document with content found for reference " + ret);
                }
            }
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    private String getBinaryUrl(DocumentReference ret) {
        return String.valueOf(ret.getId()) + "/$binary-access-read";
    }

    @Override
    public Optional<IDocumentReference> getLocalObject(DocumentReference fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.findingsService.findById(localId.get(), IDocumentReference.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IDocumentReference> updateLocalObject(DocumentReference fhirObject, IDocumentReference localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<IDocumentReference> createLocalObject(DocumentReference fhirObject) {
        if (fhirObject.getContent() != null && !fhirObject.getContent().isEmpty()) {
            DocumentReference.DocumentReferenceContentComponent content = (DocumentReference.DocumentReferenceContentComponent)fhirObject.getContent().get(0);
            Attachment attachment = content.getAttachment();
            Optional<String> patientId = FhirUtil.getId(fhirObject.getSubject());
            if (patientId.isPresent()) {
                Optional patientKontakt = this.codeModelService.load(patientId.get(), IPatient.class);
                if (patientKontakt.isPresent()) {
                    IDocumentReference iDocumentReference = (IDocumentReference)this.findingsService.create(IDocumentReference.class);
                    this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iDocumentReference);
                    iDocumentReference.setPatientId(((IPatient)patientKontakt.get()).getId());
                    IDocument document = this.createDocument((IPatient)patientKontakt.get(), attachment, iDocumentReference.getCategory());
                    if (document != null) {
                        fhirObject.getContent().clear();
                        this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iDocumentReference);
                        iDocumentReference.setDocument(document);
                    }
                    this.findingsService.saveFinding((IFinding)iDocumentReference);
                    return Optional.of(iDocumentReference);
                }
                LoggerFactory.getLogger(this.getClass()).error("Patient [" + fhirObject.getSubject().getId() + "] not found");
            } else {
                LoggerFactory.getLogger(this.getClass()).error("No patient for document");
            }
        }
        return Optional.empty();
    }

    private IDocument createDocument(IPatient patient, Attachment attachment, String category) {
        IDocument ret;
        block28: {
            ret = this.omnivoreStore.createDocument(patient.getId(), attachment.getTitle(), category);
            if (StringUtils.isNotBlank((CharSequence)attachment.getContentType())) {
                ret.setMimeType(attachment.getContentType());
            }
            try {
                this.omnivoreStore.saveDocument(ret);
                if (attachment == null) break block28;
                if (attachment.getData() != null) {
                    try {
                        Throwable throwable = null;
                        Object var6_11 = null;
                        try (ByteArrayInputStream in = new ByteArrayInputStream(attachment.getData());){
                            this.omnivoreStore.saveDocument(ret, (InputStream)in);
                            break block28;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (ElexisException | IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error reading content from attachment data [" + attachment.getUrl() + "]", e);
                    }
                    break block28;
                }
                if (!StringUtils.isNotBlank((CharSequence)attachment.getUrl()) || !attachment.getUrl().contains("://")) break block28;
                try {
                    URL url = new URL(attachment.getUrl());
                    try {
                        Throwable throwable = null;
                        Object var7_17 = null;
                        try (InputStream in = url.openStream();){
                            this.omnivoreStore.saveDocument(ret, in);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (ElexisException | IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error reading content from url [" + attachment.getUrl() + "]", e);
                    }
                }
                catch (MalformedURLException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Attachment url invalid", (Throwable)e);
                }
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating document", (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return DocumentReference.class.equals(fhirClazz) && IDocumentReference.class.equals(localClazz);
    }
}

