/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.context.RepeatContextSupport;

public class CompositeCompletionPolicy
implements CompletionPolicy {
    CompletionPolicy[] policies = new CompletionPolicy[0];

    public void setPolicies(CompletionPolicy[] policies) {
        this.policies = Arrays.asList(policies).toArray(new CompletionPolicy[policies.length]);
    }

    @Override
    public boolean isComplete(RepeatContext context, RepeatStatus result) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i2 = 0; i2 < policies.length; ++i2) {
            if (!policies[i2].isComplete(contexts[i2], result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i2 = 0; i2 < policies.length; ++i2) {
            if (!policies[i2].isComplete(contexts[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public RepeatContext start(RepeatContext context) {
        ArrayList<RepeatContext> list = new ArrayList<RepeatContext>();
        for (int i2 = 0; i2 < this.policies.length; ++i2) {
            list.add(this.policies[i2].start(context));
        }
        return new CompositeBatchContext(context, list);
    }

    @Override
    public void update(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i2 = 0; i2 < policies.length; ++i2) {
            policies[i2].update(contexts[i2]);
        }
        ((RepeatContextSupport)context).increment();
    }

    protected class CompositeBatchContext
    extends RepeatContextSupport {
        private RepeatContext[] contexts;
        private CompletionPolicy[] policies;

        public CompositeBatchContext(RepeatContext context, List<RepeatContext> contexts) {
            super(context);
            this.contexts = contexts.toArray(new RepeatContext[contexts.size()]);
            this.policies = CompositeCompletionPolicy.this.policies;
        }
    }
}

