/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.jsr.repeat;

import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.util.Assert;

public class CheckpointAlgorithmAdapter
implements CompletionPolicy {
    private CheckpointAlgorithm policy;
    private boolean isComplete = false;

    public CheckpointAlgorithmAdapter(CheckpointAlgorithm policy) {
        Assert.notNull((Object)policy, "A CheckpointAlgorithm is required");
        this.policy = policy;
    }

    @Override
    public boolean isComplete(RepeatContext context, RepeatStatus result) {
        try {
            this.isComplete = this.policy.isReadyToCheckpoint();
            return this.isComplete;
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }

    @Override
    public boolean isComplete(RepeatContext context) {
        try {
            this.isComplete = this.policy.isReadyToCheckpoint();
            return this.isComplete;
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }

    @Override
    public RepeatContext start(RepeatContext parent) {
        try {
            this.policy.beginCheckpoint();
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
        return parent;
    }

    @Override
    public void update(RepeatContext context) {
        try {
            if (this.isComplete) {
                this.policy.endCheckpoint();
            }
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }
}

