/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.Iterator;
import org.springframework.batch.item.ItemReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class IteratorItemReader<T>
implements ItemReader<T> {
    private final Iterator<T> iterator;

    public IteratorItemReader(Iterable<T> iterable) {
        Assert.notNull(iterable, "Iterable argument cannot be null!");
        this.iterator = iterable.iterator();
    }

    public IteratorItemReader(Iterator<T> iterator2) {
        Assert.notNull(iterator2, "Iterator argument cannot be null!");
        this.iterator = iterator2;
    }

    @Override
    @Nullable
    public T read() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return null;
    }
}

