/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.json;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.item.json.JsonObjectMarshaller;
import org.springframework.batch.item.support.AbstractFileItemWriter;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JsonFileItemWriter<T>
extends AbstractFileItemWriter<T> {
    private static final char JSON_OBJECT_SEPARATOR = ',';
    private static final char JSON_ARRAY_START = '[';
    private static final char JSON_ARRAY_STOP = ']';
    private JsonObjectMarshaller<T> jsonObjectMarshaller;

    public JsonFileItemWriter(Resource resource, JsonObjectMarshaller<T> jsonObjectMarshaller) {
        Assert.notNull((Object)resource, "resource must not be null");
        Assert.notNull(jsonObjectMarshaller, "json object marshaller must not be null");
        this.setResource(resource);
        this.setJsonObjectMarshaller(jsonObjectMarshaller);
        this.setHeaderCallback(writer -> writer.write(91));
        this.setFooterCallback(writer -> writer.write(this.lineSeparator + ']' + this.lineSeparator));
        this.setExecutionContextName(ClassUtils.getShortName(JsonFileItemWriter.class));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.append) {
            this.shouldDeleteIfExists = false;
        }
    }

    public void setJsonObjectMarshaller(JsonObjectMarshaller<T> jsonObjectMarshaller) {
        this.jsonObjectMarshaller = jsonObjectMarshaller;
    }

    @Override
    public String doWrite(List<? extends T> items) {
        StringBuilder lines = new StringBuilder();
        Iterator<T> iterator2 = items.iterator();
        if (!items.isEmpty() && this.state.getLinesWritten() > 0L) {
            lines.append(',').append(this.lineSeparator);
        }
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            lines.append(' ').append(this.jsonObjectMarshaller.marshal(item));
            if (!iterator2.hasNext()) continue;
            lines.append(',').append(this.lineSeparator);
        }
        return lines.toString();
    }
}

