/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.util.List;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.support.AbstractFileItemWriter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FlatFileItemWriter<T>
extends AbstractFileItemWriter<T> {
    protected LineAggregator<T> lineAggregator;

    public FlatFileItemWriter() {
        this.setExecutionContextName(ClassUtils.getShortName(FlatFileItemWriter.class));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.lineAggregator, "A LineAggregator must be provided.");
        if (this.append) {
            this.shouldDeleteIfExists = false;
        }
    }

    public void setLineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
    }

    @Override
    public String doWrite(List<? extends T> items) {
        StringBuilder lines = new StringBuilder();
        for (T item : items) {
            lines.append(this.lineAggregator.aggregate(item)).append(this.lineSeparator);
        }
        return lines.toString();
    }
}

