/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.data.RepositoryItemReader;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RepositoryItemReaderBuilder<T> {
    private PagingAndSortingRepository<?, ?> repository;
    private Map<String, Sort.Direction> sorts;
    private List<?> arguments;
    private int pageSize = 10;
    private String methodName;
    private RepositoryMethodReference<?> repositoryMethodReference;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public RepositoryItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public RepositoryItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public RepositoryItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public RepositoryItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public RepositoryItemReaderBuilder<T> arguments(List<?> arguments) {
        this.arguments = arguments;
        return this;
    }

    public RepositoryItemReaderBuilder<T> arguments(Object ... arguments) {
        return this.arguments(Arrays.asList(arguments));
    }

    public RepositoryItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public RepositoryItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public RepositoryItemReaderBuilder<T> repository(PagingAndSortingRepository<?, ?> repository) {
        this.repository = repository;
        return this;
    }

    public RepositoryItemReaderBuilder<T> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public RepositoryItemReaderBuilder<T> repository(RepositoryMethodReference<?> repositoryMethodReference) {
        this.repositoryMethodReference = repositoryMethodReference;
        return this;
    }

    public RepositoryItemReader<T> build() {
        if (this.repositoryMethodReference != null) {
            this.methodName = this.repositoryMethodReference.getMethodName();
            this.repository = this.repositoryMethodReference.getRepository();
            if (CollectionUtils.isEmpty(this.arguments)) {
                this.arguments = this.repositoryMethodReference.getArguments();
            }
        }
        Assert.notNull(this.sorts, "sorts map is required.");
        Assert.notNull(this.repository, "repository is required.");
        Assert.hasText(this.methodName, "methodName is required.");
        if (this.saveState) {
            Assert.state(StringUtils.hasText(this.name), "A name is required when saveState is set to true.");
        }
        RepositoryItemReader reader = new RepositoryItemReader();
        reader.setArguments(this.arguments);
        reader.setRepository(this.repository);
        reader.setMethodName(this.methodName);
        reader.setPageSize(this.pageSize);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setSaveState(this.saveState);
        reader.setSort(this.sorts);
        reader.setName(this.name);
        return reader;
    }

    private static class RepositoryMethodInterceptor
    implements MethodInterceptor {
        private String methodName;
        private List<Object> arguments;

        private RepositoryMethodInterceptor() {
        }

        @Override
        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            this.methodName = method.getName();
            if (objects != null && objects.length > 1) {
                this.arguments = new ArrayList<Object>(Arrays.asList(objects));
                this.arguments.remove(objects.length - 1);
            }
            return null;
        }

        String getMethodName() {
            return this.methodName;
        }

        List<Object> getArguments() {
            return this.arguments;
        }
    }

    public static class RepositoryMethodReference<T> {
        private RepositoryMethodInterceptor repositoryInvocationHandler;
        private PagingAndSortingRepository<?, ?> repository;

        public RepositoryMethodReference(PagingAndSortingRepository<?, ?> repository) {
            this.repository = repository;
            this.repositoryInvocationHandler = new RepositoryMethodInterceptor();
        }

        public T methodIs() {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(this.repository.getClass());
            enhancer.setCallback(this.repositoryInvocationHandler);
            return (T)enhancer.create();
        }

        PagingAndSortingRepository<?, ?> getRepository() {
            return this.repository;
        }

        String getMethodName() {
            return this.repositoryInvocationHandler.getMethodName();
        }

        List<Object> getArguments() {
            return this.repositoryInvocationHandler.getArguments();
        }
    }
}

