/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class RepositoryItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private PagingAndSortingRepository<?, ?> repository;
    private Sort sort;
    private volatile int page = 0;
    private int pageSize = 10;
    private volatile int current = 0;
    private List<?> arguments;
    private volatile List<T> results;
    private final Object lock = new Object();
    private String methodName;

    public RepositoryItemReader() {
        this.setName(ClassUtils.getShortName(RepositoryItemReader.class));
    }

    public void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }

    public void setSort(Map<String, Sort.Direction> sorts) {
        this.sort = this.convertToSort(sorts);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRepository(PagingAndSortingRepository<?, ?> repository) {
        this.repository = repository;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.repository != null, "A PagingAndSortingRepository is required");
        Assert.state(this.pageSize > 0, "Page size must be greater than 0");
        Assert.state(this.sort != null, "A sort is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected T doRead() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            boolean nextPageNeeded;
            boolean bl = nextPageNeeded = this.results != null && this.current >= this.results.size();
            if (this.results == null || nextPageNeeded) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reading page " + this.page);
                }
                this.results = this.doPageRead();
                ++this.page;
                if (this.results.size() <= 0) {
                    return null;
                }
                if (nextPageNeeded) {
                    this.current = 0;
                }
            }
            if (this.current < this.results.size()) {
                T curLine = this.results.get(this.current);
                ++this.current;
                return curLine;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void jumpToItem(int itemLastIndex) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.page = itemLastIndex / this.pageSize;
            this.current = itemLastIndex % this.pageSize;
        }
    }

    protected List<T> doPageRead() throws Exception {
        PageRequest pageRequest = PageRequest.of((int)this.page, (int)this.pageSize, (Sort)this.sort);
        MethodInvoker invoker = this.createMethodInvoker(this.repository, this.methodName);
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.arguments != null && this.arguments.size() > 0) {
            parameters.addAll(this.arguments);
        }
        parameters.add(pageRequest);
        invoker.setArguments(parameters.toArray());
        Page curPage = (Page)this.doInvoke(invoker);
        return curPage.getContent();
    }

    @Override
    protected void doOpen() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.current = 0;
            this.page = 0;
            this.results = null;
        }
    }

    private Sort convertToSort(Map<String, Sort.Direction> sorts) {
        ArrayList<Sort.Order> sortValues = new ArrayList<Sort.Order>();
        for (Map.Entry<String, Sort.Direction> curSort : sorts.entrySet()) {
            sortValues.add(new Sort.Order(curSort.getValue(), curSort.getKey()));
        }
        return Sort.by(sortValues);
    }

    private Object doInvoke(MethodInvoker invoker) throws Exception {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return invoker.invoke();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new AbstractMethodInvokingDelegator.InvocationTargetThrowableWrapper(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        return invoker;
    }
}

