/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.job;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.item.ExecutionContext;

public class DefaultJobParametersExtractor
implements JobParametersExtractor {
    private Set<String> keys = new HashSet<String>();
    private boolean useAllParentParameters = true;

    public void setKeys(String[] keys2) {
        this.keys = new HashSet<String>(Arrays.asList(keys2));
    }

    @Override
    public JobParameters getJobParameters(Job job, StepExecution stepExecution) {
        JobParametersBuilder builder = new JobParametersBuilder();
        Map<String, JobParameter> jobParameters = stepExecution.getJobParameters().getParameters();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        if (this.useAllParentParameters) {
            for (String key : jobParameters.keySet()) {
                builder.addParameter(key, jobParameters.get(key));
            }
        }
        for (String key : this.keys) {
            if (key.endsWith("(long)")) {
                if (executionContext.containsKey(key = key.replace("(long)", ""))) {
                    builder.addLong(key, executionContext.getLong(key));
                    continue;
                }
                if (!jobParameters.containsKey(key)) continue;
                builder.addLong(key, (Long)jobParameters.get(key).getValue());
                continue;
            }
            if (key.endsWith("(int)")) {
                if (executionContext.containsKey(key = key.replace("(int)", ""))) {
                    builder.addLong(key, Long.valueOf(executionContext.getInt(key)));
                    continue;
                }
                if (!jobParameters.containsKey(key)) continue;
                builder.addLong(key, (Long)jobParameters.get(key).getValue());
                continue;
            }
            if (key.endsWith("(double)")) {
                if (executionContext.containsKey(key = key.replace("(double)", ""))) {
                    builder.addDouble(key, executionContext.getDouble(key));
                    continue;
                }
                if (!jobParameters.containsKey(key)) continue;
                builder.addDouble(key, (Double)jobParameters.get(key).getValue());
                continue;
            }
            if (key.endsWith("(string)")) {
                if (executionContext.containsKey(key = key.replace("(string)", ""))) {
                    builder.addString(key, executionContext.getString(key));
                    continue;
                }
                if (!jobParameters.containsKey(key)) continue;
                builder.addString(key, (String)jobParameters.get(key).getValue());
                continue;
            }
            if (key.endsWith("(date)")) {
                if (executionContext.containsKey(key = key.replace("(date)", ""))) {
                    builder.addDate(key, (Date)executionContext.get(key));
                    continue;
                }
                if (!jobParameters.containsKey(key)) continue;
                builder.addDate(key, (Date)jobParameters.get(key).getValue());
                continue;
            }
            if (executionContext.containsKey(key)) {
                builder.addString(key, executionContext.get(key).toString());
                continue;
            }
            if (!jobParameters.containsKey(key)) continue;
            builder.addString(key, jobParameters.get(key).getValue().toString());
        }
        return builder.toJobParameters();
    }

    public void setUseAllParentParameters(boolean useAllParentParameters) {
        this.useAllParentParameters = useAllParentParameters;
    }
}

