/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.annotation.OnSkipInProcess;
import org.springframework.batch.core.annotation.OnSkipInRead;
import org.springframework.batch.core.annotation.OnSkipInWrite;
import org.springframework.batch.core.listener.StepListenerFactoryBean;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.FatalStepExecutionException;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.item.FaultTolerantChunkProcessor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProvider;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleRetryExceptionHandler;
import org.springframework.batch.core.step.skip.CompositeSkipPolicy;
import org.springframework.batch.core.step.skip.ExceptionClassifierSkipPolicy;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NeverSkipItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicyFailedException;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.support.ReflectionUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;
import org.springframework.classify.SubclassClassifier;
import org.springframework.retry.ExhaustedRetryException;
import org.springframework.retry.RetryException;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.ExceptionClassifierRetryPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class FaultTolerantStepBuilder<I, O>
extends SimpleStepBuilder<I, O> {
    private ChunkMonitor chunkMonitor = new ChunkMonitor();
    private boolean streamIsReader;
    private int retryLimit = 0;
    private BackOffPolicy backOffPolicy;
    private Set<RetryListener> retryListeners = new LinkedHashSet<RetryListener>();
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private KeyGenerator keyGenerator;
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses = new LinkedHashSet<Class<? extends Throwable>>();
    private Map<Class<? extends Throwable>, Boolean> skippableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private Collection<Class<? extends Throwable>> nonSkippableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private Collection<Class<? extends Throwable>> nonRetryableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Set<SkipListener<? super I, ? super O>> skipListeners = new LinkedHashSet<SkipListener<? super I, ? super O>>();
    private Set<org.springframework.batch.core.jsr.RetryListener> jsrRetryListeners = new LinkedHashSet<org.springframework.batch.core.jsr.RetryListener>();
    private int skipLimit = 0;
    private SkipPolicy skipPolicy;
    private boolean processorTransactional = true;

    public FaultTolerantStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    protected FaultTolerantStepBuilder(SimpleStepBuilder<I, O> parent) {
        super(parent);
    }

    @Override
    public TaskletStep build() {
        this.registerStepListenerAsSkipListener();
        return super.build();
    }

    protected void registerStepListenerAsSkipListener() {
        for (StepExecutionListener stepExecutionListener : this.properties.getStepExecutionListeners()) {
            if (!(stepExecutionListener instanceof SkipListener)) continue;
            this.listener((SkipListener)((Object)stepExecutionListener));
        }
        for (ChunkListener chunkListener : this.chunkListeners) {
            if (!(chunkListener instanceof SkipListener)) continue;
            this.listener((SkipListener)((Object)chunkListener));
        }
    }

    @Override
    protected Tasklet createTasklet() {
        Assert.state(this.getReader() != null, "ItemReader must be provided");
        Assert.state(this.getWriter() != null, "ItemWriter must be provided");
        this.addSpecialExceptions();
        this.registerSkipListeners();
        ChunkProvider<I> chunkProvider = this.createChunkProvider();
        ChunkProcessor<I> chunkProcessor = this.createChunkProcessor();
        ChunkOrientedTasklet<I> tasklet = new ChunkOrientedTasklet<I>(chunkProvider, chunkProcessor);
        tasklet.setBuffering(!this.isReaderTransactionalQueue());
        return tasklet;
    }

    @Override
    public SimpleStepBuilder<I, O> listener(Object listener) {
        super.listener(listener);
        HashSet<Method> skipListenerMethods = new HashSet<Method>();
        skipListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), OnSkipInRead.class));
        skipListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), OnSkipInProcess.class));
        skipListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), OnSkipInWrite.class));
        if (skipListenerMethods.size() > 0) {
            StepListenerFactoryBean factory = new StepListenerFactoryBean();
            factory.setDelegate(listener);
            this.skipListeners.add((SkipListener)factory.getObject());
        }
        FaultTolerantStepBuilder result = this;
        return result;
    }

    @Override
    public FaultTolerantStepBuilder<I, O> listener(SkipListener<? super I, ? super O> listener) {
        this.skipListeners.add(listener);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> listener(org.springframework.batch.core.jsr.RetryListener listener) {
        this.jsrRetryListeners.add(listener);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> listener(ChunkListener listener) {
        super.listener(new TerminateOnExceptionChunkListenerDelegate(listener));
        return this;
    }

    @Override
    public AbstractTaskletStepBuilder<SimpleStepBuilder<I, O>> transactionAttribute(TransactionAttribute transactionAttribute) {
        return super.transactionAttribute(this.getTransactionAttribute(transactionAttribute));
    }

    public FaultTolerantStepBuilder<I, O> listener(RetryListener listener) {
        this.retryListeners.add(listener);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> keyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> retryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> backOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> retryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> skipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> noSkip(Class<? extends Throwable> type) {
        this.skippableExceptionClasses.put(type, false);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> skip(Class<? extends Throwable> type) {
        this.skippableExceptionClasses.put(type, true);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> skipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
        return this;
    }

    public FaultTolerantStepBuilder<I, O> noRollback(Class<? extends Throwable> type) {
        this.noRollbackExceptionClasses.add(type);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> noRetry(Class<? extends Throwable> type) {
        this.retryableExceptionClasses.put(type, false);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> retry(Class<? extends Throwable> type) {
        this.retryableExceptionClasses.put(type, true);
        return this;
    }

    public FaultTolerantStepBuilder<I, O> processorNonTransactional() {
        this.processorTransactional = false;
        return this;
    }

    @Override
    public AbstractTaskletStepBuilder<SimpleStepBuilder<I, O>> stream(ItemStream stream) {
        if (stream instanceof ItemReader) {
            if (!this.streamIsReader) {
                this.streamIsReader = true;
                super.stream(this.chunkMonitor);
            }
            this.chunkMonitor.registerItemStream(stream);
        } else {
            super.stream(stream);
        }
        return this;
    }

    @Override
    public FaultTolerantStepBuilder<I, O> faultTolerant() {
        return this;
    }

    protected ChunkProvider<I> createChunkProvider() {
        SkipPolicy readSkipPolicy = this.createSkipPolicy();
        readSkipPolicy = this.getFatalExceptionAwareProxy(readSkipPolicy);
        FaultTolerantChunkProvider chunkProvider = new FaultTolerantChunkProvider(this.getReader(), this.createChunkOperations());
        chunkProvider.setMaxSkipsOnRead(Math.max(this.getChunkSize(), 100));
        chunkProvider.setSkipPolicy(readSkipPolicy);
        chunkProvider.setRollbackClassifier(this.getRollbackClassifier());
        ArrayList<StepListener> listeners = new ArrayList<StepListener>(this.getItemListeners());
        listeners.addAll(this.skipListeners);
        chunkProvider.setListeners(listeners);
        return chunkProvider;
    }

    protected ChunkProcessor<I> createChunkProcessor() {
        BatchRetryTemplate batchRetryTemplate = this.createRetryOperations();
        FaultTolerantChunkProcessor chunkProcessor = new FaultTolerantChunkProcessor(this.getProcessor(), this.getWriter(), batchRetryTemplate);
        chunkProcessor.setBuffering(!this.isReaderTransactionalQueue());
        chunkProcessor.setProcessorTransactional(this.processorTransactional);
        SkipPolicy writeSkipPolicy = this.createSkipPolicy();
        writeSkipPolicy = this.getFatalExceptionAwareProxy(writeSkipPolicy);
        chunkProcessor.setWriteSkipPolicy(writeSkipPolicy);
        chunkProcessor.setProcessSkipPolicy(writeSkipPolicy);
        chunkProcessor.setRollbackClassifier(this.getRollbackClassifier());
        chunkProcessor.setKeyGenerator(this.keyGenerator);
        this.detectStreamInReader();
        ArrayList<StepListener> listeners = new ArrayList<StepListener>(this.getItemListeners());
        listeners.addAll(this.skipListeners);
        chunkProcessor.setListeners(listeners);
        chunkProcessor.setChunkMonitor(this.chunkMonitor);
        return chunkProcessor;
    }

    private void addSpecialExceptions() {
        this.addNonSkippableExceptionIfMissing(SkipLimitExceededException.class, NonSkippableReadException.class, SkipListenerFailedException.class, SkipPolicyFailedException.class, RetryException.class, JobInterruptedException.class, Error.class, BeanCreationException.class);
        this.addNonRetryableExceptionIfMissing(SkipLimitExceededException.class, NonSkippableReadException.class, TransactionException.class, FatalStepExecutionException.class, SkipListenerFailedException.class, SkipPolicyFailedException.class, RetryException.class, JobInterruptedException.class, Error.class, BatchRuntimeException.class, BeanCreationException.class);
    }

    protected void detectStreamInReader() {
        if (this.streamIsReader) {
            if (!this.concurrent()) {
                this.chunkMonitor.setItemReader(this.getReader());
            } else {
                this.logger.warn("Asynchronous TaskExecutor detected with ItemStream reader.  This is probably an error, and may lead to incorrect restart data being stored.");
            }
        }
    }

    private void registerSkipListeners() {
        for (Object itemHandler : new Object[]{this.getReader(), this.getWriter(), this.getProcessor()}) {
            StepListener listener;
            if (!StepListenerFactoryBean.isListener(itemHandler) || !((listener = StepListenerFactoryBean.getListener(itemHandler)) instanceof SkipListener)) continue;
            SkipListener skipListener = (SkipListener)listener;
            this.skipListeners.add(skipListener);
        }
    }

    protected Classifier<Throwable, Boolean> getRollbackClassifier() {
        Classifier<Throwable, Boolean> classifier = new BinaryExceptionClassifier(this.noRollbackExceptionClasses, false);
        if (!((Boolean)classifier.classify(new ForceRollbackForWriteSkipException("test", new RuntimeException()))).booleanValue() || !((Boolean)classifier.classify(new ExhaustedRetryException("test"))).booleanValue()) {
            BinaryExceptionClassifier binary = classifier;
            HashSet<Class<? extends Throwable>> types = new HashSet<Class<? extends Throwable>>();
            types.add(ForceRollbackForWriteSkipException.class);
            types.add(ExhaustedRetryException.class);
            BinaryExceptionClassifier panic = new BinaryExceptionClassifier(types, true);
            classifier = classifiable -> (Boolean)panic.classify(classifiable) != false || (Boolean)binary.classify(classifiable) != false;
        }
        return classifier;
    }

    private TransactionAttribute getTransactionAttribute(TransactionAttribute attribute) {
        final Classifier<Throwable, Boolean> classifier = this.getRollbackClassifier();
        return new DefaultTransactionAttribute(attribute){

            @Override
            public boolean rollbackOn(Throwable ex) {
                return (Boolean)classifier.classify(ex);
            }
        };
    }

    protected SkipPolicy createSkipPolicy() {
        SkipPolicy skipPolicy = this.skipPolicy;
        HashMap<Class<? extends Throwable>, Boolean> map = new HashMap<Class<? extends Throwable>, Boolean>(this.skippableExceptionClasses);
        map.put(ForceRollbackForWriteSkipException.class, true);
        LimitCheckingItemSkipPolicy limitCheckingItemSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, map);
        if (skipPolicy == null) {
            Assert.state(!this.skippableExceptionClasses.isEmpty() || this.skipLimit <= 0, "If a skip limit is provided then skippable exceptions must also be specified");
            skipPolicy = limitCheckingItemSkipPolicy;
        } else if (limitCheckingItemSkipPolicy != null) {
            skipPolicy = new CompositeSkipPolicy(new SkipPolicy[]{skipPolicy, limitCheckingItemSkipPolicy});
        }
        return skipPolicy;
    }

    protected BatchRetryTemplate createRetryOperations() {
        RetryPolicy retryPolicy = this.retryPolicy;
        SimpleRetryPolicy simpleRetryPolicy = null;
        HashMap<Class<? extends Throwable>, Boolean> map = new HashMap<Class<? extends Throwable>, Boolean>(this.retryableExceptionClasses);
        map.put(ForceRollbackForWriteSkipException.class, true);
        simpleRetryPolicy = new SimpleRetryPolicy(this.retryLimit, map);
        if (retryPolicy == null) {
            Assert.state(!this.retryableExceptionClasses.isEmpty() || this.retryLimit <= 0, "If a retry limit is provided then retryable exceptions must also be specified");
            retryPolicy = simpleRetryPolicy;
        } else if (!this.retryableExceptionClasses.isEmpty() && this.retryLimit > 0) {
            CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy();
            compositeRetryPolicy.setPolicies(new RetryPolicy[]{retryPolicy, simpleRetryPolicy});
            retryPolicy = compositeRetryPolicy;
        }
        RetryPolicy retryPolicyWrapper = this.getFatalExceptionAwareProxy(retryPolicy);
        BatchRetryTemplate batchRetryTemplate = new BatchRetryTemplate();
        if (this.backOffPolicy != null) {
            batchRetryTemplate.setBackOffPolicy(this.backOffPolicy);
        }
        batchRetryTemplate.setRetryPolicy(retryPolicyWrapper);
        RepeatOperations stepOperations = this.getStepOperations();
        if (stepOperations instanceof RepeatTemplate) {
            SimpleRetryExceptionHandler exceptionHandler = new SimpleRetryExceptionHandler(retryPolicyWrapper, this.getExceptionHandler(), this.nonRetryableExceptionClasses);
            ((RepeatTemplate)stepOperations).setExceptionHandler(exceptionHandler);
        }
        if (this.retryContextCache != null) {
            batchRetryTemplate.setRetryContextCache(this.retryContextCache);
        }
        if (this.retryListeners != null) {
            batchRetryTemplate.setListeners(this.retryListeners.toArray(new RetryListener[0]));
        }
        return batchRetryTemplate;
    }

    protected ChunkMonitor getChunkMonitor() {
        return this.chunkMonitor;
    }

    protected Set<SkipListener<? super I, ? super O>> getSkipListeners() {
        return this.skipListeners;
    }

    protected Set<org.springframework.batch.core.jsr.RetryListener> getJsrRetryListeners() {
        return this.jsrRetryListeners;
    }

    private RetryPolicy getFatalExceptionAwareProxy(RetryPolicy retryPolicy) {
        NeverRetryPolicy neverRetryPolicy = new NeverRetryPolicy();
        HashMap<Class<? extends Throwable>, NeverRetryPolicy> map = new HashMap<Class<? extends Throwable>, NeverRetryPolicy>();
        for (Class<? extends Throwable> fatal : this.nonRetryableExceptionClasses) {
            map.put(fatal, neverRetryPolicy);
        }
        SubclassClassifier<Throwable, RetryPolicy> classifier = new SubclassClassifier<Throwable, RetryPolicy>(retryPolicy);
        classifier.setTypeMap(map);
        ExceptionClassifierRetryPolicy retryPolicyWrapper = new ExceptionClassifierRetryPolicy();
        retryPolicyWrapper.setExceptionClassifier(classifier);
        return retryPolicyWrapper;
    }

    protected SkipPolicy getFatalExceptionAwareProxy(SkipPolicy skipPolicy) {
        NeverSkipItemSkipPolicy neverSkipPolicy = new NeverSkipItemSkipPolicy();
        HashMap<Class<? extends Throwable>, NeverSkipItemSkipPolicy> map = new HashMap<Class<? extends Throwable>, NeverSkipItemSkipPolicy>();
        for (Class<? extends Throwable> fatal : this.nonSkippableExceptionClasses) {
            map.put(fatal, neverSkipPolicy);
        }
        SubclassClassifier<Throwable, SkipPolicy> classifier = new SubclassClassifier<Throwable, SkipPolicy>(skipPolicy);
        classifier.setTypeMap(map);
        ExceptionClassifierSkipPolicy skipPolicyWrapper = new ExceptionClassifierSkipPolicy();
        skipPolicyWrapper.setExceptionClassifier(classifier);
        return skipPolicyWrapper;
    }

    private void addNonSkippableExceptionIfMissing(Class<? extends Throwable> ... cls) {
        ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> exceptionClass : this.nonSkippableExceptionClasses) {
            exceptions.add(exceptionClass);
        }
        for (Class<? extends Throwable> fatal : cls) {
            if (exceptions.contains(fatal)) continue;
            exceptions.add(fatal);
        }
        this.nonSkippableExceptionClasses = exceptions;
    }

    private void addNonRetryableExceptionIfMissing(Class<? extends Throwable> ... cls) {
        ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> exceptionClass : this.nonRetryableExceptionClasses) {
            exceptions.add(exceptionClass);
        }
        for (Class<? extends Throwable> fatal : cls) {
            if (exceptions.contains(fatal)) continue;
            exceptions.add(fatal);
        }
        this.nonRetryableExceptionClasses = exceptions;
    }

    private class TerminateOnExceptionChunkListenerDelegate
    implements ChunkListener {
        private ChunkListener chunkListener;

        TerminateOnExceptionChunkListenerDelegate(ChunkListener chunkListener) {
            this.chunkListener = chunkListener;
        }

        @Override
        public void beforeChunk(ChunkContext context) {
            try {
                this.chunkListener.beforeChunk(context);
            }
            catch (Throwable t) {
                throw new FatalStepExecutionException("ChunkListener threw exception, rethrowing as fatal", t);
            }
        }

        @Override
        public void afterChunk(ChunkContext context) {
            try {
                this.chunkListener.afterChunk(context);
            }
            catch (Throwable t) {
                throw new FatalStepExecutionException("ChunkListener threw exception, rethrowing as fatal", t);
            }
        }

        @Override
        public void afterChunkError(ChunkContext context) {
            try {
                this.chunkListener.afterChunkError(context);
            }
            catch (Throwable t) {
                throw new FatalStepExecutionException("ChunkListener threw exception, rethrowing as fatal", t);
            }
        }

        public int hashCode() {
            return this.chunkListener.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TerminateOnExceptionChunkListenerDelegate) {
                obj = ((TerminateOnExceptionChunkListenerDelegate)obj).chunkListener;
            }
            return this.chunkListener.equals(obj);
        }
    }
}

