/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Arrays;
import java.util.Iterator;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.listener.OrderedComposite;
import org.springframework.lang.Nullable;

public class CompositeStepExecutionListener
implements StepExecutionListener {
    private OrderedComposite<StepExecutionListener> list = new OrderedComposite();

    public void setListeners(StepExecutionListener[] listeners) {
        this.list.setItems(Arrays.asList(listeners));
    }

    public void register(StepExecutionListener stepExecutionListener) {
        this.list.add(stepExecutionListener);
    }

    @Override
    @Nullable
    public ExitStatus afterStep(StepExecution stepExecution) {
        Iterator<StepExecutionListener> iterator2 = this.list.reverse();
        while (iterator2.hasNext()) {
            StepExecutionListener listener = iterator2.next();
            ExitStatus close = listener.afterStep(stepExecution);
            stepExecution.setExitStatus(stepExecution.getExitStatus().and(close));
        }
        return stepExecution.getExitStatus();
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        Iterator<StepExecutionListener> iterator2 = this.list.iterator();
        while (iterator2.hasNext()) {
            StepExecutionListener listener = iterator2.next();
            listener.beforeStep(stepExecution);
        }
    }
}

