/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeItemWriteListener<S>
implements ItemWriteListener<S> {
    private OrderedComposite<ItemWriteListener<? super S>> listeners = new OrderedComposite();

    public void setListeners(List<? extends ItemWriteListener<? super S>> itemWriteListeners) {
        this.listeners.setItems(itemWriteListeners);
    }

    public void register(ItemWriteListener<? super S> itemWriteListener) {
        this.listeners.add(itemWriteListener);
    }

    @Override
    public void afterWrite(List<? extends S> items) {
        Iterator<ItemWriteListener<S>> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            ItemWriteListener<? extends S> listener = iterator2.next();
            listener.afterWrite(items);
        }
    }

    @Override
    public void beforeWrite(List<? extends S> items) {
        Iterator<ItemWriteListener<S>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            ItemWriteListener<? extends S> listener = iterator2.next();
            listener.beforeWrite(items);
        }
    }

    @Override
    public void onWriteError(Exception ex, List<? extends S> items) {
        Iterator<ItemWriteListener<S>> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            ItemWriteListener<? extends S> listener = iterator2.next();
            listener.onWriteError(ex, items);
        }
    }
}

