/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.Collection;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.BatchletParser;
import org.springframework.batch.core.jsr.configuration.xml.ChunkParser;
import org.springframework.batch.core.jsr.configuration.xml.FlowParser;
import org.springframework.batch.core.jsr.configuration.xml.JsrStepListenerFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.ListenerParser;
import org.springframework.batch.core.jsr.configuration.xml.PartitionParser;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.batch.core.jsr.configuration.xml.StepFactoryBean;
import org.springframework.batch.core.jsr.job.flow.support.state.JsrStepState;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StepParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CHUNK_ELEMENT = "chunk";
    private static final String BATCHLET_ELEMENT = "batchlet";
    private static final String ALLOW_START_IF_COMPLETE_ATTRIBUTE = "allow-start-if-complete";
    private static final String START_LIMIT_ATTRIBUTE = "start-limit";
    private static final String SPLIT_ID_ATTRIBUTE = "id";
    private static final String PARTITION_ELEMENT = "partition";

    protected Collection<BeanDefinition> parse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition();
        AbstractBeanDefinition bd = defBuilder.getRawBeanDefinition();
        bd.setBeanClass(StepFactoryBean.class);
        bd.getPropertyValues().addPropertyValue("batchPropertyContext", new RuntimeBeanReference("batchPropertyContext"));
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition(JsrStepState.class);
        String stepName = element.getAttribute(SPLIT_ID_ATTRIBUTE);
        builder.addPropertyValue("name", stepName);
        parserContext.registerBeanComponent(new BeanComponentDefinition(bd, stepName));
        stateBuilder.addConstructorArgReference(stepName);
        String startLimit = element.getAttribute(START_LIMIT_ATTRIBUTE);
        if (StringUtils.hasText(startLimit)) {
            bd.getPropertyValues().addPropertyValue("startLimit", startLimit);
        }
        String allowStartIfComplete = element.getAttribute(ALLOW_START_IF_COMPLETE_ATTRIBUTE);
        boolean allowStartIfCompleteValue = false;
        if (StringUtils.hasText(allowStartIfComplete)) {
            bd.getPropertyValues().addPropertyValue("allowStartIfComplete", allowStartIfComplete);
            allowStartIfCompleteValue = Boolean.valueOf(allowStartIfComplete);
        }
        new ListenerParser(JsrStepListenerFactoryBean.class, "listeners").parseListeners(element, parserContext, bd, stepName);
        new PropertyParser(stepName, parserContext, BatchArtifactType.STEP, stepName).parseProperties(element);
        NodeList children = element.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node nd = children.item(i2);
            if (!(nd instanceof Element)) continue;
            Element nestedElement = (Element)nd;
            String name = nestedElement.getLocalName();
            if (name.equalsIgnoreCase(BATCHLET_ELEMENT)) {
                new BatchletParser().parseBatchlet(nestedElement, bd, parserContext, stepName);
                continue;
            }
            if (name.equals(CHUNK_ELEMENT)) {
                new ChunkParser().parse(nestedElement, bd, parserContext, stepName);
                continue;
            }
            if (!name.equals(PARTITION_ELEMENT)) continue;
            new PartitionParser(stepName, allowStartIfCompleteValue).parse(nestedElement, bd, parserContext, stepName);
        }
        return FlowParser.getNextElements(parserContext, stepName, stateBuilder.getBeanDefinition(), element);
    }
}

