/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import javax.batch.api.Batchlet;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.api.partition.PartitionReducer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.jsr.partition.JsrPartitionHandler;
import org.springframework.batch.core.jsr.step.batchlet.BatchletAdapter;
import org.springframework.batch.core.jsr.step.builder.JsrBatchletStepBuilder;
import org.springframework.batch.core.jsr.step.builder.JsrFaultTolerantStepBuilder;
import org.springframework.batch.core.jsr.step.builder.JsrPartitionStepBuilder;
import org.springframework.batch.core.jsr.step.builder.JsrSimpleStepBuilder;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.jsr.item.ItemProcessorAdapter;
import org.springframework.batch.jsr.item.ItemReaderAdapter;
import org.springframework.batch.jsr.item.ItemWriterAdapter;
import org.springframework.batch.jsr.repeat.CheckpointAlgorithmAdapter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.policy.CompositeCompletionPolicy;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.policy.TimeoutTerminationPolicy;
import org.springframework.util.Assert;

public class StepFactoryBean<I, O>
extends StepParserStepFactoryBean<I, O> {
    private int partitions;
    private BatchPropertyContext batchPropertyContext;
    private PartitionReducer reducer;
    private Integer timeout;

    public void setPartitionReducer(PartitionReducer reducer) {
        this.reducer = reducer;
    }

    public void setBatchPropertyContext(BatchPropertyContext context) {
        this.batchPropertyContext = context;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    @Override
    public Step getObject() throws Exception {
        if (this.hasPartitionElement()) {
            return this.createPartitionStep();
        }
        if (this.hasChunkElement()) {
            Assert.isTrue(!this.hasTasklet(), "Step [" + this.getName() + "] has both a <chunk/> element and a 'ref' attribute  referencing a Tasklet.");
            this.validateFaultTolerantSettings();
            if (this.isFaultTolerant()) {
                return this.createFaultTolerantStep();
            }
            return this.createSimpleStep();
        }
        if (this.hasTasklet()) {
            return this.createTaskletStep();
        }
        return this.createFlowStep();
    }

    @Override
    protected TaskletStep createTaskletStep() {
        JsrBatchletStepBuilder jsrBatchletStepBuilder = new JsrBatchletStepBuilder(new StepBuilder(this.getName()));
        jsrBatchletStepBuilder.setBatchPropertyContext(this.batchPropertyContext);
        TaskletStepBuilder builder = jsrBatchletStepBuilder.tasklet(this.getTasklet());
        this.enhanceTaskletStepBuilder(builder);
        return builder.build();
    }

    @Override
    protected void setChunk(SimpleStepBuilder<I, O> builder) {
        if (this.timeout != null && this.getCommitInterval() != null) {
            CompositeCompletionPolicy completionPolicy = new CompositeCompletionPolicy();
            CompletionPolicy[] policies = new CompletionPolicy[]{new SimpleCompletionPolicy(this.getCommitInterval()), new TimeoutTerminationPolicy(this.timeout * 1000)};
            completionPolicy.setPolicies(policies);
            builder.chunk(completionPolicy);
        } else if (this.timeout != null) {
            builder.chunk(new TimeoutTerminationPolicy(this.timeout * 1000));
        } else if (this.getCommitInterval() != null) {
            builder.chunk(this.getCommitInterval());
        }
        if (this.getCompletionPolicy() != null) {
            builder.chunk(this.getCompletionPolicy());
        }
    }

    @Override
    protected Step createPartitionStep() {
        Step executedStep = null;
        if (this.hasChunkElement()) {
            Assert.isTrue(!this.hasTasklet(), "Step [" + this.getName() + "] has both a <chunk/> element and a 'ref' attribute  referencing a Tasklet.");
            this.validateFaultTolerantSettings();
            executedStep = this.isFaultTolerant() ? this.createFaultTolerantStep() : this.createSimpleStep();
        } else if (this.hasTasklet()) {
            executedStep = this.createTaskletStep();
        }
        ((JsrPartitionHandler)super.getPartitionHandler()).setStep(executedStep);
        JsrPartitionStepBuilder builder = new JsrSimpleStepBuilder(new StepBuilder(executedStep.getName())).partitioner(executedStep);
        this.enhanceCommonStep(builder);
        if (this.getPartitionHandler() != null) {
            builder.partitionHandler(this.getPartitionHandler());
        }
        if (this.reducer != null) {
            builder.reducer(this.reducer);
        }
        builder.aggregator(this.getStepExecutionAggergator());
        return builder.build();
    }

    public void setStepTasklet(Object tasklet) {
        if (tasklet instanceof Tasklet) {
            super.setTasklet((Tasklet)tasklet);
        } else if (tasklet instanceof Batchlet) {
            super.setTasklet(new BatchletAdapter((Batchlet)tasklet));
        } else {
            throw new IllegalArgumentException("The field tasklet must reference an implementation of either org.springframework.batch.core.step.tasklet.Tasklet or javax.batch.api.Batchlet");
        }
    }

    public void setStepItemReader(Object itemReader) {
        if (itemReader instanceof ItemReader) {
            super.setItemReader((ItemReader)itemReader);
        } else if (itemReader instanceof javax.batch.api.chunk.ItemReader) {
            super.setItemReader(new ItemReaderAdapter((javax.batch.api.chunk.ItemReader)itemReader));
        } else {
            throw new IllegalArgumentException("The definition of an item reader must implement either org.springframework.batch.item.ItemReader or javax.batch.api.chunk.ItemReader");
        }
    }

    public void setStepItemProcessor(Object itemProcessor) {
        if (itemProcessor instanceof ItemProcessor) {
            super.setItemProcessor((ItemProcessor)itemProcessor);
        } else if (itemProcessor instanceof javax.batch.api.chunk.ItemProcessor) {
            super.setItemProcessor(new ItemProcessorAdapter((javax.batch.api.chunk.ItemProcessor)itemProcessor));
        } else {
            throw new IllegalArgumentException("The definition of an item processor must implement either org.springframework.batch.item.ItemProcessor or javax.batch.api.chunk.ItemProcessor");
        }
    }

    public void setStepItemWriter(Object itemWriter) {
        if (itemWriter instanceof org.springframework.batch.item.ItemWriter) {
            super.setItemWriter((org.springframework.batch.item.ItemWriter)itemWriter);
        } else if (itemWriter instanceof ItemWriter) {
            super.setItemWriter(new ItemWriterAdapter((ItemWriter)itemWriter));
        } else {
            throw new IllegalArgumentException("The definition of an item writer must implement either org.springframework.batch.item.ItemWriter or javax.batch.api.chunk.ItemWriter");
        }
    }

    public void setStepChunkCompletionPolicy(Object chunkCompletionPolicy) {
        if (chunkCompletionPolicy instanceof CompletionPolicy) {
            super.setChunkCompletionPolicy((CompletionPolicy)chunkCompletionPolicy);
        } else if (chunkCompletionPolicy instanceof CheckpointAlgorithm) {
            super.setChunkCompletionPolicy(new CheckpointAlgorithmAdapter((CheckpointAlgorithm)chunkCompletionPolicy));
        } else {
            throw new IllegalArgumentException("The definition of a chunk completion policy must implement either org.springframework.batch.repeat.CompletionPolicy or javax.batch.api.chunk.CheckpointAlgorithm");
        }
    }

    @Override
    protected FaultTolerantStepBuilder<I, O> getFaultTolerantStepBuilder(String stepName) {
        JsrFaultTolerantStepBuilder jsrFaultTolerantStepBuilder = new JsrFaultTolerantStepBuilder(new StepBuilder(stepName));
        jsrFaultTolerantStepBuilder.setBatchPropertyContext(this.batchPropertyContext);
        return jsrFaultTolerantStepBuilder;
    }

    @Override
    protected SimpleStepBuilder<I, O> getSimpleStepBuilder(String stepName) {
        JsrSimpleStepBuilder jsrSimpleStepBuilder = new JsrSimpleStepBuilder(new StepBuilder(stepName));
        jsrSimpleStepBuilder.setBatchPropertyContext(this.batchPropertyContext);
        return jsrSimpleStepBuilder;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}

