/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.IOException;
import org.hl7.fhir.utilities.xml.XMLNamespace;

public class XMLWriterState {
    private String name;
    private String namespace;
    private boolean children;
    private boolean inComment;
    private boolean pretty;
    private XMLNamespace[] namespaceDefns = null;

    public void addNamespaceDefn(String namespace, String abbrev) throws IOException {
        XMLNamespace ns = this.getDefnByAbbreviation(abbrev);
        if (ns != null) {
            throw new IOException("duplicate namespace declaration on \"" + abbrev + "\"");
        }
        ns = new XMLNamespace(namespace, abbrev);
        if (this.namespaceDefns == null) {
            this.namespaceDefns = new XMLNamespace[]{ns};
        } else {
            XMLNamespace[] newns = new XMLNamespace[this.namespaceDefns.length + 1];
            for (int i2 = 0; i2 < this.namespaceDefns.length; ++i2) {
                newns[i2] = this.namespaceDefns[i2];
            }
            this.namespaceDefns = newns;
            this.namespaceDefns[this.namespaceDefns.length - 1] = ns;
        }
    }

    public XMLNamespace getDefnByNamespace(String namespace) {
        if (this.namespaceDefns == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.namespaceDefns.length; ++i2) {
            XMLNamespace element = this.namespaceDefns[i2];
            if (!element.getNamespace().equals(namespace)) continue;
            return element;
        }
        return null;
    }

    public XMLNamespace getDefnByAbbreviation(String abbreviation) {
        if (this.namespaceDefns == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.namespaceDefns.length; ++i2) {
            XMLNamespace element = this.namespaceDefns[i2];
            if (element.getAbbreviation() == null || !element.getAbbreviation().equals(abbreviation)) continue;
            return element;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean hasChildren() {
        return this.children;
    }

    public void seeChild() {
        this.children = true;
    }

    public XMLNamespace getDefaultNamespace() {
        if (this.namespaceDefns == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.namespaceDefns.length; ++i2) {
            XMLNamespace element = this.namespaceDefns[i2];
            if (element.getAbbreviation() != null) continue;
            return element;
        }
        return null;
    }

    public boolean isInComment() {
        return this.inComment;
    }

    public void setInComment(boolean inComment) {
        this.inComment = inComment;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }
}

