/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.client.ResourceAddress;
import org.hl7.fhir.r5.utils.client.ResourceFormat;
import org.hl7.fhir.r5.utils.client.network.ByteUtils;
import org.hl7.fhir.r5.utils.client.network.Client;
import org.hl7.fhir.r5.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class FHIRToolingClient {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssK";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String hostKey = "http.proxyHost";
    public static final String portKey = "http.proxyPort";
    private static final int TIMEOUT_NORMAL = 1500;
    private static final int TIMEOUT_OPERATION = 30000;
    private static final int TIMEOUT_ENTRY = 500;
    private static final int TIMEOUT_OPERATION_LONG = 60000;
    private static final int TIMEOUT_OPERATION_EXPAND = 120000;
    private String base;
    private ResourceAddress resourceAddress;
    private ResourceFormat preferredResourceFormat;
    private int maxResultSetSize = -1;
    private CapabilityStatement capabilities;
    private Client client = new Client();

    public FHIRToolingClient(String baseServiceUrl) throws URISyntaxException {
        this.preferredResourceFormat = ResourceFormat.RESOURCE_XML;
        this.initialize(baseServiceUrl);
    }

    public void initialize(String baseServiceUrl) throws URISyntaxException {
        this.base = baseServiceUrl;
        this.resourceAddress = new ResourceAddress(baseServiceUrl);
        this.maxResultSetSize = -1;
        this.checkCapabilities();
    }

    private void checkCapabilities() {
        try {
            this.capabilities = this.getCapabilitiesStatementQuick();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPreferredResourceFormat() {
        return this.preferredResourceFormat.getHeader();
    }

    public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
        this.preferredResourceFormat = resourceFormat;
    }

    public int getMaximumRecordCount() {
        return this.maxResultSetSize;
    }

    public void setMaximumRecordCount(int maxResultSetSize) {
        this.maxResultSetSize = maxResultSetSize;
    }

    public TerminologyCapabilities getTerminologyCapabilities() {
        TerminologyCapabilities capabilities = null;
        try {
            capabilities = (TerminologyCapabilities)this.client.issueGetResourceRequest(this.resourceAddress.resolveMetadataTxCaps(), this.getPreferredResourceFormat(), "TerminologyCapabilities", 1500L).getReference();
        }
        catch (Exception e) {
            throw new FHIRException("Error fetching the server's terminology capabilities", e);
        }
        return capabilities;
    }

    public CapabilityStatement getCapabilitiesStatement() {
        CapabilityStatement conformance = null;
        try {
            conformance = (CapabilityStatement)this.client.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(false), this.getPreferredResourceFormat(), "CapabilitiesStatement", 1500L).getReference();
        }
        catch (Exception e) {
            throw new FHIRException("Error fetching the server's conformance statement", e);
        }
        return conformance;
    }

    public CapabilityStatement getCapabilitiesStatementQuick() throws EFhirClientException {
        if (this.capabilities != null) {
            return this.capabilities;
        }
        try {
            this.capabilities = (CapabilityStatement)this.client.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(true), this.getPreferredResourceFormat(), "CapabilitiesStatement-Quick", 1500L).getReference();
        }
        catch (Exception e) {
            throw new FHIRException("Error fetching the server's capability statement: " + e.getMessage(), e);
        }
        return this.capabilities;
    }

    public <T extends Resource> T read(Class<T> resourceClass, String id) {
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.getPreferredResourceFormat(), "Read " + resourceClass.getName() + "/" + id, 1500L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new FHIRException(e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T vread(Class<T> resourceClass, String id, String version) {
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndIdAndVersion(resourceClass, id, version), this.getPreferredResourceFormat(), "VRead " + resourceClass.getName() + "/" + id + "/?_history/" + version, 1500L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new FHIRException("Error trying to read this version of the resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T getCanonical(Class<T> resourceClass, String canonicalURL) {
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndCanonical(resourceClass, canonicalURL), this.getPreferredResourceFormat(), "Read " + resourceClass.getName() + "?url=" + canonicalURL, 1500L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        Bundle bnd = (Bundle)result.getPayload();
        if (bnd.getEntry().size() == 0) {
            throw new EFhirClientException("No matching resource found for canonical URL '" + canonicalURL + "'");
        }
        if (bnd.getEntry().size() > 1) {
            throw new EFhirClientException("Multiple matching resources found for canonical URL '" + canonicalURL + "'");
        }
        return (T)bnd.getEntry().get(0).getResource();
    }

    public Resource update(Resource resource) {
        ResourceRequest result = null;
        try {
            result = this.client.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resource.getClass(), resource.getId()), ByteUtils.resourceToByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), "Update " + resource.fhirType() + "/" + resource.getId(), 30000L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resource.getClass(), resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    public <T extends Resource> T update(Class<T> resourceClass, T resource, String id) {
        ResourceRequest result = null;
        try {
            result = this.client.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), ByteUtils.resourceToByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), "Update " + resource.fhirType() + "/" + id, 30000L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resourceClass, resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Resource> Parameters operateType(Class<T> resourceClass, String name, Parameters params) {
        boolean complex = false;
        for (Parameters.ParametersParameterComponent parametersParameterComponent : params.getParameter()) {
            complex = complex || !(parametersParameterComponent.getValue() instanceof PrimitiveType);
        }
        String ps = "";
        try {
            void var6_11;
            if (!complex) {
                for (Parameters.ParametersParameterComponent p : params.getParameter()) {
                    if (!(p.getValue() instanceof PrimitiveType)) continue;
                    ps = ps + p.getName() + "=" + Utilities.encodeUri(((PrimitiveType)p.getValue()).asStringValue()) + "&";
                }
            }
            if (complex) {
                ResourceRequest resourceRequest = this.client.issuePostRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, ps), ByteUtils.resourceToByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), "POST " + resourceClass.getName() + "/$" + name, 60000L);
            } else {
                ResourceRequest resourceRequest = this.client.issueGetResourceRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, ps), this.getPreferredResourceFormat(), "GET " + resourceClass.getName() + "/$" + name, 60000L);
            }
            if (var6_11.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + var6_11.getHttpStatus(), (OperationOutcome)var6_11.getPayload());
            }
            if (var6_11.getPayload() instanceof Parameters) {
                return (Parameters)var6_11.getPayload();
            }
            Parameters p_out = new Parameters();
            p_out.addParameter().setName("return").setResource((Resource)var6_11.getPayload());
            return p_out;
        }
        catch (Exception exception) {
            this.handleException("Error performing operation '" + name + ": " + exception.getMessage() + "' (parameters = \"" + ps + "\")", exception);
            return null;
        }
    }

    public Bundle transaction(Bundle batch) {
        Bundle transactionResult = null;
        try {
            transactionResult = this.client.postBatchRequest(this.resourceAddress.getBaseServiceUri(), ByteUtils.resourceToByteArray(batch, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), "transaction", 30000 + 500 * batch.getEntry().size());
        }
        catch (Exception e) {
            this.handleException("An error occurred trying to process this transaction request", e);
        }
        return transactionResult;
    }

    public <T extends Resource> OperationOutcome validate(Class<T> resourceClass, T resource, String id) {
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveValidateUri(resourceClass, id), ByteUtils.resourceToByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), "POST " + resourceClass.getName() + (id != null ? "/" + id : "") + "/$validate", 60000L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to validate this resource", e);
        }
        return (OperationOutcome)result.getPayload();
    }

    protected void handleException(String message, Exception e) throws EFhirClientException {
        if (e instanceof EFhirClientException) {
            throw (EFhirClientException)e;
        }
        throw new EFhirClientException(message, e);
    }

    protected boolean isJson(String format) {
        boolean isJson = false;
        if (format.toLowerCase().contains("json")) {
            isJson = true;
        }
        return isJson;
    }

    public Bundle fetchFeed(String url) {
        Bundle feed = null;
        try {
            feed = this.client.issueGetFeedRequest(new URI(url), this.getPreferredResourceFormat());
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to retrieve history since last update", e);
        }
        return feed;
    }

    public ValueSet expandValueset(ValueSet source, Parameters expParams) {
        Parameters p = expParams == null ? new Parameters() : expParams.copy();
        p.addParameter().setName("valueSet").setResource(source);
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand"), ByteUtils.resourceToByteArray(p, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, "ValueSet/$expand?url=" + source.getUrl(), 120000L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result == null ? null : (ValueSet)result.getPayload();
    }

    public Parameters lookupCode(Map<String, String> params) {
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveOperationUri(CodeSystem.class, "lookup", params), this.getPreferredResourceFormat(), "CodeSystem/$lookup", 1500L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public ValueSet expandValueset(ValueSet source, Parameters expParams, Map<String, String> params) {
        Parameters p = expParams == null ? new Parameters() : expParams.copy();
        p.addParameter().setName("valueSet").setResource(source);
        for (String n : params.keySet()) {
            p.addParameter().setName(n).setValue(new StringType(params.get(n)));
        }
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand", params), ByteUtils.resourceToByteArray(p, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, "ValueSet/$expand?url=" + source.getUrl(), 120000L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result == null ? null : (ValueSet)result.getPayload();
    }

    public String getAddress() {
        return this.base;
    }

    public ConceptMap initializeClosure(String name) {
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), ByteUtils.resourceToByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, "Closure?name=" + name, 1500L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result == null ? null : (ConceptMap)result.getPayload();
    }

    public ConceptMap updateClosure(String name, Coding coding) {
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        params.addParameter().setName("concept").setValue(coding);
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), ByteUtils.resourceToByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), null, "UpdateClosure?name=" + name, 30000L);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result == null ? null : (ConceptMap)result.getPayload();
    }

    public long getTimeout() {
        return this.client.getTimeout();
    }

    public void setTimeout(long timeout) {
        this.client.setTimeout(timeout);
    }

    public ToolingClientLogger getLogger() {
        return this.client.getLogger();
    }

    public void setLogger(ToolingClientLogger logger) {
        this.client.setLogger(logger);
    }

    public int getRetryCount() {
        return this.client.getRetryCount();
    }

    public void setRetryCount(int retryCount) {
        this.client.setRetryCount(retryCount);
    }
}

