/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class SearchParameterRenderer
extends TerminologyRenderer {
    public SearchParameterRenderer(RenderingContext context) {
        super(context);
    }

    public SearchParameterRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws IOException, FHIRException, EOperationOutcome {
        return this.render(x, (OperationDefinition)dr);
    }

    public boolean render(XhtmlNode x, SearchParameter spd) throws IOException, FHIRException, EOperationOutcome {
        StructureDefinition sd;
        x.h2().addText(spd.getName());
        XhtmlNode p = x.para();
        p.tx("Parameter ");
        p.code().tx(spd.getCode());
        p.tx(":");
        p.code().tx(spd.getType().toCode());
        this.addMarkdown(x, spd.getDescription());
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().tx(Utilities.pluralize("Resource", spd.getBase().size()));
        XhtmlNode td = tr.td();
        for (CodeType codeType : spd.getBase()) {
            sd = this.context.getWorker().fetchTypeDefinition(codeType.toString());
            if (sd != null && sd.hasUserData("path")) {
                td.sep(", ").ah(sd.getUserString("path")).tx(codeType.getCode());
                continue;
            }
            td.sep(", ").tx(codeType.getCode());
        }
        tr = tbl.tr();
        tr.td().tx("Expression");
        if (spd.hasExpression()) {
            tr.td().code().tx(spd.getExpression());
        } else {
            tr.td().tx("(none)");
        }
        if (spd.hasXpathUsage()) {
            tr = tbl.tr();
            tr.td().tx("Usage");
            tr.td().tx(spd.getXpathUsage().getDisplay());
        }
        if (spd.hasXpath()) {
            tr = tbl.tr();
            tr.td().tx("XPath");
            tr.td().code().tx(spd.getXpath());
        }
        if (spd.hasTarget()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize("Target Resources", spd.getTarget().size()));
            td = tr.td();
            for (CodeType codeType : spd.getTarget()) {
                sd = this.context.getWorker().fetchTypeDefinition(codeType.toString());
                if (sd != null && sd.hasUserData("path")) {
                    td.sep(", ").ah(sd.getUserString("path")).tx(codeType.getCode());
                    continue;
                }
                td.sep(", ").tx(codeType.getCode());
            }
        }
        tr = tbl.tr();
        tr.td().tx("Multiples");
        if (spd.getMultipleAnd() && spd.getMultipleOr()) {
            tr.td().tx("The parameter can repeat (and) and can have repeating values (or)");
        } else if (spd.getMultipleOr()) {
            tr.td().tx("The parameter can repeat (and) but each repeat can only have one value");
        } else if (spd.getMultipleAnd()) {
            tr.td().tx("The parameter cannot repeat (and) but the single parameter can have multiple values (or)");
        } else {
            tr.td().tx("The parameter cannot repeat or have multiple values");
        }
        if (spd.hasComparator()) {
            tr = tbl.tr();
            tr.td().tx("Comparators");
            td = tr.td().tx("Allowed: ");
            for (Enumeration enumeration : spd.getComparator()) {
                td.sep(", ").tx(enumeration.asStringValue());
            }
        }
        if (spd.hasModifier()) {
            tr = tbl.tr();
            tr.td().tx("Modifiers");
            td = tr.td().tx("Allowed: ");
            for (Enumeration enumeration : spd.getModifier()) {
                td.sep(", ").tx(enumeration.asStringValue());
            }
        }
        if (spd.hasChain()) {
            tr = tbl.tr();
            tr.td().tx("Chains");
            td = tr.td().tx("Allowed: ");
            for (StringType stringType : spd.getChain()) {
                td.sep(", ").tx(stringType.asStringValue());
            }
        }
        if (spd.hasComponent()) {
            x.para().b().tx("Components");
            tbl = x.table("grid");
            for (SearchParameter.SearchParameterComponentComponent searchParameterComponentComponent : spd.getComponent()) {
                tr = tbl.tr();
                SearchParameter tsp = this.context.getWorker().fetchResource(SearchParameter.class, searchParameterComponentComponent.getDefinition());
                if (tsp != null && tsp.hasUserData("path")) {
                    tr.td().ah(tsp.getUserString("path")).tx(tsp.present());
                } else {
                    tr.td().tx(searchParameterComponentComponent.getDefinition());
                }
                tr.td().code().tx(searchParameterComponentComponent.getExpression());
            }
        }
        return false;
    }

    public void describe(XhtmlNode x, OperationDefinition opd) {
        x.tx(this.display(opd));
    }

    public String display(OperationDefinition opd) {
        return opd.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((OperationDefinition)r).present();
    }
}

