/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireResponseRenderer
extends ResourceRenderer {
    public QuestionnaireResponseRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource q) throws UnsupportedEncodingException, IOException {
        return this.render(x, (QuestionnaireResponse)q);
    }

    public boolean render(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, q);
            }
            case LINKS: {
                return this.renderLinks(x, q);
            }
            case TREE: {
                return this.renderTree(x, q);
            }
        }
        throw new Error("Unknown QuestionnaireResponse Renderer Mode");
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, qr);
            }
            case LINKS: {
                return this.renderLinks(x, qr);
            }
            case TREE: {
                return this.renderTree(x, qr);
            }
        }
        throw new Error("Unknown QuestionnaireResponse Renderer Mode");
    }

    public boolean renderTree(XhtmlNode x, BaseWrappers.ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + qr.getId(), true);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.translate("sd.head", "Definition"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List<HierarchicalTableGenerator.Title> list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        hierarchicalTableGenerator5.getClass();
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.translate("sd.head", "Answer"), this.translate("sd.hint", "The type of the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), qr);
        List<BaseWrappers.BaseWrapper> items = qr.children("item");
        for (BaseWrappers.BaseWrapper i2 : items) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), qr, i2) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    public boolean renderTree(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), true);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.translate("sd.head", "Definition"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List<HierarchicalTableGenerator.Title> list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        hierarchicalTableGenerator5.getClass();
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.translate("sd.head", "Answer"), this.translate("sd.hint", "The type of the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), q);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent i2 : q.getItem()) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), q, i2) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireResponseRoot");
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getId(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "QuestionnaireResponse", null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, "", null, null));
        return r;
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, BaseWrappers.ResourceWrapper q) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireResponseRoot");
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getId(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "QuestionnaireResponse", null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, "", null, null));
        return r;
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, BaseWrappers.ResourceWrapper q, BaseWrappers.BaseWrapper i2) throws IOException {
        boolean hasItem;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        List<BaseWrappers.BaseWrapper> items = i2.children("item");
        List<BaseWrappers.BaseWrapper> answers = i2.children("answer");
        boolean bl = hasItem = items != null && !items.isEmpty();
        if (answers != null) {
            for (BaseWrappers.BaseWrapper a : answers) {
                hasItem = a.has("item");
            }
        }
        if (hasItem) {
            r.setIcon("icon-q-group.png", "Group");
        } else {
            r.setIcon("icon-q-string.png", "Item");
        }
        String linkId = i2.has("linkId") ? i2.get("linkId").primitiveValue() : "??";
        String text = i2.has("text") ? i2.get("text").primitiveValue() : "";
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + linkId, linkId, null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, text, null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        if (answers.size() == 0) {
            List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            hierarchicalTableGenerator4.getClass();
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null));
            for (BaseWrappers.BaseWrapper si : items) {
                this.renderTreeItem(gen, r.getSubRows(), q, si);
            }
        } else if (answers.size() == 1) {
            BaseWrappers.BaseWrapper ans = answers.get(0);
            Base b = ans.get("value[x]");
            if (b == null) {
                List<HierarchicalTableGenerator.Cell> list5 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                hierarchicalTableGenerator5.getClass();
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "null!", null, null));
            } else if (b.isPrimitive()) {
                List<HierarchicalTableGenerator.Cell> list6 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                hierarchicalTableGenerator6.getClass();
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, b.primitiveValue(), null, null));
            } else {
                XhtmlNode x = new XhtmlNode(NodeType.Element, "span");
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                hierarchicalTableGenerator7.getClass();
                HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, null, null, null);
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                hierarchicalTableGenerator8.getClass();
                HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, "span");
                p.getChildren().add(x);
                cell.addPiece(p);
                this.render(x, (DataType)b);
                r.getCells().add(cell);
            }
        } else {
            List<HierarchicalTableGenerator.Cell> list7 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
            hierarchicalTableGenerator9.getClass();
            list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator9, null, null, "{todo #2}", null, null));
        }
        return hasExt;
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q, QuestionnaireResponse.QuestionnaireResponseItemComponent i2) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        boolean hasItem = i2.hasItem();
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent a : i2.getAnswer()) {
            hasItem = a.hasItem();
        }
        if (hasItem) {
            r.setIcon("icon-q-group.png", "Group");
        } else {
            r.setIcon("icon-q-string.png", "Item");
        }
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i2.getLinkId(), i2.getLinkId(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, i2.getText(), null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null));
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, QuestionnaireResponse.QuestionnaireResponseItemComponent i2, HierarchicalTableGenerator.Cell defn) {
        StructureDefinition sd;
        String path = null;
        String d = i2.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                hierarchicalTableGenerator.getClass();
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                hierarchicalTableGenerator.getClass();
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i2.getDefinition(), null));
            }
        } else {
            List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            hierarchicalTableGenerator.getClass();
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i2.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, QuestionnaireResponse.QuestionnaireResponseItemComponent i2) {
        StructureDefinition sd;
        String path = null;
        String d = i2.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i2.getDefinition());
            }
        } else {
            x.tx(i2.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        x.ah(url).tx(label);
        x.tx(": ");
        x.code(exp.getExpression());
    }

    public boolean renderForm(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        return false;
    }

    public boolean renderForm(XhtmlNode x, BaseWrappers.ResourceWrapper q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        d.tx("todo");
        return hasExt;
    }

    private boolean renderLinks(XhtmlNode x, QuestionnaireResponse q) {
        x.para().tx("Try this QuestionnaireResponse out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL(this.context.getSelfLink(), "package.tgz") + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    private boolean renderLinks(XhtmlNode x, BaseWrappers.ResourceWrapper q) {
        x.para().tx("Try this QuestionnaireResponse out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL(this.context.getSelfLink(), "package.tgz") + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }
}

