/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.PatientRenderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class DiagnosticReportRenderer
extends ResourceRenderer {
    public DiagnosticReportRenderer(RenderingContext context) {
        super(context);
    }

    public DiagnosticReportRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws IOException, FHIRException, EOperationOutcome {
        return this.render(x, (DiagnosticReport)dr);
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper dr) throws IOException, FHIRException, EOperationOutcome {
        XhtmlNode tdr;
        XhtmlNode tr;
        XhtmlNode h2 = x.h2();
        this.render(h2, this.getProperty(dr, "code").value());
        h2.tx(" ");
        BaseWrappers.PropertyWrapper pw = this.getProperty(dr, "category");
        if (this.valued(pw)) {
            h2.tx("(");
            boolean first = true;
            for (BaseWrappers.BaseWrapper b : pw.getValues()) {
                if (first) {
                    first = false;
                } else {
                    h2.tx(", ");
                }
                this.render(h2, b);
            }
            h2.tx(") ");
        }
        XhtmlNode tbl = x.table("grid");
        if (dr.has("subject")) {
            tr = tbl.tr();
            tr.td().tx("Subject");
            this.populateSubjectSummary(tr.td(), this.getProperty(dr, "subject").value());
        }
        DataType eff = null;
        DataType iss = null;
        if (dr.has("effective[x]")) {
            tr = tbl.tr();
            tr.td().tx("When For");
            eff = (DataType)this.getProperty(dr, "effective[x]").value().getBase();
            this.render(tr.td(), eff);
        }
        if (dr.has("issued")) {
            tr = tbl.tr();
            tr.td().tx("Reported");
            eff = (DataType)this.getProperty(dr, "issued").value().getBase();
            this.render(tr.td(), this.getProperty(dr, "issued").value());
        }
        if (this.valued(pw = this.getProperty(dr, "perfomer"))) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize("Performer", pw.getValues().size()));
            tdr = tr.td();
            for (BaseWrappers.BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.render(tdr, v);
            }
        }
        if (this.valued(pw = this.getProperty(dr, "identifier"))) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize("Identifier", pw.getValues().size()) + ":");
            tdr = tr.td();
            for (BaseWrappers.BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.render(tdr, v);
            }
        }
        if (this.valued(pw = this.getProperty(dr, "request"))) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize("Request", pw.getValues().size()) + ":");
            tdr = tr.td();
            for (BaseWrappers.BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.render(tdr, v);
            }
            tdr.br();
        }
        x.para().b().tx("Report Details");
        pw = this.getProperty(dr, "result");
        if (this.valued(pw)) {
            List<ObservationNode> observations = this.fetchObservations(pw.getValues(), dr);
            this.buildObservationsTable(x, observations, eff, iss);
        }
        if (this.valued(pw = this.getProperty(dr, "conclusion"))) {
            this.render(x.para(), pw.value());
        }
        if (!this.valued(pw = this.getProperty(dr, "conclusionCode"))) {
            pw = this.getProperty(dr, "codedDiagnosis");
        }
        if (this.valued(pw)) {
            XhtmlNode p = x.para();
            p.b().tx("Coded Conclusions :");
            XhtmlNode ul = x.ul();
            for (BaseWrappers.BaseWrapper v : pw.getValues()) {
                this.render(ul.li(), v);
            }
        }
        return false;
    }

    public boolean render(XhtmlNode x, DiagnosticReport dr) throws IOException, FHIRException, EOperationOutcome {
        this.render(x, new DirectWrappers.ResourceWrapperDirect(this.context, dr));
        return true;
    }

    public void describe(XhtmlNode x, DiagnosticReport dr) {
        x.tx(this.display(dr));
    }

    public String display(DiagnosticReport dr) {
        return this.display(dr.getCode());
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return this.display((DiagnosticReport)r);
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }

    private void populateSubjectSummary(XhtmlNode container, BaseWrappers.BaseWrapper subject) throws UnsupportedEncodingException, FHIRException, IOException, EOperationOutcome {
        BaseWrappers.ResourceWrapper r = this.fetchResource(subject);
        if (r == null) {
            container.tx("Unable to get Patient Details");
        } else if (r.getName().equals("Patient")) {
            this.generatePatientSummary(container, r);
        } else {
            container.tx("Not done yet");
        }
    }

    private void generatePatientSummary(XhtmlNode c, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        new PatientRenderer(this.context).describe(c, r);
    }

    private List<ObservationNode> fetchObservations(List<BaseWrappers.BaseWrapper> list, BaseWrappers.ResourceWrapper rw) throws UnsupportedEncodingException, FHIRException, IOException {
        ArrayList<ObservationNode> res = new ArrayList<ObservationNode>();
        for (BaseWrappers.BaseWrapper b : list) {
            BaseWrappers.PropertyWrapper t;
            if (!b.has("reference")) continue;
            ObservationNode obs = new ObservationNode();
            obs.ref = b.get("reference").primitiveValue();
            obs.obs = this.resolveReference(rw, obs.ref);
            if (obs.obs.getResource() != null && (t = this.getProperty(obs.obs.getResource(), "contained")).hasValues()) {
                obs.contained = this.fetchObservations(t.getValues(), rw);
            }
            res.add(obs);
        }
        return res;
    }

    private void buildObservationsTable(XhtmlNode root, List<ObservationNode> observations, DataType eff, DataType iss) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tbl = root.table("grid");
        boolean refRange = this.scanObsForRefRange(observations);
        boolean flags = this.scanObsForFlags(observations);
        boolean note = this.scanObsForNote(observations);
        boolean effectiveTime = this.scanObsForEffective(observations, eff);
        boolean issued = this.scanObsForIssued(observations, iss);
        int cs = 2;
        if (refRange) {
            ++cs;
        }
        if (flags) {
            ++cs;
        }
        if (note) {
            ++cs;
        }
        if (issued) {
            ++cs;
        }
        if (effectiveTime) {
            ++cs;
        }
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx("Code");
        tr.td().b().tx("Value");
        if (refRange) {
            tr.td().b().tx("Reference Range");
        }
        if (flags) {
            tr.td().b().tx("Flags");
        }
        if (note) {
            tr.td().b().tx("Note");
        }
        if (effectiveTime) {
            tr.td().b().tx("When For");
        }
        if (issued) {
            tr.td().b().tx("Reported");
        }
        for (ObservationNode o : observations) {
            this.addObservationToTable(tbl, o, 0, Integer.toString(cs), refRange, flags, note, effectiveTime, issued, eff, iss);
        }
    }

    private boolean scanObsForRefRange(List<ObservationNode> observations) {
        for (ObservationNode o : observations) {
            BaseWrappers.PropertyWrapper pw;
            if (o.obs.getResource() != null && this.valued(pw = this.getProperty(o.obs.getResource(), "referenceRange"))) {
                return true;
            }
            if (o.contained == null || !this.scanObsForRefRange(o.contained)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForNote(List<ObservationNode> observations) {
        for (ObservationNode o : observations) {
            BaseWrappers.PropertyWrapper pw;
            if (o.obs.getResource() != null && this.valued(pw = this.getProperty(o.obs.getResource(), "note"))) {
                return true;
            }
            if (o.contained == null || !this.scanObsForNote(o.contained)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForIssued(List<ObservationNode> observations, DataType iss) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ObservationNode o : observations) {
            BaseWrappers.PropertyWrapper pw;
            if (o.obs.getResource() != null && this.valued(pw = this.getProperty(o.obs.getResource(), "issued")) && !Base.compareDeep(pw.value().getBase(), iss, true)) {
                return true;
            }
            if (o.contained == null || !this.scanObsForIssued(o.contained, iss)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForEffective(List<ObservationNode> observations, DataType eff) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ObservationNode o : observations) {
            BaseWrappers.PropertyWrapper pw;
            if (o.obs.getResource() != null && this.valued(pw = this.getProperty(o.obs.getResource(), "effective[x]")) && !Base.compareDeep(pw.value().getBase(), eff, true)) {
                return true;
            }
            if (o.contained == null || !this.scanObsForEffective(o.contained, eff)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForFlags(List<ObservationNode> observations) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ObservationNode o : observations) {
            if (o.obs.getResource() != null) {
                BaseWrappers.PropertyWrapper pw = this.getProperty(o.obs.getResource(), "interpretation");
                if (this.valued(pw)) {
                    return true;
                }
                pw = this.getProperty(o.obs.getResource(), "status");
                if (this.valued(pw) && !pw.value().getBase().primitiveValue().equals("final")) {
                    return true;
                }
            }
            if (o.contained == null || !this.scanObsForFlags(o.contained)) continue;
            return true;
        }
        return false;
    }

    private void addObservationToTable(XhtmlNode tbl, ObservationNode o, int i2, String cs, boolean refRange, boolean flags, boolean note, boolean effectiveTime, boolean issued, DataType eff, DataType iss) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = tbl.tr();
        if (o.obs.getReference() == null) {
            XhtmlNode td = tr.td().colspan(cs);
            td.i().tx("This Observation could not be resolved");
        } else {
            if (o.obs.getResource() != null) {
                this.addObservationToTable(tr, o.obs.getResource(), i2, o.obs.getReference(), refRange, flags, note, effectiveTime, issued, eff, iss);
            } else {
                XhtmlNode td = tr.td().colspan(cs);
                td.i().ah(o.obs.getReference()).tx("Observation");
            }
            if (o.contained != null) {
                for (ObservationNode c : o.contained) {
                    this.addObservationToTable(tbl, c, i2 + 1, cs, refRange, flags, note, effectiveTime, issued, eff, iss);
                }
            }
        }
    }

    private void addObservationToTable(XhtmlNode tr, BaseWrappers.ResourceWrapper obs, int i2, String ref, boolean refRange, boolean flags, boolean note, boolean effectiveTime, boolean issued, DataType eff, DataType iss) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode td = tr.td();
        BaseWrappers.PropertyWrapper pw = this.getProperty(obs, "code");
        if (this.valued(pw)) {
            this.render(td.ah(ref), pw.value());
        }
        if (this.valued(pw = this.getProperty(obs, "bodySite"))) {
            td.tx(" (");
            this.render(td, pw.value());
            td.tx(")");
        }
        td = tr.td();
        pw = this.getProperty(obs, "value[x]");
        if (this.valued(pw)) {
            this.render(td, pw.value());
        } else {
            pw = this.getProperty(obs, "dataAbsentReason");
            if (this.valued(pw)) {
                XhtmlNode span = td.span("color: maroon", "Error");
                span.tx("Error: ");
                this.render(span.b(), pw.value());
            }
        }
        if (refRange) {
            td = tr.td();
            pw = this.getProperty(obs, "referenceRange");
            if (this.valued(pw)) {
                boolean first = true;
                for (BaseWrappers.BaseWrapper v : pw.getValues()) {
                    BaseWrappers.PropertyWrapper pwt;
                    if (first) {
                        first = false;
                    } else {
                        td.br();
                    }
                    BaseWrappers.PropertyWrapper pwr = this.getProperty(v, "type");
                    if (this.valued(pwr)) {
                        this.render(td, pwr.value());
                        td.tx(": ");
                    }
                    if (this.valued(pwt = this.getProperty(v, "text"))) {
                        this.render(td, pwt.value());
                    } else {
                        BaseWrappers.PropertyWrapper pwl = this.getProperty(v, "low");
                        BaseWrappers.PropertyWrapper pwh = this.getProperty(v, "high");
                        if (this.valued(pwl) && this.valued(pwh)) {
                            this.render(td, pwl.value());
                            td.tx(" - ");
                            this.render(td, pwh.value());
                        } else if (this.valued(pwl)) {
                            td.tx(">");
                            this.render(td, pwl.value());
                        } else if (this.valued(pwh)) {
                            td.tx("<");
                            this.render(td, pwh.value());
                        } else {
                            td.tx("??");
                        }
                    }
                    pwr = this.getProperty(v, "appliesTo");
                    BaseWrappers.PropertyWrapper pwrA = this.getProperty(v, "age");
                    if (!this.valued(pwr) && !this.valued(pwrA)) continue;
                    boolean firstA = true;
                    td.tx(" for ");
                    if (this.valued(pwr)) {
                        for (BaseWrappers.BaseWrapper va : pwr.getValues()) {
                            if (firstA) {
                                firstA = false;
                            } else {
                                td.tx(", ");
                            }
                            this.render(td, va);
                        }
                    }
                    if (!this.valued(pwrA)) continue;
                    if (firstA) {
                        firstA = false;
                    } else {
                        td.tx(", ");
                    }
                    td.tx("Age ");
                    this.render(td, pwrA.value());
                }
            }
        }
        if (flags) {
            td = tr.td();
            boolean first = true;
            pw = this.getProperty(obs, "status");
            if (this.valued(pw) && !pw.value().getBase().primitiveValue().equals("final")) {
                if (first) {
                    first = false;
                } else {
                    td.br();
                }
                this.render(td, pw.value());
            }
            if (this.valued(pw = this.getProperty(obs, "interpretation"))) {
                for (BaseWrappers.BaseWrapper v : pw.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        td.br();
                    }
                    this.render(td, v);
                }
            }
        }
        if (note) {
            td = tr.td();
            pw = this.getProperty(obs, "note");
            if (this.valued(pw)) {
                this.render(td, pw.value());
            }
        }
        if (effectiveTime) {
            td = tr.td();
            pw = this.getProperty(obs, "effective[x]");
            if (this.valued(pw) && !Base.compareDeep(pw.value().getBase(), eff, true)) {
                this.render(td, pw.value());
            }
        }
        if (issued) {
            td = tr.td();
            pw = this.getProperty(obs, "issued");
            if (this.valued(pw) && !Base.compareDeep(pw.value().getBase(), eff, true)) {
                this.render(td, pw.value());
            }
        }
    }

    public class ObservationNode {
        private String ref;
        private Resolver.ResourceWithReference obs;
        private List<ObservationNode> contained;
    }
}

