/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Measure", profile="http://hl7.org/fhir/StructureDefinition/Measure")
public class Measure
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this measure, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this measure is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the measure is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the measure", formalDefinition="A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the measure", formalDefinition="The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this measure (computer friendly)", formalDefinition="A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this measure (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the measure.")
    protected StringType title;
    @Child(name="subtitle", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the measure", formalDefinition="An explanatory or alternate title for the measure giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this measure. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="subject", type={CodeableConcept.class, Group.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Patient, Practitioner, RelatedPerson, Organization, Location, Device", formalDefinition="The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    protected DataType subject;
    @Child(name="basis", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Population basis", formalDefinition="The population basis specifies the type of elements in the population. For a subject-based measure, this is boolean (because the subject and the population basis are the same, and the population criteria define yes/no values for each individual in the population). For measures that have a population basis that is different than the subject, this element specifies the type of the population basis. For example, an encounter-based measure has a subject of Patient and a population basis of Encounter, and the population criteria all return lists of Encounters.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-types")
    protected Enumeration<Enumerations.FHIRAllTypes> basis;
    @Child(name="date", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the measure was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the measure.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the measure", formalDefinition="A free text natural language description of the measure from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate measure instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for measure (if applicable)", formalDefinition="A legal or geographic region in which the measure is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this measure is defined", formalDefinition="Explanation of why this measure is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the measure", formalDefinition="A detailed description, from a clinical perspective, of how the measure is used.")
    protected StringType usage;
    @Child(name="copyright", type={MarkdownType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the measure was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the measure was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the measure is expected to be used", formalDefinition="The period during which the measure content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the measure, such as Education, Treatment, Assessment, etc.", formalDefinition="Descriptive topics related to the content of the measure. Topics provide a high-level categorization grouping types of measures that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={CanonicalType.class}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the measure", formalDefinition="A reference to a Library resource containing the formal logic used by the measure.")
    protected List<CanonicalType> library;
    @Child(name="disclaimer", type={MarkdownType.class}, order=29, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disclaimer for use of the measure or its referenced content", formalDefinition="Notices and disclaimers regarding the use of the measure or related to intellectual property (such as code systems) referenced by the measure.")
    protected MarkdownType disclaimer;
    @Child(name="scoring", type={CodeableConcept.class}, order=30, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="proportion | ratio | continuous-variable | cohort", formalDefinition="Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-scoring")
    protected CodeableConcept scoring;
    @Child(name="scoringUnit", type={CodeableConcept.class}, order=31, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What units?", formalDefinition="Defines the expected units of measure for the measure score. This element SHOULD be specified as a UCUM unit.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-scoring-unit")
    protected CodeableConcept scoringUnit;
    @Child(name="compositeScoring", type={CodeableConcept.class}, order=32, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="opportunity | all-or-nothing | linear | weighted", formalDefinition="If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composite-measure-scoring")
    protected CodeableConcept compositeScoring;
    @Child(name="type", type={CodeableConcept.class}, order=33, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="process | outcome | structure | patient-reported-outcome | composite", formalDefinition="Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-type")
    protected List<CodeableConcept> type;
    @Child(name="riskAdjustment", type={StringType.class}, order=34, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How risk adjustment is applied for this measure", formalDefinition="A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.")
    protected StringType riskAdjustment;
    @Child(name="rateAggregation", type={StringType.class}, order=35, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How is rate aggregation performed for this measure", formalDefinition="Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.")
    protected StringType rateAggregation;
    @Child(name="rationale", type={MarkdownType.class}, order=36, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Detailed description of why the measure exists", formalDefinition="Provides a succinct statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.")
    protected MarkdownType rationale;
    @Child(name="clinicalRecommendationStatement", type={MarkdownType.class}, order=37, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Summary of clinical guidelines", formalDefinition="Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.")
    protected MarkdownType clinicalRecommendationStatement;
    @Child(name="improvementNotation", type={CodeableConcept.class}, order=38, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="increase | decrease", formalDefinition="Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-improvement-notation")
    protected CodeableConcept improvementNotation;
    @Child(name="definition", type={MarkdownType.class}, order=39, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Defined terms used in the measure documentation", formalDefinition="Provides a description of an individual term used within the measure.")
    protected List<MarkdownType> definition;
    @Child(name="guidance", type={MarkdownType.class}, order=40, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional guidance for implementers", formalDefinition="Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.")
    protected MarkdownType guidance;
    @Child(name="group", type={}, order=41, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Population criteria group", formalDefinition="A group of population criteria for the measure.")
    protected List<MeasureGroupComponent> group;
    @Child(name="supplementalData", type={}, order=42, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What other data should be reported with the measure", formalDefinition="The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.")
    protected List<MeasureSupplementalDataComponent> supplementalData;
    private static final long serialVersionUID = -345540054L;
    @SearchParamDefinition(name="composed-of", path="Measure.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("Measure:composed-of").toLocked();
    @SearchParamDefinition(name="context", path="(Measure.useContext.value as CodeableConcept)", description="A use context assigned to the measure", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="context-quantity", path="(Measure.useContext.value as Quantity) | (Measure.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the measure", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type", path="Measure.useContext.code", description="A type of use context assigned to the measure", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="date", path="Measure.date", description="The measure publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="depends-on", path="Measure.relatedArtifact.where(type='depends-on').resource | Measure.library", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("Measure:depends-on").toLocked();
    @SearchParamDefinition(name="derived-from", path="Measure.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("Measure:derived-from").toLocked();
    @SearchParamDefinition(name="description", path="Measure.description", description="The description of the measure", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="effective", path="Measure.effectivePeriod", description="The time during which the measure is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="identifier", path="Measure.identifier", description="External identifier for the measure", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="Measure.jurisdiction", description="Intended jurisdiction for the measure", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="Measure.name", description="Computationally friendly name of the measure", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="predecessor", path="Measure.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("Measure:predecessor").toLocked();
    @SearchParamDefinition(name="publisher", path="Measure.publisher", description="Name of the publisher of the measure", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="Measure.status", description="The current status of the measure", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="successor", path="Measure.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("Measure:successor").toLocked();
    @SearchParamDefinition(name="title", path="Measure.title", description="The human-friendly name of the measure", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="topic", path="Measure.topic", description="Topics associated with the measure", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="url", path="Measure.url", description="The uri that identifies the measure", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Measure.version", description="The business version of the measure", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="context-type-quantity", path="Measure.useContext", description="A use context type and quantity- or range-based value assigned to the measure", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="Measure.useContext", description="A use context type and value assigned to the measure", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");

    public Measure() {
    }

    public Measure(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Measure setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Measure setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public Measure setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public Measure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Measure setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Measure setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public Measure setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public Measure setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Measure setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Measure setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public Measure setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public Measure setSubtitle(String value) {
        if (Utilities.noString(value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Measure setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Measure setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public Measure setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public Measure setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DataType getSubject() {
        return this.subject;
    }

    public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CodeableConcept();
        }
        if (!(this.subject instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.subject;
    }

    public boolean hasSubjectCodeableConcept() {
        return this != null && this.subject instanceof CodeableConcept;
    }

    public Reference getSubjectReference() throws FHIRException {
        if (this.subject == null) {
            this.subject = new Reference();
        }
        if (!(this.subject instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (Reference)this.subject;
    }

    public boolean hasSubjectReference() {
        return this != null && this.subject instanceof Reference;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Measure setSubject(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Measure.subject[x]: " + value.fhirType());
        }
        this.subject = value;
        return this;
    }

    public Enumeration<Enumerations.FHIRAllTypes> getBasisElement() {
        if (this.basis == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.basis");
            }
            if (Configuration.doAutoCreate()) {
                this.basis = new Enumeration<Enumerations.FHIRAllTypes>(new Enumerations.FHIRAllTypesEnumFactory());
            }
        }
        return this.basis;
    }

    public boolean hasBasisElement() {
        return this.basis != null && !this.basis.isEmpty();
    }

    public boolean hasBasis() {
        return this.basis != null && !this.basis.isEmpty();
    }

    public Measure setBasisElement(Enumeration<Enumerations.FHIRAllTypes> value) {
        this.basis = value;
        return this;
    }

    public Enumerations.FHIRAllTypes getBasis() {
        return this.basis == null ? null : (Enumerations.FHIRAllTypes)((Object)this.basis.getValue());
    }

    public Measure setBasis(Enumerations.FHIRAllTypes value) {
        if (value == null) {
            this.basis = null;
        } else {
            if (this.basis == null) {
                this.basis = new Enumeration<Enumerations.FHIRAllTypes>(new Enumerations.FHIRAllTypesEnumFactory());
            }
            this.basis.setValue((Object)value);
        }
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Measure setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Measure setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public Measure setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public Measure setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public Measure setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public Measure addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Measure setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Measure setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public Measure setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Measure addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public Measure setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public Measure addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public Measure setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public Measure setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public Measure setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public Measure setUsage(String value) {
        if (Utilities.noString(value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public Measure setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public Measure setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public Measure setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public Measure setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public Measure setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public Measure setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public Measure setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    @Override
    public Measure setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    @Override
    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    @Override
    public Measure addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public Measure setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public Measure addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public Measure setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public Measure addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public Measure setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public Measure addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public Measure setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public Measure addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public Measure setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public Measure addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<CanonicalType> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        return this.library;
    }

    public Measure setLibrary(List<CanonicalType> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addLibraryElement() {
        CanonicalType t = new CanonicalType();
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return t;
    }

    public Measure addLibrary(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return this;
    }

    public boolean hasLibrary(String value) {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType v : this.library) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public MarkdownType getDisclaimerElement() {
        if (this.disclaimer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.disclaimer");
            }
            if (Configuration.doAutoCreate()) {
                this.disclaimer = new MarkdownType();
            }
        }
        return this.disclaimer;
    }

    public boolean hasDisclaimerElement() {
        return this.disclaimer != null && !this.disclaimer.isEmpty();
    }

    public boolean hasDisclaimer() {
        return this.disclaimer != null && !this.disclaimer.isEmpty();
    }

    public Measure setDisclaimerElement(MarkdownType value) {
        this.disclaimer = value;
        return this;
    }

    public String getDisclaimer() {
        return this.disclaimer == null ? null : (String)this.disclaimer.getValue();
    }

    public Measure setDisclaimer(String value) {
        if (value == null) {
            this.disclaimer = null;
        } else {
            if (this.disclaimer == null) {
                this.disclaimer = new MarkdownType();
            }
            this.disclaimer.setValue(value);
        }
        return this;
    }

    public CodeableConcept getScoring() {
        if (this.scoring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.scoring");
            }
            if (Configuration.doAutoCreate()) {
                this.scoring = new CodeableConcept();
            }
        }
        return this.scoring;
    }

    public boolean hasScoring() {
        return this.scoring != null && !this.scoring.isEmpty();
    }

    public Measure setScoring(CodeableConcept value) {
        this.scoring = value;
        return this;
    }

    public CodeableConcept getScoringUnit() {
        if (this.scoringUnit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.scoringUnit");
            }
            if (Configuration.doAutoCreate()) {
                this.scoringUnit = new CodeableConcept();
            }
        }
        return this.scoringUnit;
    }

    public boolean hasScoringUnit() {
        return this.scoringUnit != null && !this.scoringUnit.isEmpty();
    }

    public Measure setScoringUnit(CodeableConcept value) {
        this.scoringUnit = value;
        return this;
    }

    public CodeableConcept getCompositeScoring() {
        if (this.compositeScoring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.compositeScoring");
            }
            if (Configuration.doAutoCreate()) {
                this.compositeScoring = new CodeableConcept();
            }
        }
        return this.compositeScoring;
    }

    public boolean hasCompositeScoring() {
        return this.compositeScoring != null && !this.compositeScoring.isEmpty();
    }

    public Measure setCompositeScoring(CodeableConcept value) {
        this.compositeScoring = value;
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Measure setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Measure addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public StringType getRiskAdjustmentElement() {
        if (this.riskAdjustment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.riskAdjustment");
            }
            if (Configuration.doAutoCreate()) {
                this.riskAdjustment = new StringType();
            }
        }
        return this.riskAdjustment;
    }

    public boolean hasRiskAdjustmentElement() {
        return this.riskAdjustment != null && !this.riskAdjustment.isEmpty();
    }

    public boolean hasRiskAdjustment() {
        return this.riskAdjustment != null && !this.riskAdjustment.isEmpty();
    }

    public Measure setRiskAdjustmentElement(StringType value) {
        this.riskAdjustment = value;
        return this;
    }

    public String getRiskAdjustment() {
        return this.riskAdjustment == null ? null : (String)this.riskAdjustment.getValue();
    }

    public Measure setRiskAdjustment(String value) {
        if (Utilities.noString(value)) {
            this.riskAdjustment = null;
        } else {
            if (this.riskAdjustment == null) {
                this.riskAdjustment = new StringType();
            }
            this.riskAdjustment.setValue(value);
        }
        return this;
    }

    public StringType getRateAggregationElement() {
        if (this.rateAggregation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.rateAggregation");
            }
            if (Configuration.doAutoCreate()) {
                this.rateAggregation = new StringType();
            }
        }
        return this.rateAggregation;
    }

    public boolean hasRateAggregationElement() {
        return this.rateAggregation != null && !this.rateAggregation.isEmpty();
    }

    public boolean hasRateAggregation() {
        return this.rateAggregation != null && !this.rateAggregation.isEmpty();
    }

    public Measure setRateAggregationElement(StringType value) {
        this.rateAggregation = value;
        return this;
    }

    public String getRateAggregation() {
        return this.rateAggregation == null ? null : (String)this.rateAggregation.getValue();
    }

    public Measure setRateAggregation(String value) {
        if (Utilities.noString(value)) {
            this.rateAggregation = null;
        } else {
            if (this.rateAggregation == null) {
                this.rateAggregation = new StringType();
            }
            this.rateAggregation.setValue(value);
        }
        return this;
    }

    public MarkdownType getRationaleElement() {
        if (this.rationale == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.rationale");
            }
            if (Configuration.doAutoCreate()) {
                this.rationale = new MarkdownType();
            }
        }
        return this.rationale;
    }

    public boolean hasRationaleElement() {
        return this.rationale != null && !this.rationale.isEmpty();
    }

    public boolean hasRationale() {
        return this.rationale != null && !this.rationale.isEmpty();
    }

    public Measure setRationaleElement(MarkdownType value) {
        this.rationale = value;
        return this;
    }

    public String getRationale() {
        return this.rationale == null ? null : (String)this.rationale.getValue();
    }

    public Measure setRationale(String value) {
        if (value == null) {
            this.rationale = null;
        } else {
            if (this.rationale == null) {
                this.rationale = new MarkdownType();
            }
            this.rationale.setValue(value);
        }
        return this;
    }

    public MarkdownType getClinicalRecommendationStatementElement() {
        if (this.clinicalRecommendationStatement == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.clinicalRecommendationStatement");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalRecommendationStatement = new MarkdownType();
            }
        }
        return this.clinicalRecommendationStatement;
    }

    public boolean hasClinicalRecommendationStatementElement() {
        return this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty();
    }

    public boolean hasClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty();
    }

    public Measure setClinicalRecommendationStatementElement(MarkdownType value) {
        this.clinicalRecommendationStatement = value;
        return this;
    }

    public String getClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement == null ? null : (String)this.clinicalRecommendationStatement.getValue();
    }

    public Measure setClinicalRecommendationStatement(String value) {
        if (value == null) {
            this.clinicalRecommendationStatement = null;
        } else {
            if (this.clinicalRecommendationStatement == null) {
                this.clinicalRecommendationStatement = new MarkdownType();
            }
            this.clinicalRecommendationStatement.setValue(value);
        }
        return this;
    }

    public CodeableConcept getImprovementNotation() {
        if (this.improvementNotation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.improvementNotation");
            }
            if (Configuration.doAutoCreate()) {
                this.improvementNotation = new CodeableConcept();
            }
        }
        return this.improvementNotation;
    }

    public boolean hasImprovementNotation() {
        return this.improvementNotation != null && !this.improvementNotation.isEmpty();
    }

    public Measure setImprovementNotation(CodeableConcept value) {
        this.improvementNotation = value;
        return this;
    }

    public List<MarkdownType> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<MarkdownType>();
        }
        return this.definition;
    }

    public Measure setDefinition(List<MarkdownType> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (MarkdownType item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarkdownType addDefinitionElement() {
        MarkdownType t = new MarkdownType();
        if (this.definition == null) {
            this.definition = new ArrayList<MarkdownType>();
        }
        this.definition.add(t);
        return t;
    }

    public Measure addDefinition(String value) {
        MarkdownType t = new MarkdownType();
        t.setValue(value);
        if (this.definition == null) {
            this.definition = new ArrayList<MarkdownType>();
        }
        this.definition.add(t);
        return this;
    }

    public boolean hasDefinition(String value) {
        if (this.definition == null) {
            return false;
        }
        for (MarkdownType v : this.definition) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public MarkdownType getGuidanceElement() {
        if (this.guidance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.guidance");
            }
            if (Configuration.doAutoCreate()) {
                this.guidance = new MarkdownType();
            }
        }
        return this.guidance;
    }

    public boolean hasGuidanceElement() {
        return this.guidance != null && !this.guidance.isEmpty();
    }

    public boolean hasGuidance() {
        return this.guidance != null && !this.guidance.isEmpty();
    }

    public Measure setGuidanceElement(MarkdownType value) {
        this.guidance = value;
        return this;
    }

    public String getGuidance() {
        return this.guidance == null ? null : (String)this.guidance.getValue();
    }

    public Measure setGuidance(String value) {
        if (value == null) {
            this.guidance = null;
        } else {
            if (this.guidance == null) {
                this.guidance = new MarkdownType();
            }
            this.guidance.setValue(value);
        }
        return this;
    }

    public List<MeasureGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        return this.group;
    }

    public Measure setGroup(List<MeasureGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (MeasureGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureGroupComponent addGroup() {
        MeasureGroupComponent t = new MeasureGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public Measure addGroup(MeasureGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public MeasureGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    public List<MeasureSupplementalDataComponent> getSupplementalData() {
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        return this.supplementalData;
    }

    public Measure setSupplementalData(List<MeasureSupplementalDataComponent> theSupplementalData) {
        this.supplementalData = theSupplementalData;
        return this;
    }

    public boolean hasSupplementalData() {
        if (this.supplementalData == null) {
            return false;
        }
        for (MeasureSupplementalDataComponent item : this.supplementalData) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureSupplementalDataComponent addSupplementalData() {
        MeasureSupplementalDataComponent t = new MeasureSupplementalDataComponent();
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        this.supplementalData.add(t);
        return t;
    }

    public Measure addSupplementalData(MeasureSupplementalDataComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        this.supplementalData.add(t);
        return this;
    }

    public MeasureSupplementalDataComponent getSupplementalDataFirstRep() {
        if (this.getSupplementalData().isEmpty()) {
            this.addSupplementalData();
        }
        return this.getSupplementalData().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this measure is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the measure is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the measure.", 0, 1, this.title));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the measure giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this measure. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.", 0, 1, this.subject));
        children.add(new Property("basis", "code", "The population basis specifies the type of elements in the population. For a subject-based measure, this is boolean (because the subject and the population basis are the same, and the population criteria define yes/no values for each individual in the population). For measures that have a population basis that is different than the subject, this element specifies the type of the population basis. For example, an encounter-based measure has a subject of Patient and a population basis of Encounter, and the population criteria all return lists of Encounters.", 0, 1, this.basis));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the measure was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the measure.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the measure from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate measure instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the measure is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this measure is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description, from a clinical perspective, of how the measure is used.", 0, 1, this.usage));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the measure content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the measure. Topics provide a high-level categorization grouping types of measures that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "canonical(Library)", "A reference to a Library resource containing the formal logic used by the measure.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("disclaimer", "markdown", "Notices and disclaimers regarding the use of the measure or related to intellectual property (such as code systems) referenced by the measure.", 0, 1, this.disclaimer));
        children.add(new Property("scoring", "CodeableConcept", "Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.", 0, 1, this.scoring));
        children.add(new Property("scoringUnit", "CodeableConcept", "Defines the expected units of measure for the measure score. This element SHOULD be specified as a UCUM unit.", 0, 1, this.scoringUnit));
        children.add(new Property("compositeScoring", "CodeableConcept", "If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.", 0, 1, this.compositeScoring));
        children.add(new Property("type", "CodeableConcept", "Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("riskAdjustment", "string", "A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.", 0, 1, this.riskAdjustment));
        children.add(new Property("rateAggregation", "string", "Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.", 0, 1, this.rateAggregation));
        children.add(new Property("rationale", "markdown", "Provides a succinct statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.", 0, 1, this.rationale));
        children.add(new Property("clinicalRecommendationStatement", "markdown", "Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.", 0, 1, this.clinicalRecommendationStatement));
        children.add(new Property("improvementNotation", "CodeableConcept", "Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).", 0, 1, this.improvementNotation));
        children.add(new Property("definition", "markdown", "Provides a description of an individual term used within the measure.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("guidance", "markdown", "Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.", 0, 1, this.guidance));
        children.add(new Property("group", "", "A group of population criteria for the measure.", 0, Integer.MAX_VALUE, this.group));
        children.add(new Property("supplementalData", "", "The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.supplementalData));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this measure is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the measure is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the measure.", 0, 1, this.title);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the measure giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this measure. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case -573640748: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.", 0, 1, this.subject);
            }
            case -1867885268: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.", 0, 1, this.subject);
            }
            case -1257122603: {
                return new Property("subject[x]", "CodeableConcept", "The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.", 0, 1, this.subject);
            }
            case 772938623: {
                return new Property("subject[x]", "Reference(Group)", "The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.", 0, 1, this.subject);
            }
            case 93508670: {
                return new Property("basis", "code", "The population basis specifies the type of elements in the population. For a subject-based measure, this is boolean (because the subject and the population basis are the same, and the population criteria define yes/no values for each individual in the population). For measures that have a population basis that is different than the subject, this element specifies the type of the population basis. For example, an encounter-based measure has a subject of Patient and a population basis of Encounter, and the population criteria all return lists of Encounters.", 0, 1, this.basis);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the measure was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the measure.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the measure from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate measure instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the measure is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this measure is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description, from a clinical perspective, of how the measure is used.", 0, 1, this.usage);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the measure content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the measure. Topics provide a high-level categorization grouping types of measures that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "canonical(Library)", "A reference to a Library resource containing the formal logic used by the measure.", 0, Integer.MAX_VALUE, this.library);
            }
            case 432371099: {
                return new Property("disclaimer", "markdown", "Notices and disclaimers regarding the use of the measure or related to intellectual property (such as code systems) referenced by the measure.", 0, 1, this.disclaimer);
            }
            case 1924005583: {
                return new Property("scoring", "CodeableConcept", "Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.", 0, 1, this.scoring);
            }
            case 1527532787: {
                return new Property("scoringUnit", "CodeableConcept", "Defines the expected units of measure for the measure score. This element SHOULD be specified as a UCUM unit.", 0, 1, this.scoringUnit);
            }
            case 569347656: {
                return new Property("compositeScoring", "CodeableConcept", "If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.", 0, 1, this.compositeScoring);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.", 0, Integer.MAX_VALUE, this.type);
            }
            case 93273500: {
                return new Property("riskAdjustment", "string", "A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.", 0, 1, this.riskAdjustment);
            }
            case 1254503906: {
                return new Property("rateAggregation", "string", "Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.", 0, 1, this.rateAggregation);
            }
            case 345689335: {
                return new Property("rationale", "markdown", "Provides a succinct statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.", 0, 1, this.rationale);
            }
            case -18631389: {
                return new Property("clinicalRecommendationStatement", "markdown", "Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.", 0, 1, this.clinicalRecommendationStatement);
            }
            case -2085456136: {
                return new Property("improvementNotation", "CodeableConcept", "Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).", 0, 1, this.improvementNotation);
            }
            case -1014418093: {
                return new Property("definition", "markdown", "Provides a description of an individual term used within the measure.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -1314002088: {
                return new Property("guidance", "markdown", "Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.", 0, 1, this.guidance);
            }
            case 98629247: {
                return new Property("group", "", "A group of population criteria for the measure.", 0, Integer.MAX_VALUE, this.group);
            }
            case 1447496814: {
                return new Property("supplementalData", "", "The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.supplementalData);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.subject;
                }
                return baseArray;
            }
            case 93508670: {
                Base[] baseArray;
                if (this.basis == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.basis;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.usage;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 432371099: {
                Base[] baseArray;
                if (this.disclaimer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.disclaimer;
                }
                return baseArray;
            }
            case 1924005583: {
                Base[] baseArray;
                if (this.scoring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.scoring;
                }
                return baseArray;
            }
            case 1527532787: {
                Base[] baseArray;
                if (this.scoringUnit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.scoringUnit;
                }
                return baseArray;
            }
            case 569347656: {
                Base[] baseArray;
                if (this.compositeScoring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.compositeScoring;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 93273500: {
                Base[] baseArray;
                if (this.riskAdjustment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.riskAdjustment;
                }
                return baseArray;
            }
            case 1254503906: {
                Base[] baseArray;
                if (this.rateAggregation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray25 = new Base[1];
                    baseArray = baseArray25;
                    baseArray25[0] = this.rateAggregation;
                }
                return baseArray;
            }
            case 345689335: {
                Base[] baseArray;
                if (this.rationale == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray26 = new Base[1];
                    baseArray = baseArray26;
                    baseArray26[0] = this.rationale;
                }
                return baseArray;
            }
            case -18631389: {
                Base[] baseArray;
                if (this.clinicalRecommendationStatement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray27 = new Base[1];
                    baseArray = baseArray27;
                    baseArray27[0] = this.clinicalRecommendationStatement;
                }
                return baseArray;
            }
            case -2085456136: {
                Base[] baseArray;
                if (this.improvementNotation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray28 = new Base[1];
                    baseArray = baseArray28;
                    baseArray28[0] = this.improvementNotation;
                }
                return baseArray;
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -1314002088: {
                Base[] baseArray;
                if (this.guidance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray29 = new Base[1];
                    baseArray = baseArray29;
                    baseArray29[0] = this.guidance;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
            case 1447496814: {
                return this.supplementalData == null ? new Base[]{} : this.supplementalData.toArray(new Base[this.supplementalData.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToType(value);
                return value;
            }
            case 93508670: {
                value = new Enumerations.FHIRAllTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.basis = value;
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = TypeConvertor.castToString(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case 432371099: {
                this.disclaimer = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1924005583: {
                this.scoring = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1527532787: {
                this.scoringUnit = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 569347656: {
                this.compositeScoring = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 93273500: {
                this.riskAdjustment = TypeConvertor.castToString(value);
                return value;
            }
            case 1254503906: {
                this.rateAggregation = TypeConvertor.castToString(value);
                return value;
            }
            case 345689335: {
                this.rationale = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -18631389: {
                this.clinicalRecommendationStatement = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -2085456136: {
                this.improvementNotation = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(TypeConvertor.castToMarkdown(value));
                return value;
            }
            case -1314002088: {
                this.guidance = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((MeasureGroupComponent)((Object)value));
                return value;
            }
            case 1447496814: {
                this.getSupplementalData().add((MeasureSupplementalDataComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals("subject[x]")) {
            this.subject = TypeConvertor.castToType(value);
        } else if (name.equals("basis")) {
            value = new Enumerations.FHIRAllTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.basis = value;
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = TypeConvertor.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("disclaimer")) {
            this.disclaimer = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("scoring")) {
            this.scoring = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("scoringUnit")) {
            this.scoringUnit = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("compositeScoring")) {
            this.compositeScoring = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("type")) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("riskAdjustment")) {
            this.riskAdjustment = TypeConvertor.castToString(value);
        } else if (name.equals("rateAggregation")) {
            this.rateAggregation = TypeConvertor.castToString(value);
        } else if (name.equals("rationale")) {
            this.rationale = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("clinicalRecommendationStatement")) {
            this.clinicalRecommendationStatement = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("improvementNotation")) {
            this.improvementNotation = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("definition")) {
            this.getDefinition().add(TypeConvertor.castToMarkdown(value));
        } else if (name.equals("guidance")) {
            this.guidance = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("group")) {
            this.getGroup().add((MeasureGroupComponent)((Object)value));
        } else if (name.equals("supplementalData")) {
            this.getSupplementalData().add((MeasureSupplementalDataComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case -573640748: {
                return this.getSubject();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 93508670: {
                return this.getBasisElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibraryElement();
            }
            case 432371099: {
                return this.getDisclaimerElement();
            }
            case 1924005583: {
                return this.getScoring();
            }
            case 1527532787: {
                return this.getScoringUnit();
            }
            case 569347656: {
                return this.getCompositeScoring();
            }
            case 3575610: {
                return this.addType();
            }
            case 93273500: {
                return this.getRiskAdjustmentElement();
            }
            case 1254503906: {
                return this.getRateAggregationElement();
            }
            case 345689335: {
                return this.getRationaleElement();
            }
            case -18631389: {
                return this.getClinicalRecommendationStatementElement();
            }
            case -2085456136: {
                return this.getImprovementNotation();
            }
            case -1014418093: {
                return this.addDefinitionElement();
            }
            case -1314002088: {
                return this.getGuidanceElement();
            }
            case 98629247: {
                return this.addGroup();
            }
            case 1447496814: {
                return this.addSupplementalData();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 93508670: {
                return new String[]{"code"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"canonical"};
            }
            case 432371099: {
                return new String[]{"markdown"};
            }
            case 1924005583: {
                return new String[]{"CodeableConcept"};
            }
            case 1527532787: {
                return new String[]{"CodeableConcept"};
            }
            case 569347656: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 93273500: {
                return new String[]{"string"};
            }
            case 1254503906: {
                return new String[]{"string"};
            }
            case 345689335: {
                return new String[]{"markdown"};
            }
            case -18631389: {
                return new String[]{"markdown"};
            }
            case -2085456136: {
                return new String[]{"CodeableConcept"};
            }
            case -1014418093: {
                return new String[]{"markdown"};
            }
            case -1314002088: {
                return new String[]{"markdown"};
            }
            case 98629247: {
                return new String[0];
            }
            case 1447496814: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.title");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.experimental");
        }
        if (name.equals("subjectCodeableConcept")) {
            this.subject = new CodeableConcept();
            return this.subject;
        }
        if (name.equals("subjectReference")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("basis")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.basis");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.usage");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.library");
        }
        if (name.equals("disclaimer")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.disclaimer");
        }
        if (name.equals("scoring")) {
            this.scoring = new CodeableConcept();
            return this.scoring;
        }
        if (name.equals("scoringUnit")) {
            this.scoringUnit = new CodeableConcept();
            return this.scoringUnit;
        }
        if (name.equals("compositeScoring")) {
            this.compositeScoring = new CodeableConcept();
            return this.compositeScoring;
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("riskAdjustment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.riskAdjustment");
        }
        if (name.equals("rateAggregation")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.rateAggregation");
        }
        if (name.equals("rationale")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.rationale");
        }
        if (name.equals("clinicalRecommendationStatement")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.clinicalRecommendationStatement");
        }
        if (name.equals("improvementNotation")) {
            this.improvementNotation = new CodeableConcept();
            return this.improvementNotation;
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.definition");
        }
        if (name.equals("guidance")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.guidance");
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        if (name.equals("supplementalData")) {
            return this.addSupplementalData();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Measure";
    }

    @Override
    public Measure copy() {
        Measure dst = new Measure();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Measure dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.basis = this.basis == null ? null : this.basis.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.library) {
                dst.library.add(canonicalType.copy());
            }
        }
        dst.disclaimer = this.disclaimer == null ? null : this.disclaimer.copy();
        dst.scoring = this.scoring == null ? null : this.scoring.copy();
        dst.scoringUnit = this.scoringUnit == null ? null : this.scoringUnit.copy();
        CodeableConcept codeableConcept = dst.compositeScoring = this.compositeScoring == null ? null : this.compositeScoring.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.type) {
                dst.type.add(codeableConcept2.copy());
            }
        }
        dst.riskAdjustment = this.riskAdjustment == null ? null : this.riskAdjustment.copy();
        dst.rateAggregation = this.rateAggregation == null ? null : this.rateAggregation.copy();
        dst.rationale = this.rationale == null ? null : this.rationale.copy();
        dst.clinicalRecommendationStatement = this.clinicalRecommendationStatement == null ? null : this.clinicalRecommendationStatement.copy();
        CodeableConcept codeableConcept3 = dst.improvementNotation = this.improvementNotation == null ? null : this.improvementNotation.copy();
        if (this.definition != null) {
            dst.definition = new ArrayList<MarkdownType>();
            for (MarkdownType markdownType2 : this.definition) {
                dst.definition.add(markdownType2.copy());
            }
        }
        MarkdownType markdownType3 = dst.guidance = this.guidance == null ? null : this.guidance.copy();
        if (this.group != null) {
            dst.group = new ArrayList<MeasureGroupComponent>();
            for (MeasureGroupComponent measureGroupComponent : this.group) {
                dst.group.add(measureGroupComponent.copy());
            }
        }
        if (this.supplementalData != null) {
            dst.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
            for (MeasureSupplementalDataComponent measureSupplementalDataComponent : this.supplementalData) {
                dst.supplementalData.add(measureSupplementalDataComponent.copy());
            }
        }
    }

    protected Measure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Measure)) {
            return false;
        }
        Measure o = (Measure)other_;
        return Measure.compareDeep(this.url, o.url, true) && Measure.compareDeep(this.identifier, o.identifier, true) && Measure.compareDeep(this.version, o.version, true) && Measure.compareDeep(this.name, o.name, true) && Measure.compareDeep(this.title, o.title, true) && Measure.compareDeep(this.subtitle, o.subtitle, true) && Measure.compareDeep(this.status, o.status, true) && Measure.compareDeep(this.experimental, o.experimental, true) && Measure.compareDeep(this.subject, o.subject, true) && Measure.compareDeep(this.basis, o.basis, true) && Measure.compareDeep(this.date, o.date, true) && Measure.compareDeep(this.publisher, o.publisher, true) && Measure.compareDeep(this.contact, o.contact, true) && Measure.compareDeep(this.description, o.description, true) && Measure.compareDeep(this.useContext, o.useContext, true) && Measure.compareDeep(this.jurisdiction, o.jurisdiction, true) && Measure.compareDeep(this.purpose, o.purpose, true) && Measure.compareDeep(this.usage, o.usage, true) && Measure.compareDeep(this.copyright, o.copyright, true) && Measure.compareDeep(this.approvalDate, o.approvalDate, true) && Measure.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Measure.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && Measure.compareDeep(this.topic, o.topic, true) && Measure.compareDeep(this.author, o.author, true) && Measure.compareDeep(this.editor, o.editor, true) && Measure.compareDeep(this.reviewer, o.reviewer, true) && Measure.compareDeep(this.endorser, o.endorser, true) && Measure.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && Measure.compareDeep(this.library, o.library, true) && Measure.compareDeep(this.disclaimer, o.disclaimer, true) && Measure.compareDeep(this.scoring, o.scoring, true) && Measure.compareDeep(this.scoringUnit, o.scoringUnit, true) && Measure.compareDeep(this.compositeScoring, o.compositeScoring, true) && Measure.compareDeep(this.type, o.type, true) && Measure.compareDeep(this.riskAdjustment, o.riskAdjustment, true) && Measure.compareDeep(this.rateAggregation, o.rateAggregation, true) && Measure.compareDeep(this.rationale, o.rationale, true) && Measure.compareDeep(this.clinicalRecommendationStatement, o.clinicalRecommendationStatement, true) && Measure.compareDeep(this.improvementNotation, o.improvementNotation, true) && Measure.compareDeep(this.definition, o.definition, true) && Measure.compareDeep(this.guidance, o.guidance, true) && Measure.compareDeep(this.group, o.group, true) && Measure.compareDeep(this.supplementalData, o.supplementalData, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Measure)) {
            return false;
        }
        Measure o = (Measure)other_;
        return Measure.compareValues(this.url, o.url, true) && Measure.compareValues(this.version, o.version, true) && Measure.compareValues(this.name, o.name, true) && Measure.compareValues(this.title, o.title, true) && Measure.compareValues(this.subtitle, o.subtitle, true) && Measure.compareValues(this.status, o.status, true) && Measure.compareValues(this.experimental, o.experimental, true) && Measure.compareValues(this.basis, o.basis, true) && Measure.compareValues(this.date, o.date, true) && Measure.compareValues(this.publisher, o.publisher, true) && Measure.compareValues(this.description, o.description, true) && Measure.compareValues(this.purpose, o.purpose, true) && Measure.compareValues(this.usage, o.usage, true) && Measure.compareValues(this.copyright, o.copyright, true) && Measure.compareValues(this.approvalDate, o.approvalDate, true) && Measure.compareValues(this.lastReviewDate, o.lastReviewDate, true) && Measure.compareValues(this.library, o.library, true) && Measure.compareValues(this.disclaimer, o.disclaimer, true) && Measure.compareValues(this.riskAdjustment, o.riskAdjustment, true) && Measure.compareValues(this.rateAggregation, o.rateAggregation, true) && Measure.compareValues(this.rationale, o.rationale, true) && Measure.compareValues(this.clinicalRecommendationStatement, o.clinicalRecommendationStatement, true) && Measure.compareValues(this.definition, o.definition, true) && Measure.compareValues(this.guidance, o.guidance, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.status, this.experimental, this.subject, this.basis, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.disclaimer, this.scoring, this.scoringUnit, this.compositeScoring, this.type, this.riskAdjustment, this.rateAggregation, this.rationale, this.clinicalRecommendationStatement, this.improvementNotation, this.definition, this.guidance, this.group, this.supplementalData);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Measure;
    }

    @Block
    public static class MeasureSupplementalDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Meaning of the supplemental data", formalDefinition="Indicates a meaning for the supplemental data. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing supplemental data to be correlated across measures.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-supplemental-data-example")
        protected CodeableConcept code;
        @Child(name="usage", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="supplemental-data | risk-adjustment-factor", formalDefinition="An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-data-usage")
        protected List<CodeableConcept> usage;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human readable description of this supplemental data", formalDefinition="The human readable description of this supplemental data.")
        protected StringType description;
        @Child(name="criteria", type={Expression.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expression describing additional data to be reported", formalDefinition="The criteria for the supplemental data. This is typically the name of a valid expression defined within a referenced library, but it may also be a path to a specific data element. The criteria defines the data to be returned for this element.")
        protected Expression criteria;
        private static final long serialVersionUID = -1897021670L;

        public MeasureSupplementalDataComponent() {
        }

        public MeasureSupplementalDataComponent(Expression criteria) {
            this.setCriteria(criteria);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureSupplementalDataComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<CodeableConcept> getUsage() {
            if (this.usage == null) {
                this.usage = new ArrayList<CodeableConcept>();
            }
            return this.usage;
        }

        public MeasureSupplementalDataComponent setUsage(List<CodeableConcept> theUsage) {
            this.usage = theUsage;
            return this;
        }

        public boolean hasUsage() {
            if (this.usage == null) {
                return false;
            }
            for (CodeableConcept item : this.usage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addUsage() {
            CodeableConcept t = new CodeableConcept();
            if (this.usage == null) {
                this.usage = new ArrayList<CodeableConcept>();
            }
            this.usage.add(t);
            return t;
        }

        public MeasureSupplementalDataComponent addUsage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.usage == null) {
                this.usage = new ArrayList<CodeableConcept>();
            }
            this.usage.add(t);
            return this;
        }

        public CodeableConcept getUsageFirstRep() {
            if (this.getUsage().isEmpty()) {
                this.addUsage();
            }
            return this.getUsage().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureSupplementalDataComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureSupplementalDataComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Expression getCriteria() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new Expression();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureSupplementalDataComponent setCriteria(Expression value) {
            this.criteria = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Indicates a meaning for the supplemental data. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing supplemental data to be correlated across measures.", 0, 1, this.code));
            children.add(new Property("usage", "CodeableConcept", "An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.", 0, Integer.MAX_VALUE, this.usage));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this supplemental data.", 0, 1, this.description));
            children.add(new Property("criteria", "Expression", "The criteria for the supplemental data. This is typically the name of a valid expression defined within a referenced library, but it may also be a path to a specific data element. The criteria defines the data to be returned for this element.", 0, 1, this.criteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Indicates a meaning for the supplemental data. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing supplemental data to be correlated across measures.", 0, 1, this.code);
                }
                case 111574433: {
                    return new Property("usage", "CodeableConcept", "An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.", 0, Integer.MAX_VALUE, this.usage);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this supplemental data.", 0, 1, this.description);
                }
                case 1952046943: {
                    return new Property("criteria", "Expression", "The criteria for the supplemental data. This is typically the name of a valid expression defined within a referenced library, but it may also be a path to a specific data element. The criteria defines the data to be returned for this element.", 0, 1, this.criteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111574433: {
                    return this.usage == null ? new Base[]{} : this.usage.toArray(new Base[this.usage.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.criteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111574433: {
                    this.getUsage().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 1952046943: {
                    this.criteria = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("usage")) {
                this.getUsage().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("criteria")) {
                this.criteria = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 111574433: {
                    return this.addUsage();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1952046943: {
                    return this.getCriteria();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111574433: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1952046943: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("usage")) {
                return this.addUsage();
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.supplementalData.description");
            }
            if (name.equals("criteria")) {
                this.criteria = new Expression();
                return this.criteria;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureSupplementalDataComponent copy() {
            MeasureSupplementalDataComponent dst = new MeasureSupplementalDataComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureSupplementalDataComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.usage != null) {
                dst.usage = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.usage) {
                    dst.usage.add(i2.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureSupplementalDataComponent)) {
                return false;
            }
            MeasureSupplementalDataComponent o = (MeasureSupplementalDataComponent)other_;
            return MeasureSupplementalDataComponent.compareDeep(this.code, o.code, true) && MeasureSupplementalDataComponent.compareDeep(this.usage, o.usage, true) && MeasureSupplementalDataComponent.compareDeep(this.description, o.description, true) && MeasureSupplementalDataComponent.compareDeep(this.criteria, o.criteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureSupplementalDataComponent)) {
                return false;
            }
            MeasureSupplementalDataComponent o = (MeasureSupplementalDataComponent)other_;
            return MeasureSupplementalDataComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.usage, this.description, this.criteria);
        }

        @Override
        public String fhirType() {
            return "Measure.supplementalData";
        }
    }

    @Block
    public static class MeasureGroupStratifierComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Meaning of the stratifier component", formalDefinition="Indicates a meaning for the stratifier component. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing stratifiers to be correlated across measures.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-stratifier-example")
        protected CodeableConcept code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human readable description of this stratifier component", formalDefinition="The human readable description of this stratifier criteria component.")
        protected StringType description;
        @Child(name="criteria", type={Expression.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Component of how the measure should be stratified", formalDefinition="An expression that specifies the criteria for this component of the stratifier. This is typically the name of an expression defined within a referenced library, but it may also be a path to a stratifier element.")
        protected Expression criteria;
        private static final long serialVersionUID = 2107514056L;

        public MeasureGroupStratifierComponentComponent() {
        }

        public MeasureGroupStratifierComponentComponent(Expression criteria) {
            this.setCriteria(criteria);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureGroupStratifierComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponentComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupStratifierComponentComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupStratifierComponentComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Expression getCriteria() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponentComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new Expression();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupStratifierComponentComponent setCriteria(Expression value) {
            this.criteria = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Indicates a meaning for the stratifier component. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing stratifiers to be correlated across measures.", 0, 1, this.code));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this stratifier criteria component.", 0, 1, this.description));
            children.add(new Property("criteria", "Expression", "An expression that specifies the criteria for this component of the stratifier. This is typically the name of an expression defined within a referenced library, but it may also be a path to a stratifier element.", 0, 1, this.criteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Indicates a meaning for the stratifier component. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing stratifiers to be correlated across measures.", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this stratifier criteria component.", 0, 1, this.description);
                }
                case 1952046943: {
                    return new Property("criteria", "Expression", "An expression that specifies the criteria for this component of the stratifier. This is typically the name of an expression defined within a referenced library, but it may also be a path to a stratifier element.", 0, 1, this.criteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.criteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 1952046943: {
                    this.criteria = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("criteria")) {
                this.criteria = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1952046943: {
                    return this.getCriteria();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1952046943: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.group.stratifier.component.description");
            }
            if (name.equals("criteria")) {
                this.criteria = new Expression();
                return this.criteria;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupStratifierComponentComponent copy() {
            MeasureGroupStratifierComponentComponent dst = new MeasureGroupStratifierComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureGroupStratifierComponentComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupStratifierComponentComponent)) {
                return false;
            }
            MeasureGroupStratifierComponentComponent o = (MeasureGroupStratifierComponentComponent)other_;
            return MeasureGroupStratifierComponentComponent.compareDeep(this.code, o.code, true) && MeasureGroupStratifierComponentComponent.compareDeep(this.description, o.description, true) && MeasureGroupStratifierComponentComponent.compareDeep(this.criteria, o.criteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupStratifierComponentComponent)) {
                return false;
            }
            MeasureGroupStratifierComponentComponent o = (MeasureGroupStratifierComponentComponent)other_;
            return MeasureGroupStratifierComponentComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.description, this.criteria);
        }

        @Override
        public String fhirType() {
            return "Measure.group.stratifier.component";
        }
    }

    @Block
    public static class MeasureGroupStratifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Meaning of the stratifier", formalDefinition="Indicates a meaning for the stratifier. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing stratifiers to be correlated across measures.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-stratifier-example")
        protected CodeableConcept code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human readable description of this stratifier", formalDefinition="The human readable description of this stratifier criteria.")
        protected StringType description;
        @Child(name="criteria", type={Expression.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the measure should be stratified", formalDefinition="An expression that specifies the criteria for the stratifier. This is typically the name of an expression defined within a referenced library, but it may also be a path to a stratifier element.")
        protected Expression criteria;
        @Child(name="component", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Stratifier criteria component for the measure", formalDefinition="A component of the stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library or a valid FHIR Resource Path.")
        protected List<MeasureGroupStratifierComponentComponent> component;
        private static final long serialVersionUID = -1706793609L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureGroupStratifierComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupStratifierComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupStratifierComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Expression getCriteria() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new Expression();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupStratifierComponent setCriteria(Expression value) {
            this.criteria = value;
            return this;
        }

        public List<MeasureGroupStratifierComponentComponent> getComponent() {
            if (this.component == null) {
                this.component = new ArrayList<MeasureGroupStratifierComponentComponent>();
            }
            return this.component;
        }

        public MeasureGroupStratifierComponent setComponent(List<MeasureGroupStratifierComponentComponent> theComponent) {
            this.component = theComponent;
            return this;
        }

        public boolean hasComponent() {
            if (this.component == null) {
                return false;
            }
            for (MeasureGroupStratifierComponentComponent item : this.component) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupStratifierComponentComponent addComponent() {
            MeasureGroupStratifierComponentComponent t = new MeasureGroupStratifierComponentComponent();
            if (this.component == null) {
                this.component = new ArrayList<MeasureGroupStratifierComponentComponent>();
            }
            this.component.add(t);
            return t;
        }

        public MeasureGroupStratifierComponent addComponent(MeasureGroupStratifierComponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.component == null) {
                this.component = new ArrayList<MeasureGroupStratifierComponentComponent>();
            }
            this.component.add(t);
            return this;
        }

        public MeasureGroupStratifierComponentComponent getComponentFirstRep() {
            if (this.getComponent().isEmpty()) {
                this.addComponent();
            }
            return this.getComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Indicates a meaning for the stratifier. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing stratifiers to be correlated across measures.", 0, 1, this.code));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this stratifier criteria.", 0, 1, this.description));
            children.add(new Property("criteria", "Expression", "An expression that specifies the criteria for the stratifier. This is typically the name of an expression defined within a referenced library, but it may also be a path to a stratifier element.", 0, 1, this.criteria));
            children.add(new Property("component", "", "A component of the stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.component));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Indicates a meaning for the stratifier. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing stratifiers to be correlated across measures.", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this stratifier criteria.", 0, 1, this.description);
                }
                case 1952046943: {
                    return new Property("criteria", "Expression", "An expression that specifies the criteria for the stratifier. This is typically the name of an expression defined within a referenced library, but it may also be a path to a stratifier element.", 0, 1, this.criteria);
                }
                case -1399907075: {
                    return new Property("component", "", "A component of the stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.component);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.criteria;
                    }
                    return baseArray;
                }
                case -1399907075: {
                    return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 1952046943: {
                    this.criteria = TypeConvertor.castToExpression(value);
                    return value;
                }
                case -1399907075: {
                    this.getComponent().add((MeasureGroupStratifierComponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("criteria")) {
                this.criteria = TypeConvertor.castToExpression(value);
            } else if (name.equals("component")) {
                this.getComponent().add((MeasureGroupStratifierComponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1952046943: {
                    return this.getCriteria();
                }
                case -1399907075: {
                    return this.addComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1952046943: {
                    return new String[]{"Expression"};
                }
                case -1399907075: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.group.stratifier.description");
            }
            if (name.equals("criteria")) {
                this.criteria = new Expression();
                return this.criteria;
            }
            if (name.equals("component")) {
                return this.addComponent();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupStratifierComponent copy() {
            MeasureGroupStratifierComponent dst = new MeasureGroupStratifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureGroupStratifierComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.description = this.description == null ? null : this.description.copy();
            Expression expression = dst.criteria = this.criteria == null ? null : this.criteria.copy();
            if (this.component != null) {
                dst.component = new ArrayList<MeasureGroupStratifierComponentComponent>();
                for (MeasureGroupStratifierComponentComponent i2 : this.component) {
                    dst.component.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupStratifierComponent)) {
                return false;
            }
            MeasureGroupStratifierComponent o = (MeasureGroupStratifierComponent)other_;
            return MeasureGroupStratifierComponent.compareDeep(this.code, o.code, true) && MeasureGroupStratifierComponent.compareDeep(this.description, o.description, true) && MeasureGroupStratifierComponent.compareDeep(this.criteria, o.criteria, true) && MeasureGroupStratifierComponent.compareDeep(this.component, o.component, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupStratifierComponent)) {
                return false;
            }
            MeasureGroupStratifierComponent o = (MeasureGroupStratifierComponent)other_;
            return MeasureGroupStratifierComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.description, this.criteria, this.component);
        }

        @Override
        public String fhirType() {
            return "Measure.group.stratifier";
        }
    }

    @Block
    public static class MeasureGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-observation", formalDefinition="The type of population criteria.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-population")
        protected CodeableConcept code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human readable description of this population criteria", formalDefinition="The human readable description of this population criteria.")
        protected StringType description;
        @Child(name="criteria", type={Expression.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The criteria that defines this population", formalDefinition="An expression that specifies the criteria for the population, typically the name of an expression in a library.")
        protected Expression criteria;
        @Child(name="inputPopulationId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which population", formalDefinition="The id of a population element in this measure that provides the input for this population criteria. In most cases, the scoring structure of the measure implies specific relationships (e.g. the Numerator uses the Denominator as the source in a proportion scoring). In some cases, however, multiple possible choices exist and must be resolved explicitly. For example in a ratio measure with multiple initial populations, the denominator must specify which population should be used as the starting point.")
        protected StringType inputPopulationId;
        @Child(name="aggregateMethod", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Aggregation method for a measure score (e.g. sum, average, median, minimum, maximum, count)", formalDefinition="Specifies which method should be used to aggregate measure observation values. For most scoring types, this is implied by scoring (e.g. a proportion measure counts members of the populations). For continuous variables, however, this information must be specified to ensure correct calculation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-aggregate-method")
        protected CodeableConcept aggregateMethod;
        private static final long serialVersionUID = 119326506L;

        public MeasureGroupPopulationComponent() {
        }

        public MeasureGroupPopulationComponent(Expression criteria) {
            this.setCriteria(criteria);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureGroupPopulationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupPopulationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupPopulationComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Expression getCriteria() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new Expression();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupPopulationComponent setCriteria(Expression value) {
            this.criteria = value;
            return this;
        }

        public StringType getInputPopulationIdElement() {
            if (this.inputPopulationId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.inputPopulationId");
                }
                if (Configuration.doAutoCreate()) {
                    this.inputPopulationId = new StringType();
                }
            }
            return this.inputPopulationId;
        }

        public boolean hasInputPopulationIdElement() {
            return this.inputPopulationId != null && !this.inputPopulationId.isEmpty();
        }

        public boolean hasInputPopulationId() {
            return this.inputPopulationId != null && !this.inputPopulationId.isEmpty();
        }

        public MeasureGroupPopulationComponent setInputPopulationIdElement(StringType value) {
            this.inputPopulationId = value;
            return this;
        }

        public String getInputPopulationId() {
            return this.inputPopulationId == null ? null : (String)this.inputPopulationId.getValue();
        }

        public MeasureGroupPopulationComponent setInputPopulationId(String value) {
            if (Utilities.noString(value)) {
                this.inputPopulationId = null;
            } else {
                if (this.inputPopulationId == null) {
                    this.inputPopulationId = new StringType();
                }
                this.inputPopulationId.setValue(value);
            }
            return this;
        }

        public CodeableConcept getAggregateMethod() {
            if (this.aggregateMethod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.aggregateMethod");
                }
                if (Configuration.doAutoCreate()) {
                    this.aggregateMethod = new CodeableConcept();
                }
            }
            return this.aggregateMethod;
        }

        public boolean hasAggregateMethod() {
            return this.aggregateMethod != null && !this.aggregateMethod.isEmpty();
        }

        public MeasureGroupPopulationComponent setAggregateMethod(CodeableConcept value) {
            this.aggregateMethod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The type of population criteria.", 0, 1, this.code));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population criteria.", 0, 1, this.description));
            children.add(new Property("criteria", "Expression", "An expression that specifies the criteria for the population, typically the name of an expression in a library.", 0, 1, this.criteria));
            children.add(new Property("inputPopulationId", "string", "The id of a population element in this measure that provides the input for this population criteria. In most cases, the scoring structure of the measure implies specific relationships (e.g. the Numerator uses the Denominator as the source in a proportion scoring). In some cases, however, multiple possible choices exist and must be resolved explicitly. For example in a ratio measure with multiple initial populations, the denominator must specify which population should be used as the starting point.", 0, 1, this.inputPopulationId));
            children.add(new Property("aggregateMethod", "CodeableConcept", "Specifies which method should be used to aggregate measure observation values. For most scoring types, this is implied by scoring (e.g. a proportion measure counts members of the populations). For continuous variables, however, this information must be specified to ensure correct calculation.", 0, 1, this.aggregateMethod));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The type of population criteria.", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population criteria.", 0, 1, this.description);
                }
                case 1952046943: {
                    return new Property("criteria", "Expression", "An expression that specifies the criteria for the population, typically the name of an expression in a library.", 0, 1, this.criteria);
                }
                case -464344526: {
                    return new Property("inputPopulationId", "string", "The id of a population element in this measure that provides the input for this population criteria. In most cases, the scoring structure of the measure implies specific relationships (e.g. the Numerator uses the Denominator as the source in a proportion scoring). In some cases, however, multiple possible choices exist and must be resolved explicitly. For example in a ratio measure with multiple initial populations, the denominator must specify which population should be used as the starting point.", 0, 1, this.inputPopulationId);
                }
                case -1036416: {
                    return new Property("aggregateMethod", "CodeableConcept", "Specifies which method should be used to aggregate measure observation values. For most scoring types, this is implied by scoring (e.g. a proportion measure counts members of the populations). For continuous variables, however, this information must be specified to ensure correct calculation.", 0, 1, this.aggregateMethod);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.criteria;
                    }
                    return baseArray;
                }
                case -464344526: {
                    Base[] baseArray;
                    if (this.inputPopulationId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.inputPopulationId;
                    }
                    return baseArray;
                }
                case -1036416: {
                    Base[] baseArray;
                    if (this.aggregateMethod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.aggregateMethod;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 1952046943: {
                    this.criteria = TypeConvertor.castToExpression(value);
                    return value;
                }
                case -464344526: {
                    this.inputPopulationId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1036416: {
                    this.aggregateMethod = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("criteria")) {
                this.criteria = TypeConvertor.castToExpression(value);
            } else if (name.equals("inputPopulationId")) {
                this.inputPopulationId = TypeConvertor.castToString(value);
            } else if (name.equals("aggregateMethod")) {
                this.aggregateMethod = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1952046943: {
                    return this.getCriteria();
                }
                case -464344526: {
                    return this.getInputPopulationIdElement();
                }
                case -1036416: {
                    return this.getAggregateMethod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1952046943: {
                    return new String[]{"Expression"};
                }
                case -464344526: {
                    return new String[]{"string"};
                }
                case -1036416: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.group.population.description");
            }
            if (name.equals("criteria")) {
                this.criteria = new Expression();
                return this.criteria;
            }
            if (name.equals("inputPopulationId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.group.population.inputPopulationId");
            }
            if (name.equals("aggregateMethod")) {
                this.aggregateMethod = new CodeableConcept();
                return this.aggregateMethod;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupPopulationComponent copy() {
            MeasureGroupPopulationComponent dst = new MeasureGroupPopulationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureGroupPopulationComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            dst.inputPopulationId = this.inputPopulationId == null ? null : this.inputPopulationId.copy();
            dst.aggregateMethod = this.aggregateMethod == null ? null : this.aggregateMethod.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupPopulationComponent)) {
                return false;
            }
            MeasureGroupPopulationComponent o = (MeasureGroupPopulationComponent)other_;
            return MeasureGroupPopulationComponent.compareDeep(this.code, o.code, true) && MeasureGroupPopulationComponent.compareDeep(this.description, o.description, true) && MeasureGroupPopulationComponent.compareDeep(this.criteria, o.criteria, true) && MeasureGroupPopulationComponent.compareDeep(this.inputPopulationId, o.inputPopulationId, true) && MeasureGroupPopulationComponent.compareDeep(this.aggregateMethod, o.aggregateMethod, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupPopulationComponent)) {
                return false;
            }
            MeasureGroupPopulationComponent o = (MeasureGroupPopulationComponent)other_;
            return MeasureGroupPopulationComponent.compareValues(this.description, o.description, true) && MeasureGroupPopulationComponent.compareValues(this.inputPopulationId, o.inputPopulationId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.description, this.criteria, this.inputPopulationId, this.aggregateMethod);
        }

        @Override
        public String fhirType() {
            return "Measure.group.population";
        }
    }

    @Block
    public static class MeasureGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Meaning of the group", formalDefinition="Indicates a meaning for the group. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing groups to be correlated across measures.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-group-example")
        protected CodeableConcept code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Summary description", formalDefinition="The human readable description of this population group.")
        protected StringType description;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="process | outcome | structure | patient-reported-outcome | composite", formalDefinition="Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-type")
        protected List<CodeableConcept> type;
        @Child(name="basis", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Population basis", formalDefinition="The population basis specifies the type of elements in the population. For a subject-based measure, this is boolean (because the subject and the population basis are the same, and the population criteria define yes/no values for each individual in the population). For measures that have a population basis that is different than the subject, this element specifies the type of the population basis. For example, an encounter-based measure has a subject of Patient and a population basis of Encounter, and the population criteria all return lists of Encounters.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-types")
        protected Enumeration<Enumerations.FHIRAllTypes> basis;
        @Child(name="scoring", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="proportion | ratio | continuous-variable | cohort", formalDefinition="Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-scoring")
        protected CodeableConcept scoring;
        @Child(name="scoringUnit", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What units?", formalDefinition="Defines the expected units of measure for the measure score. This element SHOULD be specified as a UCUM unit.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-scoring-unit")
        protected CodeableConcept scoringUnit;
        @Child(name="improvementNotation", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="increase | decrease", formalDefinition="Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-improvement-notation")
        protected CodeableConcept improvementNotation;
        @Child(name="population", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Population criteria", formalDefinition="A population criteria for the measure.")
        protected List<MeasureGroupPopulationComponent> population;
        @Child(name="stratifier", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Stratifier criteria for the measure", formalDefinition="The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library or a valid FHIR Resource Path.")
        protected List<MeasureGroupStratifierComponent> stratifier;
        private static final long serialVersionUID = 693617289L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureGroupComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public MeasureGroupComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public MeasureGroupComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public Enumeration<Enumerations.FHIRAllTypes> getBasisElement() {
            if (this.basis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.basis");
                }
                if (Configuration.doAutoCreate()) {
                    this.basis = new Enumeration<Enumerations.FHIRAllTypes>(new Enumerations.FHIRAllTypesEnumFactory());
                }
            }
            return this.basis;
        }

        public boolean hasBasisElement() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public boolean hasBasis() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public MeasureGroupComponent setBasisElement(Enumeration<Enumerations.FHIRAllTypes> value) {
            this.basis = value;
            return this;
        }

        public Enumerations.FHIRAllTypes getBasis() {
            return this.basis == null ? null : (Enumerations.FHIRAllTypes)((Object)this.basis.getValue());
        }

        public MeasureGroupComponent setBasis(Enumerations.FHIRAllTypes value) {
            if (value == null) {
                this.basis = null;
            } else {
                if (this.basis == null) {
                    this.basis = new Enumeration<Enumerations.FHIRAllTypes>(new Enumerations.FHIRAllTypesEnumFactory());
                }
                this.basis.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getScoring() {
            if (this.scoring == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.scoring");
                }
                if (Configuration.doAutoCreate()) {
                    this.scoring = new CodeableConcept();
                }
            }
            return this.scoring;
        }

        public boolean hasScoring() {
            return this.scoring != null && !this.scoring.isEmpty();
        }

        public MeasureGroupComponent setScoring(CodeableConcept value) {
            this.scoring = value;
            return this;
        }

        public CodeableConcept getScoringUnit() {
            if (this.scoringUnit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.scoringUnit");
                }
                if (Configuration.doAutoCreate()) {
                    this.scoringUnit = new CodeableConcept();
                }
            }
            return this.scoringUnit;
        }

        public boolean hasScoringUnit() {
            return this.scoringUnit != null && !this.scoringUnit.isEmpty();
        }

        public MeasureGroupComponent setScoringUnit(CodeableConcept value) {
            this.scoringUnit = value;
            return this;
        }

        public CodeableConcept getImprovementNotation() {
            if (this.improvementNotation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.improvementNotation");
                }
                if (Configuration.doAutoCreate()) {
                    this.improvementNotation = new CodeableConcept();
                }
            }
            return this.improvementNotation;
        }

        public boolean hasImprovementNotation() {
            return this.improvementNotation != null && !this.improvementNotation.isEmpty();
        }

        public MeasureGroupComponent setImprovementNotation(CodeableConcept value) {
            this.improvementNotation = value;
            return this;
        }

        public List<MeasureGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            return this.population;
        }

        public MeasureGroupComponent setPopulation(List<MeasureGroupPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MeasureGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupPopulationComponent addPopulation() {
            MeasureGroupPopulationComponent t = new MeasureGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MeasureGroupComponent addPopulation(MeasureGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public MeasureGroupPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        public List<MeasureGroupStratifierComponent> getStratifier() {
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            return this.stratifier;
        }

        public MeasureGroupComponent setStratifier(List<MeasureGroupStratifierComponent> theStratifier) {
            this.stratifier = theStratifier;
            return this;
        }

        public boolean hasStratifier() {
            if (this.stratifier == null) {
                return false;
            }
            for (MeasureGroupStratifierComponent item : this.stratifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupStratifierComponent addStratifier() {
            MeasureGroupStratifierComponent t = new MeasureGroupStratifierComponent();
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return t;
        }

        public MeasureGroupComponent addStratifier(MeasureGroupStratifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return this;
        }

        public MeasureGroupStratifierComponent getStratifierFirstRep() {
            if (this.getStratifier().isEmpty()) {
                this.addStratifier();
            }
            return this.getStratifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Indicates a meaning for the group. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing groups to be correlated across measures.", 0, 1, this.code));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population group.", 0, 1, this.description));
            children.add(new Property("type", "CodeableConcept", "Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("basis", "code", "The population basis specifies the type of elements in the population. For a subject-based measure, this is boolean (because the subject and the population basis are the same, and the population criteria define yes/no values for each individual in the population). For measures that have a population basis that is different than the subject, this element specifies the type of the population basis. For example, an encounter-based measure has a subject of Patient and a population basis of Encounter, and the population criteria all return lists of Encounters.", 0, 1, this.basis));
            children.add(new Property("scoring", "CodeableConcept", "Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.", 0, 1, this.scoring));
            children.add(new Property("scoringUnit", "CodeableConcept", "Defines the expected units of measure for the measure score. This element SHOULD be specified as a UCUM unit.", 0, 1, this.scoringUnit));
            children.add(new Property("improvementNotation", "CodeableConcept", "Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).", 0, 1, this.improvementNotation));
            children.add(new Property("population", "", "A population criteria for the measure.", 0, Integer.MAX_VALUE, this.population));
            children.add(new Property("stratifier", "", "The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.stratifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Indicates a meaning for the group. This can be as simple as a unique identifier, or it can establish meaning in a broader context by drawing from a terminology, allowing groups to be correlated across measures.", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population group.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.", 0, Integer.MAX_VALUE, this.type);
                }
                case 93508670: {
                    return new Property("basis", "code", "The population basis specifies the type of elements in the population. For a subject-based measure, this is boolean (because the subject and the population basis are the same, and the population criteria define yes/no values for each individual in the population). For measures that have a population basis that is different than the subject, this element specifies the type of the population basis. For example, an encounter-based measure has a subject of Patient and a population basis of Encounter, and the population criteria all return lists of Encounters.", 0, 1, this.basis);
                }
                case 1924005583: {
                    return new Property("scoring", "CodeableConcept", "Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.", 0, 1, this.scoring);
                }
                case 1527532787: {
                    return new Property("scoringUnit", "CodeableConcept", "Defines the expected units of measure for the measure score. This element SHOULD be specified as a UCUM unit.", 0, 1, this.scoringUnit);
                }
                case -2085456136: {
                    return new Property("improvementNotation", "CodeableConcept", "Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).", 0, 1, this.improvementNotation);
                }
                case -2023558323: {
                    return new Property("population", "", "A population criteria for the measure.", 0, Integer.MAX_VALUE, this.population);
                }
                case 90983669: {
                    return new Property("stratifier", "", "The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.stratifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 93508670: {
                    Base[] baseArray;
                    if (this.basis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.basis;
                    }
                    return baseArray;
                }
                case 1924005583: {
                    Base[] baseArray;
                    if (this.scoring == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.scoring;
                    }
                    return baseArray;
                }
                case 1527532787: {
                    Base[] baseArray;
                    if (this.scoringUnit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.scoringUnit;
                    }
                    return baseArray;
                }
                case -2085456136: {
                    Base[] baseArray;
                    if (this.improvementNotation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.improvementNotation;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case 90983669: {
                    return this.stratifier == null ? new Base[]{} : this.stratifier.toArray(new Base[this.stratifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 93508670: {
                    value = new Enumerations.FHIRAllTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.basis = value;
                    return value;
                }
                case 1924005583: {
                    this.scoring = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1527532787: {
                    this.scoringUnit = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2085456136: {
                    this.improvementNotation = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((MeasureGroupPopulationComponent)((Object)value));
                    return value;
                }
                case 90983669: {
                    this.getStratifier().add((MeasureGroupStratifierComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("basis")) {
                value = new Enumerations.FHIRAllTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.basis = value;
            } else if (name.equals("scoring")) {
                this.scoring = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("scoringUnit")) {
                this.scoringUnit = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("improvementNotation")) {
                this.improvementNotation = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MeasureGroupPopulationComponent)((Object)value));
            } else if (name.equals("stratifier")) {
                this.getStratifier().add((MeasureGroupStratifierComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.addType();
                }
                case 93508670: {
                    return this.getBasisElement();
                }
                case 1924005583: {
                    return this.getScoring();
                }
                case 1527532787: {
                    return this.getScoringUnit();
                }
                case -2085456136: {
                    return this.getImprovementNotation();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case 90983669: {
                    return this.addStratifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 93508670: {
                    return new String[]{"code"};
                }
                case 1924005583: {
                    return new String[]{"CodeableConcept"};
                }
                case 1527532787: {
                    return new String[]{"CodeableConcept"};
                }
                case -2085456136: {
                    return new String[]{"CodeableConcept"};
                }
                case -2023558323: {
                    return new String[0];
                }
                case 90983669: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.group.description");
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("basis")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.group.basis");
            }
            if (name.equals("scoring")) {
                this.scoring = new CodeableConcept();
                return this.scoring;
            }
            if (name.equals("scoringUnit")) {
                this.scoringUnit = new CodeableConcept();
                return this.scoringUnit;
            }
            if (name.equals("improvementNotation")) {
                this.improvementNotation = new CodeableConcept();
                return this.improvementNotation;
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("stratifier")) {
                return this.addStratifier();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupComponent copy() {
            MeasureGroupComponent dst = new MeasureGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MeasureGroupComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            dst.basis = this.basis == null ? null : this.basis.copy();
            dst.scoring = this.scoring == null ? null : this.scoring.copy();
            dst.scoringUnit = this.scoringUnit == null ? null : this.scoringUnit.copy();
            CodeableConcept codeableConcept = dst.improvementNotation = this.improvementNotation == null ? null : this.improvementNotation.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MeasureGroupPopulationComponent>();
                for (MeasureGroupPopulationComponent measureGroupPopulationComponent : this.population) {
                    dst.population.add(measureGroupPopulationComponent.copy());
                }
            }
            if (this.stratifier != null) {
                dst.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
                for (MeasureGroupStratifierComponent measureGroupStratifierComponent : this.stratifier) {
                    dst.stratifier.add(measureGroupStratifierComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupComponent)) {
                return false;
            }
            MeasureGroupComponent o = (MeasureGroupComponent)other_;
            return MeasureGroupComponent.compareDeep(this.code, o.code, true) && MeasureGroupComponent.compareDeep(this.description, o.description, true) && MeasureGroupComponent.compareDeep(this.type, o.type, true) && MeasureGroupComponent.compareDeep(this.basis, o.basis, true) && MeasureGroupComponent.compareDeep(this.scoring, o.scoring, true) && MeasureGroupComponent.compareDeep(this.scoringUnit, o.scoringUnit, true) && MeasureGroupComponent.compareDeep(this.improvementNotation, o.improvementNotation, true) && MeasureGroupComponent.compareDeep(this.population, o.population, true) && MeasureGroupComponent.compareDeep(this.stratifier, o.stratifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupComponent)) {
                return false;
            }
            MeasureGroupComponent o = (MeasureGroupComponent)other_;
            return MeasureGroupComponent.compareValues(this.description, o.description, true) && MeasureGroupComponent.compareValues(this.basis, o.basis, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.description, this.type, this.basis, this.scoring, this.scoringUnit, this.improvementNotation, this.population, this.stratifier);
        }

        @Override
        public String fhirType() {
            return "Measure.group";
        }
    }
}

