/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="InventoryReport", profile="http://hl7.org/fhir/StructureDefinition/InventoryReport")
public class InventoryReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifiers for the report", formalDefinition="Identifiers for the InventoryReport.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | requested | active | entered-in-error", formalDefinition="The status of the inventory check or notification - whether this is draft (e.g. the report is still pending some updates) or active.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/inventoryreport-status")
    protected Enumeration<InventoryReportStatus> status;
    @Child(name="countType", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="snapshot | difference", formalDefinition="Whether the report is about the current inventory count (snapshot) or a differential change in inventory (change).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/inventoryreport-counttype")
    protected Enumeration<InventoryCountType> countType;
    @Child(name="operationType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="addition | subtraction", formalDefinition="What type of operation is being performed - addition or subtraction.")
    protected CodeableConcept operationType;
    @Child(name="operationTypeReason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The reason for this count - regular count, ad-hoc count, new arrivals, etc.", formalDefinition="The reason for this count - regular count, ad-hoc count, new arrivals, etc.")
    protected CodeableConcept operationTypeReason;
    @Child(name="reportedDateTime", type={DateTimeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the report has been submitted", formalDefinition="When the report has been submitted.")
    protected DateTimeType reportedDateTime;
    @Child(name="reporter", type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who submits the report", formalDefinition="Who submits the report.")
    protected Reference reporter;
    @Child(name="reportingPeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The period the report refers to", formalDefinition="The period the report refers to.")
    protected Period reportingPeriod;
    @Child(name="inventoryListing", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An inventory listing section (grouped by any of the attributes)", formalDefinition="An inventory listing section (grouped by any of the attributes).")
    protected List<InventoryReportInventoryListingComponent> inventoryListing;
    @Child(name="note", type={Annotation.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A note associated with the InventoryReport", formalDefinition="A note associated with the InventoryReport.")
    protected Annotation note;
    private static final long serialVersionUID = 1491752269L;

    public InventoryReport() {
    }

    public InventoryReport(InventoryReportStatus status, InventoryCountType countType, Date reportedDateTime) {
        this.setStatus(status);
        this.setCountType(countType);
        this.setReportedDateTime(reportedDateTime);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public InventoryReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public InventoryReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<InventoryReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<InventoryReportStatus>(new InventoryReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public InventoryReport setStatusElement(Enumeration<InventoryReportStatus> value) {
        this.status = value;
        return this;
    }

    public InventoryReportStatus getStatus() {
        return this.status == null ? null : (InventoryReportStatus)((Object)this.status.getValue());
    }

    public InventoryReport setStatus(InventoryReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<InventoryReportStatus>(new InventoryReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<InventoryCountType> getCountTypeElement() {
        if (this.countType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.countType");
            }
            if (Configuration.doAutoCreate()) {
                this.countType = new Enumeration<InventoryCountType>(new InventoryCountTypeEnumFactory());
            }
        }
        return this.countType;
    }

    public boolean hasCountTypeElement() {
        return this.countType != null && !this.countType.isEmpty();
    }

    public boolean hasCountType() {
        return this.countType != null && !this.countType.isEmpty();
    }

    public InventoryReport setCountTypeElement(Enumeration<InventoryCountType> value) {
        this.countType = value;
        return this;
    }

    public InventoryCountType getCountType() {
        return this.countType == null ? null : (InventoryCountType)((Object)this.countType.getValue());
    }

    public InventoryReport setCountType(InventoryCountType value) {
        if (this.countType == null) {
            this.countType = new Enumeration<InventoryCountType>(new InventoryCountTypeEnumFactory());
        }
        this.countType.setValue((Object)value);
        return this;
    }

    public CodeableConcept getOperationType() {
        if (this.operationType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.operationType");
            }
            if (Configuration.doAutoCreate()) {
                this.operationType = new CodeableConcept();
            }
        }
        return this.operationType;
    }

    public boolean hasOperationType() {
        return this.operationType != null && !this.operationType.isEmpty();
    }

    public InventoryReport setOperationType(CodeableConcept value) {
        this.operationType = value;
        return this;
    }

    public CodeableConcept getOperationTypeReason() {
        if (this.operationTypeReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.operationTypeReason");
            }
            if (Configuration.doAutoCreate()) {
                this.operationTypeReason = new CodeableConcept();
            }
        }
        return this.operationTypeReason;
    }

    public boolean hasOperationTypeReason() {
        return this.operationTypeReason != null && !this.operationTypeReason.isEmpty();
    }

    public InventoryReport setOperationTypeReason(CodeableConcept value) {
        this.operationTypeReason = value;
        return this;
    }

    public DateTimeType getReportedDateTimeElement() {
        if (this.reportedDateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.reportedDateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.reportedDateTime = new DateTimeType();
            }
        }
        return this.reportedDateTime;
    }

    public boolean hasReportedDateTimeElement() {
        return this.reportedDateTime != null && !this.reportedDateTime.isEmpty();
    }

    public boolean hasReportedDateTime() {
        return this.reportedDateTime != null && !this.reportedDateTime.isEmpty();
    }

    public InventoryReport setReportedDateTimeElement(DateTimeType value) {
        this.reportedDateTime = value;
        return this;
    }

    public Date getReportedDateTime() {
        return this.reportedDateTime == null ? null : (Date)this.reportedDateTime.getValue();
    }

    public InventoryReport setReportedDateTime(Date value) {
        if (this.reportedDateTime == null) {
            this.reportedDateTime = new DateTimeType();
        }
        this.reportedDateTime.setValue(value);
        return this;
    }

    public Reference getReporter() {
        if (this.reporter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.reporter");
            }
            if (Configuration.doAutoCreate()) {
                this.reporter = new Reference();
            }
        }
        return this.reporter;
    }

    public boolean hasReporter() {
        return this.reporter != null && !this.reporter.isEmpty();
    }

    public InventoryReport setReporter(Reference value) {
        this.reporter = value;
        return this;
    }

    public Period getReportingPeriod() {
        if (this.reportingPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.reportingPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.reportingPeriod = new Period();
            }
        }
        return this.reportingPeriod;
    }

    public boolean hasReportingPeriod() {
        return this.reportingPeriod != null && !this.reportingPeriod.isEmpty();
    }

    public InventoryReport setReportingPeriod(Period value) {
        this.reportingPeriod = value;
        return this;
    }

    public List<InventoryReportInventoryListingComponent> getInventoryListing() {
        if (this.inventoryListing == null) {
            this.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
        }
        return this.inventoryListing;
    }

    public InventoryReport setInventoryListing(List<InventoryReportInventoryListingComponent> theInventoryListing) {
        this.inventoryListing = theInventoryListing;
        return this;
    }

    public boolean hasInventoryListing() {
        if (this.inventoryListing == null) {
            return false;
        }
        for (InventoryReportInventoryListingComponent item : this.inventoryListing) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InventoryReportInventoryListingComponent addInventoryListing() {
        InventoryReportInventoryListingComponent t = new InventoryReportInventoryListingComponent();
        if (this.inventoryListing == null) {
            this.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
        }
        this.inventoryListing.add(t);
        return t;
    }

    public InventoryReport addInventoryListing(InventoryReportInventoryListingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.inventoryListing == null) {
            this.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
        }
        this.inventoryListing.add(t);
        return this;
    }

    public InventoryReportInventoryListingComponent getInventoryListingFirstRep() {
        if (this.getInventoryListing().isEmpty()) {
            this.addInventoryListing();
        }
        return this.getInventoryListing().get(0);
    }

    public Annotation getNote() {
        if (this.note == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.note");
            }
            if (Configuration.doAutoCreate()) {
                this.note = new Annotation();
            }
        }
        return this.note;
    }

    public boolean hasNote() {
        return this.note != null && !this.note.isEmpty();
    }

    public InventoryReport setNote(Annotation value) {
        this.note = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Identifiers for the InventoryReport.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("status", "code", "The status of the inventory check or notification - whether this is draft (e.g. the report is still pending some updates) or active.", 0, 1, this.status));
        children.add(new Property("countType", "code", "Whether the report is about the current inventory count (snapshot) or a differential change in inventory (change).", 0, 1, this.countType));
        children.add(new Property("operationType", "CodeableConcept", "What type of operation is being performed - addition or subtraction.", 0, 1, this.operationType));
        children.add(new Property("operationTypeReason", "CodeableConcept", "The reason for this count - regular count, ad-hoc count, new arrivals, etc.", 0, 1, this.operationTypeReason));
        children.add(new Property("reportedDateTime", "dateTime", "When the report has been submitted.", 0, 1, this.reportedDateTime));
        children.add(new Property("reporter", "Reference(Practitioner|Patient|RelatedPerson|Device)", "Who submits the report.", 0, 1, this.reporter));
        children.add(new Property("reportingPeriod", "Period", "The period the report refers to.", 0, 1, this.reportingPeriod));
        children.add(new Property("inventoryListing", "", "An inventory listing section (grouped by any of the attributes).", 0, Integer.MAX_VALUE, this.inventoryListing));
        children.add(new Property("note", "Annotation", "A note associated with the InventoryReport.", 0, 1, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Identifiers for the InventoryReport.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the inventory check or notification - whether this is draft (e.g. the report is still pending some updates) or active.", 0, 1, this.status);
            }
            case 1351759081: {
                return new Property("countType", "code", "Whether the report is about the current inventory count (snapshot) or a differential change in inventory (change).", 0, 1, this.countType);
            }
            case 91999553: {
                return new Property("operationType", "CodeableConcept", "What type of operation is being performed - addition or subtraction.", 0, 1, this.operationType);
            }
            case 449681125: {
                return new Property("operationTypeReason", "CodeableConcept", "The reason for this count - regular count, ad-hoc count, new arrivals, etc.", 0, 1, this.operationTypeReason);
            }
            case -1048250994: {
                return new Property("reportedDateTime", "dateTime", "When the report has been submitted.", 0, 1, this.reportedDateTime);
            }
            case -427039519: {
                return new Property("reporter", "Reference(Practitioner|Patient|RelatedPerson|Device)", "Who submits the report.", 0, 1, this.reporter);
            }
            case 409685391: {
                return new Property("reportingPeriod", "Period", "The period the report refers to.", 0, 1, this.reportingPeriod);
            }
            case -1764804216: {
                return new Property("inventoryListing", "", "An inventory listing section (grouped by any of the attributes).", 0, Integer.MAX_VALUE, this.inventoryListing);
            }
            case 3387378: {
                return new Property("note", "Annotation", "A note associated with the InventoryReport.", 0, 1, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1351759081: {
                Base[] baseArray;
                if (this.countType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.countType;
                }
                return baseArray;
            }
            case 91999553: {
                Base[] baseArray;
                if (this.operationType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.operationType;
                }
                return baseArray;
            }
            case 449681125: {
                Base[] baseArray;
                if (this.operationTypeReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.operationTypeReason;
                }
                return baseArray;
            }
            case -1048250994: {
                Base[] baseArray;
                if (this.reportedDateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.reportedDateTime;
                }
                return baseArray;
            }
            case -427039519: {
                Base[] baseArray;
                if (this.reporter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.reporter;
                }
                return baseArray;
            }
            case 409685391: {
                Base[] baseArray;
                if (this.reportingPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.reportingPeriod;
                }
                return baseArray;
            }
            case -1764804216: {
                return this.inventoryListing == null ? new Base[]{} : this.inventoryListing.toArray(new Base[this.inventoryListing.size()]);
            }
            case 3387378: {
                Base[] baseArray;
                if (this.note == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.note;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new InventoryReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1351759081: {
                value = new InventoryCountTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.countType = value;
                return value;
            }
            case 91999553: {
                this.operationType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 449681125: {
                this.operationTypeReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1048250994: {
                this.reportedDateTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -427039519: {
                this.reporter = TypeConvertor.castToReference(value);
                return value;
            }
            case 409685391: {
                this.reportingPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1764804216: {
                this.getInventoryListing().add((InventoryReportInventoryListingComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.note = TypeConvertor.castToAnnotation(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new InventoryReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("countType")) {
            value = new InventoryCountTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.countType = value;
        } else if (name.equals("operationType")) {
            this.operationType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("operationTypeReason")) {
            this.operationTypeReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("reportedDateTime")) {
            this.reportedDateTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals("reporter")) {
            this.reporter = TypeConvertor.castToReference(value);
        } else if (name.equals("reportingPeriod")) {
            this.reportingPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("inventoryListing")) {
            this.getInventoryListing().add((InventoryReportInventoryListingComponent)((Object)value));
        } else if (name.equals("note")) {
            this.note = TypeConvertor.castToAnnotation(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1351759081: {
                return this.getCountTypeElement();
            }
            case 91999553: {
                return this.getOperationType();
            }
            case 449681125: {
                return this.getOperationTypeReason();
            }
            case -1048250994: {
                return this.getReportedDateTimeElement();
            }
            case -427039519: {
                return this.getReporter();
            }
            case 409685391: {
                return this.getReportingPeriod();
            }
            case -1764804216: {
                return this.addInventoryListing();
            }
            case 3387378: {
                return this.getNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1351759081: {
                return new String[]{"code"};
            }
            case 91999553: {
                return new String[]{"CodeableConcept"};
            }
            case 449681125: {
                return new String[]{"CodeableConcept"};
            }
            case -1048250994: {
                return new String[]{"dateTime"};
            }
            case -427039519: {
                return new String[]{"Reference"};
            }
            case 409685391: {
                return new String[]{"Period"};
            }
            case -1764804216: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.status");
        }
        if (name.equals("countType")) {
            throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.countType");
        }
        if (name.equals("operationType")) {
            this.operationType = new CodeableConcept();
            return this.operationType;
        }
        if (name.equals("operationTypeReason")) {
            this.operationTypeReason = new CodeableConcept();
            return this.operationTypeReason;
        }
        if (name.equals("reportedDateTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.reportedDateTime");
        }
        if (name.equals("reporter")) {
            this.reporter = new Reference();
            return this.reporter;
        }
        if (name.equals("reportingPeriod")) {
            this.reportingPeriod = new Period();
            return this.reportingPeriod;
        }
        if (name.equals("inventoryListing")) {
            return this.addInventoryListing();
        }
        if (name.equals("note")) {
            this.note = new Annotation();
            return this.note;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "InventoryReport";
    }

    @Override
    public InventoryReport copy() {
        InventoryReport dst = new InventoryReport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(InventoryReport dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.countType = this.countType == null ? null : this.countType.copy();
        dst.operationType = this.operationType == null ? null : this.operationType.copy();
        dst.operationTypeReason = this.operationTypeReason == null ? null : this.operationTypeReason.copy();
        dst.reportedDateTime = this.reportedDateTime == null ? null : this.reportedDateTime.copy();
        dst.reporter = this.reporter == null ? null : this.reporter.copy();
        Period period = dst.reportingPeriod = this.reportingPeriod == null ? null : this.reportingPeriod.copy();
        if (this.inventoryListing != null) {
            dst.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
            for (InventoryReportInventoryListingComponent inventoryReportInventoryListingComponent : this.inventoryListing) {
                dst.inventoryListing.add(inventoryReportInventoryListingComponent.copy());
            }
        }
        dst.note = this.note == null ? null : this.note.copy();
    }

    protected InventoryReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof InventoryReport)) {
            return false;
        }
        InventoryReport o = (InventoryReport)other_;
        return InventoryReport.compareDeep(this.identifier, o.identifier, true) && InventoryReport.compareDeep(this.status, o.status, true) && InventoryReport.compareDeep(this.countType, o.countType, true) && InventoryReport.compareDeep(this.operationType, o.operationType, true) && InventoryReport.compareDeep(this.operationTypeReason, o.operationTypeReason, true) && InventoryReport.compareDeep(this.reportedDateTime, o.reportedDateTime, true) && InventoryReport.compareDeep(this.reporter, o.reporter, true) && InventoryReport.compareDeep(this.reportingPeriod, o.reportingPeriod, true) && InventoryReport.compareDeep(this.inventoryListing, o.inventoryListing, true) && InventoryReport.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof InventoryReport)) {
            return false;
        }
        InventoryReport o = (InventoryReport)other_;
        return InventoryReport.compareValues(this.status, o.status, true) && InventoryReport.compareValues(this.countType, o.countType, true) && InventoryReport.compareValues(this.reportedDateTime, o.reportedDateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.countType, this.operationType, this.operationTypeReason, this.reportedDateTime, this.reporter, this.reportingPeriod, this.inventoryListing, this.note);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.InventoryReport;
    }

    @Block
    public static class InventoryReportInventoryListingItemsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The category of the item or items", formalDefinition="The category of the item or items.")
        protected CodeableConcept category;
        @Child(name="quantity", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of the item or items", formalDefinition="The quantity of the item or items.")
        protected Quantity quantity;
        @Child(name="item", type={CodeableReference.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The code or reference to the item type", formalDefinition="The code or reference to the item type.")
        protected CodeableReference item;
        @Child(name="lot", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The lot number of the item or items", formalDefinition="The lot number of the item or items.")
        protected StringType lot;
        @Child(name="serial", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The serial number of the item", formalDefinition="The serial number of the item.")
        protected StringType serial;
        @Child(name="expiry", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The expiry date of the item or items", formalDefinition="The expiry date of the item or items.")
        protected DateTimeType expiry;
        @Child(name="manufacturingDate", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The manufacturingDate of the item or items", formalDefinition="The manufacturingDate of the item or items.")
        protected DateTimeType manufacturingDate;
        private static final long serialVersionUID = -848736270L;

        public InventoryReportInventoryListingItemsComponent() {
        }

        public InventoryReportInventoryListingItemsComponent(Quantity quantity, CodeableReference item) {
            this.setQuantity(quantity);
            this.setItem(item);
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public StringType getLotElement() {
            if (this.lot == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.lot");
                }
                if (Configuration.doAutoCreate()) {
                    this.lot = new StringType();
                }
            }
            return this.lot;
        }

        public boolean hasLotElement() {
            return this.lot != null && !this.lot.isEmpty();
        }

        public boolean hasLot() {
            return this.lot != null && !this.lot.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setLotElement(StringType value) {
            this.lot = value;
            return this;
        }

        public String getLot() {
            return this.lot == null ? null : (String)this.lot.getValue();
        }

        public InventoryReportInventoryListingItemsComponent setLot(String value) {
            if (Utilities.noString(value)) {
                this.lot = null;
            } else {
                if (this.lot == null) {
                    this.lot = new StringType();
                }
                this.lot.setValue(value);
            }
            return this;
        }

        public StringType getSerialElement() {
            if (this.serial == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.serial");
                }
                if (Configuration.doAutoCreate()) {
                    this.serial = new StringType();
                }
            }
            return this.serial;
        }

        public boolean hasSerialElement() {
            return this.serial != null && !this.serial.isEmpty();
        }

        public boolean hasSerial() {
            return this.serial != null && !this.serial.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setSerialElement(StringType value) {
            this.serial = value;
            return this;
        }

        public String getSerial() {
            return this.serial == null ? null : (String)this.serial.getValue();
        }

        public InventoryReportInventoryListingItemsComponent setSerial(String value) {
            if (Utilities.noString(value)) {
                this.serial = null;
            } else {
                if (this.serial == null) {
                    this.serial = new StringType();
                }
                this.serial.setValue(value);
            }
            return this;
        }

        public DateTimeType getExpiryElement() {
            if (this.expiry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.expiry");
                }
                if (Configuration.doAutoCreate()) {
                    this.expiry = new DateTimeType();
                }
            }
            return this.expiry;
        }

        public boolean hasExpiryElement() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public boolean hasExpiry() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setExpiryElement(DateTimeType value) {
            this.expiry = value;
            return this;
        }

        public Date getExpiry() {
            return this.expiry == null ? null : (Date)this.expiry.getValue();
        }

        public InventoryReportInventoryListingItemsComponent setExpiry(Date value) {
            if (value == null) {
                this.expiry = null;
            } else {
                if (this.expiry == null) {
                    this.expiry = new DateTimeType();
                }
                this.expiry.setValue(value);
            }
            return this;
        }

        public DateTimeType getManufacturingDateElement() {
            if (this.manufacturingDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemsComponent.manufacturingDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.manufacturingDate = new DateTimeType();
                }
            }
            return this.manufacturingDate;
        }

        public boolean hasManufacturingDateElement() {
            return this.manufacturingDate != null && !this.manufacturingDate.isEmpty();
        }

        public boolean hasManufacturingDate() {
            return this.manufacturingDate != null && !this.manufacturingDate.isEmpty();
        }

        public InventoryReportInventoryListingItemsComponent setManufacturingDateElement(DateTimeType value) {
            this.manufacturingDate = value;
            return this;
        }

        public Date getManufacturingDate() {
            return this.manufacturingDate == null ? null : (Date)this.manufacturingDate.getValue();
        }

        public InventoryReportInventoryListingItemsComponent setManufacturingDate(Date value) {
            if (value == null) {
                this.manufacturingDate = null;
            } else {
                if (this.manufacturingDate == null) {
                    this.manufacturingDate = new DateTimeType();
                }
                this.manufacturingDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "The category of the item or items.", 0, 1, this.category));
            children.add(new Property("quantity", "Quantity", "The quantity of the item or items.", 0, 1, this.quantity));
            children.add(new Property("item", "CodeableReference(Device|Medication)", "The code or reference to the item type.", 0, 1, this.item));
            children.add(new Property("lot", "string", "The lot number of the item or items.", 0, 1, this.lot));
            children.add(new Property("serial", "string", "The serial number of the item.", 0, 1, this.serial));
            children.add(new Property("expiry", "dateTime", "The expiry date of the item or items.", 0, 1, this.expiry));
            children.add(new Property("manufacturingDate", "dateTime", "The manufacturingDate of the item or items.", 0, 1, this.manufacturingDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "The category of the item or items.", 0, 1, this.category);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity of the item or items.", 0, 1, this.quantity);
                }
                case 3242771: {
                    return new Property("item", "CodeableReference(Device|Medication)", "The code or reference to the item type.", 0, 1, this.item);
                }
                case 107345: {
                    return new Property("lot", "string", "The lot number of the item or items.", 0, 1, this.lot);
                }
                case -905839116: {
                    return new Property("serial", "string", "The serial number of the item.", 0, 1, this.serial);
                }
                case -1289159373: {
                    return new Property("expiry", "dateTime", "The expiry date of the item or items.", 0, 1, this.expiry);
                }
                case 1492515340: {
                    return new Property("manufacturingDate", "dateTime", "The manufacturingDate of the item or items.", 0, 1, this.manufacturingDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.item;
                    }
                    return baseArray;
                }
                case 107345: {
                    Base[] baseArray;
                    if (this.lot == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lot;
                    }
                    return baseArray;
                }
                case -905839116: {
                    Base[] baseArray;
                    if (this.serial == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.serial;
                    }
                    return baseArray;
                }
                case -1289159373: {
                    Base[] baseArray;
                    if (this.expiry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.expiry;
                    }
                    return baseArray;
                }
                case 1492515340: {
                    Base[] baseArray;
                    if (this.manufacturingDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.manufacturingDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 107345: {
                    this.lot = TypeConvertor.castToString(value);
                    return value;
                }
                case -905839116: {
                    this.serial = TypeConvertor.castToString(value);
                    return value;
                }
                case -1289159373: {
                    this.expiry = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 1492515340: {
                    this.manufacturingDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("lot")) {
                this.lot = TypeConvertor.castToString(value);
            } else if (name.equals("serial")) {
                this.serial = TypeConvertor.castToString(value);
            } else if (name.equals("expiry")) {
                this.expiry = TypeConvertor.castToDateTime(value);
            } else if (name.equals("manufacturingDate")) {
                this.manufacturingDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 3242771: {
                    return this.getItem();
                }
                case 107345: {
                    return this.getLotElement();
                }
                case -905839116: {
                    return this.getSerialElement();
                }
                case -1289159373: {
                    return this.getExpiryElement();
                }
                case 1492515340: {
                    return this.getManufacturingDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case 107345: {
                    return new String[]{"string"};
                }
                case -905839116: {
                    return new String[]{"string"};
                }
                case -1289159373: {
                    return new String[]{"dateTime"};
                }
                case 1492515340: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("lot")) {
                throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.inventoryListing.items.lot");
            }
            if (name.equals("serial")) {
                throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.inventoryListing.items.serial");
            }
            if (name.equals("expiry")) {
                throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.inventoryListing.items.expiry");
            }
            if (name.equals("manufacturingDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.inventoryListing.items.manufacturingDate");
            }
            return super.addChild(name);
        }

        @Override
        public InventoryReportInventoryListingItemsComponent copy() {
            InventoryReportInventoryListingItemsComponent dst = new InventoryReportInventoryListingItemsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryReportInventoryListingItemsComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.item = this.item == null ? null : this.item.copy();
            dst.lot = this.lot == null ? null : this.lot.copy();
            dst.serial = this.serial == null ? null : this.serial.copy();
            dst.expiry = this.expiry == null ? null : this.expiry.copy();
            dst.manufacturingDate = this.manufacturingDate == null ? null : this.manufacturingDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingItemsComponent)) {
                return false;
            }
            InventoryReportInventoryListingItemsComponent o = (InventoryReportInventoryListingItemsComponent)other_;
            return InventoryReportInventoryListingItemsComponent.compareDeep(this.category, o.category, true) && InventoryReportInventoryListingItemsComponent.compareDeep(this.quantity, o.quantity, true) && InventoryReportInventoryListingItemsComponent.compareDeep(this.item, o.item, true) && InventoryReportInventoryListingItemsComponent.compareDeep(this.lot, o.lot, true) && InventoryReportInventoryListingItemsComponent.compareDeep(this.serial, o.serial, true) && InventoryReportInventoryListingItemsComponent.compareDeep(this.expiry, o.expiry, true) && InventoryReportInventoryListingItemsComponent.compareDeep(this.manufacturingDate, o.manufacturingDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingItemsComponent)) {
                return false;
            }
            InventoryReportInventoryListingItemsComponent o = (InventoryReportInventoryListingItemsComponent)other_;
            return InventoryReportInventoryListingItemsComponent.compareValues(this.lot, o.lot, true) && InventoryReportInventoryListingItemsComponent.compareValues(this.serial, o.serial, true) && InventoryReportInventoryListingItemsComponent.compareValues(this.expiry, o.expiry, true) && InventoryReportInventoryListingItemsComponent.compareValues(this.manufacturingDate, o.manufacturingDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.category, this.quantity, this.item, this.lot, this.serial, this.expiry, this.manufacturingDate);
        }

        @Override
        public String fhirType() {
            return "InventoryReport.inventoryListing.items";
        }
    }

    @Block
    public static class InventoryReportInventoryListingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location of the inventory items", formalDefinition="Location of the inventory items.")
        protected Reference location;
        @Child(name="itemStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the items", formalDefinition="The status of the items.")
        protected CodeableConcept itemStatus;
        @Child(name="countingDateTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date and time when the items were counted", formalDefinition="The date and time when the items were counted.")
        protected DateTimeType countingDateTime;
        @Child(name="items", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The item or items in this listing", formalDefinition="The item or items in this listing.")
        protected List<InventoryReportInventoryListingItemsComponent> items;
        private static final long serialVersionUID = -847152550L;

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public InventoryReportInventoryListingComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public CodeableConcept getItemStatus() {
            if (this.itemStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingComponent.itemStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemStatus = new CodeableConcept();
                }
            }
            return this.itemStatus;
        }

        public boolean hasItemStatus() {
            return this.itemStatus != null && !this.itemStatus.isEmpty();
        }

        public InventoryReportInventoryListingComponent setItemStatus(CodeableConcept value) {
            this.itemStatus = value;
            return this;
        }

        public DateTimeType getCountingDateTimeElement() {
            if (this.countingDateTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingComponent.countingDateTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.countingDateTime = new DateTimeType();
                }
            }
            return this.countingDateTime;
        }

        public boolean hasCountingDateTimeElement() {
            return this.countingDateTime != null && !this.countingDateTime.isEmpty();
        }

        public boolean hasCountingDateTime() {
            return this.countingDateTime != null && !this.countingDateTime.isEmpty();
        }

        public InventoryReportInventoryListingComponent setCountingDateTimeElement(DateTimeType value) {
            this.countingDateTime = value;
            return this;
        }

        public Date getCountingDateTime() {
            return this.countingDateTime == null ? null : (Date)this.countingDateTime.getValue();
        }

        public InventoryReportInventoryListingComponent setCountingDateTime(Date value) {
            if (value == null) {
                this.countingDateTime = null;
            } else {
                if (this.countingDateTime == null) {
                    this.countingDateTime = new DateTimeType();
                }
                this.countingDateTime.setValue(value);
            }
            return this;
        }

        public List<InventoryReportInventoryListingItemsComponent> getItems() {
            if (this.items == null) {
                this.items = new ArrayList<InventoryReportInventoryListingItemsComponent>();
            }
            return this.items;
        }

        public InventoryReportInventoryListingComponent setItems(List<InventoryReportInventoryListingItemsComponent> theItems) {
            this.items = theItems;
            return this;
        }

        public boolean hasItems() {
            if (this.items == null) {
                return false;
            }
            for (InventoryReportInventoryListingItemsComponent item : this.items) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InventoryReportInventoryListingItemsComponent addItems() {
            InventoryReportInventoryListingItemsComponent t = new InventoryReportInventoryListingItemsComponent();
            if (this.items == null) {
                this.items = new ArrayList<InventoryReportInventoryListingItemsComponent>();
            }
            this.items.add(t);
            return t;
        }

        public InventoryReportInventoryListingComponent addItems(InventoryReportInventoryListingItemsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.items == null) {
                this.items = new ArrayList<InventoryReportInventoryListingItemsComponent>();
            }
            this.items.add(t);
            return this;
        }

        public InventoryReportInventoryListingItemsComponent getItemsFirstRep() {
            if (this.getItems().isEmpty()) {
                this.addItems();
            }
            return this.getItems().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("location", "Reference(Location)", "Location of the inventory items.", 0, 1, this.location));
            children.add(new Property("itemStatus", "CodeableConcept", "The status of the items.", 0, 1, this.itemStatus));
            children.add(new Property("countingDateTime", "dateTime", "The date and time when the items were counted.", 0, 1, this.countingDateTime));
            children.add(new Property("items", "", "The item or items in this listing.", 0, Integer.MAX_VALUE, this.items));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "Location of the inventory items.", 0, 1, this.location);
                }
                case 1999789285: {
                    return new Property("itemStatus", "CodeableConcept", "The status of the items.", 0, 1, this.itemStatus);
                }
                case -2075203282: {
                    return new Property("countingDateTime", "dateTime", "The date and time when the items were counted.", 0, 1, this.countingDateTime);
                }
                case 100526016: {
                    return new Property("items", "", "The item or items in this listing.", 0, Integer.MAX_VALUE, this.items);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case 1999789285: {
                    Base[] baseArray;
                    if (this.itemStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.itemStatus;
                    }
                    return baseArray;
                }
                case -2075203282: {
                    Base[] baseArray;
                    if (this.countingDateTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.countingDateTime;
                    }
                    return baseArray;
                }
                case 100526016: {
                    return this.items == null ? new Base[]{} : this.items.toArray(new Base[this.items.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1999789285: {
                    this.itemStatus = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2075203282: {
                    this.countingDateTime = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 100526016: {
                    this.getItems().add((InventoryReportInventoryListingItemsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("location")) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals("itemStatus")) {
                this.itemStatus = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("countingDateTime")) {
                this.countingDateTime = TypeConvertor.castToDateTime(value);
            } else if (name.equals("items")) {
                this.getItems().add((InventoryReportInventoryListingItemsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case 1999789285: {
                    return this.getItemStatus();
                }
                case -2075203282: {
                    return this.getCountingDateTimeElement();
                }
                case 100526016: {
                    return this.addItems();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case 1999789285: {
                    return new String[]{"CodeableConcept"};
                }
                case -2075203282: {
                    return new String[]{"dateTime"};
                }
                case 100526016: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("itemStatus")) {
                this.itemStatus = new CodeableConcept();
                return this.itemStatus;
            }
            if (name.equals("countingDateTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type InventoryReport.inventoryListing.countingDateTime");
            }
            if (name.equals("items")) {
                return this.addItems();
            }
            return super.addChild(name);
        }

        @Override
        public InventoryReportInventoryListingComponent copy() {
            InventoryReportInventoryListingComponent dst = new InventoryReportInventoryListingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryReportInventoryListingComponent dst) {
            super.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.itemStatus = this.itemStatus == null ? null : this.itemStatus.copy();
            DateTimeType dateTimeType = dst.countingDateTime = this.countingDateTime == null ? null : this.countingDateTime.copy();
            if (this.items != null) {
                dst.items = new ArrayList<InventoryReportInventoryListingItemsComponent>();
                for (InventoryReportInventoryListingItemsComponent i2 : this.items) {
                    dst.items.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingComponent)) {
                return false;
            }
            InventoryReportInventoryListingComponent o = (InventoryReportInventoryListingComponent)other_;
            return InventoryReportInventoryListingComponent.compareDeep(this.location, o.location, true) && InventoryReportInventoryListingComponent.compareDeep(this.itemStatus, o.itemStatus, true) && InventoryReportInventoryListingComponent.compareDeep(this.countingDateTime, o.countingDateTime, true) && InventoryReportInventoryListingComponent.compareDeep(this.items, o.items, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingComponent)) {
                return false;
            }
            InventoryReportInventoryListingComponent o = (InventoryReportInventoryListingComponent)other_;
            return InventoryReportInventoryListingComponent.compareValues(this.countingDateTime, o.countingDateTime, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.location, this.itemStatus, this.countingDateTime, this.items);
        }

        @Override
        public String fhirType() {
            return "InventoryReport.inventoryListing";
        }
    }

    public static class InventoryReportStatusEnumFactory
    implements EnumFactory<InventoryReportStatus> {
        @Override
        public InventoryReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return InventoryReportStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return InventoryReportStatus.REQUESTED;
            }
            if ("active".equals(codeString)) {
                return InventoryReportStatus.ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return InventoryReportStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown InventoryReportStatus code '" + codeString + "'");
        }

        public Enumeration<InventoryReportStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InventoryReportStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.DRAFT);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.REQUESTED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.ACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown InventoryReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(InventoryReportStatus code) {
            if (code == InventoryReportStatus.DRAFT) {
                return "draft";
            }
            if (code == InventoryReportStatus.REQUESTED) {
                return "requested";
            }
            if (code == InventoryReportStatus.ACTIVE) {
                return "active";
            }
            if (code == InventoryReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(InventoryReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum InventoryReportStatus {
        DRAFT,
        REQUESTED,
        ACTIVE,
        ENTEREDINERROR,
        NULL;


        public static InventoryReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InventoryReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case ACTIVE: {
                    return "active";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The existence of the report is registered, but it is still without content or only some preliminary content.";
                }
                case REQUESTED: {
                    return "The inventory report has been requested but there is no data available.";
                }
                case ACTIVE: {
                    return "This report is submitted as current.";
                }
                case ENTEREDINERROR: {
                    return "The report has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }

    public static class InventoryCountTypeEnumFactory
    implements EnumFactory<InventoryCountType> {
        @Override
        public InventoryCountType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("snapshot".equals(codeString)) {
                return InventoryCountType.SNAPSHOT;
            }
            if ("difference".equals(codeString)) {
                return InventoryCountType.DIFFERENCE;
            }
            throw new IllegalArgumentException("Unknown InventoryCountType code '" + codeString + "'");
        }

        public Enumeration<InventoryCountType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InventoryCountType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("snapshot".equals(codeString)) {
                return new Enumeration<InventoryCountType>(this, InventoryCountType.SNAPSHOT);
            }
            if ("difference".equals(codeString)) {
                return new Enumeration<InventoryCountType>(this, InventoryCountType.DIFFERENCE);
            }
            throw new FHIRException("Unknown InventoryCountType code '" + codeString + "'");
        }

        @Override
        public String toCode(InventoryCountType code) {
            if (code == InventoryCountType.SNAPSHOT) {
                return "snapshot";
            }
            if (code == InventoryCountType.DIFFERENCE) {
                return "difference";
            }
            return "?";
        }

        @Override
        public String toSystem(InventoryCountType code) {
            return code.getSystem();
        }
    }

    public static enum InventoryCountType {
        SNAPSHOT,
        DIFFERENCE,
        NULL;


        public static InventoryCountType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("snapshot".equals(codeString)) {
                return SNAPSHOT;
            }
            if ("difference".equals(codeString)) {
                return DIFFERENCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InventoryCountType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SNAPSHOT: {
                    return "snapshot";
                }
                case DIFFERENCE: {
                    return "difference";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SNAPSHOT: {
                    return "http://hl7.org/fhir/inventoryreport-counttype";
                }
                case DIFFERENCE: {
                    return "http://hl7.org/fhir/inventoryreport-counttype";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SNAPSHOT: {
                    return "The inventory report is a current absolute snapshot, i.e. it represents the quantities at hand.";
                }
                case DIFFERENCE: {
                    return "The inventory report is about the difference between a previous count and a current count, i.e. it represents the items that have been added/subtracted from inventory.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SNAPSHOT: {
                    return "Snapshot";
                }
                case DIFFERENCE: {
                    return "Difference";
                }
            }
            return "?";
        }
    }
}

