/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="DeviceRequest", profile="http://hl7.org/fhir/StructureDefinition/DeviceRequest")
public class DeviceRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Request identifier", formalDefinition="Identifiers assigned to this order by the orderer or by the receiver.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What request fulfills", formalDefinition="Plan/proposal/order fulfilled by this request.")
    protected List<Reference> basedOn;
    @Child(name="priorRequest", type={DeviceRequest.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What request replaces", formalDefinition="The request takes the place of the referenced completed or terminated request(s).")
    protected List<Reference> priorRequest;
    @Child(name="groupIdentifier", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier of composite request", formalDefinition="Composite request this is part of.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown", formalDefinition="The status of the request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<Enumerations.RequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Whether the request is a proposal, plan, an original order or a reflex order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<Enumerations.RequestIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the request should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<Enumerations.RequestPriority> priority;
    @Child(name="doNotPerform", type={BooleanType.class}, order=9, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if the request is to stop or not to start using the device", formalDefinition="If true, indicates that the provider is asking for the patient to either stop using or to not start using the specified device or category of devices. For example, the patient has undergone surgery and the provider is indicating that the patient should not wear contact lenses.")
    protected BooleanType doNotPerform;
    @Child(name="code", type={CodeableReference.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Device requested", formalDefinition="The details of the device to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
    protected CodeableReference code;
    @Child(name="quantity", type={IntegerType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Quantity of devices to supply", formalDefinition="The number of devices to be provided.")
    protected IntegerType quantity;
    @Child(name="parameter", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device details", formalDefinition="Specific parameters for the ordered item.  For example, the prism value for lenses.")
    protected List<DeviceRequestParameterComponent> parameter;
    @Child(name="subject", type={Patient.class, Group.class, Location.class, Device.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Focus of request", formalDefinition="The patient who will use the device.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter motivating request", formalDefinition="An encounter that provides additional context in which this request is made.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Desired time or schedule for use", formalDefinition="The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
    protected DataType occurrence;
    @Child(name="authoredOn", type={DateTimeType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When recorded", formalDefinition="When the request transitioned to being actionable.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={Device.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what submitted the device request", formalDefinition="The individual or entity who initiated the request and has responsibility for its activation.")
    protected Reference requester;
    @Child(name="performerType", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Filler role", formalDefinition="The desired kind of individual or entity to provide the device to the subject of the request (e.g., patient, location).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/participant-role")
    protected CodeableConcept performerType;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, HealthcareService.class, Patient.class, Device.class, RelatedPerson.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requested Filler", formalDefinition="The desired individual or entity to provide the device to the subject of the request (e.g., patient, location).")
    protected Reference performer;
    @Child(name="reason", type={CodeableReference.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Coded/Linked Reason for request", formalDefinition="Reason or justification for the use of this device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableReference> reason;
    @Child(name="insurance", type={Coverage.class, ClaimResponse.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated insurance coverage", formalDefinition="Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.")
    protected List<Reference> insurance;
    @Child(name="supportingInfo", type={Reference.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional clinical information", formalDefinition="Additional clinical information about the patient that may influence the request fulfilment.  For example, this may include where on the subject's body the device will be used (i.e. the target site).")
    protected List<Reference> supportingInfo;
    @Child(name="note", type={Annotation.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Notes or comments", formalDefinition="Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    protected List<Annotation> note;
    @Child(name="relevantHistory", type={Provenance.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request provenance", formalDefinition="Key events in the history of the request.")
    protected List<Reference> relevantHistory;
    private static final long serialVersionUID = 97830140L;
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceRequest:patient").toLocked();
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DeviceRequest:encounter").toLocked();
    @SearchParamDefinition(name="authored-on", path="DeviceRequest.authoredOn", description="When the request transitioned to being actionable", type="date")
    public static final String SP_AUTHORED_ON = "authored-on";
    public static final DateClientParam AUTHORED_ON = new DateClientParam("authored-on");
    @SearchParamDefinition(name="based-on", path="DeviceRequest.basedOn", description="Plan/proposal/order fulfilled by this request", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("DeviceRequest:based-on").toLocked();
    @SearchParamDefinition(name="device", path="DeviceRequest.code.reference", description="Reference to resource that is being requested/ordered", type="reference")
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("DeviceRequest:device").toLocked();
    @SearchParamDefinition(name="event-date", path="(DeviceRequest.occurrence as dateTime) | (DeviceRequest.occurrence as Period)", description="When service should occur", type="date")
    public static final String SP_EVENT_DATE = "event-date";
    public static final DateClientParam EVENT_DATE = new DateClientParam("event-date");
    @SearchParamDefinition(name="group-identifier", path="DeviceRequest.groupIdentifier", description="Composite request this is part of", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="instantiates-canonical", path="DeviceRequest.instantiatesCanonical", description="Instantiates FHIR protocol or definition", type="reference", target={ActivityDefinition.class, PlanDefinition.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("DeviceRequest:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="DeviceRequest.instantiatesUri", description="Instantiates external protocol or definition", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="insurance", path="DeviceRequest.insurance", description="Associated insurance coverage", type="reference", target={ClaimResponse.class, Coverage.class})
    public static final String SP_INSURANCE = "insurance";
    public static final ReferenceClientParam INSURANCE = new ReferenceClientParam("insurance");
    public static final Include INCLUDE_INSURANCE = new Include("DeviceRequest:insurance").toLocked();
    @SearchParamDefinition(name="intent", path="DeviceRequest.intent", description="proposal | plan | original-order |reflex-order", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="performer", path="DeviceRequest.performer", description="Desired performer for service", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={CareTeam.class, Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("DeviceRequest:performer").toLocked();
    @SearchParamDefinition(name="prior-request", path="DeviceRequest.priorRequest", description="Request takes the place of referenced completed or terminated requests", type="reference", target={DeviceRequest.class})
    public static final String SP_PRIOR_REQUEST = "prior-request";
    public static final ReferenceClientParam PRIOR_REQUEST = new ReferenceClientParam("prior-request");
    public static final Include INCLUDE_PRIOR_REQUEST = new Include("DeviceRequest:prior-request").toLocked();
    @SearchParamDefinition(name="requester", path="DeviceRequest.requester", description="Who/what is requesting service", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("DeviceRequest:requester").toLocked();
    @SearchParamDefinition(name="status", path="DeviceRequest.status", description="entered-in-error | draft | active |suspended | completed", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DeviceRequest.subject", description="Individual the service is ordered for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={Device.class, Group.class, Location.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceRequest:subject").toLocked();

    public DeviceRequest() {
    }

    public DeviceRequest(Enumerations.RequestIntent intent, CodeableReference code, Reference subject) {
        this.setIntent(intent);
        this.setCode(code);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public DeviceRequest setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public DeviceRequest addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public DeviceRequest setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public DeviceRequest addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DeviceRequest setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DeviceRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPriorRequest() {
        if (this.priorRequest == null) {
            this.priorRequest = new ArrayList<Reference>();
        }
        return this.priorRequest;
    }

    public DeviceRequest setPriorRequest(List<Reference> thePriorRequest) {
        this.priorRequest = thePriorRequest;
        return this;
    }

    public boolean hasPriorRequest() {
        if (this.priorRequest == null) {
            return false;
        }
        for (Reference item : this.priorRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPriorRequest() {
        Reference t = new Reference();
        if (this.priorRequest == null) {
            this.priorRequest = new ArrayList<Reference>();
        }
        this.priorRequest.add(t);
        return t;
    }

    public DeviceRequest addPriorRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.priorRequest == null) {
            this.priorRequest = new ArrayList<Reference>();
        }
        this.priorRequest.add(t);
        return this;
    }

    public Reference getPriorRequestFirstRep() {
        if (this.getPriorRequest().isEmpty()) {
            this.addPriorRequest();
        }
        return this.getPriorRequest().get(0);
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public DeviceRequest setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<Enumerations.RequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceRequest setStatusElement(Enumeration<Enumerations.RequestStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.RequestStatus getStatus() {
        return this.status == null ? null : (Enumerations.RequestStatus)((Object)this.status.getValue());
    }

    public DeviceRequest setStatus(Enumerations.RequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<Enumerations.RequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public DeviceRequest setIntentElement(Enumeration<Enumerations.RequestIntent> value) {
        this.intent = value;
        return this;
    }

    public Enumerations.RequestIntent getIntent() {
        return this.intent == null ? null : (Enumerations.RequestIntent)((Object)this.intent.getValue());
    }

    public DeviceRequest setIntent(Enumerations.RequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public DeviceRequest setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public Enumerations.RequestPriority getPriority() {
        return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
    }

    public DeviceRequest setPriority(Enumerations.RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getDoNotPerformElement() {
        if (this.doNotPerform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.doNotPerform");
            }
            if (Configuration.doAutoCreate()) {
                this.doNotPerform = new BooleanType();
            }
        }
        return this.doNotPerform;
    }

    public boolean hasDoNotPerformElement() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public boolean hasDoNotPerform() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public DeviceRequest setDoNotPerformElement(BooleanType value) {
        this.doNotPerform = value;
        return this;
    }

    public boolean getDoNotPerform() {
        return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
    }

    public DeviceRequest setDoNotPerform(boolean value) {
        if (this.doNotPerform == null) {
            this.doNotPerform = new BooleanType();
        }
        this.doNotPerform.setValue((Object)value);
        return this;
    }

    public CodeableReference getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableReference();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DeviceRequest setCode(CodeableReference value) {
        this.code = value;
        return this;
    }

    public IntegerType getQuantityElement() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new IntegerType();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantityElement() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public DeviceRequest setQuantityElement(IntegerType value) {
        this.quantity = value;
        return this;
    }

    public int getQuantity() {
        return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
    }

    public DeviceRequest setQuantity(int value) {
        if (this.quantity == null) {
            this.quantity = new IntegerType();
        }
        this.quantity.setValue((Object)value);
        return this;
    }

    public List<DeviceRequestParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<DeviceRequestParameterComponent>();
        }
        return this.parameter;
    }

    public DeviceRequest setParameter(List<DeviceRequestParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (DeviceRequestParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceRequestParameterComponent addParameter() {
        DeviceRequestParameterComponent t = new DeviceRequestParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<DeviceRequestParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public DeviceRequest addParameter(DeviceRequestParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<DeviceRequestParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public DeviceRequestParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DeviceRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Timing();
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public DeviceRequest setOccurrence(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new Error("Not the right type for DeviceRequest.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public DeviceRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public DeviceRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public DeviceRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public CodeableConcept getPerformerType() {
        if (this.performerType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.performerType");
            }
            if (Configuration.doAutoCreate()) {
                this.performerType = new CodeableConcept();
            }
        }
        return this.performerType;
    }

    public boolean hasPerformerType() {
        return this.performerType != null && !this.performerType.isEmpty();
    }

    public DeviceRequest setPerformerType(CodeableConcept value) {
        this.performerType = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceRequest.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public DeviceRequest setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public DeviceRequest setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public DeviceRequest addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        return this.insurance;
    }

    public DeviceRequest setInsurance(List<Reference> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (Reference item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInsurance() {
        Reference t = new Reference();
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return t;
    }

    public DeviceRequest addInsurance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<Reference>();
        }
        this.insurance.add(t);
        return this;
    }

    public Reference getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public DeviceRequest setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public DeviceRequest addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceRequest setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceRequest addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public DeviceRequest setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public DeviceRequest addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the orderer or by the receiver.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(ActivityDefinition|PlanDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(Any)", "Plan/proposal/order fulfilled by this request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("priorRequest", "Reference(DeviceRequest)", "The request takes the place of the referenced completed or terminated request(s).", 0, Integer.MAX_VALUE, this.priorRequest));
        children.add(new Property("groupIdentifier", "Identifier", "Composite request this is part of.", 0, 1, this.groupIdentifier));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of the request.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, an original order or a reflex order.", 0, 1, this.intent));
        children.add(new Property("priority", SP_CODE, "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("doNotPerform", "boolean", "If true, indicates that the provider is asking for the patient to either stop using or to not start using the specified device or category of devices. For example, the patient has undergone surgery and the provider is indicating that the patient should not wear contact lenses.", 0, 1, this.doNotPerform));
        children.add(new Property(SP_CODE, "CodeableReference(Device|DeviceDefinition)", "The details of the device to be used.", 0, 1, this.code));
        children.add(new Property("quantity", "integer", "The number of devices to be provided.", 0, 1, this.quantity));
        children.add(new Property("parameter", "", "Specific parameters for the ordered item.  For example, the prism value for lenses.", 0, Integer.MAX_VALUE, this.parameter));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Location|Device)", "The patient who will use the device.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "An encounter that provides additional context in which this request is made.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, 1, this.occurrence));
        children.add(new Property("authoredOn", "dateTime", "When the request transitioned to being actionable.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "Reference(Device|Practitioner|PractitionerRole|Organization)", "The individual or entity who initiated the request and has responsibility for its activation.", 0, 1, this.requester));
        children.add(new Property("performerType", "CodeableConcept", "The desired kind of individual or entity to provide the device to the subject of the request (e.g., patient, location).", 0, 1, this.performerType));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "The desired individual or entity to provide the device to the subject of the request (e.g., patient, location).", 0, 1, this.performer));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Reason or justification for the use of this device.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property(SP_INSURANCE, "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("supportingInfo", "Reference(Any)", "Additional clinical information about the patient that may influence the request fulfilment.  For example, this may include where on the subject's body the device will be used (i.e. the target site).", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("note", "Annotation", "Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relevantHistory", "Reference(Provenance)", "Key events in the history of the request.", 0, Integer.MAX_VALUE, this.relevantHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the orderer or by the receiver.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(ActivityDefinition|PlanDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "Plan/proposal/order fulfilled by this request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case 237568101: {
                return new Property("priorRequest", "Reference(DeviceRequest)", "The request takes the place of the referenced completed or terminated request(s).", 0, Integer.MAX_VALUE, this.priorRequest);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "Composite request this is part of.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of the request.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, an original order or a reflex order.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property("priority", SP_CODE, "Indicates how quickly the request should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case -1788508167: {
                return new Property("doNotPerform", "boolean", "If true, indicates that the provider is asking for the patient to either stop using or to not start using the specified device or category of devices. For example, the patient has undergone surgery and the provider is indicating that the patient should not wear contact lenses.", 0, 1, this.doNotPerform);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableReference(Device|DeviceDefinition)", "The details of the device to be used.", 0, 1, this.code);
            }
            case -1285004149: {
                return new Property("quantity", "integer", "The number of devices to be provided.", 0, 1, this.quantity);
            }
            case 1954460585: {
                return new Property("parameter", "", "Specific parameters for the ordered item.  For example, the prism value for lenses.", 0, Integer.MAX_VALUE, this.parameter);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Location|Device)", "The patient who will use the device.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "An encounter that provides additional context in which this request is made.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "Timing", "The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, 1, this.occurrence);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "When the request transitioned to being actionable.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "Reference(Device|Practitioner|PractitionerRole|Organization)", "The individual or entity who initiated the request and has responsibility for its activation.", 0, 1, this.requester);
            }
            case -901444568: {
                return new Property("performerType", "CodeableConcept", "The desired kind of individual or entity to provide the device to the subject of the request (e.g., patient, location).", 0, 1, this.performerType);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|HealthcareService|Patient|Device|RelatedPerson)", "The desired individual or entity to provide the device to the subject of the request (e.g., patient, location).", 0, 1, this.performer);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Reason or justification for the use of this device.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 73049818: {
                return new Property(SP_INSURANCE, "Reference(Coverage|ClaimResponse)", "Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Additional clinical information about the patient that may influence the request fulfilment.  For example, this may include where on the subject's body the device will be used (i.e. the target site).", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1538891575: {
                return new Property("relevantHistory", "Reference(Provenance)", "Key events in the history of the request.", 0, Integer.MAX_VALUE, this.relevantHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case 237568101: {
                return this.priorRequest == null ? new Base[]{} : this.priorRequest.toArray(new Base[this.priorRequest.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1788508167: {
                Base[] baseArray;
                if (this.doNotPerform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.doNotPerform;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.code;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.quantity;
                }
                return baseArray;
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.requester;
                }
                return baseArray;
            }
            case -901444568: {
                Base[] baseArray;
                if (this.performerType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.performerType;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.performer;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 237568101: {
                this.getPriorRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new Enumerations.RequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1788508167: {
                this.doNotPerform = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToInteger(value);
                return value;
            }
            case 1954460585: {
                this.getParameter().add((DeviceRequestParameterComponent)((Object)value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = TypeConvertor.castToReference(value);
                return value;
            }
            case -901444568: {
                this.performerType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 481140686: {
                this.performer = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("priorRequest")) {
            this.getPriorRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new Enumerations.RequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals("priority")) {
            value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.priority = value;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToInteger(value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((DeviceRequestParameterComponent)((Object)value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = TypeConvertor.castToReference(value);
        } else if (name.equals("performerType")) {
            this.performerType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_INSURANCE)) {
            this.getInsurance().add(TypeConvertor.castToReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case 237568101: {
                return this.addPriorRequest();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1788508167: {
                return this.getDoNotPerformElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1285004149: {
                return this.getQuantityElement();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -901444568: {
                return this.getPerformerType();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -934964668: {
                return this.addReason();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case 237568101: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case -1788508167: {
                return new String[]{"boolean"};
            }
            case 3059181: {
                return new String[]{"CodeableReference"};
            }
            case -1285004149: {
                return new String[]{"integer"};
            }
            case 1954460585: {
                return new String[0];
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[]{"Reference"};
            }
            case -901444568: {
                return new String[]{"CodeableConcept"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 73049818: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("priorRequest")) {
            return this.addPriorRequest();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.intent");
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.priority");
        }
        if (name.equals("doNotPerform")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.doNotPerform");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableReference();
            return this.code;
        }
        if (name.equals("quantity")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.quantity");
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals("performerType")) {
            this.performerType = new CodeableConcept();
            return this.performerType;
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals(SP_INSURANCE)) {
            return this.addInsurance();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceRequest";
    }

    @Override
    public DeviceRequest copy() {
        DeviceRequest dst = new DeviceRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceRequest dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.priorRequest != null) {
            dst.priorRequest = new ArrayList<Reference>();
            for (Reference reference : this.priorRequest) {
                dst.priorRequest.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
        dst.code = this.code == null ? null : this.code.copy();
        IntegerType integerType = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.parameter != null) {
            dst.parameter = new ArrayList<DeviceRequestParameterComponent>();
            for (DeviceRequestParameterComponent deviceRequestParameterComponent : this.parameter) {
                dst.parameter.add(deviceRequestParameterComponent.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        dst.performerType = this.performerType == null ? null : this.performerType.copy();
        Reference reference = dst.performer = this.performer == null ? null : this.performer.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<Reference>();
            for (Reference reference2 : this.insurance) {
                dst.insurance.add(reference2.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference3 : this.supportingInfo) {
                dst.supportingInfo.add(reference3.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference4 : this.relevantHistory) {
                dst.relevantHistory.add(reference4.copy());
            }
        }
    }

    protected DeviceRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceRequest)) {
            return false;
        }
        DeviceRequest o = (DeviceRequest)other_;
        return DeviceRequest.compareDeep(this.identifier, o.identifier, true) && DeviceRequest.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && DeviceRequest.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && DeviceRequest.compareDeep(this.basedOn, o.basedOn, true) && DeviceRequest.compareDeep(this.priorRequest, o.priorRequest, true) && DeviceRequest.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && DeviceRequest.compareDeep(this.status, o.status, true) && DeviceRequest.compareDeep(this.intent, o.intent, true) && DeviceRequest.compareDeep(this.priority, o.priority, true) && DeviceRequest.compareDeep(this.doNotPerform, o.doNotPerform, true) && DeviceRequest.compareDeep(this.code, o.code, true) && DeviceRequest.compareDeep(this.quantity, o.quantity, true) && DeviceRequest.compareDeep(this.parameter, o.parameter, true) && DeviceRequest.compareDeep(this.subject, o.subject, true) && DeviceRequest.compareDeep(this.encounter, o.encounter, true) && DeviceRequest.compareDeep(this.occurrence, o.occurrence, true) && DeviceRequest.compareDeep(this.authoredOn, o.authoredOn, true) && DeviceRequest.compareDeep(this.requester, o.requester, true) && DeviceRequest.compareDeep(this.performerType, o.performerType, true) && DeviceRequest.compareDeep(this.performer, o.performer, true) && DeviceRequest.compareDeep(this.reason, o.reason, true) && DeviceRequest.compareDeep(this.insurance, o.insurance, true) && DeviceRequest.compareDeep(this.supportingInfo, o.supportingInfo, true) && DeviceRequest.compareDeep(this.note, o.note, true) && DeviceRequest.compareDeep(this.relevantHistory, o.relevantHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceRequest)) {
            return false;
        }
        DeviceRequest o = (DeviceRequest)other_;
        return DeviceRequest.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && DeviceRequest.compareValues(this.instantiatesUri, o.instantiatesUri, true) && DeviceRequest.compareValues(this.status, o.status, true) && DeviceRequest.compareValues(this.intent, o.intent, true) && DeviceRequest.compareValues(this.priority, o.priority, true) && DeviceRequest.compareValues(this.doNotPerform, o.doNotPerform, true) && DeviceRequest.compareValues(this.quantity, o.quantity, true) && DeviceRequest.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.priorRequest, this.groupIdentifier, this.status, this.intent, this.priority, this.doNotPerform, this.code, this.quantity, this.parameter, this.subject, this.encounter, this.occurrence, this.authoredOn, this.requester, this.performerType, this.performer, this.reason, this.insurance, this.supportingInfo, this.note, this.relevantHistory);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceRequest;
    }

    @Block
    public static class DeviceRequestParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device detail", formalDefinition="A code or string that identifies the device detail being asserted.")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, Range.class, BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of detail", formalDefinition="The value of the device detail.")
        protected DataType value;
        private static final long serialVersionUID = -1950789033L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceRequestParameterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DeviceRequestParameterComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DeviceRequestParameterComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof Range || value instanceof BooleanType)) {
                throw new Error("Not the right type for DeviceRequest.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceRequest.SP_CODE, "CodeableConcept", "A code or string that identifies the device detail being asserted.", 0, 1, this.code));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(DeviceRequest.SP_CODE, "CodeableConcept", "A code or string that identifies the device detail being asserted.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the device detail.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the device detail.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the device detail.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the device detail.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceRequest.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "Range", "boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceRequest.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceRequestParameterComponent copy() {
            DeviceRequestParameterComponent dst = new DeviceRequestParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceRequestParameterComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceRequestParameterComponent)) {
                return false;
            }
            DeviceRequestParameterComponent o = (DeviceRequestParameterComponent)other_;
            return DeviceRequestParameterComponent.compareDeep(this.code, o.code, true) && DeviceRequestParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceRequestParameterComponent)) {
                return false;
            }
            DeviceRequestParameterComponent o = (DeviceRequestParameterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.value);
        }

        @Override
        public String fhirType() {
            return "DeviceRequest.parameter";
        }
    }
}

