/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Citation", profile="http://hl7.org/fhir/StructureDefinition/Citation")
public class Citation
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this citation, represented as a globally unique URI", formalDefinition="An absolute URI that is used to identify this citation when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for the Citation resource itself", formalDefinition="A formal identifier that is used to identify this citation when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the citation", formalDefinition="The identifier that is used to identify this version of the citation when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the citation author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this citation (computer friendly)", formalDefinition="A natural language name identifying the citation. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this citation (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the citation.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this summary. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this citation is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the citation was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the citation changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The publisher of the Citation, not the publisher of the article or artifact being cited", formalDefinition="The name of the organization or individual that published the citation.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher of the Citation Resource", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the citation", formalDefinition="A free text natural language description of the citation from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the Citation Resource content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for citation (if applicable)", formalDefinition="A legal or geographic region in which the citation is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this citation is defined", formalDefinition="Explanation of why this citation is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions for the Citation, not for the cited artifact", formalDefinition="Use and/or publishing restrictions for the Citation, not for the cited artifact.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the citation was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the citation was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the citation is expected to be used", formalDefinition="The period during which the citation content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="author", type={ContactDetail.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the Citation", formalDefinition="Who authored the Citation.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the Citation", formalDefinition="Who edited the Citation.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the Citation", formalDefinition="Who reviewed the Citation.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the Citation", formalDefinition="Who endorsed the Citation.")
    protected List<ContactDetail> endorser;
    @Child(name="summary", type={ContactDetail.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A human-readable display of the citation", formalDefinition="A human-readable display of the citation.")
    protected List<ContactDetail> summary;
    @Child(name="classification", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The assignment to an organizing scheme", formalDefinition="The assignment to an organizing scheme.")
    protected List<CitationClassificationComponent> classification;
    @Child(name="note", type={Annotation.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for general notes and annotations not coded elsewhere", formalDefinition="Used for general notes and annotations not coded elsewhere.")
    protected List<Annotation> note;
    @Child(name="currentState", type={CodeableConcept.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The status of the citation", formalDefinition="The status of the citation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-status-type")
    protected List<CodeableConcept> currentState;
    @Child(name="statusDate", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An effective date or period for a status of the citation", formalDefinition="An effective date or period for a status of the citation.")
    protected List<CitationStatusDateComponent> statusDate;
    @Child(name="relatesTo", type={}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Artifact related to the Citation Resource", formalDefinition="Artifact related to the Citation Resource.")
    protected List<CitationRelatesToComponent> relatesTo;
    @Child(name="citedArtifact", type={}, order=28, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The article or artifact being described", formalDefinition="The article or artifact being described.")
    protected CitationCitedArtifactComponent citedArtifact;
    private static final long serialVersionUID = 2083863417L;
    @SearchParamDefinition(name="context", path="(Citation.useContext.value as CodeableConcept)", description="A use context assigned to the citation", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="context-quantity", path="(Citation.useContext.value as Quantity) | (Citation.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the citation", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type", path="Citation.useContext.code", description="A type of use context assigned to the citation", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="date", path="Citation.date", description="The citation publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="Citation.description", description="The description of the citation", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="effective", path="Citation.effectivePeriod", description="The time during which the citation is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="identifier", path="Citation.identifier", description="External identifier for the citation", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="Citation.jurisdiction", description="Intended jurisdiction for the citation", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="Citation.name", description="Computationally friendly name of the citation", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="Citation.publisher", description="Name of the publisher of the citation", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="Citation.status", description="The current status of the citation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="Citation.title", description="The human-friendly name of the citation", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="Citation.url", description="The uri that identifies the citation", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Citation.version", description="The business version of the citation", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="context-type-quantity", path="Citation.useContext", description="A use context type and quantity- or range-based value assigned to the citation", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="Citation.useContext", description="A use context type and value assigned to the citation", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");

    public Citation() {
    }

    public Citation(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Citation setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Citation setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public Citation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public Citation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Citation setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Citation setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public Citation setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public Citation setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Citation setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Citation setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Citation setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Citation setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public Citation setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public Citation setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Citation setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Citation setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public Citation setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public Citation setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public Citation setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public Citation addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Citation setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Citation setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public Citation setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Citation addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public Citation setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public Citation addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public Citation setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public Citation setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public Citation setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public Citation setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public Citation setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public Citation setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public Citation setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public Citation setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public Citation setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public Citation setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public Citation addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public Citation setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public Citation addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public Citation setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public Citation addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public Citation setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public Citation addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<ContactDetail> getSummary() {
        if (this.summary == null) {
            this.summary = new ArrayList<ContactDetail>();
        }
        return this.summary;
    }

    public Citation setSummary(List<ContactDetail> theSummary) {
        this.summary = theSummary;
        return this;
    }

    public boolean hasSummary() {
        if (this.summary == null) {
            return false;
        }
        for (ContactDetail item : this.summary) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addSummary() {
        ContactDetail t = new ContactDetail();
        if (this.summary == null) {
            this.summary = new ArrayList<ContactDetail>();
        }
        this.summary.add(t);
        return t;
    }

    public Citation addSummary(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.summary == null) {
            this.summary = new ArrayList<ContactDetail>();
        }
        this.summary.add(t);
        return this;
    }

    public ContactDetail getSummaryFirstRep() {
        if (this.getSummary().isEmpty()) {
            this.addSummary();
        }
        return this.getSummary().get(0);
    }

    public List<CitationClassificationComponent> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<CitationClassificationComponent>();
        }
        return this.classification;
    }

    public Citation setClassification(List<CitationClassificationComponent> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (CitationClassificationComponent item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationClassificationComponent addClassification() {
        CitationClassificationComponent t = new CitationClassificationComponent();
        if (this.classification == null) {
            this.classification = new ArrayList<CitationClassificationComponent>();
        }
        this.classification.add(t);
        return t;
    }

    public Citation addClassification(CitationClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<CitationClassificationComponent>();
        }
        this.classification.add(t);
        return this;
    }

    public CitationClassificationComponent getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Citation setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Citation addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableConcept> getCurrentState() {
        if (this.currentState == null) {
            this.currentState = new ArrayList<CodeableConcept>();
        }
        return this.currentState;
    }

    public Citation setCurrentState(List<CodeableConcept> theCurrentState) {
        this.currentState = theCurrentState;
        return this;
    }

    public boolean hasCurrentState() {
        if (this.currentState == null) {
            return false;
        }
        for (CodeableConcept item : this.currentState) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCurrentState() {
        CodeableConcept t = new CodeableConcept();
        if (this.currentState == null) {
            this.currentState = new ArrayList<CodeableConcept>();
        }
        this.currentState.add(t);
        return t;
    }

    public Citation addCurrentState(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.currentState == null) {
            this.currentState = new ArrayList<CodeableConcept>();
        }
        this.currentState.add(t);
        return this;
    }

    public CodeableConcept getCurrentStateFirstRep() {
        if (this.getCurrentState().isEmpty()) {
            this.addCurrentState();
        }
        return this.getCurrentState().get(0);
    }

    public List<CitationStatusDateComponent> getStatusDate() {
        if (this.statusDate == null) {
            this.statusDate = new ArrayList<CitationStatusDateComponent>();
        }
        return this.statusDate;
    }

    public Citation setStatusDate(List<CitationStatusDateComponent> theStatusDate) {
        this.statusDate = theStatusDate;
        return this;
    }

    public boolean hasStatusDate() {
        if (this.statusDate == null) {
            return false;
        }
        for (CitationStatusDateComponent item : this.statusDate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationStatusDateComponent addStatusDate() {
        CitationStatusDateComponent t = new CitationStatusDateComponent();
        if (this.statusDate == null) {
            this.statusDate = new ArrayList<CitationStatusDateComponent>();
        }
        this.statusDate.add(t);
        return t;
    }

    public Citation addStatusDate(CitationStatusDateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusDate == null) {
            this.statusDate = new ArrayList<CitationStatusDateComponent>();
        }
        this.statusDate.add(t);
        return this;
    }

    public CitationStatusDateComponent getStatusDateFirstRep() {
        if (this.getStatusDate().isEmpty()) {
            this.addStatusDate();
        }
        return this.getStatusDate().get(0);
    }

    public List<CitationRelatesToComponent> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<CitationRelatesToComponent>();
        }
        return this.relatesTo;
    }

    public Citation setRelatesTo(List<CitationRelatesToComponent> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (CitationRelatesToComponent item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationRelatesToComponent addRelatesTo() {
        CitationRelatesToComponent t = new CitationRelatesToComponent();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<CitationRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public Citation addRelatesTo(CitationRelatesToComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<CitationRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public CitationRelatesToComponent getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public CitationCitedArtifactComponent getCitedArtifact() {
        if (this.citedArtifact == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.citedArtifact");
            }
            if (Configuration.doAutoCreate()) {
                this.citedArtifact = new CitationCitedArtifactComponent();
            }
        }
        return this.citedArtifact;
    }

    public boolean hasCitedArtifact() {
        return this.citedArtifact != null && !this.citedArtifact.isEmpty();
    }

    public Citation setCitedArtifact(CitationCitedArtifactComponent value) {
        this.citedArtifact = value;
        return this;
    }

    @Override
    public int getTopicMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public Citation setTopic(List<CodeableConcept> theTopic) {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public boolean hasTopic() {
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public Citation addTopic(CodeableConcept t) {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public int getRelatedArtifactMax() {
        return 0;
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        return new ArrayList<RelatedArtifact>();
    }

    @Override
    public Citation setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        throw new Error("The resource type \"Citation\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public boolean hasRelatedArtifact() {
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        throw new Error("The resource type \"Citation\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public Citation addRelatedArtifact(RelatedArtifact t) {
        throw new Error("The resource type \"Citation\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        throw new Error("The resource type \"Citation\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this citation when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this citation when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the citation when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the citation author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the citation. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the citation.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this citation is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the citation was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the citation changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the citation.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the citation from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the citation is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this citation is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "Use and/or publishing restrictions for the Citation, not for the cited artifact.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the citation content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("author", "ContactDetail", "Who authored the Citation.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "Who edited the Citation.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "Who reviewed the Citation.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "Who endorsed the Citation.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("summary", "ContactDetail", "A human-readable display of the citation.", 0, Integer.MAX_VALUE, this.summary));
        children.add(new Property("classification", "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("currentState", "CodeableConcept", "The status of the citation.", 0, Integer.MAX_VALUE, this.currentState));
        children.add(new Property("statusDate", "", "An effective date or period for a status of the citation.", 0, Integer.MAX_VALUE, this.statusDate));
        children.add(new Property("relatesTo", "", "Artifact related to the Citation Resource.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property("citedArtifact", "", "The article or artifact being described.", 0, 1, this.citedArtifact));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this citation when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this citation when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the citation when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the citation author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the citation. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the citation.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this citation is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the citation was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the citation changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the citation.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the citation from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the citation is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this citation is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "Use and/or publishing restrictions for the Citation, not for the cited artifact.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the citation content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "Who authored the Citation.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "Who edited the Citation.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "Who reviewed the Citation.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "Who endorsed the Citation.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case -1857640538: {
                return new Property("summary", "ContactDetail", "A human-readable display of the citation.", 0, Integer.MAX_VALUE, this.summary);
            }
            case 382350310: {
                return new Property("classification", "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1457822360: {
                return new Property("currentState", "CodeableConcept", "The status of the citation.", 0, Integer.MAX_VALUE, this.currentState);
            }
            case 247524032: {
                return new Property("statusDate", "", "An effective date or period for a status of the citation.", 0, Integer.MAX_VALUE, this.statusDate);
            }
            case -7765931: {
                return new Property("relatesTo", "", "Artifact related to the Citation Resource.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case -495272225: {
                return new Property("citedArtifact", "", "The article or artifact being described.", 0, 1, this.citedArtifact);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case -1857640538: {
                return this.summary == null ? new Base[]{} : this.summary.toArray(new Base[this.summary.size()]);
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1457822360: {
                return this.currentState == null ? new Base[]{} : this.currentState.toArray(new Base[this.currentState.size()]);
            }
            case 247524032: {
                return this.statusDate == null ? new Base[]{} : this.statusDate.toArray(new Base[this.statusDate.size()]);
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case -495272225: {
                Base[] baseArray;
                if (this.citedArtifact == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.citedArtifact;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1857640538: {
                this.getSummary().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 382350310: {
                this.getClassification().add((CitationClassificationComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1457822360: {
                this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 247524032: {
                this.getStatusDate().add((CitationStatusDateComponent)((Object)value));
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add((CitationRelatesToComponent)((Object)value));
                return value;
            }
            case -495272225: {
                this.citedArtifact = (CitationCitedArtifactComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("summary")) {
            this.getSummary().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("classification")) {
            this.getClassification().add((CitationClassificationComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("currentState")) {
            this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("statusDate")) {
            this.getStatusDate().add((CitationStatusDateComponent)((Object)value));
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add((CitationRelatesToComponent)((Object)value));
        } else if (name.equals("citedArtifact")) {
            this.citedArtifact = (CitationCitedArtifactComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case -1857640538: {
                return this.addSummary();
            }
            case 382350310: {
                return this.addClassification();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1457822360: {
                return this.addCurrentState();
            }
            case 247524032: {
                return this.addStatusDate();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case -495272225: {
                return this.getCitedArtifact();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case -1857640538: {
                return new String[]{"ContactDetail"};
            }
            case 382350310: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1457822360: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[0];
            }
            case -7765931: {
                return new String[0];
            }
            case -495272225: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("summary")) {
            return this.addSummary();
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("currentState")) {
            return this.addCurrentState();
        }
        if (name.equals("statusDate")) {
            return this.addStatusDate();
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals("citedArtifact")) {
            this.citedArtifact = new CitationCitedArtifactComponent();
            return this.citedArtifact;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Citation";
    }

    @Override
    public Citation copy() {
        Citation dst = new Citation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Citation dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.summary != null) {
            dst.summary = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.summary) {
                dst.summary.add(contactDetail.copy());
            }
        }
        if (this.classification != null) {
            dst.classification = new ArrayList<CitationClassificationComponent>();
            for (CitationClassificationComponent citationClassificationComponent : this.classification) {
                dst.classification.add(citationClassificationComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.currentState != null) {
            dst.currentState = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.currentState) {
                dst.currentState.add(codeableConcept.copy());
            }
        }
        if (this.statusDate != null) {
            dst.statusDate = new ArrayList<CitationStatusDateComponent>();
            for (CitationStatusDateComponent citationStatusDateComponent : this.statusDate) {
                dst.statusDate.add(citationStatusDateComponent.copy());
            }
        }
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<CitationRelatesToComponent>();
            for (CitationRelatesToComponent citationRelatesToComponent : this.relatesTo) {
                dst.relatesTo.add(citationRelatesToComponent.copy());
            }
        }
        dst.citedArtifact = this.citedArtifact == null ? null : this.citedArtifact.copy();
    }

    protected Citation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Citation)) {
            return false;
        }
        Citation o = (Citation)other_;
        return Citation.compareDeep(this.url, o.url, true) && Citation.compareDeep(this.identifier, o.identifier, true) && Citation.compareDeep(this.version, o.version, true) && Citation.compareDeep(this.name, o.name, true) && Citation.compareDeep(this.title, o.title, true) && Citation.compareDeep(this.status, o.status, true) && Citation.compareDeep(this.experimental, o.experimental, true) && Citation.compareDeep(this.date, o.date, true) && Citation.compareDeep(this.publisher, o.publisher, true) && Citation.compareDeep(this.contact, o.contact, true) && Citation.compareDeep(this.description, o.description, true) && Citation.compareDeep(this.useContext, o.useContext, true) && Citation.compareDeep(this.jurisdiction, o.jurisdiction, true) && Citation.compareDeep(this.purpose, o.purpose, true) && Citation.compareDeep(this.copyright, o.copyright, true) && Citation.compareDeep(this.approvalDate, o.approvalDate, true) && Citation.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Citation.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && Citation.compareDeep(this.author, o.author, true) && Citation.compareDeep(this.editor, o.editor, true) && Citation.compareDeep(this.reviewer, o.reviewer, true) && Citation.compareDeep(this.endorser, o.endorser, true) && Citation.compareDeep(this.summary, o.summary, true) && Citation.compareDeep(this.classification, o.classification, true) && Citation.compareDeep(this.note, o.note, true) && Citation.compareDeep(this.currentState, o.currentState, true) && Citation.compareDeep(this.statusDate, o.statusDate, true) && Citation.compareDeep(this.relatesTo, o.relatesTo, true) && Citation.compareDeep(this.citedArtifact, o.citedArtifact, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Citation)) {
            return false;
        }
        Citation o = (Citation)other_;
        return Citation.compareValues(this.url, o.url, true) && Citation.compareValues(this.version, o.version, true) && Citation.compareValues(this.name, o.name, true) && Citation.compareValues(this.title, o.title, true) && Citation.compareValues(this.status, o.status, true) && Citation.compareValues(this.experimental, o.experimental, true) && Citation.compareValues(this.date, o.date, true) && Citation.compareValues(this.publisher, o.publisher, true) && Citation.compareValues(this.description, o.description, true) && Citation.compareValues(this.purpose, o.purpose, true) && Citation.compareValues(this.copyright, o.copyright, true) && Citation.compareValues(this.approvalDate, o.approvalDate, true) && Citation.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.author, this.editor, this.reviewer, this.endorser, this.summary, this.classification, this.note, this.currentState, this.statusDate, this.relatesTo, this.citedArtifact);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Citation;
    }

    @Block
    public static class CitationCitedArtifactContributorshipSummaryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Either authorList or contributorshipStatement", formalDefinition="Used most commonly to express an author list or a contributorship statement.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-type")
        protected CodeableConcept type;
        @Child(name="style", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The format for the display string", formalDefinition="The format for the display string.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-style")
        protected CodeableConcept style;
        @Child(name="source", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to code the producer or rule for creating the display string", formalDefinition="Used to code the producer or rule for creating the display string.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-source")
        protected CodeableConcept source;
        @Child(name="value", type={MarkdownType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The display string for the author list, contributor list, or contributorship statement", formalDefinition="The display string for the author list, contributor list, or contributorship statement.")
        protected MarkdownType value;
        private static final long serialVersionUID = 1353383781L;

        public CitationCitedArtifactContributorshipSummaryComponent() {
        }

        public CitationCitedArtifactContributorshipSummaryComponent(String value) {
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipSummaryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactContributorshipSummaryComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getStyle() {
            if (this.style == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipSummaryComponent.style");
                }
                if (Configuration.doAutoCreate()) {
                    this.style = new CodeableConcept();
                }
            }
            return this.style;
        }

        public boolean hasStyle() {
            return this.style != null && !this.style.isEmpty();
        }

        public CitationCitedArtifactContributorshipSummaryComponent setStyle(CodeableConcept value) {
            this.style = value;
            return this;
        }

        public CodeableConcept getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipSummaryComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new CodeableConcept();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public CitationCitedArtifactContributorshipSummaryComponent setSource(CodeableConcept value) {
            this.source = value;
            return this;
        }

        public MarkdownType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipSummaryComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new MarkdownType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationCitedArtifactContributorshipSummaryComponent setValueElement(MarkdownType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationCitedArtifactContributorshipSummaryComponent setValue(String value) {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used most commonly to express an author list or a contributorship statement.", 0, 1, this.type));
            children.add(new Property("style", "CodeableConcept", "The format for the display string.", 0, 1, this.style));
            children.add(new Property("source", "CodeableConcept", "Used to code the producer or rule for creating the display string.", 0, 1, this.source));
            children.add(new Property("value", "markdown", "The display string for the author list, contributor list, or contributorship statement.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used most commonly to express an author list or a contributorship statement.", 0, 1, this.type);
                }
                case 109780401: {
                    return new Property("style", "CodeableConcept", "The format for the display string.", 0, 1, this.style);
                }
                case -896505829: {
                    return new Property("source", "CodeableConcept", "Used to code the producer or rule for creating the display string.", 0, 1, this.source);
                }
                case 111972721: {
                    return new Property("value", "markdown", "The display string for the author list, contributor list, or contributorship statement.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 109780401: {
                    Base[] baseArray;
                    if (this.style == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.style;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.source;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 109780401: {
                    this.style = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("style")) {
                this.style = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 109780401: {
                    return this.getStyle();
                }
                case -896505829: {
                    return this.getSource();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 109780401: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("style")) {
                this.style = new CodeableConcept();
                return this.style;
            }
            if (name.equals("source")) {
                this.source = new CodeableConcept();
                return this.source;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.summary.value");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipSummaryComponent copy() {
            CitationCitedArtifactContributorshipSummaryComponent dst = new CitationCitedArtifactContributorshipSummaryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipSummaryComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.style = this.style == null ? null : this.style.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipSummaryComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipSummaryComponent o = (CitationCitedArtifactContributorshipSummaryComponent)other_;
            return CitationCitedArtifactContributorshipSummaryComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactContributorshipSummaryComponent.compareDeep(this.style, o.style, true) && CitationCitedArtifactContributorshipSummaryComponent.compareDeep(this.source, o.source, true) && CitationCitedArtifactContributorshipSummaryComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipSummaryComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipSummaryComponent o = (CitationCitedArtifactContributorshipSummaryComponent)other_;
            return CitationCitedArtifactContributorshipSummaryComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.style, this.source, this.value);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.summary";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipEntryContributionInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific contribution", formalDefinition="The specific contribution.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-contribution-instance-type")
        protected CodeableConcept type;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the contribution was made", formalDefinition="The time that the contribution was made.")
        protected DateTimeType time;
        private static final long serialVersionUID = -196837729L;

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent() {
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryContributionInstanceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryContributionInstanceComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The specific contribution.", 0, 1, this.type));
            children.add(new Property("time", "dateTime", "The time that the contribution was made.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The specific contribution.", 0, 1, this.type);
                }
                case 3560141: {
                    return new Property("time", "dateTime", "The time that the contribution was made.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("time")) {
                this.time = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3560141: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.contributionInstance.time");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent copy() {
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent dst = new CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipEntryContributionInstanceComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryContributionInstanceComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent o = (CitationCitedArtifactContributorshipEntryContributionInstanceComponent)other_;
            return CitationCitedArtifactContributorshipEntryContributionInstanceComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactContributorshipEntryContributionInstanceComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryContributionInstanceComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent o = (CitationCitedArtifactContributorshipEntryContributionInstanceComponent)other_;
            return CitationCitedArtifactContributorshipEntryContributionInstanceComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.time);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.entry.contributionInstance";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipEntryAffiliationInfoComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="affiliation", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the organization", formalDefinition="Display for the organization.")
        protected StringType affiliation;
        @Child(name="role", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role within the organization, such as professional title", formalDefinition="Role within the organization, such as professional title.")
        protected StringType role;
        @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier for the organization", formalDefinition="Identifier for the organization.")
        protected List<Identifier> identifier;
        private static final long serialVersionUID = 548335522L;

        public StringType getAffiliationElement() {
            if (this.affiliation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.affiliation");
                }
                if (Configuration.doAutoCreate()) {
                    this.affiliation = new StringType();
                }
            }
            return this.affiliation;
        }

        public boolean hasAffiliationElement() {
            return this.affiliation != null && !this.affiliation.isEmpty();
        }

        public boolean hasAffiliation() {
            return this.affiliation != null && !this.affiliation.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent setAffiliationElement(StringType value) {
            this.affiliation = value;
            return this;
        }

        public String getAffiliation() {
            return this.affiliation == null ? null : (String)this.affiliation.getValue();
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent setAffiliation(String value) {
            if (Utilities.noString(value)) {
                this.affiliation = null;
            } else {
                if (this.affiliation == null) {
                    this.affiliation = new StringType();
                }
                this.affiliation.setValue(value);
            }
            return this;
        }

        public StringType getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new StringType();
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent setRoleElement(StringType value) {
            this.role = value;
            return this;
        }

        public String getRole() {
            return this.role == null ? null : (String)this.role.getValue();
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent setRole(String value) {
            if (Utilities.noString(value)) {
                this.role = null;
            } else {
                if (this.role == null) {
                    this.role = new StringType();
                }
                this.role.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("affiliation", "string", "Display for the organization.", 0, 1, this.affiliation));
            children.add(new Property("role", "string", "Role within the organization, such as professional title.", 0, 1, this.role));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for the organization.", 0, Integer.MAX_VALUE, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2019918576: {
                    return new Property("affiliation", "string", "Display for the organization.", 0, 1, this.affiliation);
                }
                case 3506294: {
                    return new Property("role", "string", "Role within the organization, such as professional title.", 0, 1, this.role);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for the organization.", 0, Integer.MAX_VALUE, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    Base[] baseArray;
                    if (this.affiliation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.affiliation;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    this.affiliation = TypeConvertor.castToString(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("affiliation")) {
                this.affiliation = TypeConvertor.castToString(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    return this.getAffiliationElement();
                }
                case 3506294: {
                    return this.getRoleElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    return new String[]{"string"};
                }
                case 3506294: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("affiliation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.affiliationInfo.affiliation");
            }
            if (name.equals("role")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.affiliationInfo.role");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent copy() {
            CitationCitedArtifactContributorshipEntryAffiliationInfoComponent dst = new CitationCitedArtifactContributorshipEntryAffiliationInfoComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipEntryAffiliationInfoComponent dst) {
            super.copyValues(dst);
            dst.affiliation = this.affiliation == null ? null : this.affiliation.copy();
            StringType stringType = dst.role = this.role == null ? null : this.role.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i2 : this.identifier) {
                    dst.identifier.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryAffiliationInfoComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryAffiliationInfoComponent o = (CitationCitedArtifactContributorshipEntryAffiliationInfoComponent)other_;
            return CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.compareDeep(this.affiliation, o.affiliation, true) && CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.compareDeep(this.role, o.role, true) && CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryAffiliationInfoComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryAffiliationInfoComponent o = (CitationCitedArtifactContributorshipEntryAffiliationInfoComponent)other_;
            return CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.compareValues(this.affiliation, o.affiliation, true) && CitationCitedArtifactContributorshipEntryAffiliationInfoComponent.compareValues(this.role, o.role, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.affiliation, this.role, this.identifier);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.entry.affiliationInfo";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={HumanName.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the individual.")
        protected HumanName name;
        @Child(name="initials", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Initials for forename", formalDefinition="Initials for forename.")
        protected StringType initials;
        @Child(name="collectiveName", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for collective or corporate name as an author", formalDefinition="Used for collective or corporate name as an author.")
        protected StringType collectiveName;
        @Child(name="identifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Author identifier, eg ORCID", formalDefinition="Unique person identifier.")
        protected List<Identifier> identifier;
        @Child(name="affiliationInfo", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Organizational affiliation", formalDefinition="Organization affiliated with the entity.")
        protected List<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent> affiliationInfo;
        @Child(name="address", type={Address.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Physical mailing address", formalDefinition="Physical mailing address for the author or contributor.")
        protected List<Address> address;
        @Child(name="telecom", type={ContactPoint.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Email or telephone contact methods for the author or contributor", formalDefinition="Email or telephone contact methods for the author or contributor.")
        protected List<ContactPoint> telecom;
        @Child(name="contributionType", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific contribution", formalDefinition="This element identifies the specific nature of an individual\u2019s contribution with respect to the cited work.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-contribution-type")
        protected List<CodeableConcept> contributionType;
        @Child(name="role", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The role of the contributor (e.g. author, editor, reviewer)", formalDefinition="The role of the contributor (e.g. author, editor, reviewer).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-role")
        protected CodeableConcept role;
        @Child(name="contributionInstance", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contributions with accounting for time or number", formalDefinition="Contributions with accounting for time or number.")
        protected List<CitationCitedArtifactContributorshipEntryContributionInstanceComponent> contributionInstance;
        @Child(name="correspondingContact", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indication of which contributor is the corresponding contributor for the role", formalDefinition="Indication of which contributor is the corresponding contributor for the role.")
        protected BooleanType correspondingContact;
        @Child(name="listOrder", type={PositiveIntType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to code order of authors", formalDefinition="Used to code order of authors.")
        protected PositiveIntType listOrder;
        private static final long serialVersionUID = -1994433623L;

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public StringType getInitialsElement() {
            if (this.initials == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.initials");
                }
                if (Configuration.doAutoCreate()) {
                    this.initials = new StringType();
                }
            }
            return this.initials;
        }

        public boolean hasInitialsElement() {
            return this.initials != null && !this.initials.isEmpty();
        }

        public boolean hasInitials() {
            return this.initials != null && !this.initials.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setInitialsElement(StringType value) {
            this.initials = value;
            return this;
        }

        public String getInitials() {
            return this.initials == null ? null : (String)this.initials.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setInitials(String value) {
            if (Utilities.noString(value)) {
                this.initials = null;
            } else {
                if (this.initials == null) {
                    this.initials = new StringType();
                }
                this.initials.setValue(value);
            }
            return this;
        }

        public StringType getCollectiveNameElement() {
            if (this.collectiveName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.collectiveName");
                }
                if (Configuration.doAutoCreate()) {
                    this.collectiveName = new StringType();
                }
            }
            return this.collectiveName;
        }

        public boolean hasCollectiveNameElement() {
            return this.collectiveName != null && !this.collectiveName.isEmpty();
        }

        public boolean hasCollectiveName() {
            return this.collectiveName != null && !this.collectiveName.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setCollectiveNameElement(StringType value) {
            this.collectiveName = value;
            return this;
        }

        public String getCollectiveName() {
            return this.collectiveName == null ? null : (String)this.collectiveName.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setCollectiveName(String value) {
            if (Utilities.noString(value)) {
                this.collectiveName = null;
            } else {
                if (this.collectiveName == null) {
                    this.collectiveName = new StringType();
                }
                this.collectiveName.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationCitedArtifactContributorshipEntryComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent> getAffiliationInfo() {
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent>();
            }
            return this.affiliationInfo;
        }

        public CitationCitedArtifactContributorshipEntryComponent setAffiliationInfo(List<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent> theAffiliationInfo) {
            this.affiliationInfo = theAffiliationInfo;
            return this;
        }

        public boolean hasAffiliationInfo() {
            if (this.affiliationInfo == null) {
                return false;
            }
            for (CitationCitedArtifactContributorshipEntryAffiliationInfoComponent item : this.affiliationInfo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent addAffiliationInfo() {
            CitationCitedArtifactContributorshipEntryAffiliationInfoComponent t = new CitationCitedArtifactContributorshipEntryAffiliationInfoComponent();
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent>();
            }
            this.affiliationInfo.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addAffiliationInfo(CitationCitedArtifactContributorshipEntryAffiliationInfoComponent t) {
            if (t == null) {
                return this;
            }
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent>();
            }
            this.affiliationInfo.add(t);
            return this;
        }

        public CitationCitedArtifactContributorshipEntryAffiliationInfoComponent getAffiliationInfoFirstRep() {
            if (this.getAffiliationInfo().isEmpty()) {
                this.addAffiliationInfo();
            }
            return this.getAffiliationInfo().get(0);
        }

        public List<Address> getAddress() {
            if (this.address == null) {
                this.address = new ArrayList<Address>();
            }
            return this.address;
        }

        public CitationCitedArtifactContributorshipEntryComponent setAddress(List<Address> theAddress) {
            this.address = theAddress;
            return this;
        }

        public boolean hasAddress() {
            if (this.address == null) {
                return false;
            }
            for (Address item : this.address) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Address addAddress() {
            Address t = new Address();
            if (this.address == null) {
                this.address = new ArrayList<Address>();
            }
            this.address.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addAddress(Address t) {
            if (t == null) {
                return this;
            }
            if (this.address == null) {
                this.address = new ArrayList<Address>();
            }
            this.address.add(t);
            return this;
        }

        public Address getAddressFirstRep() {
            if (this.getAddress().isEmpty()) {
                this.addAddress();
            }
            return this.getAddress().get(0);
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public CitationCitedArtifactContributorshipEntryComponent setTelecom(List<ContactPoint> theTelecom) {
            this.telecom = theTelecom;
            return this;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public ContactPoint getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public List<CodeableConcept> getContributionType() {
            if (this.contributionType == null) {
                this.contributionType = new ArrayList<CodeableConcept>();
            }
            return this.contributionType;
        }

        public CitationCitedArtifactContributorshipEntryComponent setContributionType(List<CodeableConcept> theContributionType) {
            this.contributionType = theContributionType;
            return this;
        }

        public boolean hasContributionType() {
            if (this.contributionType == null) {
                return false;
            }
            for (CodeableConcept item : this.contributionType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addContributionType() {
            CodeableConcept t = new CodeableConcept();
            if (this.contributionType == null) {
                this.contributionType = new ArrayList<CodeableConcept>();
            }
            this.contributionType.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addContributionType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.contributionType == null) {
                this.contributionType = new ArrayList<CodeableConcept>();
            }
            this.contributionType.add(t);
            return this;
        }

        public CodeableConcept getContributionTypeFirstRep() {
            if (this.getContributionType().isEmpty()) {
                this.addContributionType();
            }
            return this.getContributionType().get(0);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public List<CitationCitedArtifactContributorshipEntryContributionInstanceComponent> getContributionInstance() {
            if (this.contributionInstance == null) {
                this.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
            }
            return this.contributionInstance;
        }

        public CitationCitedArtifactContributorshipEntryComponent setContributionInstance(List<CitationCitedArtifactContributorshipEntryContributionInstanceComponent> theContributionInstance) {
            this.contributionInstance = theContributionInstance;
            return this;
        }

        public boolean hasContributionInstance() {
            if (this.contributionInstance == null) {
                return false;
            }
            for (CitationCitedArtifactContributorshipEntryContributionInstanceComponent item : this.contributionInstance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent addContributionInstance() {
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent t = new CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
            if (this.contributionInstance == null) {
                this.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
            }
            this.contributionInstance.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addContributionInstance(CitationCitedArtifactContributorshipEntryContributionInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contributionInstance == null) {
                this.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
            }
            this.contributionInstance.add(t);
            return this;
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent getContributionInstanceFirstRep() {
            if (this.getContributionInstance().isEmpty()) {
                this.addContributionInstance();
            }
            return this.getContributionInstance().get(0);
        }

        public BooleanType getCorrespondingContactElement() {
            if (this.correspondingContact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.correspondingContact");
                }
                if (Configuration.doAutoCreate()) {
                    this.correspondingContact = new BooleanType();
                }
            }
            return this.correspondingContact;
        }

        public boolean hasCorrespondingContactElement() {
            return this.correspondingContact != null && !this.correspondingContact.isEmpty();
        }

        public boolean hasCorrespondingContact() {
            return this.correspondingContact != null && !this.correspondingContact.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setCorrespondingContactElement(BooleanType value) {
            this.correspondingContact = value;
            return this;
        }

        public boolean getCorrespondingContact() {
            return this.correspondingContact == null || this.correspondingContact.isEmpty() ? false : (Boolean)this.correspondingContact.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setCorrespondingContact(boolean value) {
            if (this.correspondingContact == null) {
                this.correspondingContact = new BooleanType();
            }
            this.correspondingContact.setValue((Object)value);
            return this;
        }

        public PositiveIntType getListOrderElement() {
            if (this.listOrder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.listOrder");
                }
                if (Configuration.doAutoCreate()) {
                    this.listOrder = new PositiveIntType();
                }
            }
            return this.listOrder;
        }

        public boolean hasListOrderElement() {
            return this.listOrder != null && !this.listOrder.isEmpty();
        }

        public boolean hasListOrder() {
            return this.listOrder != null && !this.listOrder.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setListOrderElement(PositiveIntType value) {
            this.listOrder = value;
            return this;
        }

        public int getListOrder() {
            return this.listOrder == null || this.listOrder.isEmpty() ? 0 : (Integer)this.listOrder.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setListOrder(int value) {
            if (this.listOrder == null) {
                this.listOrder = new PositiveIntType();
            }
            this.listOrder.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Citation.SP_NAME, "HumanName", "A name associated with the individual.", 0, 1, this.name));
            children.add(new Property("initials", "string", "Initials for forename.", 0, 1, this.initials));
            children.add(new Property("collectiveName", "string", "Used for collective or corporate name as an author.", 0, 1, this.collectiveName));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Unique person identifier.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("affiliationInfo", "", "Organization affiliated with the entity.", 0, Integer.MAX_VALUE, this.affiliationInfo));
            children.add(new Property("address", "Address", "Physical mailing address for the author or contributor.", 0, Integer.MAX_VALUE, this.address));
            children.add(new Property("telecom", "ContactPoint", "Email or telephone contact methods for the author or contributor.", 0, Integer.MAX_VALUE, this.telecom));
            children.add(new Property("contributionType", "CodeableConcept", "This element identifies the specific nature of an individual\u2019s contribution with respect to the cited work.", 0, Integer.MAX_VALUE, this.contributionType));
            children.add(new Property("role", "CodeableConcept", "The role of the contributor (e.g. author, editor, reviewer).", 0, 1, this.role));
            children.add(new Property("contributionInstance", "", "Contributions with accounting for time or number.", 0, Integer.MAX_VALUE, this.contributionInstance));
            children.add(new Property("correspondingContact", "boolean", "Indication of which contributor is the corresponding contributor for the role.", 0, 1, this.correspondingContact));
            children.add(new Property("listOrder", "positiveInt", "Used to code order of authors.", 0, 1, this.listOrder));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(Citation.SP_NAME, "HumanName", "A name associated with the individual.", 0, 1, this.name);
                }
                case 269062575: {
                    return new Property("initials", "string", "Initials for forename.", 0, 1, this.initials);
                }
                case 502871833: {
                    return new Property("collectiveName", "string", "Used for collective or corporate name as an author.", 0, 1, this.collectiveName);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Unique person identifier.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case -215129154: {
                    return new Property("affiliationInfo", "", "Organization affiliated with the entity.", 0, Integer.MAX_VALUE, this.affiliationInfo);
                }
                case -1147692044: {
                    return new Property("address", "Address", "Physical mailing address for the author or contributor.", 0, Integer.MAX_VALUE, this.address);
                }
                case -1429363305: {
                    return new Property("telecom", "ContactPoint", "Email or telephone contact methods for the author or contributor.", 0, Integer.MAX_VALUE, this.telecom);
                }
                case -1600446614: {
                    return new Property("contributionType", "CodeableConcept", "This element identifies the specific nature of an individual\u2019s contribution with respect to the cited work.", 0, Integer.MAX_VALUE, this.contributionType);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role of the contributor (e.g. author, editor, reviewer).", 0, 1, this.role);
                }
                case -547910459: {
                    return new Property("contributionInstance", "", "Contributions with accounting for time or number.", 0, Integer.MAX_VALUE, this.contributionInstance);
                }
                case -1816008851: {
                    return new Property("correspondingContact", "boolean", "Indication of which contributor is the corresponding contributor for the role.", 0, 1, this.correspondingContact);
                }
                case -1238918832: {
                    return new Property("listOrder", "positiveInt", "Used to code order of authors.", 0, 1, this.listOrder);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 269062575: {
                    Base[] baseArray;
                    if (this.initials == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.initials;
                    }
                    return baseArray;
                }
                case 502871833: {
                    Base[] baseArray;
                    if (this.collectiveName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.collectiveName;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -215129154: {
                    return this.affiliationInfo == null ? new Base[]{} : this.affiliationInfo.toArray(new Base[this.affiliationInfo.size()]);
                }
                case -1147692044: {
                    return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case -1600446614: {
                    return this.contributionType == null ? new Base[]{} : this.contributionType.toArray(new Base[this.contributionType.size()]);
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.role;
                    }
                    return baseArray;
                }
                case -547910459: {
                    return this.contributionInstance == null ? new Base[]{} : this.contributionInstance.toArray(new Base[this.contributionInstance.size()]);
                }
                case -1816008851: {
                    Base[] baseArray;
                    if (this.correspondingContact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.correspondingContact;
                    }
                    return baseArray;
                }
                case -1238918832: {
                    Base[] baseArray;
                    if (this.listOrder == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.listOrder;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToHumanName(value);
                    return value;
                }
                case 269062575: {
                    this.initials = TypeConvertor.castToString(value);
                    return value;
                }
                case 502871833: {
                    this.collectiveName = TypeConvertor.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -215129154: {
                    this.getAffiliationInfo().add((CitationCitedArtifactContributorshipEntryAffiliationInfoComponent)value);
                    return value;
                }
                case -1147692044: {
                    this.getAddress().add(TypeConvertor.castToAddress(value));
                    return value;
                }
                case -1429363305: {
                    this.getTelecom().add(TypeConvertor.castToContactPoint(value));
                    return value;
                }
                case -1600446614: {
                    this.getContributionType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -547910459: {
                    this.getContributionInstance().add((CitationCitedArtifactContributorshipEntryContributionInstanceComponent)value);
                    return value;
                }
                case -1816008851: {
                    this.correspondingContact = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1238918832: {
                    this.listOrder = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_NAME)) {
                this.name = TypeConvertor.castToHumanName(value);
            } else if (name.equals("initials")) {
                this.initials = TypeConvertor.castToString(value);
            } else if (name.equals("collectiveName")) {
                this.collectiveName = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("affiliationInfo")) {
                this.getAffiliationInfo().add((CitationCitedArtifactContributorshipEntryAffiliationInfoComponent)value);
            } else if (name.equals("address")) {
                this.getAddress().add(TypeConvertor.castToAddress(value));
            } else if (name.equals("telecom")) {
                this.getTelecom().add(TypeConvertor.castToContactPoint(value));
            } else if (name.equals("contributionType")) {
                this.getContributionType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("contributionInstance")) {
                this.getContributionInstance().add((CitationCitedArtifactContributorshipEntryContributionInstanceComponent)value);
            } else if (name.equals("correspondingContact")) {
                this.correspondingContact = TypeConvertor.castToBoolean(value);
            } else if (name.equals("listOrder")) {
                this.listOrder = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getName();
                }
                case 269062575: {
                    return this.getInitialsElement();
                }
                case 502871833: {
                    return this.getCollectiveNameElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -215129154: {
                    return this.addAffiliationInfo();
                }
                case -1147692044: {
                    return this.addAddress();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case -1600446614: {
                    return this.addContributionType();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -547910459: {
                    return this.addContributionInstance();
                }
                case -1816008851: {
                    return this.getCorrespondingContactElement();
                }
                case -1238918832: {
                    return this.getListOrderElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"HumanName"};
                }
                case 269062575: {
                    return new String[]{"string"};
                }
                case 502871833: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -215129154: {
                    return new String[0];
                }
                case -1147692044: {
                    return new String[]{"Address"};
                }
                case -1429363305: {
                    return new String[]{"ContactPoint"};
                }
                case -1600446614: {
                    return new String[]{"CodeableConcept"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -547910459: {
                    return new String[0];
                }
                case -1816008851: {
                    return new String[]{"boolean"};
                }
                case -1238918832: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Citation.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals("initials")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.initials");
            }
            if (name.equals("collectiveName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.collectiveName");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("affiliationInfo")) {
                return this.addAffiliationInfo();
            }
            if (name.equals("address")) {
                return this.addAddress();
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            if (name.equals("contributionType")) {
                return this.addContributionType();
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("contributionInstance")) {
                return this.addContributionInstance();
            }
            if (name.equals("correspondingContact")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.correspondingContact");
            }
            if (name.equals("listOrder")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.entry.listOrder");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipEntryComponent copy() {
            CitationCitedArtifactContributorshipEntryComponent dst = new CitationCitedArtifactContributorshipEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipEntryComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.initials = this.initials == null ? null : this.initials.copy();
            StringType stringType = dst.collectiveName = this.collectiveName == null ? null : this.collectiveName.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.affiliationInfo != null) {
                dst.affiliationInfo = new ArrayList<CitationCitedArtifactContributorshipEntryAffiliationInfoComponent>();
                for (CitationCitedArtifactContributorshipEntryAffiliationInfoComponent citationCitedArtifactContributorshipEntryAffiliationInfoComponent : this.affiliationInfo) {
                    dst.affiliationInfo.add(citationCitedArtifactContributorshipEntryAffiliationInfoComponent.copy());
                }
            }
            if (this.address != null) {
                dst.address = new ArrayList<Address>();
                for (Address address : this.address) {
                    dst.address.add(address.copy());
                }
            }
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint contactPoint : this.telecom) {
                    dst.telecom.add(contactPoint.copy());
                }
            }
            if (this.contributionType != null) {
                dst.contributionType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.contributionType) {
                    dst.contributionType.add(codeableConcept.copy());
                }
            }
            CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
            if (this.contributionInstance != null) {
                dst.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
                for (CitationCitedArtifactContributorshipEntryContributionInstanceComponent citationCitedArtifactContributorshipEntryContributionInstanceComponent : this.contributionInstance) {
                    dst.contributionInstance.add(citationCitedArtifactContributorshipEntryContributionInstanceComponent.copy());
                }
            }
            dst.correspondingContact = this.correspondingContact == null ? null : this.correspondingContact.copy();
            dst.listOrder = this.listOrder == null ? null : this.listOrder.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryComponent o = (CitationCitedArtifactContributorshipEntryComponent)other_;
            return CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.name, o.name, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.initials, o.initials, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.collectiveName, o.collectiveName, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.identifier, o.identifier, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.affiliationInfo, o.affiliationInfo, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.address, o.address, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.telecom, o.telecom, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.contributionType, o.contributionType, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.role, o.role, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.contributionInstance, o.contributionInstance, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.correspondingContact, o.correspondingContact, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.listOrder, o.listOrder, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryComponent o = (CitationCitedArtifactContributorshipEntryComponent)other_;
            return CitationCitedArtifactContributorshipEntryComponent.compareValues(this.initials, o.initials, true) && CitationCitedArtifactContributorshipEntryComponent.compareValues(this.collectiveName, o.collectiveName, true) && CitationCitedArtifactContributorshipEntryComponent.compareValues(this.correspondingContact, o.correspondingContact, true) && CitationCitedArtifactContributorshipEntryComponent.compareValues(this.listOrder, o.listOrder, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.name, this.initials, this.collectiveName, this.identifier, this.affiliationInfo, this.address, this.telecom, this.contributionType, this.role, this.contributionInstance, this.correspondingContact, this.listOrder);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.entry";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="complete", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates if the list includes all authors and/or contributors", formalDefinition="Indicates if the list includes all authors and/or contributors.")
        protected BooleanType complete;
        @Child(name="entry", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An individual entity named in the list", formalDefinition="An individual entity named in the author list or contributor list.")
        protected List<CitationCitedArtifactContributorshipEntryComponent> entry;
        @Child(name="summary", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used to record a display of the author/contributor list without separate coding for each list member", formalDefinition="Used to record a display of the author/contributor list without separate coding for each list member.")
        protected List<CitationCitedArtifactContributorshipSummaryComponent> summary;
        private static final long serialVersionUID = 78346599L;

        public BooleanType getCompleteElement() {
            if (this.complete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipComponent.complete");
                }
                if (Configuration.doAutoCreate()) {
                    this.complete = new BooleanType();
                }
            }
            return this.complete;
        }

        public boolean hasCompleteElement() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public boolean hasComplete() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public CitationCitedArtifactContributorshipComponent setCompleteElement(BooleanType value) {
            this.complete = value;
            return this;
        }

        public boolean getComplete() {
            return this.complete == null || this.complete.isEmpty() ? false : (Boolean)this.complete.getValue();
        }

        public CitationCitedArtifactContributorshipComponent setComplete(boolean value) {
            if (this.complete == null) {
                this.complete = new BooleanType();
            }
            this.complete.setValue((Object)value);
            return this;
        }

        public List<CitationCitedArtifactContributorshipEntryComponent> getEntry() {
            if (this.entry == null) {
                this.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
            }
            return this.entry;
        }

        public CitationCitedArtifactContributorshipComponent setEntry(List<CitationCitedArtifactContributorshipEntryComponent> theEntry) {
            this.entry = theEntry;
            return this;
        }

        public boolean hasEntry() {
            if (this.entry == null) {
                return false;
            }
            for (CitationCitedArtifactContributorshipEntryComponent item : this.entry) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactContributorshipEntryComponent addEntry() {
            CitationCitedArtifactContributorshipEntryComponent t = new CitationCitedArtifactContributorshipEntryComponent();
            if (this.entry == null) {
                this.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
            }
            this.entry.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipComponent addEntry(CitationCitedArtifactContributorshipEntryComponent t) {
            if (t == null) {
                return this;
            }
            if (this.entry == null) {
                this.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
            }
            this.entry.add(t);
            return this;
        }

        public CitationCitedArtifactContributorshipEntryComponent getEntryFirstRep() {
            if (this.getEntry().isEmpty()) {
                this.addEntry();
            }
            return this.getEntry().get(0);
        }

        public List<CitationCitedArtifactContributorshipSummaryComponent> getSummary() {
            if (this.summary == null) {
                this.summary = new ArrayList<CitationCitedArtifactContributorshipSummaryComponent>();
            }
            return this.summary;
        }

        public CitationCitedArtifactContributorshipComponent setSummary(List<CitationCitedArtifactContributorshipSummaryComponent> theSummary) {
            this.summary = theSummary;
            return this;
        }

        public boolean hasSummary() {
            if (this.summary == null) {
                return false;
            }
            for (CitationCitedArtifactContributorshipSummaryComponent item : this.summary) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactContributorshipSummaryComponent addSummary() {
            CitationCitedArtifactContributorshipSummaryComponent t = new CitationCitedArtifactContributorshipSummaryComponent();
            if (this.summary == null) {
                this.summary = new ArrayList<CitationCitedArtifactContributorshipSummaryComponent>();
            }
            this.summary.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipComponent addSummary(CitationCitedArtifactContributorshipSummaryComponent t) {
            if (t == null) {
                return this;
            }
            if (this.summary == null) {
                this.summary = new ArrayList<CitationCitedArtifactContributorshipSummaryComponent>();
            }
            this.summary.add(t);
            return this;
        }

        public CitationCitedArtifactContributorshipSummaryComponent getSummaryFirstRep() {
            if (this.getSummary().isEmpty()) {
                this.addSummary();
            }
            return this.getSummary().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("complete", "boolean", "Indicates if the list includes all authors and/or contributors.", 0, 1, this.complete));
            children.add(new Property("entry", "", "An individual entity named in the author list or contributor list.", 0, Integer.MAX_VALUE, this.entry));
            children.add(new Property("summary", "", "Used to record a display of the author/contributor list without separate coding for each list member.", 0, Integer.MAX_VALUE, this.summary));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -599445191: {
                    return new Property("complete", "boolean", "Indicates if the list includes all authors and/or contributors.", 0, 1, this.complete);
                }
                case 96667762: {
                    return new Property("entry", "", "An individual entity named in the author list or contributor list.", 0, Integer.MAX_VALUE, this.entry);
                }
                case -1857640538: {
                    return new Property("summary", "", "Used to record a display of the author/contributor list without separate coding for each list member.", 0, Integer.MAX_VALUE, this.summary);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    Base[] baseArray;
                    if (this.complete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.complete;
                    }
                    return baseArray;
                }
                case 96667762: {
                    return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
                }
                case -1857640538: {
                    return this.summary == null ? new Base[]{} : this.summary.toArray(new Base[this.summary.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    this.complete = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 96667762: {
                    this.getEntry().add((CitationCitedArtifactContributorshipEntryComponent)value);
                    return value;
                }
                case -1857640538: {
                    this.getSummary().add((CitationCitedArtifactContributorshipSummaryComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("complete")) {
                this.complete = TypeConvertor.castToBoolean(value);
            } else if (name.equals("entry")) {
                this.getEntry().add((CitationCitedArtifactContributorshipEntryComponent)value);
            } else if (name.equals("summary")) {
                this.getSummary().add((CitationCitedArtifactContributorshipSummaryComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return this.getCompleteElement();
                }
                case 96667762: {
                    return this.addEntry();
                }
                case -1857640538: {
                    return this.addSummary();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return new String[]{"boolean"};
                }
                case 96667762: {
                    return new String[0];
                }
                case -1857640538: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("complete")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.contributorship.complete");
            }
            if (name.equals("entry")) {
                return this.addEntry();
            }
            if (name.equals("summary")) {
                return this.addSummary();
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipComponent copy() {
            CitationCitedArtifactContributorshipComponent dst = new CitationCitedArtifactContributorshipComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipComponent dst) {
            super.copyValues(dst);
            BooleanType booleanType = dst.complete = this.complete == null ? null : this.complete.copy();
            if (this.entry != null) {
                dst.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
                for (CitationCitedArtifactContributorshipEntryComponent citationCitedArtifactContributorshipEntryComponent : this.entry) {
                    dst.entry.add(citationCitedArtifactContributorshipEntryComponent.copy());
                }
            }
            if (this.summary != null) {
                dst.summary = new ArrayList<CitationCitedArtifactContributorshipSummaryComponent>();
                for (CitationCitedArtifactContributorshipSummaryComponent citationCitedArtifactContributorshipSummaryComponent : this.summary) {
                    dst.summary.add(citationCitedArtifactContributorshipSummaryComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipComponent o = (CitationCitedArtifactContributorshipComponent)other_;
            return CitationCitedArtifactContributorshipComponent.compareDeep(this.complete, o.complete, true) && CitationCitedArtifactContributorshipComponent.compareDeep(this.entry, o.entry, true) && CitationCitedArtifactContributorshipComponent.compareDeep(this.summary, o.summary, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipComponent o = (CitationCitedArtifactContributorshipComponent)other_;
            return CitationCitedArtifactContributorshipComponent.compareValues(this.complete, o.complete, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.complete, this.entry, this.summary);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship";
        }
    }

    @Block
    public static class CitationCitedArtifactClassificationWhoClassifiedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="person", type={Person.class, Practitioner.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Person who created the classification", formalDefinition="Person who created the classification.")
        protected Reference person;
        @Child(name="organization", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization who created the classification", formalDefinition="Organization who created the classification.")
        protected Reference organization;
        @Child(name="publisher", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The publisher of the classification, not the publisher of the article or artifact being cited", formalDefinition="The publisher of the classification, not the publisher of the article or artifact being cited.")
        protected Reference publisher;
        @Child(name="classifierCopyright", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Rights management statement for the classification", formalDefinition="Rights management statement for the classification.")
        protected StringType classifierCopyright;
        @Child(name="freeToShare", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Acceptable to re-use the classification", formalDefinition="Acceptable to re-use the classification.")
        protected BooleanType freeToShare;
        private static final long serialVersionUID = -1835300032L;

        public Reference getPerson() {
            if (this.person == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationWhoClassifiedComponent.person");
                }
                if (Configuration.doAutoCreate()) {
                    this.person = new Reference();
                }
            }
            return this.person;
        }

        public boolean hasPerson() {
            return this.person != null && !this.person.isEmpty();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setPerson(Reference value) {
            this.person = value;
            return this;
        }

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationWhoClassifiedComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        public Reference getPublisher() {
            if (this.publisher == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationWhoClassifiedComponent.publisher");
                }
                if (Configuration.doAutoCreate()) {
                    this.publisher = new Reference();
                }
            }
            return this.publisher;
        }

        public boolean hasPublisher() {
            return this.publisher != null && !this.publisher.isEmpty();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setPublisher(Reference value) {
            this.publisher = value;
            return this;
        }

        public StringType getClassifierCopyrightElement() {
            if (this.classifierCopyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationWhoClassifiedComponent.classifierCopyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.classifierCopyright = new StringType();
                }
            }
            return this.classifierCopyright;
        }

        public boolean hasClassifierCopyrightElement() {
            return this.classifierCopyright != null && !this.classifierCopyright.isEmpty();
        }

        public boolean hasClassifierCopyright() {
            return this.classifierCopyright != null && !this.classifierCopyright.isEmpty();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setClassifierCopyrightElement(StringType value) {
            this.classifierCopyright = value;
            return this;
        }

        public String getClassifierCopyright() {
            return this.classifierCopyright == null ? null : (String)this.classifierCopyright.getValue();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setClassifierCopyright(String value) {
            if (Utilities.noString(value)) {
                this.classifierCopyright = null;
            } else {
                if (this.classifierCopyright == null) {
                    this.classifierCopyright = new StringType();
                }
                this.classifierCopyright.setValue(value);
            }
            return this;
        }

        public BooleanType getFreeToShareElement() {
            if (this.freeToShare == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationWhoClassifiedComponent.freeToShare");
                }
                if (Configuration.doAutoCreate()) {
                    this.freeToShare = new BooleanType();
                }
            }
            return this.freeToShare;
        }

        public boolean hasFreeToShareElement() {
            return this.freeToShare != null && !this.freeToShare.isEmpty();
        }

        public boolean hasFreeToShare() {
            return this.freeToShare != null && !this.freeToShare.isEmpty();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setFreeToShareElement(BooleanType value) {
            this.freeToShare = value;
            return this;
        }

        public boolean getFreeToShare() {
            return this.freeToShare == null || this.freeToShare.isEmpty() ? false : (Boolean)this.freeToShare.getValue();
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent setFreeToShare(boolean value) {
            if (this.freeToShare == null) {
                this.freeToShare = new BooleanType();
            }
            this.freeToShare.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("person", "Reference(Person|Practitioner)", "Person who created the classification.", 0, 1, this.person));
            children.add(new Property("organization", "Reference(Organization)", "Organization who created the classification.", 0, 1, this.organization));
            children.add(new Property(Citation.SP_PUBLISHER, "Reference(Organization)", "The publisher of the classification, not the publisher of the article or artifact being cited.", 0, 1, this.publisher));
            children.add(new Property("classifierCopyright", "string", "Rights management statement for the classification.", 0, 1, this.classifierCopyright));
            children.add(new Property("freeToShare", "boolean", "Acceptable to re-use the classification.", 0, 1, this.freeToShare));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -991716523: {
                    return new Property("person", "Reference(Person|Practitioner)", "Person who created the classification.", 0, 1, this.person);
                }
                case 1178922291: {
                    return new Property("organization", "Reference(Organization)", "Organization who created the classification.", 0, 1, this.organization);
                }
                case 1447404028: {
                    return new Property(Citation.SP_PUBLISHER, "Reference(Organization)", "The publisher of the classification, not the publisher of the article or artifact being cited.", 0, 1, this.publisher);
                }
                case -434942298: {
                    return new Property("classifierCopyright", "string", "Rights management statement for the classification.", 0, 1, this.classifierCopyright);
                }
                case -1268656616: {
                    return new Property("freeToShare", "boolean", "Acceptable to re-use the classification.", 0, 1, this.freeToShare);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -991716523: {
                    Base[] baseArray;
                    if (this.person == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.person;
                    }
                    return baseArray;
                }
                case 1178922291: {
                    Base[] baseArray;
                    if (this.organization == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.organization;
                    }
                    return baseArray;
                }
                case 1447404028: {
                    Base[] baseArray;
                    if (this.publisher == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.publisher;
                    }
                    return baseArray;
                }
                case -434942298: {
                    Base[] baseArray;
                    if (this.classifierCopyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.classifierCopyright;
                    }
                    return baseArray;
                }
                case -1268656616: {
                    Base[] baseArray;
                    if (this.freeToShare == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.freeToShare;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -991716523: {
                    this.person = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1178922291: {
                    this.organization = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1447404028: {
                    this.publisher = TypeConvertor.castToReference(value);
                    return value;
                }
                case -434942298: {
                    this.classifierCopyright = TypeConvertor.castToString(value);
                    return value;
                }
                case -1268656616: {
                    this.freeToShare = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("person")) {
                this.person = TypeConvertor.castToReference(value);
            } else if (name.equals("organization")) {
                this.organization = TypeConvertor.castToReference(value);
            } else if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = TypeConvertor.castToReference(value);
            } else if (name.equals("classifierCopyright")) {
                this.classifierCopyright = TypeConvertor.castToString(value);
            } else if (name.equals("freeToShare")) {
                this.freeToShare = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -991716523: {
                    return this.getPerson();
                }
                case 1178922291: {
                    return this.getOrganization();
                }
                case 1447404028: {
                    return this.getPublisher();
                }
                case -434942298: {
                    return this.getClassifierCopyrightElement();
                }
                case -1268656616: {
                    return this.getFreeToShareElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -991716523: {
                    return new String[]{"Reference"};
                }
                case 1178922291: {
                    return new String[]{"Reference"};
                }
                case 1447404028: {
                    return new String[]{"Reference"};
                }
                case -434942298: {
                    return new String[]{"string"};
                }
                case -1268656616: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("person")) {
                this.person = new Reference();
                return this.person;
            }
            if (name.equals("organization")) {
                this.organization = new Reference();
                return this.organization;
            }
            if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = new Reference();
                return this.publisher;
            }
            if (name.equals("classifierCopyright")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.classification.whoClassified.classifierCopyright");
            }
            if (name.equals("freeToShare")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.classification.whoClassified.freeToShare");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactClassificationWhoClassifiedComponent copy() {
            CitationCitedArtifactClassificationWhoClassifiedComponent dst = new CitationCitedArtifactClassificationWhoClassifiedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactClassificationWhoClassifiedComponent dst) {
            super.copyValues(dst);
            dst.person = this.person == null ? null : this.person.copy();
            dst.organization = this.organization == null ? null : this.organization.copy();
            dst.publisher = this.publisher == null ? null : this.publisher.copy();
            dst.classifierCopyright = this.classifierCopyright == null ? null : this.classifierCopyright.copy();
            dst.freeToShare = this.freeToShare == null ? null : this.freeToShare.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactClassificationWhoClassifiedComponent)) {
                return false;
            }
            CitationCitedArtifactClassificationWhoClassifiedComponent o = (CitationCitedArtifactClassificationWhoClassifiedComponent)other_;
            return CitationCitedArtifactClassificationWhoClassifiedComponent.compareDeep(this.person, o.person, true) && CitationCitedArtifactClassificationWhoClassifiedComponent.compareDeep(this.organization, o.organization, true) && CitationCitedArtifactClassificationWhoClassifiedComponent.compareDeep(this.publisher, o.publisher, true) && CitationCitedArtifactClassificationWhoClassifiedComponent.compareDeep(this.classifierCopyright, o.classifierCopyright, true) && CitationCitedArtifactClassificationWhoClassifiedComponent.compareDeep(this.freeToShare, o.freeToShare, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactClassificationWhoClassifiedComponent)) {
                return false;
            }
            CitationCitedArtifactClassificationWhoClassifiedComponent o = (CitationCitedArtifactClassificationWhoClassifiedComponent)other_;
            return CitationCitedArtifactClassificationWhoClassifiedComponent.compareValues(this.classifierCopyright, o.classifierCopyright, true) && CitationCitedArtifactClassificationWhoClassifiedComponent.compareValues(this.freeToShare, o.freeToShare, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.person, this.organization, this.publisher, this.classifierCopyright, this.freeToShare);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.classification.whoClassified";
        }
    }

    @Block
    public static class CitationCitedArtifactClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of classifier (e.g. publication type, keyword)", formalDefinition="The kind of classifier (e.g. publication type, keyword).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-classification-type")
        protected CodeableConcept type;
        @Child(name="classifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific classification value", formalDefinition="The specific classification value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> classifier;
        @Child(name="whoClassified", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Provenance and copyright of classification", formalDefinition="Provenance and copyright of classification.")
        protected CitationCitedArtifactClassificationWhoClassifiedComponent whoClassified;
        private static final long serialVersionUID = -1887617918L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public CitationCitedArtifactClassificationComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public CitationCitedArtifactClassificationComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        public CitationCitedArtifactClassificationWhoClassifiedComponent getWhoClassified() {
            if (this.whoClassified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationComponent.whoClassified");
                }
                if (Configuration.doAutoCreate()) {
                    this.whoClassified = new CitationCitedArtifactClassificationWhoClassifiedComponent();
                }
            }
            return this.whoClassified;
        }

        public boolean hasWhoClassified() {
            return this.whoClassified != null && !this.whoClassified.isEmpty();
        }

        public CitationCitedArtifactClassificationComponent setWhoClassified(CitationCitedArtifactClassificationWhoClassifiedComponent value) {
            this.whoClassified = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type));
            children.add(new Property("classifier", "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier));
            children.add(new Property("whoClassified", "", "Provenance and copyright of classification.", 0, 1, this.whoClassified));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type);
                }
                case -281470431: {
                    return new Property("classifier", "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier);
                }
                case -196629391: {
                    return new Property("whoClassified", "", "Provenance and copyright of classification.", 0, 1, this.whoClassified);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
                case -196629391: {
                    Base[] baseArray;
                    if (this.whoClassified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.whoClassified;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -196629391: {
                    this.whoClassified = (CitationCitedArtifactClassificationWhoClassifiedComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("classifier")) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("whoClassified")) {
                this.whoClassified = (CitationCitedArtifactClassificationWhoClassifiedComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -281470431: {
                    return this.addClassifier();
                }
                case -196629391: {
                    return this.getWhoClassified();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
                case -196629391: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("classifier")) {
                return this.addClassifier();
            }
            if (name.equals("whoClassified")) {
                this.whoClassified = new CitationCitedArtifactClassificationWhoClassifiedComponent();
                return this.whoClassified;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactClassificationComponent copy() {
            CitationCitedArtifactClassificationComponent dst = new CitationCitedArtifactClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.classifier) {
                    dst.classifier.add(i2.copy());
                }
            }
            dst.whoClassified = this.whoClassified == null ? null : this.whoClassified.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactClassificationComponent)) {
                return false;
            }
            CitationCitedArtifactClassificationComponent o = (CitationCitedArtifactClassificationComponent)other_;
            return CitationCitedArtifactClassificationComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactClassificationComponent.compareDeep(this.classifier, o.classifier, true) && CitationCitedArtifactClassificationComponent.compareDeep(this.whoClassified, o.whoClassified, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactClassificationComponent)) {
                return false;
            }
            CitationCitedArtifactClassificationComponent o = (CitationCitedArtifactClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.classifier, this.whoClassified);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.classification";
        }
    }

    @Block
    public static class CitationCitedArtifactWebLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code the reason for different URLs, e.g. abstract and full-text", formalDefinition="Code the reason for different URLs, e.g. abstract and full-text.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/article-url-type")
        protected CodeableConcept type;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific URL", formalDefinition="The specific URL.")
        protected UriType url;
        private static final long serialVersionUID = 397204034L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactWebLocationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactWebLocationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactWebLocationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CitationCitedArtifactWebLocationComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CitationCitedArtifactWebLocationComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Code the reason for different URLs, e.g. abstract and full-text.", 0, 1, this.type));
            children.add(new Property(Citation.SP_URL, "uri", "The specific URL.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Code the reason for different URLs, e.g. abstract and full-text.", 0, 1, this.type);
                }
                case 116079: {
                    return new Property(Citation.SP_URL, "uri", "The specific URL.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Citation.SP_URL)) {
                this.url = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Citation.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.webLocation.url");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactWebLocationComponent copy() {
            CitationCitedArtifactWebLocationComponent dst = new CitationCitedArtifactWebLocationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactWebLocationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactWebLocationComponent)) {
                return false;
            }
            CitationCitedArtifactWebLocationComponent o = (CitationCitedArtifactWebLocationComponent)other_;
            return CitationCitedArtifactWebLocationComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactWebLocationComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactWebLocationComponent)) {
                return false;
            }
            CitationCitedArtifactWebLocationComponent o = (CitationCitedArtifactWebLocationComponent)other_;
            return CitationCitedArtifactWebLocationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.url);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.webLocation";
        }
    }

    @Block
    public static class CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date on which the issue of the journal was published", formalDefinition="Date on which the issue of the journal was published.")
        protected DateType date;
        @Child(name="year", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Year on which the issue of the journal was published", formalDefinition="Year on which the issue of the journal was published.")
        protected StringType year;
        @Child(name="month", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Month on which the issue of the journal was published", formalDefinition="Month on which the issue of the journal was published.")
        protected StringType month;
        @Child(name="day", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Day on which the issue of the journal was published", formalDefinition="Day on which the issue of the journal was published.")
        protected StringType day;
        @Child(name="season", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Season on which the issue of the journal was published", formalDefinition="Spring, Summer, Fall/Autumn, Winter.")
        protected StringType season;
        @Child(name="text", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text representation of the date of which the issue of the journal was published", formalDefinition="Text representation of the date of which the issue of the journal was published.")
        protected StringType text;
        private static final long serialVersionUID = 1585589146L;

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public StringType getYearElement() {
            if (this.year == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.year");
                }
                if (Configuration.doAutoCreate()) {
                    this.year = new StringType();
                }
            }
            return this.year;
        }

        public boolean hasYearElement() {
            return this.year != null && !this.year.isEmpty();
        }

        public boolean hasYear() {
            return this.year != null && !this.year.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setYearElement(StringType value) {
            this.year = value;
            return this;
        }

        public String getYear() {
            return this.year == null ? null : (String)this.year.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setYear(String value) {
            if (Utilities.noString(value)) {
                this.year = null;
            } else {
                if (this.year == null) {
                    this.year = new StringType();
                }
                this.year.setValue(value);
            }
            return this;
        }

        public StringType getMonthElement() {
            if (this.month == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.month");
                }
                if (Configuration.doAutoCreate()) {
                    this.month = new StringType();
                }
            }
            return this.month;
        }

        public boolean hasMonthElement() {
            return this.month != null && !this.month.isEmpty();
        }

        public boolean hasMonth() {
            return this.month != null && !this.month.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setMonthElement(StringType value) {
            this.month = value;
            return this;
        }

        public String getMonth() {
            return this.month == null ? null : (String)this.month.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setMonth(String value) {
            if (Utilities.noString(value)) {
                this.month = null;
            } else {
                if (this.month == null) {
                    this.month = new StringType();
                }
                this.month.setValue(value);
            }
            return this;
        }

        public StringType getDayElement() {
            if (this.day == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.day");
                }
                if (Configuration.doAutoCreate()) {
                    this.day = new StringType();
                }
            }
            return this.day;
        }

        public boolean hasDayElement() {
            return this.day != null && !this.day.isEmpty();
        }

        public boolean hasDay() {
            return this.day != null && !this.day.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setDayElement(StringType value) {
            this.day = value;
            return this;
        }

        public String getDay() {
            return this.day == null ? null : (String)this.day.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setDay(String value) {
            if (Utilities.noString(value)) {
                this.day = null;
            } else {
                if (this.day == null) {
                    this.day = new StringType();
                }
                this.day.setValue(value);
            }
            return this;
        }

        public StringType getSeasonElement() {
            if (this.season == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.season");
                }
                if (Configuration.doAutoCreate()) {
                    this.season = new StringType();
                }
            }
            return this.season;
        }

        public boolean hasSeasonElement() {
            return this.season != null && !this.season.isEmpty();
        }

        public boolean hasSeason() {
            return this.season != null && !this.season.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setSeasonElement(StringType value) {
            this.season = value;
            return this;
        }

        public String getSeason() {
            return this.season == null ? null : (String)this.season.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setSeason(String value) {
            if (Utilities.noString(value)) {
                this.season = null;
            } else {
                if (this.season == null) {
                    this.season = new StringType();
                }
                this.season.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Citation.SP_DATE, Citation.SP_DATE, "Date on which the issue of the journal was published.", 0, 1, this.date));
            children.add(new Property("year", "string", "Year on which the issue of the journal was published.", 0, 1, this.year));
            children.add(new Property("month", "string", "Month on which the issue of the journal was published.", 0, 1, this.month));
            children.add(new Property("day", "string", "Day on which the issue of the journal was published.", 0, 1, this.day));
            children.add(new Property("season", "string", "Spring, Summer, Fall/Autumn, Winter.", 0, 1, this.season));
            children.add(new Property("text", "string", "Text representation of the date of which the issue of the journal was published.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3076014: {
                    return new Property(Citation.SP_DATE, Citation.SP_DATE, "Date on which the issue of the journal was published.", 0, 1, this.date);
                }
                case 0x38883D: {
                    return new Property("year", "string", "Year on which the issue of the journal was published.", 0, 1, this.year);
                }
                case 104080000: {
                    return new Property("month", "string", "Month on which the issue of the journal was published.", 0, 1, this.month);
                }
                case 99228: {
                    return new Property("day", "string", "Day on which the issue of the journal was published.", 0, 1, this.day);
                }
                case -906335517: {
                    return new Property("season", "string", "Spring, Summer, Fall/Autumn, Winter.", 0, 1, this.season);
                }
                case 3556653: {
                    return new Property("text", "string", "Text representation of the date of which the issue of the journal was published.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.date;
                    }
                    return baseArray;
                }
                case 0x38883D: {
                    Base[] baseArray;
                    if (this.year == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.year;
                    }
                    return baseArray;
                }
                case 104080000: {
                    Base[] baseArray;
                    if (this.month == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.month;
                    }
                    return baseArray;
                }
                case 99228: {
                    Base[] baseArray;
                    if (this.day == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.day;
                    }
                    return baseArray;
                }
                case -906335517: {
                    Base[] baseArray;
                    if (this.season == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.season;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    this.date = TypeConvertor.castToDate(value);
                    return value;
                }
                case 0x38883D: {
                    this.year = TypeConvertor.castToString(value);
                    return value;
                }
                case 104080000: {
                    this.month = TypeConvertor.castToString(value);
                    return value;
                }
                case 99228: {
                    this.day = TypeConvertor.castToString(value);
                    return value;
                }
                case -906335517: {
                    this.season = TypeConvertor.castToString(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_DATE)) {
                this.date = TypeConvertor.castToDate(value);
            } else if (name.equals("year")) {
                this.year = TypeConvertor.castToString(value);
            } else if (name.equals("month")) {
                this.month = TypeConvertor.castToString(value);
            } else if (name.equals("day")) {
                this.day = TypeConvertor.castToString(value);
            } else if (name.equals("season")) {
                this.season = TypeConvertor.castToString(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return this.getDateElement();
                }
                case 0x38883D: {
                    return this.getYearElement();
                }
                case 104080000: {
                    return this.getMonthElement();
                }
                case 99228: {
                    return this.getDayElement();
                }
                case -906335517: {
                    return this.getSeasonElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return new String[]{Citation.SP_DATE};
                }
                case 0x38883D: {
                    return new String[]{"string"};
                }
                case 104080000: {
                    return new String[]{"string"};
                }
                case 99228: {
                    return new String[]{"string"};
                }
                case -906335517: {
                    return new String[]{"string"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Citation.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication.date");
            }
            if (name.equals("year")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication.year");
            }
            if (name.equals("month")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication.month");
            }
            if (name.equals("day")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication.day");
            }
            if (name.equals("season")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication.season");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication.text");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent copy() {
            CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent dst = new CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent dst) {
            super.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.year = this.year == null ? null : this.year.copy();
            dst.month = this.month == null ? null : this.month.copy();
            dst.day = this.day == null ? null : this.day.copy();
            dst.season = this.season == null ? null : this.season.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent o = (CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent)other_;
            return CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareDeep(this.date, o.date, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareDeep(this.year, o.year, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareDeep(this.month, o.month, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareDeep(this.day, o.day, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareDeep(this.season, o.season, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent o = (CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent)other_;
            return CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareValues(this.date, o.date, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareValues(this.year, o.year, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareValues(this.month, o.month, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareValues(this.day, o.day, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareValues(this.season, o.season, true) && CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.date, this.year, this.month, this.day, this.season, this.text);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.publicationForm.periodicRelease.dateOfPublication";
        }
    }

    @Block
    public static class CitationCitedArtifactPublicationFormPeriodicReleaseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="citedMedium", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internet or Print", formalDefinition="Describes the form of the medium cited. Common codes are \"Internet\" or \"Print\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/journal-issue-medium")
        protected CodeableConcept citedMedium;
        @Child(name="volume", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Volume number of journal in which the article is published", formalDefinition="Volume number of journal in which the article is published.")
        protected StringType volume;
        @Child(name="issue", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Issue, part or supplement of journal in which the article is published", formalDefinition="Issue, part or supplement of journal in which the article is published.")
        protected StringType issue;
        @Child(name="dateOfPublication", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Defining the date on which the issue of the journal was published", formalDefinition="Defining the date on which the issue of the journal was published.")
        protected CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent dateOfPublication;
        private static final long serialVersionUID = -474554951L;

        public CodeableConcept getCitedMedium() {
            if (this.citedMedium == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseComponent.citedMedium");
                }
                if (Configuration.doAutoCreate()) {
                    this.citedMedium = new CodeableConcept();
                }
            }
            return this.citedMedium;
        }

        public boolean hasCitedMedium() {
            return this.citedMedium != null && !this.citedMedium.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent setCitedMedium(CodeableConcept value) {
            this.citedMedium = value;
            return this;
        }

        public StringType getVolumeElement() {
            if (this.volume == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseComponent.volume");
                }
                if (Configuration.doAutoCreate()) {
                    this.volume = new StringType();
                }
            }
            return this.volume;
        }

        public boolean hasVolumeElement() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public boolean hasVolume() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent setVolumeElement(StringType value) {
            this.volume = value;
            return this;
        }

        public String getVolume() {
            return this.volume == null ? null : (String)this.volume.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent setVolume(String value) {
            if (Utilities.noString(value)) {
                this.volume = null;
            } else {
                if (this.volume == null) {
                    this.volume = new StringType();
                }
                this.volume.setValue(value);
            }
            return this;
        }

        public StringType getIssueElement() {
            if (this.issue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseComponent.issue");
                }
                if (Configuration.doAutoCreate()) {
                    this.issue = new StringType();
                }
            }
            return this.issue;
        }

        public boolean hasIssueElement() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public boolean hasIssue() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent setIssueElement(StringType value) {
            this.issue = value;
            return this;
        }

        public String getIssue() {
            return this.issue == null ? null : (String)this.issue.getValue();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent setIssue(String value) {
            if (Utilities.noString(value)) {
                this.issue = null;
            } else {
                if (this.issue == null) {
                    this.issue = new StringType();
                }
                this.issue.setValue(value);
            }
            return this;
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent getDateOfPublication() {
            if (this.dateOfPublication == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPeriodicReleaseComponent.dateOfPublication");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateOfPublication = new CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent();
                }
            }
            return this.dateOfPublication;
        }

        public boolean hasDateOfPublication() {
            return this.dateOfPublication != null && !this.dateOfPublication.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent setDateOfPublication(CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent value) {
            this.dateOfPublication = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("citedMedium", "CodeableConcept", "Describes the form of the medium cited. Common codes are \"Internet\" or \"Print\".", 0, 1, this.citedMedium));
            children.add(new Property("volume", "string", "Volume number of journal in which the article is published.", 0, 1, this.volume));
            children.add(new Property("issue", "string", "Issue, part or supplement of journal in which the article is published.", 0, 1, this.issue));
            children.add(new Property("dateOfPublication", "", "Defining the date on which the issue of the journal was published.", 0, 1, this.dateOfPublication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 612116418: {
                    return new Property("citedMedium", "CodeableConcept", "Describes the form of the medium cited. Common codes are \"Internet\" or \"Print\".", 0, 1, this.citedMedium);
                }
                case -810883302: {
                    return new Property("volume", "string", "Volume number of journal in which the article is published.", 0, 1, this.volume);
                }
                case 100509913: {
                    return new Property("issue", "string", "Issue, part or supplement of journal in which the article is published.", 0, 1, this.issue);
                }
                case -1662473529: {
                    return new Property("dateOfPublication", "", "Defining the date on which the issue of the journal was published.", 0, 1, this.dateOfPublication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    Base[] baseArray;
                    if (this.citedMedium == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.citedMedium;
                    }
                    return baseArray;
                }
                case -810883302: {
                    Base[] baseArray;
                    if (this.volume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.volume;
                    }
                    return baseArray;
                }
                case 100509913: {
                    Base[] baseArray;
                    if (this.issue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issue;
                    }
                    return baseArray;
                }
                case -1662473529: {
                    Base[] baseArray;
                    if (this.dateOfPublication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.dateOfPublication;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    this.citedMedium = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -810883302: {
                    this.volume = TypeConvertor.castToString(value);
                    return value;
                }
                case 100509913: {
                    this.issue = TypeConvertor.castToString(value);
                    return value;
                }
                case -1662473529: {
                    this.dateOfPublication = (CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("citedMedium")) {
                this.citedMedium = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("volume")) {
                this.volume = TypeConvertor.castToString(value);
            } else if (name.equals("issue")) {
                this.issue = TypeConvertor.castToString(value);
            } else if (name.equals("dateOfPublication")) {
                this.dateOfPublication = (CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    return this.getCitedMedium();
                }
                case -810883302: {
                    return this.getVolumeElement();
                }
                case 100509913: {
                    return this.getIssueElement();
                }
                case -1662473529: {
                    return this.getDateOfPublication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    return new String[]{"CodeableConcept"};
                }
                case -810883302: {
                    return new String[]{"string"};
                }
                case 100509913: {
                    return new String[]{"string"};
                }
                case -1662473529: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("citedMedium")) {
                this.citedMedium = new CodeableConcept();
                return this.citedMedium;
            }
            if (name.equals("volume")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.volume");
            }
            if (name.equals("issue")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.periodicRelease.issue");
            }
            if (name.equals("dateOfPublication")) {
                this.dateOfPublication = new CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent();
                return this.dateOfPublication;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent copy() {
            CitationCitedArtifactPublicationFormPeriodicReleaseComponent dst = new CitationCitedArtifactPublicationFormPeriodicReleaseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPublicationFormPeriodicReleaseComponent dst) {
            super.copyValues(dst);
            dst.citedMedium = this.citedMedium == null ? null : this.citedMedium.copy();
            dst.volume = this.volume == null ? null : this.volume.copy();
            dst.issue = this.issue == null ? null : this.issue.copy();
            dst.dateOfPublication = this.dateOfPublication == null ? null : this.dateOfPublication.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPeriodicReleaseComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPeriodicReleaseComponent o = (CitationCitedArtifactPublicationFormPeriodicReleaseComponent)other_;
            return CitationCitedArtifactPublicationFormPeriodicReleaseComponent.compareDeep(this.citedMedium, o.citedMedium, true) && CitationCitedArtifactPublicationFormPeriodicReleaseComponent.compareDeep(this.volume, o.volume, true) && CitationCitedArtifactPublicationFormPeriodicReleaseComponent.compareDeep(this.issue, o.issue, true) && CitationCitedArtifactPublicationFormPeriodicReleaseComponent.compareDeep(this.dateOfPublication, o.dateOfPublication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPeriodicReleaseComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPeriodicReleaseComponent o = (CitationCitedArtifactPublicationFormPeriodicReleaseComponent)other_;
            return CitationCitedArtifactPublicationFormPeriodicReleaseComponent.compareValues(this.volume, o.volume, true) && CitationCitedArtifactPublicationFormPeriodicReleaseComponent.compareValues(this.issue, o.issue, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.citedMedium, this.volume, this.issue, this.dateOfPublication);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.publicationForm.periodicRelease";
        }
    }

    @Block
    public static class CitationCitedArtifactPublicationFormPublishedInComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container (e.g. Periodical, database, or book)", formalDefinition="Kind of container (e.g. Periodical, database, or book).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/published-in-type")
        protected CodeableConcept type;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN", formalDefinition="Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN.")
        protected List<Identifier> identifier;
        @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the database or title of the book or journal", formalDefinition="Name of the database or title of the book or journal.")
        protected StringType title;
        @Child(name="publisher", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the publisher", formalDefinition="Name of the publisher.")
        protected Reference publisher;
        @Child(name="publisherLocation", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Geographic location of the publisher", formalDefinition="Geographic location of the publisher.")
        protected StringType publisherLocation;
        private static final long serialVersionUID = 1440066953L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setTitle(String value) {
            if (Utilities.noString(value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public Reference getPublisher() {
            if (this.publisher == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.publisher");
                }
                if (Configuration.doAutoCreate()) {
                    this.publisher = new Reference();
                }
            }
            return this.publisher;
        }

        public boolean hasPublisher() {
            return this.publisher != null && !this.publisher.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setPublisher(Reference value) {
            this.publisher = value;
            return this;
        }

        public StringType getPublisherLocationElement() {
            if (this.publisherLocation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.publisherLocation");
                }
                if (Configuration.doAutoCreate()) {
                    this.publisherLocation = new StringType();
                }
            }
            return this.publisherLocation;
        }

        public boolean hasPublisherLocationElement() {
            return this.publisherLocation != null && !this.publisherLocation.isEmpty();
        }

        public boolean hasPublisherLocation() {
            return this.publisherLocation != null && !this.publisherLocation.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setPublisherLocationElement(StringType value) {
            this.publisherLocation = value;
            return this;
        }

        public String getPublisherLocation() {
            return this.publisherLocation == null ? null : (String)this.publisherLocation.getValue();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setPublisherLocation(String value) {
            if (Utilities.noString(value)) {
                this.publisherLocation = null;
            } else {
                if (this.publisherLocation == null) {
                    this.publisherLocation = new StringType();
                }
                this.publisherLocation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Kind of container (e.g. Periodical, database, or book).", 0, 1, this.type));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property(Citation.SP_TITLE, "string", "Name of the database or title of the book or journal.", 0, 1, this.title));
            children.add(new Property(Citation.SP_PUBLISHER, "Reference(Organization)", "Name of the publisher.", 0, 1, this.publisher));
            children.add(new Property("publisherLocation", "string", "Geographic location of the publisher.", 0, 1, this.publisherLocation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Kind of container (e.g. Periodical, database, or book).", 0, 1, this.type);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 110371416: {
                    return new Property(Citation.SP_TITLE, "string", "Name of the database or title of the book or journal.", 0, 1, this.title);
                }
                case 1447404028: {
                    return new Property(Citation.SP_PUBLISHER, "Reference(Organization)", "Name of the publisher.", 0, 1, this.publisher);
                }
                case -1281627695: {
                    return new Property("publisherLocation", "string", "Geographic location of the publisher.", 0, 1, this.publisherLocation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case 1447404028: {
                    Base[] baseArray;
                    if (this.publisher == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.publisher;
                    }
                    return baseArray;
                }
                case -1281627695: {
                    Base[] baseArray;
                    if (this.publisherLocation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.publisherLocation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 1447404028: {
                    this.publisher = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1281627695: {
                    this.publisherLocation = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals(Citation.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = TypeConvertor.castToReference(value);
            } else if (name.equals("publisherLocation")) {
                this.publisherLocation = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case 1447404028: {
                    return this.getPublisher();
                }
                case -1281627695: {
                    return this.getPublisherLocationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case 1447404028: {
                    return new String[]{"Reference"};
                }
                case -1281627695: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals(Citation.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.publishedIn.title");
            }
            if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = new Reference();
                return this.publisher;
            }
            if (name.equals("publisherLocation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.publishedIn.publisherLocation");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPublicationFormPublishedInComponent copy() {
            CitationCitedArtifactPublicationFormPublishedInComponent dst = new CitationCitedArtifactPublicationFormPublishedInComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPublicationFormPublishedInComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i2 : this.identifier) {
                    dst.identifier.add(i2.copy());
                }
            }
            dst.title = this.title == null ? null : this.title.copy();
            dst.publisher = this.publisher == null ? null : this.publisher.copy();
            dst.publisherLocation = this.publisherLocation == null ? null : this.publisherLocation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPublishedInComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPublishedInComponent o = (CitationCitedArtifactPublicationFormPublishedInComponent)other_;
            return CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.identifier, o.identifier, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.title, o.title, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.publisher, o.publisher, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.publisherLocation, o.publisherLocation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPublishedInComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPublishedInComponent o = (CitationCitedArtifactPublicationFormPublishedInComponent)other_;
            return CitationCitedArtifactPublicationFormPublishedInComponent.compareValues(this.title, o.title, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareValues(this.publisherLocation, o.publisherLocation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.identifier, this.title, this.publisher, this.publisherLocation);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.publicationForm.publishedIn";
        }
    }

    @Block
    public static class CitationCitedArtifactPublicationFormComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="publishedIn", type={}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The collection the cited article or artifact is published in", formalDefinition="The collection the cited article or artifact is published in.")
        protected CitationCitedArtifactPublicationFormPublishedInComponent publishedIn;
        @Child(name="periodicRelease", type={}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific issue in which the cited article resides", formalDefinition="The specific issue in which the cited article resides.")
        protected CitationCitedArtifactPublicationFormPeriodicReleaseComponent periodicRelease;
        @Child(name="articleDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date the article was added to the database, or the date the article was released", formalDefinition="The date the article was added to the database, or the date the article was released (which may differ from the journal issue publication date).")
        protected DateTimeType articleDate;
        @Child(name="lastRevisionDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date the article was last revised or updated in the database", formalDefinition="The date the article was last revised or updated in the database.")
        protected DateTimeType lastRevisionDate;
        @Child(name="language", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Language in which this form of the article is published", formalDefinition="Language in which this form of the article is published.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected List<CodeableConcept> language;
        @Child(name="accessionNumber", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Entry number or identifier for inclusion in a database", formalDefinition="Entry number or identifier for inclusion in a database.")
        protected StringType accessionNumber;
        @Child(name="pageString", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for full display of pagination", formalDefinition="Used for full display of pagination.")
        protected StringType pageString;
        @Child(name="firstPage", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of first page", formalDefinition="Used for isolated representation of first page.")
        protected StringType firstPage;
        @Child(name="lastPage", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of last page", formalDefinition="Used for isolated representation of last page.")
        protected StringType lastPage;
        @Child(name="pageCount", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of pages or screens", formalDefinition="Actual or approximate number of pages or screens.")
        protected StringType pageCount;
        @Child(name="copyright", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Copyright notice for the full article or artifact", formalDefinition="Copyright notice for the full article or artifact.")
        protected MarkdownType copyright;
        private static final long serialVersionUID = -191740896L;

        public CitationCitedArtifactPublicationFormPublishedInComponent getPublishedIn() {
            if (this.publishedIn == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.publishedIn");
                }
                if (Configuration.doAutoCreate()) {
                    this.publishedIn = new CitationCitedArtifactPublicationFormPublishedInComponent();
                }
            }
            return this.publishedIn;
        }

        public boolean hasPublishedIn() {
            return this.publishedIn != null && !this.publishedIn.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPublishedIn(CitationCitedArtifactPublicationFormPublishedInComponent value) {
            this.publishedIn = value;
            return this;
        }

        public CitationCitedArtifactPublicationFormPeriodicReleaseComponent getPeriodicRelease() {
            if (this.periodicRelease == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.periodicRelease");
                }
                if (Configuration.doAutoCreate()) {
                    this.periodicRelease = new CitationCitedArtifactPublicationFormPeriodicReleaseComponent();
                }
            }
            return this.periodicRelease;
        }

        public boolean hasPeriodicRelease() {
            return this.periodicRelease != null && !this.periodicRelease.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPeriodicRelease(CitationCitedArtifactPublicationFormPeriodicReleaseComponent value) {
            this.periodicRelease = value;
            return this;
        }

        public DateTimeType getArticleDateElement() {
            if (this.articleDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.articleDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.articleDate = new DateTimeType();
                }
            }
            return this.articleDate;
        }

        public boolean hasArticleDateElement() {
            return this.articleDate != null && !this.articleDate.isEmpty();
        }

        public boolean hasArticleDate() {
            return this.articleDate != null && !this.articleDate.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setArticleDateElement(DateTimeType value) {
            this.articleDate = value;
            return this;
        }

        public Date getArticleDate() {
            return this.articleDate == null ? null : (Date)this.articleDate.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setArticleDate(Date value) {
            if (value == null) {
                this.articleDate = null;
            } else {
                if (this.articleDate == null) {
                    this.articleDate = new DateTimeType();
                }
                this.articleDate.setValue(value);
            }
            return this;
        }

        public DateTimeType getLastRevisionDateElement() {
            if (this.lastRevisionDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.lastRevisionDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastRevisionDate = new DateTimeType();
                }
            }
            return this.lastRevisionDate;
        }

        public boolean hasLastRevisionDateElement() {
            return this.lastRevisionDate != null && !this.lastRevisionDate.isEmpty();
        }

        public boolean hasLastRevisionDate() {
            return this.lastRevisionDate != null && !this.lastRevisionDate.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setLastRevisionDateElement(DateTimeType value) {
            this.lastRevisionDate = value;
            return this;
        }

        public Date getLastRevisionDate() {
            return this.lastRevisionDate == null ? null : (Date)this.lastRevisionDate.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setLastRevisionDate(Date value) {
            if (value == null) {
                this.lastRevisionDate = null;
            } else {
                if (this.lastRevisionDate == null) {
                    this.lastRevisionDate = new DateTimeType();
                }
                this.lastRevisionDate.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            return this.language;
        }

        public CitationCitedArtifactPublicationFormComponent setLanguage(List<CodeableConcept> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeableConcept item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLanguage() {
            CodeableConcept t = new CodeableConcept();
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return t;
        }

        public CitationCitedArtifactPublicationFormComponent addLanguage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return this;
        }

        public CodeableConcept getLanguageFirstRep() {
            if (this.getLanguage().isEmpty()) {
                this.addLanguage();
            }
            return this.getLanguage().get(0);
        }

        public StringType getAccessionNumberElement() {
            if (this.accessionNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.accessionNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.accessionNumber = new StringType();
                }
            }
            return this.accessionNumber;
        }

        public boolean hasAccessionNumberElement() {
            return this.accessionNumber != null && !this.accessionNumber.isEmpty();
        }

        public boolean hasAccessionNumber() {
            return this.accessionNumber != null && !this.accessionNumber.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setAccessionNumberElement(StringType value) {
            this.accessionNumber = value;
            return this;
        }

        public String getAccessionNumber() {
            return this.accessionNumber == null ? null : (String)this.accessionNumber.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setAccessionNumber(String value) {
            if (Utilities.noString(value)) {
                this.accessionNumber = null;
            } else {
                if (this.accessionNumber == null) {
                    this.accessionNumber = new StringType();
                }
                this.accessionNumber.setValue(value);
            }
            return this;
        }

        public StringType getPageStringElement() {
            if (this.pageString == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.pageString");
                }
                if (Configuration.doAutoCreate()) {
                    this.pageString = new StringType();
                }
            }
            return this.pageString;
        }

        public boolean hasPageStringElement() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public boolean hasPageString() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPageStringElement(StringType value) {
            this.pageString = value;
            return this;
        }

        public String getPageString() {
            return this.pageString == null ? null : (String)this.pageString.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setPageString(String value) {
            if (Utilities.noString(value)) {
                this.pageString = null;
            } else {
                if (this.pageString == null) {
                    this.pageString = new StringType();
                }
                this.pageString.setValue(value);
            }
            return this;
        }

        public StringType getFirstPageElement() {
            if (this.firstPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.firstPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstPage = new StringType();
                }
            }
            return this.firstPage;
        }

        public boolean hasFirstPageElement() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public boolean hasFirstPage() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setFirstPageElement(StringType value) {
            this.firstPage = value;
            return this;
        }

        public String getFirstPage() {
            return this.firstPage == null ? null : (String)this.firstPage.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setFirstPage(String value) {
            if (Utilities.noString(value)) {
                this.firstPage = null;
            } else {
                if (this.firstPage == null) {
                    this.firstPage = new StringType();
                }
                this.firstPage.setValue(value);
            }
            return this;
        }

        public StringType getLastPageElement() {
            if (this.lastPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.lastPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastPage = new StringType();
                }
            }
            return this.lastPage;
        }

        public boolean hasLastPageElement() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public boolean hasLastPage() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setLastPageElement(StringType value) {
            this.lastPage = value;
            return this;
        }

        public String getLastPage() {
            return this.lastPage == null ? null : (String)this.lastPage.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setLastPage(String value) {
            if (Utilities.noString(value)) {
                this.lastPage = null;
            } else {
                if (this.lastPage == null) {
                    this.lastPage = new StringType();
                }
                this.lastPage.setValue(value);
            }
            return this;
        }

        public StringType getPageCountElement() {
            if (this.pageCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.pageCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.pageCount = new StringType();
                }
            }
            return this.pageCount;
        }

        public boolean hasPageCountElement() {
            return this.pageCount != null && !this.pageCount.isEmpty();
        }

        public boolean hasPageCount() {
            return this.pageCount != null && !this.pageCount.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPageCountElement(StringType value) {
            this.pageCount = value;
            return this;
        }

        public String getPageCount() {
            return this.pageCount == null ? null : (String)this.pageCount.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setPageCount(String value) {
            if (Utilities.noString(value)) {
                this.pageCount = null;
            } else {
                if (this.pageCount == null) {
                    this.pageCount = new StringType();
                }
                this.pageCount.setValue(value);
            }
            return this;
        }

        public MarkdownType getCopyrightElement() {
            if (this.copyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.copyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.copyright = new MarkdownType();
                }
            }
            return this.copyright;
        }

        public boolean hasCopyrightElement() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public boolean hasCopyright() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setCopyrightElement(MarkdownType value) {
            this.copyright = value;
            return this;
        }

        public String getCopyright() {
            return this.copyright == null ? null : (String)this.copyright.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setCopyright(String value) {
            if (value == null) {
                this.copyright = null;
            } else {
                if (this.copyright == null) {
                    this.copyright = new MarkdownType();
                }
                this.copyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("publishedIn", "", "The collection the cited article or artifact is published in.", 0, 1, this.publishedIn));
            children.add(new Property("periodicRelease", "", "The specific issue in which the cited article resides.", 0, 1, this.periodicRelease));
            children.add(new Property("articleDate", "dateTime", "The date the article was added to the database, or the date the article was released (which may differ from the journal issue publication date).", 0, 1, this.articleDate));
            children.add(new Property("lastRevisionDate", "dateTime", "The date the article was last revised or updated in the database.", 0, 1, this.lastRevisionDate));
            children.add(new Property("language", "CodeableConcept", "Language in which this form of the article is published.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property("accessionNumber", "string", "Entry number or identifier for inclusion in a database.", 0, 1, this.accessionNumber));
            children.add(new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString));
            children.add(new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage));
            children.add(new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage));
            children.add(new Property("pageCount", "string", "Actual or approximate number of pages or screens.", 0, 1, this.pageCount));
            children.add(new Property("copyright", "markdown", "Copyright notice for the full article or artifact.", 0, 1, this.copyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -614144077: {
                    return new Property("publishedIn", "", "The collection the cited article or artifact is published in.", 0, 1, this.publishedIn);
                }
                case 1726878956: {
                    return new Property("periodicRelease", "", "The specific issue in which the cited article resides.", 0, 1, this.periodicRelease);
                }
                case 817743300: {
                    return new Property("articleDate", "dateTime", "The date the article was added to the database, or the date the article was released (which may differ from the journal issue publication date).", 0, 1, this.articleDate);
                }
                case 2129161183: {
                    return new Property("lastRevisionDate", "dateTime", "The date the article was last revised or updated in the database.", 0, 1, this.lastRevisionDate);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language in which this form of the article is published.", 0, Integer.MAX_VALUE, this.language);
                }
                case 1807963277: {
                    return new Property("accessionNumber", "string", "Entry number or identifier for inclusion in a database.", 0, 1, this.accessionNumber);
                }
                case 1287145344: {
                    return new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString);
                }
                case 132895071: {
                    return new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage);
                }
                case -1459540411: {
                    return new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage);
                }
                case 857882560: {
                    return new Property("pageCount", "string", "Actual or approximate number of pages or screens.", 0, 1, this.pageCount);
                }
                case 1522889671: {
                    return new Property("copyright", "markdown", "Copyright notice for the full article or artifact.", 0, 1, this.copyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    Base[] baseArray;
                    if (this.publishedIn == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.publishedIn;
                    }
                    return baseArray;
                }
                case 1726878956: {
                    Base[] baseArray;
                    if (this.periodicRelease == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.periodicRelease;
                    }
                    return baseArray;
                }
                case 817743300: {
                    Base[] baseArray;
                    if (this.articleDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.articleDate;
                    }
                    return baseArray;
                }
                case 2129161183: {
                    Base[] baseArray;
                    if (this.lastRevisionDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lastRevisionDate;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case 1807963277: {
                    Base[] baseArray;
                    if (this.accessionNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.accessionNumber;
                    }
                    return baseArray;
                }
                case 1287145344: {
                    Base[] baseArray;
                    if (this.pageString == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.pageString;
                    }
                    return baseArray;
                }
                case 132895071: {
                    Base[] baseArray;
                    if (this.firstPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.firstPage;
                    }
                    return baseArray;
                }
                case -1459540411: {
                    Base[] baseArray;
                    if (this.lastPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.lastPage;
                    }
                    return baseArray;
                }
                case 857882560: {
                    Base[] baseArray;
                    if (this.pageCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.pageCount;
                    }
                    return baseArray;
                }
                case 1522889671: {
                    Base[] baseArray;
                    if (this.copyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.copyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    this.publishedIn = (CitationCitedArtifactPublicationFormPublishedInComponent)value;
                    return value;
                }
                case 1726878956: {
                    this.periodicRelease = (CitationCitedArtifactPublicationFormPeriodicReleaseComponent)value;
                    return value;
                }
                case 817743300: {
                    this.articleDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 2129161183: {
                    this.lastRevisionDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1807963277: {
                    this.accessionNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case 1287145344: {
                    this.pageString = TypeConvertor.castToString(value);
                    return value;
                }
                case 132895071: {
                    this.firstPage = TypeConvertor.castToString(value);
                    return value;
                }
                case -1459540411: {
                    this.lastPage = TypeConvertor.castToString(value);
                    return value;
                }
                case 857882560: {
                    this.pageCount = TypeConvertor.castToString(value);
                    return value;
                }
                case 1522889671: {
                    this.copyright = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("publishedIn")) {
                this.publishedIn = (CitationCitedArtifactPublicationFormPublishedInComponent)value;
            } else if (name.equals("periodicRelease")) {
                this.periodicRelease = (CitationCitedArtifactPublicationFormPeriodicReleaseComponent)value;
            } else if (name.equals("articleDate")) {
                this.articleDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("lastRevisionDate")) {
                this.lastRevisionDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("accessionNumber")) {
                this.accessionNumber = TypeConvertor.castToString(value);
            } else if (name.equals("pageString")) {
                this.pageString = TypeConvertor.castToString(value);
            } else if (name.equals("firstPage")) {
                this.firstPage = TypeConvertor.castToString(value);
            } else if (name.equals("lastPage")) {
                this.lastPage = TypeConvertor.castToString(value);
            } else if (name.equals("pageCount")) {
                this.pageCount = TypeConvertor.castToString(value);
            } else if (name.equals("copyright")) {
                this.copyright = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    return this.getPublishedIn();
                }
                case 1726878956: {
                    return this.getPeriodicRelease();
                }
                case 817743300: {
                    return this.getArticleDateElement();
                }
                case 2129161183: {
                    return this.getLastRevisionDateElement();
                }
                case -1613589672: {
                    return this.addLanguage();
                }
                case 1807963277: {
                    return this.getAccessionNumberElement();
                }
                case 1287145344: {
                    return this.getPageStringElement();
                }
                case 132895071: {
                    return this.getFirstPageElement();
                }
                case -1459540411: {
                    return this.getLastPageElement();
                }
                case 857882560: {
                    return this.getPageCountElement();
                }
                case 1522889671: {
                    return this.getCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    return new String[0];
                }
                case 1726878956: {
                    return new String[0];
                }
                case 817743300: {
                    return new String[]{"dateTime"};
                }
                case 2129161183: {
                    return new String[]{"dateTime"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 1807963277: {
                    return new String[]{"string"};
                }
                case 1287145344: {
                    return new String[]{"string"};
                }
                case 132895071: {
                    return new String[]{"string"};
                }
                case -1459540411: {
                    return new String[]{"string"};
                }
                case 857882560: {
                    return new String[]{"string"};
                }
                case 1522889671: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("publishedIn")) {
                this.publishedIn = new CitationCitedArtifactPublicationFormPublishedInComponent();
                return this.publishedIn;
            }
            if (name.equals("periodicRelease")) {
                this.periodicRelease = new CitationCitedArtifactPublicationFormPeriodicReleaseComponent();
                return this.periodicRelease;
            }
            if (name.equals("articleDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.articleDate");
            }
            if (name.equals("lastRevisionDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.lastRevisionDate");
            }
            if (name.equals("language")) {
                return this.addLanguage();
            }
            if (name.equals("accessionNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.accessionNumber");
            }
            if (name.equals("pageString")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.pageString");
            }
            if (name.equals("firstPage")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.firstPage");
            }
            if (name.equals("lastPage")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.lastPage");
            }
            if (name.equals("pageCount")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.pageCount");
            }
            if (name.equals("copyright")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.publicationForm.copyright");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPublicationFormComponent copy() {
            CitationCitedArtifactPublicationFormComponent dst = new CitationCitedArtifactPublicationFormComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPublicationFormComponent dst) {
            super.copyValues(dst);
            dst.publishedIn = this.publishedIn == null ? null : this.publishedIn.copy();
            dst.periodicRelease = this.periodicRelease == null ? null : this.periodicRelease.copy();
            dst.articleDate = this.articleDate == null ? null : this.articleDate.copy();
            DateTimeType dateTimeType = dst.lastRevisionDate = this.lastRevisionDate == null ? null : this.lastRevisionDate.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.language) {
                    dst.language.add(i2.copy());
                }
            }
            dst.accessionNumber = this.accessionNumber == null ? null : this.accessionNumber.copy();
            dst.pageString = this.pageString == null ? null : this.pageString.copy();
            dst.firstPage = this.firstPage == null ? null : this.firstPage.copy();
            dst.lastPage = this.lastPage == null ? null : this.lastPage.copy();
            dst.pageCount = this.pageCount == null ? null : this.pageCount.copy();
            dst.copyright = this.copyright == null ? null : this.copyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormComponent o = (CitationCitedArtifactPublicationFormComponent)other_;
            return CitationCitedArtifactPublicationFormComponent.compareDeep(this.publishedIn, o.publishedIn, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.periodicRelease, o.periodicRelease, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.articleDate, o.articleDate, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.lastRevisionDate, o.lastRevisionDate, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.language, o.language, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.accessionNumber, o.accessionNumber, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.pageString, o.pageString, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.firstPage, o.firstPage, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.lastPage, o.lastPage, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.pageCount, o.pageCount, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.copyright, o.copyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormComponent o = (CitationCitedArtifactPublicationFormComponent)other_;
            return CitationCitedArtifactPublicationFormComponent.compareValues(this.articleDate, o.articleDate, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.lastRevisionDate, o.lastRevisionDate, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.accessionNumber, o.accessionNumber, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.pageString, o.pageString, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.firstPage, o.firstPage, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.lastPage, o.lastPage, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.pageCount, o.pageCount, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.copyright, o.copyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.publishedIn, this.periodicRelease, this.articleDate, this.lastRevisionDate, this.language, this.accessionNumber, this.pageString, this.firstPage, this.lastPage, this.pageCount, this.copyright);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.publicationForm";
        }
    }

    @Block
    public static class CitationCitedArtifactRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationshipType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the cited artifact resource relates to the target artifact", formalDefinition="How the cited artifact resource relates to the target artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-relationship-type")
        protected CodeableConcept relationshipType;
        @Child(name="targetClassifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The clasification of the related artifact", formalDefinition="The clasification of the related artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> targetClassifier;
        @Child(name="target", type={UriType.class, Identifier.class, Reference.class, Attachment.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The article or artifact that the cited artifact is related to", formalDefinition="The article or artifact that the cited artifact is related to.")
        protected DataType target;
        private static final long serialVersionUID = 819025047L;

        public CitationCitedArtifactRelatesToComponent() {
        }

        public CitationCitedArtifactRelatesToComponent(CodeableConcept relationshipType, DataType target) {
            this.setRelationshipType(relationshipType);
            this.setTarget(target);
        }

        public CodeableConcept getRelationshipType() {
            if (this.relationshipType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.relationshipType");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationshipType = new CodeableConcept();
                }
            }
            return this.relationshipType;
        }

        public boolean hasRelationshipType() {
            return this.relationshipType != null && !this.relationshipType.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setRelationshipType(CodeableConcept value) {
            this.relationshipType = value;
            return this;
        }

        public List<CodeableConcept> getTargetClassifier() {
            if (this.targetClassifier == null) {
                this.targetClassifier = new ArrayList<CodeableConcept>();
            }
            return this.targetClassifier;
        }

        public CitationCitedArtifactRelatesToComponent setTargetClassifier(List<CodeableConcept> theTargetClassifier) {
            this.targetClassifier = theTargetClassifier;
            return this;
        }

        public boolean hasTargetClassifier() {
            if (this.targetClassifier == null) {
                return false;
            }
            for (CodeableConcept item : this.targetClassifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTargetClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.targetClassifier == null) {
                this.targetClassifier = new ArrayList<CodeableConcept>();
            }
            this.targetClassifier.add(t);
            return t;
        }

        public CitationCitedArtifactRelatesToComponent addTargetClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.targetClassifier == null) {
                this.targetClassifier = new ArrayList<CodeableConcept>();
            }
            this.targetClassifier.add(t);
            return this;
        }

        public CodeableConcept getTargetClassifierFirstRep() {
            if (this.getTargetClassifier().isEmpty()) {
                this.addTargetClassifier();
            }
            return this.getTargetClassifier().get(0);
        }

        public DataType getTarget() {
            return this.target;
        }

        public UriType getTargetUriType() throws FHIRException {
            if (this.target == null) {
                this.target = new UriType();
            }
            if (!(this.target instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (UriType)this.target;
        }

        public boolean hasTargetUriType() {
            return this != null && this.target instanceof UriType;
        }

        public Identifier getTargetIdentifier() throws FHIRException {
            if (this.target == null) {
                this.target = new Identifier();
            }
            if (!(this.target instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Identifier)this.target;
        }

        public boolean hasTargetIdentifier() {
            return this != null && this.target instanceof Identifier;
        }

        public Reference getTargetReference() throws FHIRException {
            if (this.target == null) {
                this.target = new Reference();
            }
            if (!(this.target instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Reference)this.target;
        }

        public boolean hasTargetReference() {
            return this != null && this.target instanceof Reference;
        }

        public Attachment getTargetAttachment() throws FHIRException {
            if (this.target == null) {
                this.target = new Attachment();
            }
            if (!(this.target instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Attachment)this.target;
        }

        public boolean hasTargetAttachment() {
            return this != null && this.target instanceof Attachment;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setTarget(DataType value) {
            if (!(value == null || value instanceof UriType || value instanceof Identifier || value instanceof Reference || value instanceof Attachment)) {
                throw new Error("Not the right type for Citation.citedArtifact.relatesTo.target[x]: " + value.fhirType());
            }
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationshipType", "CodeableConcept", "How the cited artifact resource relates to the target artifact.", 0, 1, this.relationshipType));
            children.add(new Property("targetClassifier", "CodeableConcept", "The clasification of the related artifact.", 0, Integer.MAX_VALUE, this.targetClassifier));
            children.add(new Property("target[x]", "uri|Identifier|Reference(Any)|Attachment", "The article or artifact that the cited artifact is related to.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1602839150: {
                    return new Property("relationshipType", "CodeableConcept", "How the cited artifact resource relates to the target artifact.", 0, 1, this.relationshipType);
                }
                case -1267112302: {
                    return new Property("targetClassifier", "CodeableConcept", "The clasification of the related artifact.", 0, Integer.MAX_VALUE, this.targetClassifier);
                }
                case -815579825: {
                    return new Property("target[x]", "uri|Identifier|Reference(Any)|Attachment", "The article or artifact that the cited artifact is related to.", 0, 1, this.target);
                }
                case -880905839: {
                    return new Property("target[x]", "uri|Identifier|Reference(Any)|Attachment", "The article or artifact that the cited artifact is related to.", 0, 1, this.target);
                }
                case -815585765: {
                    return new Property("target[x]", "uri", "The article or artifact that the cited artifact is related to.", 0, 1, this.target);
                }
                case 1690892570: {
                    return new Property("target[x]", "Identifier", "The article or artifact that the cited artifact is related to.", 0, 1, this.target);
                }
                case 1259806906: {
                    return new Property("target[x]", "Reference(Any)", "The article or artifact that the cited artifact is related to.", 0, 1, this.target);
                }
                case 1345824148: {
                    return new Property("target[x]", "Attachment", "The article or artifact that the cited artifact is related to.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    Base[] baseArray;
                    if (this.relationshipType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationshipType;
                    }
                    return baseArray;
                }
                case -1267112302: {
                    return this.targetClassifier == null ? new Base[]{} : this.targetClassifier.toArray(new Base[this.targetClassifier.size()]);
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    this.relationshipType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1267112302: {
                    this.getTargetClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("targetClassifier")) {
                this.getTargetClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("target[x]")) {
                this.target = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    return this.getRelationshipType();
                }
                case -1267112302: {
                    return this.addTargetClassifier();
                }
                case -815579825: {
                    return this.getTarget();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    return new String[]{"CodeableConcept"};
                }
                case -1267112302: {
                    return new String[]{"CodeableConcept"};
                }
                case -880905839: {
                    return new String[]{"uri", "Identifier", "Reference", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = new CodeableConcept();
                return this.relationshipType;
            }
            if (name.equals("targetClassifier")) {
                return this.addTargetClassifier();
            }
            if (name.equals("targetUri")) {
                this.target = new UriType();
                return this.target;
            }
            if (name.equals("targetIdentifier")) {
                this.target = new Identifier();
                return this.target;
            }
            if (name.equals("targetReference")) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("targetAttachment")) {
                this.target = new Attachment();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactRelatesToComponent copy() {
            CitationCitedArtifactRelatesToComponent dst = new CitationCitedArtifactRelatesToComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactRelatesToComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.relationshipType = this.relationshipType == null ? null : this.relationshipType.copy();
            if (this.targetClassifier != null) {
                dst.targetClassifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.targetClassifier) {
                    dst.targetClassifier.add(i2.copy());
                }
            }
            dst.target = this.target == null ? null : this.target.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactRelatesToComponent)) {
                return false;
            }
            CitationCitedArtifactRelatesToComponent o = (CitationCitedArtifactRelatesToComponent)other_;
            return CitationCitedArtifactRelatesToComponent.compareDeep(this.relationshipType, o.relationshipType, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.targetClassifier, o.targetClassifier, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactRelatesToComponent)) {
                return false;
            }
            CitationCitedArtifactRelatesToComponent o = (CitationCitedArtifactRelatesToComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.relationshipType, this.targetClassifier, this.target);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.relatesTo";
        }
    }

    @Block
    public static class CitationCitedArtifactPartComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of component", formalDefinition="The kind of component.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-part-type")
        protected CodeableConcept type;
        @Child(name="value", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specification of the component", formalDefinition="The specification of the component.")
        protected StringType value;
        @Child(name="baseCitation", type={Citation.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The citation for the full article or artifact", formalDefinition="The citation for the full article or artifact.")
        protected Reference baseCitation;
        private static final long serialVersionUID = -765350500L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPartComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactPartComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPartComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationCitedArtifactPartComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationCitedArtifactPartComponent setValue(String value) {
            if (Utilities.noString(value)) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public Reference getBaseCitation() {
            if (this.baseCitation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPartComponent.baseCitation");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseCitation = new Reference();
                }
            }
            return this.baseCitation;
        }

        public boolean hasBaseCitation() {
            return this.baseCitation != null && !this.baseCitation.isEmpty();
        }

        public CitationCitedArtifactPartComponent setBaseCitation(Reference value) {
            this.baseCitation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of component.", 0, 1, this.type));
            children.add(new Property("value", "string", "The specification of the component.", 0, 1, this.value));
            children.add(new Property("baseCitation", "Reference(Citation)", "The citation for the full article or artifact.", 0, 1, this.baseCitation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of component.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "string", "The specification of the component.", 0, 1, this.value);
                }
                case 1182995672: {
                    return new Property("baseCitation", "Reference(Citation)", "The citation for the full article or artifact.", 0, 1, this.baseCitation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 1182995672: {
                    Base[] baseArray;
                    if (this.baseCitation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.baseCitation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 1182995672: {
                    this.baseCitation = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("baseCitation")) {
                this.baseCitation = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case 1182995672: {
                    return this.getBaseCitation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case 1182995672: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.part.value");
            }
            if (name.equals("baseCitation")) {
                this.baseCitation = new Reference();
                return this.baseCitation;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPartComponent copy() {
            CitationCitedArtifactPartComponent dst = new CitationCitedArtifactPartComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPartComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.baseCitation = this.baseCitation == null ? null : this.baseCitation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPartComponent)) {
                return false;
            }
            CitationCitedArtifactPartComponent o = (CitationCitedArtifactPartComponent)other_;
            return CitationCitedArtifactPartComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactPartComponent.compareDeep(this.value, o.value, true) && CitationCitedArtifactPartComponent.compareDeep(this.baseCitation, o.baseCitation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPartComponent)) {
                return false;
            }
            CitationCitedArtifactPartComponent o = (CitationCitedArtifactPartComponent)other_;
            return CitationCitedArtifactPartComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value, this.baseCitation);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.part";
        }
    }

    @Block
    public static class CitationCitedArtifactAbstractComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of abstract", formalDefinition="Used to express the reason or specific aspect for the abstract.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-abstract-type")
        protected CodeableConcept type;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the specific language", formalDefinition="Used to express the specific language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="text", type={MarkdownType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Abstract content", formalDefinition="Abstract content.")
        protected MarkdownType text;
        @Child(name="copyright", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Copyright notice for the abstract", formalDefinition="Copyright notice for the abstract.")
        protected MarkdownType copyright;
        private static final long serialVersionUID = -1882363442L;

        public CitationCitedArtifactAbstractComponent() {
        }

        public CitationCitedArtifactAbstractComponent(String text) {
            this.setText(text);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public MarkdownType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new MarkdownType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setTextElement(MarkdownType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public CitationCitedArtifactAbstractComponent setText(String value) {
            if (this.text == null) {
                this.text = new MarkdownType();
            }
            this.text.setValue(value);
            return this;
        }

        public MarkdownType getCopyrightElement() {
            if (this.copyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.copyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.copyright = new MarkdownType();
                }
            }
            return this.copyright;
        }

        public boolean hasCopyrightElement() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public boolean hasCopyright() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setCopyrightElement(MarkdownType value) {
            this.copyright = value;
            return this;
        }

        public String getCopyright() {
            return this.copyright == null ? null : (String)this.copyright.getValue();
        }

        public CitationCitedArtifactAbstractComponent setCopyright(String value) {
            if (value == null) {
                this.copyright = null;
            } else {
                if (this.copyright == null) {
                    this.copyright = new MarkdownType();
                }
                this.copyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the reason or specific aspect for the abstract.", 0, 1, this.type));
            children.add(new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language));
            children.add(new Property("text", "markdown", "Abstract content.", 0, 1, this.text));
            children.add(new Property("copyright", "markdown", "Copyright notice for the abstract.", 0, 1, this.copyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the reason or specific aspect for the abstract.", 0, 1, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language);
                }
                case 3556653: {
                    return new Property("text", "markdown", "Abstract content.", 0, 1, this.text);
                }
                case 1522889671: {
                    return new Property("copyright", "markdown", "Copyright notice for the abstract.", 0, 1, this.copyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case 1522889671: {
                    Base[] baseArray;
                    if (this.copyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.copyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 1522889671: {
                    this.copyright = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("copyright")) {
                this.copyright = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case 1522889671: {
                    return this.getCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"markdown"};
                }
                case 1522889671: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.abstract.text");
            }
            if (name.equals("copyright")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.abstract.copyright");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactAbstractComponent copy() {
            CitationCitedArtifactAbstractComponent dst = new CitationCitedArtifactAbstractComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactAbstractComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.copyright = this.copyright == null ? null : this.copyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactAbstractComponent)) {
                return false;
            }
            CitationCitedArtifactAbstractComponent o = (CitationCitedArtifactAbstractComponent)other_;
            return CitationCitedArtifactAbstractComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactAbstractComponent.compareDeep(this.language, o.language, true) && CitationCitedArtifactAbstractComponent.compareDeep(this.text, o.text, true) && CitationCitedArtifactAbstractComponent.compareDeep(this.copyright, o.copyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactAbstractComponent)) {
                return false;
            }
            CitationCitedArtifactAbstractComponent o = (CitationCitedArtifactAbstractComponent)other_;
            return CitationCitedArtifactAbstractComponent.compareValues(this.text, o.text, true) && CitationCitedArtifactAbstractComponent.compareValues(this.copyright, o.copyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.language, this.text, this.copyright);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.abstract";
        }
    }

    @Block
    public static class CitationCitedArtifactTitleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of title", formalDefinition="Used to express the reason or specific aspect for the title.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/title-type")
        protected CodeableConcept type;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the specific language", formalDefinition="Used to express the specific language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="text", type={MarkdownType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The title of the article or artifact", formalDefinition="The title of the article or artifact.")
        protected MarkdownType text;
        private static final long serialVersionUID = 10089224L;

        public CitationCitedArtifactTitleComponent() {
        }

        public CitationCitedArtifactTitleComponent(String text) {
            this.setText(text);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactTitleComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactTitleComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactTitleComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationCitedArtifactTitleComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public MarkdownType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactTitleComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new MarkdownType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public CitationCitedArtifactTitleComponent setTextElement(MarkdownType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public CitationCitedArtifactTitleComponent setText(String value) {
            if (this.text == null) {
                this.text = new MarkdownType();
            }
            this.text.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the reason or specific aspect for the title.", 0, 1, this.type));
            children.add(new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language));
            children.add(new Property("text", "markdown", "The title of the article or artifact.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the reason or specific aspect for the title.", 0, 1, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language);
                }
                case 3556653: {
                    return new Property("text", "markdown", "The title of the article or artifact.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.title.text");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactTitleComponent copy() {
            CitationCitedArtifactTitleComponent dst = new CitationCitedArtifactTitleComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactTitleComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactTitleComponent)) {
                return false;
            }
            CitationCitedArtifactTitleComponent o = (CitationCitedArtifactTitleComponent)other_;
            return CitationCitedArtifactTitleComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactTitleComponent.compareDeep(this.language, o.language, true) && CitationCitedArtifactTitleComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactTitleComponent)) {
                return false;
            }
            CitationCitedArtifactTitleComponent o = (CitationCitedArtifactTitleComponent)other_;
            return CitationCitedArtifactTitleComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.language, this.text);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.title";
        }
    }

    @Block
    public static class CitationCitedArtifactStatusDateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="activity", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of the status", formalDefinition="Classification of the status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-status-type")
        protected CodeableConcept activity;
        @Child(name="actual", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Either occurred or expected", formalDefinition="Either occurred or expected.")
        protected BooleanType actual;
        @Child(name="period", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the status started and/or ended", formalDefinition="When the status started and/or ended.")
        protected Period period;
        private static final long serialVersionUID = 1123586924L;

        public CitationCitedArtifactStatusDateComponent() {
        }

        public CitationCitedArtifactStatusDateComponent(CodeableConcept activity, Period period) {
            this.setActivity(activity);
            this.setPeriod(period);
        }

        public CodeableConcept getActivity() {
            if (this.activity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactStatusDateComponent.activity");
                }
                if (Configuration.doAutoCreate()) {
                    this.activity = new CodeableConcept();
                }
            }
            return this.activity;
        }

        public boolean hasActivity() {
            return this.activity != null && !this.activity.isEmpty();
        }

        public CitationCitedArtifactStatusDateComponent setActivity(CodeableConcept value) {
            this.activity = value;
            return this;
        }

        public BooleanType getActualElement() {
            if (this.actual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactStatusDateComponent.actual");
                }
                if (Configuration.doAutoCreate()) {
                    this.actual = new BooleanType();
                }
            }
            return this.actual;
        }

        public boolean hasActualElement() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public boolean hasActual() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public CitationCitedArtifactStatusDateComponent setActualElement(BooleanType value) {
            this.actual = value;
            return this;
        }

        public boolean getActual() {
            return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
        }

        public CitationCitedArtifactStatusDateComponent setActual(boolean value) {
            if (this.actual == null) {
                this.actual = new BooleanType();
            }
            this.actual.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactStatusDateComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CitationCitedArtifactStatusDateComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("activity", "CodeableConcept", "Classification of the status.", 0, 1, this.activity));
            children.add(new Property("actual", "boolean", "Either occurred or expected.", 0, 1, this.actual));
            children.add(new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1655966961: {
                    return new Property("activity", "CodeableConcept", "Classification of the status.", 0, 1, this.activity);
                }
                case -1422939762: {
                    return new Property("actual", "boolean", "Either occurred or expected.", 0, 1, this.actual);
                }
                case -991726143: {
                    return new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    Base[] baseArray;
                    if (this.activity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.activity;
                    }
                    return baseArray;
                }
                case -1422939762: {
                    Base[] baseArray;
                    if (this.actual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actual;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    this.activity = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1422939762: {
                    this.actual = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actual")) {
                this.actual = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return this.getActivity();
                }
                case -1422939762: {
                    return this.getActualElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return new String[]{"CodeableConcept"};
                }
                case -1422939762: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = new CodeableConcept();
                return this.activity;
            }
            if (name.equals("actual")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.statusDate.actual");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactStatusDateComponent copy() {
            CitationCitedArtifactStatusDateComponent dst = new CitationCitedArtifactStatusDateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactStatusDateComponent dst) {
            super.copyValues(dst);
            dst.activity = this.activity == null ? null : this.activity.copy();
            dst.actual = this.actual == null ? null : this.actual.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactStatusDateComponent)) {
                return false;
            }
            CitationCitedArtifactStatusDateComponent o = (CitationCitedArtifactStatusDateComponent)other_;
            return CitationCitedArtifactStatusDateComponent.compareDeep(this.activity, o.activity, true) && CitationCitedArtifactStatusDateComponent.compareDeep(this.actual, o.actual, true) && CitationCitedArtifactStatusDateComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactStatusDateComponent)) {
                return false;
            }
            CitationCitedArtifactStatusDateComponent o = (CitationCitedArtifactStatusDateComponent)other_;
            return CitationCitedArtifactStatusDateComponent.compareValues(this.actual, o.actual, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.activity, this.actual, this.period);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.statusDate";
        }
    }

    @Block
    public static class CitationCitedArtifactVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version number or other version identifier", formalDefinition="The version number or other version identifier.")
        protected StringType value;
        @Child(name="baseCitation", type={Citation.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Citation for the main version of the cited artifact", formalDefinition="Citation for the main version of the cited artifact.")
        protected Reference baseCitation;
        private static final long serialVersionUID = 1437090319L;

        public CitationCitedArtifactVersionComponent() {
        }

        public CitationCitedArtifactVersionComponent(String value) {
            this.setValue(value);
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactVersionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationCitedArtifactVersionComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationCitedArtifactVersionComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public Reference getBaseCitation() {
            if (this.baseCitation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactVersionComponent.baseCitation");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseCitation = new Reference();
                }
            }
            return this.baseCitation;
        }

        public boolean hasBaseCitation() {
            return this.baseCitation != null && !this.baseCitation.isEmpty();
        }

        public CitationCitedArtifactVersionComponent setBaseCitation(Reference value) {
            this.baseCitation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value", "string", "The version number or other version identifier.", 0, 1, this.value));
            children.add(new Property("baseCitation", "Reference(Citation)", "Citation for the main version of the cited artifact.", 0, 1, this.baseCitation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 111972721: {
                    return new Property("value", "string", "The version number or other version identifier.", 0, 1, this.value);
                }
                case 1182995672: {
                    return new Property("baseCitation", "Reference(Citation)", "Citation for the main version of the cited artifact.", 0, 1, this.baseCitation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 1182995672: {
                    Base[] baseArray;
                    if (this.baseCitation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.baseCitation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 1182995672: {
                    this.baseCitation = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("baseCitation")) {
                this.baseCitation = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return this.getValueElement();
                }
                case 1182995672: {
                    return this.getBaseCitation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"string"};
                }
                case 1182995672: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.version.value");
            }
            if (name.equals("baseCitation")) {
                this.baseCitation = new Reference();
                return this.baseCitation;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactVersionComponent copy() {
            CitationCitedArtifactVersionComponent dst = new CitationCitedArtifactVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactVersionComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            dst.baseCitation = this.baseCitation == null ? null : this.baseCitation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactVersionComponent)) {
                return false;
            }
            CitationCitedArtifactVersionComponent o = (CitationCitedArtifactVersionComponent)other_;
            return CitationCitedArtifactVersionComponent.compareDeep(this.value, o.value, true) && CitationCitedArtifactVersionComponent.compareDeep(this.baseCitation, o.baseCitation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactVersionComponent)) {
                return false;
            }
            CitationCitedArtifactVersionComponent o = (CitationCitedArtifactVersionComponent)other_;
            return CitationCitedArtifactVersionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.value, this.baseCitation);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.version";
        }
    }

    @Block
    public static class CitationCitedArtifactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="May include DOI, PMID, PMCID, etc.", formalDefinition="A formal identifier that is used to identify this citation when it is represented in other formats, or referenced in a specification, model, design or an instance.")
        protected List<Identifier> identifier;
        @Child(name="relatedIdentifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="May include trial registry identifiers", formalDefinition="A formal identifier that is used to identify things closely related to this citation.")
        protected List<Identifier> relatedIdentifier;
        @Child(name="dateAccessed", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the cited artifact was accessed", formalDefinition="When the cited artifact was accessed.")
        protected DateTimeType dateAccessed;
        @Child(name="version", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The defined version of the cited artifact", formalDefinition="The defined version of the cited artifact.")
        protected CitationCitedArtifactVersionComponent version;
        @Child(name="currentState", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The status of the cited artifact", formalDefinition="The status of the cited artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-status-type")
        protected List<CodeableConcept> currentState;
        @Child(name="statusDate", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An effective date or period for a status of the cited artifact", formalDefinition="An effective date or period for a status of the cited artifact.")
        protected List<CitationCitedArtifactStatusDateComponent> statusDate;
        @Child(name="title", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The title details of the article or artifact", formalDefinition="The title details of the article or artifact.")
        protected List<CitationCitedArtifactTitleComponent> title;
        @Child(name="abstract", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Summary of the article or artifact", formalDefinition="Summary of the article or artifact.")
        protected List<CitationCitedArtifactAbstractComponent> abstract_;
        @Child(name="part", type={}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The component of the article or artifact", formalDefinition="The component of the article or artifact.")
        protected CitationCitedArtifactPartComponent part;
        @Child(name="relatesTo", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The artifact related to the cited artifact", formalDefinition="The artifact related to the cited artifact.")
        protected List<CitationCitedArtifactRelatesToComponent> relatesTo;
        @Child(name="publicationForm", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="If multiple, used to represent alternative forms of the article that are not separate citations", formalDefinition="If multiple, used to represent alternative forms of the article that are not separate citations.")
        protected List<CitationCitedArtifactPublicationFormComponent> publicationForm;
        @Child(name="webLocation", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for any URL for the article or artifact cited", formalDefinition="Used for any URL for the article or artifact cited.")
        protected List<CitationCitedArtifactWebLocationComponent> webLocation;
        @Child(name="classification", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The assignment to an organizing scheme", formalDefinition="The assignment to an organizing scheme.")
        protected List<CitationCitedArtifactClassificationComponent> classification;
        @Child(name="contributorship", type={}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Attribution of authors and other contributors", formalDefinition="This element is used to list authors and other contributors, their contact information, specific contributions, and summary statements.")
        protected CitationCitedArtifactContributorshipComponent contributorship;
        @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Any additional information or content for the article or artifact", formalDefinition="Any additional information or content for the article or artifact.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -1685890486L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationCitedArtifactComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<Identifier> getRelatedIdentifier() {
            if (this.relatedIdentifier == null) {
                this.relatedIdentifier = new ArrayList<Identifier>();
            }
            return this.relatedIdentifier;
        }

        public CitationCitedArtifactComponent setRelatedIdentifier(List<Identifier> theRelatedIdentifier) {
            this.relatedIdentifier = theRelatedIdentifier;
            return this;
        }

        public boolean hasRelatedIdentifier() {
            if (this.relatedIdentifier == null) {
                return false;
            }
            for (Identifier item : this.relatedIdentifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addRelatedIdentifier() {
            Identifier t = new Identifier();
            if (this.relatedIdentifier == null) {
                this.relatedIdentifier = new ArrayList<Identifier>();
            }
            this.relatedIdentifier.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addRelatedIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.relatedIdentifier == null) {
                this.relatedIdentifier = new ArrayList<Identifier>();
            }
            this.relatedIdentifier.add(t);
            return this;
        }

        public Identifier getRelatedIdentifierFirstRep() {
            if (this.getRelatedIdentifier().isEmpty()) {
                this.addRelatedIdentifier();
            }
            return this.getRelatedIdentifier().get(0);
        }

        public DateTimeType getDateAccessedElement() {
            if (this.dateAccessed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.dateAccessed");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateAccessed = new DateTimeType();
                }
            }
            return this.dateAccessed;
        }

        public boolean hasDateAccessedElement() {
            return this.dateAccessed != null && !this.dateAccessed.isEmpty();
        }

        public boolean hasDateAccessed() {
            return this.dateAccessed != null && !this.dateAccessed.isEmpty();
        }

        public CitationCitedArtifactComponent setDateAccessedElement(DateTimeType value) {
            this.dateAccessed = value;
            return this;
        }

        public Date getDateAccessed() {
            return this.dateAccessed == null ? null : (Date)this.dateAccessed.getValue();
        }

        public CitationCitedArtifactComponent setDateAccessed(Date value) {
            if (value == null) {
                this.dateAccessed = null;
            } else {
                if (this.dateAccessed == null) {
                    this.dateAccessed = new DateTimeType();
                }
                this.dateAccessed.setValue(value);
            }
            return this;
        }

        public CitationCitedArtifactVersionComponent getVersion() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new CitationCitedArtifactVersionComponent();
                }
            }
            return this.version;
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public CitationCitedArtifactComponent setVersion(CitationCitedArtifactVersionComponent value) {
            this.version = value;
            return this;
        }

        public List<CodeableConcept> getCurrentState() {
            if (this.currentState == null) {
                this.currentState = new ArrayList<CodeableConcept>();
            }
            return this.currentState;
        }

        public CitationCitedArtifactComponent setCurrentState(List<CodeableConcept> theCurrentState) {
            this.currentState = theCurrentState;
            return this;
        }

        public boolean hasCurrentState() {
            if (this.currentState == null) {
                return false;
            }
            for (CodeableConcept item : this.currentState) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCurrentState() {
            CodeableConcept t = new CodeableConcept();
            if (this.currentState == null) {
                this.currentState = new ArrayList<CodeableConcept>();
            }
            this.currentState.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addCurrentState(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.currentState == null) {
                this.currentState = new ArrayList<CodeableConcept>();
            }
            this.currentState.add(t);
            return this;
        }

        public CodeableConcept getCurrentStateFirstRep() {
            if (this.getCurrentState().isEmpty()) {
                this.addCurrentState();
            }
            return this.getCurrentState().get(0);
        }

        public List<CitationCitedArtifactStatusDateComponent> getStatusDate() {
            if (this.statusDate == null) {
                this.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
            }
            return this.statusDate;
        }

        public CitationCitedArtifactComponent setStatusDate(List<CitationCitedArtifactStatusDateComponent> theStatusDate) {
            this.statusDate = theStatusDate;
            return this;
        }

        public boolean hasStatusDate() {
            if (this.statusDate == null) {
                return false;
            }
            for (CitationCitedArtifactStatusDateComponent item : this.statusDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactStatusDateComponent addStatusDate() {
            CitationCitedArtifactStatusDateComponent t = new CitationCitedArtifactStatusDateComponent();
            if (this.statusDate == null) {
                this.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
            }
            this.statusDate.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addStatusDate(CitationCitedArtifactStatusDateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.statusDate == null) {
                this.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
            }
            this.statusDate.add(t);
            return this;
        }

        public CitationCitedArtifactStatusDateComponent getStatusDateFirstRep() {
            if (this.getStatusDate().isEmpty()) {
                this.addStatusDate();
            }
            return this.getStatusDate().get(0);
        }

        public List<CitationCitedArtifactTitleComponent> getTitle() {
            if (this.title == null) {
                this.title = new ArrayList<CitationCitedArtifactTitleComponent>();
            }
            return this.title;
        }

        public CitationCitedArtifactComponent setTitle(List<CitationCitedArtifactTitleComponent> theTitle) {
            this.title = theTitle;
            return this;
        }

        public boolean hasTitle() {
            if (this.title == null) {
                return false;
            }
            for (CitationCitedArtifactTitleComponent item : this.title) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactTitleComponent addTitle() {
            CitationCitedArtifactTitleComponent t = new CitationCitedArtifactTitleComponent();
            if (this.title == null) {
                this.title = new ArrayList<CitationCitedArtifactTitleComponent>();
            }
            this.title.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addTitle(CitationCitedArtifactTitleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.title == null) {
                this.title = new ArrayList<CitationCitedArtifactTitleComponent>();
            }
            this.title.add(t);
            return this;
        }

        public CitationCitedArtifactTitleComponent getTitleFirstRep() {
            if (this.getTitle().isEmpty()) {
                this.addTitle();
            }
            return this.getTitle().get(0);
        }

        public List<CitationCitedArtifactAbstractComponent> getAbstract() {
            if (this.abstract_ == null) {
                this.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
            }
            return this.abstract_;
        }

        public CitationCitedArtifactComponent setAbstract(List<CitationCitedArtifactAbstractComponent> theAbstract) {
            this.abstract_ = theAbstract;
            return this;
        }

        public boolean hasAbstract() {
            if (this.abstract_ == null) {
                return false;
            }
            for (CitationCitedArtifactAbstractComponent item : this.abstract_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactAbstractComponent addAbstract() {
            CitationCitedArtifactAbstractComponent t = new CitationCitedArtifactAbstractComponent();
            if (this.abstract_ == null) {
                this.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
            }
            this.abstract_.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addAbstract(CitationCitedArtifactAbstractComponent t) {
            if (t == null) {
                return this;
            }
            if (this.abstract_ == null) {
                this.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
            }
            this.abstract_.add(t);
            return this;
        }

        public CitationCitedArtifactAbstractComponent getAbstractFirstRep() {
            if (this.getAbstract().isEmpty()) {
                this.addAbstract();
            }
            return this.getAbstract().get(0);
        }

        public CitationCitedArtifactPartComponent getPart() {
            if (this.part == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.part");
                }
                if (Configuration.doAutoCreate()) {
                    this.part = new CitationCitedArtifactPartComponent();
                }
            }
            return this.part;
        }

        public boolean hasPart() {
            return this.part != null && !this.part.isEmpty();
        }

        public CitationCitedArtifactComponent setPart(CitationCitedArtifactPartComponent value) {
            this.part = value;
            return this;
        }

        public List<CitationCitedArtifactRelatesToComponent> getRelatesTo() {
            if (this.relatesTo == null) {
                this.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
            }
            return this.relatesTo;
        }

        public CitationCitedArtifactComponent setRelatesTo(List<CitationCitedArtifactRelatesToComponent> theRelatesTo) {
            this.relatesTo = theRelatesTo;
            return this;
        }

        public boolean hasRelatesTo() {
            if (this.relatesTo == null) {
                return false;
            }
            for (CitationCitedArtifactRelatesToComponent item : this.relatesTo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactRelatesToComponent addRelatesTo() {
            CitationCitedArtifactRelatesToComponent t = new CitationCitedArtifactRelatesToComponent();
            if (this.relatesTo == null) {
                this.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
            }
            this.relatesTo.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addRelatesTo(CitationCitedArtifactRelatesToComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatesTo == null) {
                this.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
            }
            this.relatesTo.add(t);
            return this;
        }

        public CitationCitedArtifactRelatesToComponent getRelatesToFirstRep() {
            if (this.getRelatesTo().isEmpty()) {
                this.addRelatesTo();
            }
            return this.getRelatesTo().get(0);
        }

        public List<CitationCitedArtifactPublicationFormComponent> getPublicationForm() {
            if (this.publicationForm == null) {
                this.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
            }
            return this.publicationForm;
        }

        public CitationCitedArtifactComponent setPublicationForm(List<CitationCitedArtifactPublicationFormComponent> thePublicationForm) {
            this.publicationForm = thePublicationForm;
            return this;
        }

        public boolean hasPublicationForm() {
            if (this.publicationForm == null) {
                return false;
            }
            for (CitationCitedArtifactPublicationFormComponent item : this.publicationForm) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactPublicationFormComponent addPublicationForm() {
            CitationCitedArtifactPublicationFormComponent t = new CitationCitedArtifactPublicationFormComponent();
            if (this.publicationForm == null) {
                this.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
            }
            this.publicationForm.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addPublicationForm(CitationCitedArtifactPublicationFormComponent t) {
            if (t == null) {
                return this;
            }
            if (this.publicationForm == null) {
                this.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
            }
            this.publicationForm.add(t);
            return this;
        }

        public CitationCitedArtifactPublicationFormComponent getPublicationFormFirstRep() {
            if (this.getPublicationForm().isEmpty()) {
                this.addPublicationForm();
            }
            return this.getPublicationForm().get(0);
        }

        public List<CitationCitedArtifactWebLocationComponent> getWebLocation() {
            if (this.webLocation == null) {
                this.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
            }
            return this.webLocation;
        }

        public CitationCitedArtifactComponent setWebLocation(List<CitationCitedArtifactWebLocationComponent> theWebLocation) {
            this.webLocation = theWebLocation;
            return this;
        }

        public boolean hasWebLocation() {
            if (this.webLocation == null) {
                return false;
            }
            for (CitationCitedArtifactWebLocationComponent item : this.webLocation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactWebLocationComponent addWebLocation() {
            CitationCitedArtifactWebLocationComponent t = new CitationCitedArtifactWebLocationComponent();
            if (this.webLocation == null) {
                this.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
            }
            this.webLocation.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addWebLocation(CitationCitedArtifactWebLocationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.webLocation == null) {
                this.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
            }
            this.webLocation.add(t);
            return this;
        }

        public CitationCitedArtifactWebLocationComponent getWebLocationFirstRep() {
            if (this.getWebLocation().isEmpty()) {
                this.addWebLocation();
            }
            return this.getWebLocation().get(0);
        }

        public List<CitationCitedArtifactClassificationComponent> getClassification() {
            if (this.classification == null) {
                this.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
            }
            return this.classification;
        }

        public CitationCitedArtifactComponent setClassification(List<CitationCitedArtifactClassificationComponent> theClassification) {
            this.classification = theClassification;
            return this;
        }

        public boolean hasClassification() {
            if (this.classification == null) {
                return false;
            }
            for (CitationCitedArtifactClassificationComponent item : this.classification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactClassificationComponent addClassification() {
            CitationCitedArtifactClassificationComponent t = new CitationCitedArtifactClassificationComponent();
            if (this.classification == null) {
                this.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
            }
            this.classification.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addClassification(CitationCitedArtifactClassificationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.classification == null) {
                this.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
            }
            this.classification.add(t);
            return this;
        }

        public CitationCitedArtifactClassificationComponent getClassificationFirstRep() {
            if (this.getClassification().isEmpty()) {
                this.addClassification();
            }
            return this.getClassification().get(0);
        }

        public CitationCitedArtifactContributorshipComponent getContributorship() {
            if (this.contributorship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.contributorship");
                }
                if (Configuration.doAutoCreate()) {
                    this.contributorship = new CitationCitedArtifactContributorshipComponent();
                }
            }
            return this.contributorship;
        }

        public boolean hasContributorship() {
            return this.contributorship != null && !this.contributorship.isEmpty();
        }

        public CitationCitedArtifactComponent setContributorship(CitationCitedArtifactContributorshipComponent value) {
            this.contributorship = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public CitationCitedArtifactComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this citation when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("relatedIdentifier", "Identifier", "A formal identifier that is used to identify things closely related to this citation.", 0, Integer.MAX_VALUE, this.relatedIdentifier));
            children.add(new Property("dateAccessed", "dateTime", "When the cited artifact was accessed.", 0, 1, this.dateAccessed));
            children.add(new Property(Citation.SP_VERSION, "", "The defined version of the cited artifact.", 0, 1, this.version));
            children.add(new Property("currentState", "CodeableConcept", "The status of the cited artifact.", 0, Integer.MAX_VALUE, this.currentState));
            children.add(new Property("statusDate", "", "An effective date or period for a status of the cited artifact.", 0, Integer.MAX_VALUE, this.statusDate));
            children.add(new Property(Citation.SP_TITLE, "", "The title details of the article or artifact.", 0, Integer.MAX_VALUE, this.title));
            children.add(new Property("abstract", "", "Summary of the article or artifact.", 0, Integer.MAX_VALUE, this.abstract_));
            children.add(new Property("part", "", "The component of the article or artifact.", 0, 1, this.part));
            children.add(new Property("relatesTo", "", "The artifact related to the cited artifact.", 0, Integer.MAX_VALUE, this.relatesTo));
            children.add(new Property("publicationForm", "", "If multiple, used to represent alternative forms of the article that are not separate citations.", 0, Integer.MAX_VALUE, this.publicationForm));
            children.add(new Property("webLocation", "", "Used for any URL for the article or artifact cited.", 0, Integer.MAX_VALUE, this.webLocation));
            children.add(new Property("classification", "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification));
            children.add(new Property("contributorship", "", "This element is used to list authors and other contributors, their contact information, specific contributions, and summary statements.", 0, 1, this.contributorship));
            children.add(new Property("note", "Annotation", "Any additional information or content for the article or artifact.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this citation when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case -1007604940: {
                    return new Property("relatedIdentifier", "Identifier", "A formal identifier that is used to identify things closely related to this citation.", 0, Integer.MAX_VALUE, this.relatedIdentifier);
                }
                case 540917457: {
                    return new Property("dateAccessed", "dateTime", "When the cited artifact was accessed.", 0, 1, this.dateAccessed);
                }
                case 351608024: {
                    return new Property(Citation.SP_VERSION, "", "The defined version of the cited artifact.", 0, 1, this.version);
                }
                case 1457822360: {
                    return new Property("currentState", "CodeableConcept", "The status of the cited artifact.", 0, Integer.MAX_VALUE, this.currentState);
                }
                case 247524032: {
                    return new Property("statusDate", "", "An effective date or period for a status of the cited artifact.", 0, Integer.MAX_VALUE, this.statusDate);
                }
                case 110371416: {
                    return new Property(Citation.SP_TITLE, "", "The title details of the article or artifact.", 0, Integer.MAX_VALUE, this.title);
                }
                case 1732898850: {
                    return new Property("abstract", "", "Summary of the article or artifact.", 0, Integer.MAX_VALUE, this.abstract_);
                }
                case 3433459: {
                    return new Property("part", "", "The component of the article or artifact.", 0, 1, this.part);
                }
                case -7765931: {
                    return new Property("relatesTo", "", "The artifact related to the cited artifact.", 0, Integer.MAX_VALUE, this.relatesTo);
                }
                case 1470639376: {
                    return new Property("publicationForm", "", "If multiple, used to represent alternative forms of the article that are not separate citations.", 0, Integer.MAX_VALUE, this.publicationForm);
                }
                case -828032215: {
                    return new Property("webLocation", "", "Used for any URL for the article or artifact cited.", 0, Integer.MAX_VALUE, this.webLocation);
                }
                case 382350310: {
                    return new Property("classification", "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification);
                }
                case 538727831: {
                    return new Property("contributorship", "", "This element is used to list authors and other contributors, their contact information, specific contributions, and summary statements.", 0, 1, this.contributorship);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Any additional information or content for the article or artifact.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -1007604940: {
                    return this.relatedIdentifier == null ? new Base[]{} : this.relatedIdentifier.toArray(new Base[this.relatedIdentifier.size()]);
                }
                case 540917457: {
                    Base[] baseArray;
                    if (this.dateAccessed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.dateAccessed;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 1457822360: {
                    return this.currentState == null ? new Base[]{} : this.currentState.toArray(new Base[this.currentState.size()]);
                }
                case 247524032: {
                    return this.statusDate == null ? new Base[]{} : this.statusDate.toArray(new Base[this.statusDate.size()]);
                }
                case 110371416: {
                    return this.title == null ? new Base[]{} : this.title.toArray(new Base[this.title.size()]);
                }
                case 1732898850: {
                    return this.abstract_ == null ? new Base[]{} : this.abstract_.toArray(new Base[this.abstract_.size()]);
                }
                case 3433459: {
                    Base[] baseArray;
                    if (this.part == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.part;
                    }
                    return baseArray;
                }
                case -7765931: {
                    return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
                }
                case 1470639376: {
                    return this.publicationForm == null ? new Base[]{} : this.publicationForm.toArray(new Base[this.publicationForm.size()]);
                }
                case -828032215: {
                    return this.webLocation == null ? new Base[]{} : this.webLocation.toArray(new Base[this.webLocation.size()]);
                }
                case 382350310: {
                    return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
                }
                case 538727831: {
                    Base[] baseArray;
                    if (this.contributorship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.contributorship;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -1007604940: {
                    this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 540917457: {
                    this.dateAccessed = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 351608024: {
                    this.version = (CitationCitedArtifactVersionComponent)value;
                    return value;
                }
                case 1457822360: {
                    this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 247524032: {
                    this.getStatusDate().add((CitationCitedArtifactStatusDateComponent)value);
                    return value;
                }
                case 110371416: {
                    this.getTitle().add((CitationCitedArtifactTitleComponent)value);
                    return value;
                }
                case 1732898850: {
                    this.getAbstract().add((CitationCitedArtifactAbstractComponent)value);
                    return value;
                }
                case 3433459: {
                    this.part = (CitationCitedArtifactPartComponent)value;
                    return value;
                }
                case -7765931: {
                    this.getRelatesTo().add((CitationCitedArtifactRelatesToComponent)value);
                    return value;
                }
                case 1470639376: {
                    this.getPublicationForm().add((CitationCitedArtifactPublicationFormComponent)value);
                    return value;
                }
                case -828032215: {
                    this.getWebLocation().add((CitationCitedArtifactWebLocationComponent)value);
                    return value;
                }
                case 382350310: {
                    this.getClassification().add((CitationCitedArtifactClassificationComponent)value);
                    return value;
                }
                case 538727831: {
                    this.contributorship = (CitationCitedArtifactContributorshipComponent)value;
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("relatedIdentifier")) {
                this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("dateAccessed")) {
                this.dateAccessed = TypeConvertor.castToDateTime(value);
            } else if (name.equals(Citation.SP_VERSION)) {
                this.version = (CitationCitedArtifactVersionComponent)value;
            } else if (name.equals("currentState")) {
                this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("statusDate")) {
                this.getStatusDate().add((CitationCitedArtifactStatusDateComponent)value);
            } else if (name.equals(Citation.SP_TITLE)) {
                this.getTitle().add((CitationCitedArtifactTitleComponent)value);
            } else if (name.equals("abstract")) {
                this.getAbstract().add((CitationCitedArtifactAbstractComponent)value);
            } else if (name.equals("part")) {
                this.part = (CitationCitedArtifactPartComponent)value;
            } else if (name.equals("relatesTo")) {
                this.getRelatesTo().add((CitationCitedArtifactRelatesToComponent)value);
            } else if (name.equals("publicationForm")) {
                this.getPublicationForm().add((CitationCitedArtifactPublicationFormComponent)value);
            } else if (name.equals("webLocation")) {
                this.getWebLocation().add((CitationCitedArtifactWebLocationComponent)value);
            } else if (name.equals("classification")) {
                this.getClassification().add((CitationCitedArtifactClassificationComponent)value);
            } else if (name.equals("contributorship")) {
                this.contributorship = (CitationCitedArtifactContributorshipComponent)value;
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -1007604940: {
                    return this.addRelatedIdentifier();
                }
                case 540917457: {
                    return this.getDateAccessedElement();
                }
                case 351608024: {
                    return this.getVersion();
                }
                case 1457822360: {
                    return this.addCurrentState();
                }
                case 247524032: {
                    return this.addStatusDate();
                }
                case 110371416: {
                    return this.addTitle();
                }
                case 1732898850: {
                    return this.addAbstract();
                }
                case 3433459: {
                    return this.getPart();
                }
                case -7765931: {
                    return this.addRelatesTo();
                }
                case 1470639376: {
                    return this.addPublicationForm();
                }
                case -828032215: {
                    return this.addWebLocation();
                }
                case 382350310: {
                    return this.addClassification();
                }
                case 538727831: {
                    return this.getContributorship();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1007604940: {
                    return new String[]{"Identifier"};
                }
                case 540917457: {
                    return new String[]{"dateTime"};
                }
                case 351608024: {
                    return new String[0];
                }
                case 1457822360: {
                    return new String[]{"CodeableConcept"};
                }
                case 247524032: {
                    return new String[0];
                }
                case 110371416: {
                    return new String[0];
                }
                case 1732898850: {
                    return new String[0];
                }
                case 3433459: {
                    return new String[0];
                }
                case -7765931: {
                    return new String[0];
                }
                case 1470639376: {
                    return new String[0];
                }
                case -828032215: {
                    return new String[0];
                }
                case 382350310: {
                    return new String[0];
                }
                case 538727831: {
                    return new String[0];
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("relatedIdentifier")) {
                return this.addRelatedIdentifier();
            }
            if (name.equals("dateAccessed")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.citedArtifact.dateAccessed");
            }
            if (name.equals(Citation.SP_VERSION)) {
                this.version = new CitationCitedArtifactVersionComponent();
                return this.version;
            }
            if (name.equals("currentState")) {
                return this.addCurrentState();
            }
            if (name.equals("statusDate")) {
                return this.addStatusDate();
            }
            if (name.equals(Citation.SP_TITLE)) {
                return this.addTitle();
            }
            if (name.equals("abstract")) {
                return this.addAbstract();
            }
            if (name.equals("part")) {
                this.part = new CitationCitedArtifactPartComponent();
                return this.part;
            }
            if (name.equals("relatesTo")) {
                return this.addRelatesTo();
            }
            if (name.equals("publicationForm")) {
                return this.addPublicationForm();
            }
            if (name.equals("webLocation")) {
                return this.addWebLocation();
            }
            if (name.equals("classification")) {
                return this.addClassification();
            }
            if (name.equals("contributorship")) {
                this.contributorship = new CitationCitedArtifactContributorshipComponent();
                return this.contributorship;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactComponent copy() {
            CitationCitedArtifactComponent dst = new CitationCitedArtifactComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.relatedIdentifier != null) {
                dst.relatedIdentifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.relatedIdentifier) {
                    dst.relatedIdentifier.add(identifier.copy());
                }
            }
            dst.dateAccessed = this.dateAccessed == null ? null : this.dateAccessed.copy();
            CitationCitedArtifactVersionComponent citationCitedArtifactVersionComponent = dst.version = this.version == null ? null : this.version.copy();
            if (this.currentState != null) {
                dst.currentState = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.currentState) {
                    dst.currentState.add(codeableConcept.copy());
                }
            }
            if (this.statusDate != null) {
                dst.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
                for (CitationCitedArtifactStatusDateComponent citationCitedArtifactStatusDateComponent : this.statusDate) {
                    dst.statusDate.add(citationCitedArtifactStatusDateComponent.copy());
                }
            }
            if (this.title != null) {
                dst.title = new ArrayList<CitationCitedArtifactTitleComponent>();
                for (CitationCitedArtifactTitleComponent citationCitedArtifactTitleComponent : this.title) {
                    dst.title.add(citationCitedArtifactTitleComponent.copy());
                }
            }
            if (this.abstract_ != null) {
                dst.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
                for (CitationCitedArtifactAbstractComponent citationCitedArtifactAbstractComponent : this.abstract_) {
                    dst.abstract_.add(citationCitedArtifactAbstractComponent.copy());
                }
            }
            CitationCitedArtifactPartComponent citationCitedArtifactPartComponent = dst.part = this.part == null ? null : this.part.copy();
            if (this.relatesTo != null) {
                dst.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
                for (CitationCitedArtifactRelatesToComponent citationCitedArtifactRelatesToComponent : this.relatesTo) {
                    dst.relatesTo.add(citationCitedArtifactRelatesToComponent.copy());
                }
            }
            if (this.publicationForm != null) {
                dst.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
                for (CitationCitedArtifactPublicationFormComponent citationCitedArtifactPublicationFormComponent : this.publicationForm) {
                    dst.publicationForm.add(citationCitedArtifactPublicationFormComponent.copy());
                }
            }
            if (this.webLocation != null) {
                dst.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
                for (CitationCitedArtifactWebLocationComponent citationCitedArtifactWebLocationComponent : this.webLocation) {
                    dst.webLocation.add(citationCitedArtifactWebLocationComponent.copy());
                }
            }
            if (this.classification != null) {
                dst.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
                for (CitationCitedArtifactClassificationComponent citationCitedArtifactClassificationComponent : this.classification) {
                    dst.classification.add(citationCitedArtifactClassificationComponent.copy());
                }
            }
            CitationCitedArtifactContributorshipComponent citationCitedArtifactContributorshipComponent = dst.contributorship = this.contributorship == null ? null : this.contributorship.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactComponent)) {
                return false;
            }
            CitationCitedArtifactComponent o = (CitationCitedArtifactComponent)other_;
            return CitationCitedArtifactComponent.compareDeep(this.identifier, o.identifier, true) && CitationCitedArtifactComponent.compareDeep(this.relatedIdentifier, o.relatedIdentifier, true) && CitationCitedArtifactComponent.compareDeep(this.dateAccessed, o.dateAccessed, true) && CitationCitedArtifactComponent.compareDeep(this.version, o.version, true) && CitationCitedArtifactComponent.compareDeep(this.currentState, o.currentState, true) && CitationCitedArtifactComponent.compareDeep(this.statusDate, o.statusDate, true) && CitationCitedArtifactComponent.compareDeep(this.title, o.title, true) && CitationCitedArtifactComponent.compareDeep(this.abstract_, o.abstract_, true) && CitationCitedArtifactComponent.compareDeep(this.part, o.part, true) && CitationCitedArtifactComponent.compareDeep(this.relatesTo, o.relatesTo, true) && CitationCitedArtifactComponent.compareDeep(this.publicationForm, o.publicationForm, true) && CitationCitedArtifactComponent.compareDeep(this.webLocation, o.webLocation, true) && CitationCitedArtifactComponent.compareDeep(this.classification, o.classification, true) && CitationCitedArtifactComponent.compareDeep(this.contributorship, o.contributorship, true) && CitationCitedArtifactComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactComponent)) {
                return false;
            }
            CitationCitedArtifactComponent o = (CitationCitedArtifactComponent)other_;
            return CitationCitedArtifactComponent.compareValues(this.dateAccessed, o.dateAccessed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.relatedIdentifier, this.dateAccessed, this.version, this.currentState, this.statusDate, this.title, this.abstract_, this.part, this.relatesTo, this.publicationForm, this.webLocation, this.classification, this.contributorship, this.note);
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact";
        }
    }

    @Block
    public static class CitationRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationshipType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the Citation resource relates to the target artifact", formalDefinition="How the Citation resource relates to the target artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-relationship-type")
        protected CodeableConcept relationshipType;
        @Child(name="targetClassifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The clasification of the related artifact", formalDefinition="The clasification of the related artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> targetClassifier;
        @Child(name="target", type={UriType.class, Identifier.class, Reference.class, Attachment.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The article or artifact that the Citation Resource is related to", formalDefinition="The article or artifact that the Citation Resource is related to.")
        protected DataType target;
        private static final long serialVersionUID = 819025047L;

        public CitationRelatesToComponent() {
        }

        public CitationRelatesToComponent(CodeableConcept relationshipType, DataType target) {
            this.setRelationshipType(relationshipType);
            this.setTarget(target);
        }

        public CodeableConcept getRelationshipType() {
            if (this.relationshipType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationRelatesToComponent.relationshipType");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationshipType = new CodeableConcept();
                }
            }
            return this.relationshipType;
        }

        public boolean hasRelationshipType() {
            return this.relationshipType != null && !this.relationshipType.isEmpty();
        }

        public CitationRelatesToComponent setRelationshipType(CodeableConcept value) {
            this.relationshipType = value;
            return this;
        }

        public List<CodeableConcept> getTargetClassifier() {
            if (this.targetClassifier == null) {
                this.targetClassifier = new ArrayList<CodeableConcept>();
            }
            return this.targetClassifier;
        }

        public CitationRelatesToComponent setTargetClassifier(List<CodeableConcept> theTargetClassifier) {
            this.targetClassifier = theTargetClassifier;
            return this;
        }

        public boolean hasTargetClassifier() {
            if (this.targetClassifier == null) {
                return false;
            }
            for (CodeableConcept item : this.targetClassifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTargetClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.targetClassifier == null) {
                this.targetClassifier = new ArrayList<CodeableConcept>();
            }
            this.targetClassifier.add(t);
            return t;
        }

        public CitationRelatesToComponent addTargetClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.targetClassifier == null) {
                this.targetClassifier = new ArrayList<CodeableConcept>();
            }
            this.targetClassifier.add(t);
            return this;
        }

        public CodeableConcept getTargetClassifierFirstRep() {
            if (this.getTargetClassifier().isEmpty()) {
                this.addTargetClassifier();
            }
            return this.getTargetClassifier().get(0);
        }

        public DataType getTarget() {
            return this.target;
        }

        public UriType getTargetUriType() throws FHIRException {
            if (this.target == null) {
                this.target = new UriType();
            }
            if (!(this.target instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (UriType)this.target;
        }

        public boolean hasTargetUriType() {
            return this != null && this.target instanceof UriType;
        }

        public Identifier getTargetIdentifier() throws FHIRException {
            if (this.target == null) {
                this.target = new Identifier();
            }
            if (!(this.target instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Identifier)this.target;
        }

        public boolean hasTargetIdentifier() {
            return this != null && this.target instanceof Identifier;
        }

        public Reference getTargetReference() throws FHIRException {
            if (this.target == null) {
                this.target = new Reference();
            }
            if (!(this.target instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Reference)this.target;
        }

        public boolean hasTargetReference() {
            return this != null && this.target instanceof Reference;
        }

        public Attachment getTargetAttachment() throws FHIRException {
            if (this.target == null) {
                this.target = new Attachment();
            }
            if (!(this.target instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Attachment)this.target;
        }

        public boolean hasTargetAttachment() {
            return this != null && this.target instanceof Attachment;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public CitationRelatesToComponent setTarget(DataType value) {
            if (!(value == null || value instanceof UriType || value instanceof Identifier || value instanceof Reference || value instanceof Attachment)) {
                throw new Error("Not the right type for Citation.relatesTo.target[x]: " + value.fhirType());
            }
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationshipType", "CodeableConcept", "How the Citation resource relates to the target artifact.", 0, 1, this.relationshipType));
            children.add(new Property("targetClassifier", "CodeableConcept", "The clasification of the related artifact.", 0, Integer.MAX_VALUE, this.targetClassifier));
            children.add(new Property("target[x]", "uri|Identifier|Reference(Any)|Attachment", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1602839150: {
                    return new Property("relationshipType", "CodeableConcept", "How the Citation resource relates to the target artifact.", 0, 1, this.relationshipType);
                }
                case -1267112302: {
                    return new Property("targetClassifier", "CodeableConcept", "The clasification of the related artifact.", 0, Integer.MAX_VALUE, this.targetClassifier);
                }
                case -815579825: {
                    return new Property("target[x]", "uri|Identifier|Reference(Any)|Attachment", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target);
                }
                case -880905839: {
                    return new Property("target[x]", "uri|Identifier|Reference(Any)|Attachment", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target);
                }
                case -815585765: {
                    return new Property("target[x]", "uri", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target);
                }
                case 1690892570: {
                    return new Property("target[x]", "Identifier", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target);
                }
                case 1259806906: {
                    return new Property("target[x]", "Reference(Any)", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target);
                }
                case 1345824148: {
                    return new Property("target[x]", "Attachment", "The article or artifact that the Citation Resource is related to.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    Base[] baseArray;
                    if (this.relationshipType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationshipType;
                    }
                    return baseArray;
                }
                case -1267112302: {
                    return this.targetClassifier == null ? new Base[]{} : this.targetClassifier.toArray(new Base[this.targetClassifier.size()]);
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    this.relationshipType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1267112302: {
                    this.getTargetClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("targetClassifier")) {
                this.getTargetClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("target[x]")) {
                this.target = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    return this.getRelationshipType();
                }
                case -1267112302: {
                    return this.addTargetClassifier();
                }
                case -815579825: {
                    return this.getTarget();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1602839150: {
                    return new String[]{"CodeableConcept"};
                }
                case -1267112302: {
                    return new String[]{"CodeableConcept"};
                }
                case -880905839: {
                    return new String[]{"uri", "Identifier", "Reference", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationshipType")) {
                this.relationshipType = new CodeableConcept();
                return this.relationshipType;
            }
            if (name.equals("targetClassifier")) {
                return this.addTargetClassifier();
            }
            if (name.equals("targetUri")) {
                this.target = new UriType();
                return this.target;
            }
            if (name.equals("targetIdentifier")) {
                this.target = new Identifier();
                return this.target;
            }
            if (name.equals("targetReference")) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("targetAttachment")) {
                this.target = new Attachment();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public CitationRelatesToComponent copy() {
            CitationRelatesToComponent dst = new CitationRelatesToComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationRelatesToComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.relationshipType = this.relationshipType == null ? null : this.relationshipType.copy();
            if (this.targetClassifier != null) {
                dst.targetClassifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.targetClassifier) {
                    dst.targetClassifier.add(i2.copy());
                }
            }
            dst.target = this.target == null ? null : this.target.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationRelatesToComponent)) {
                return false;
            }
            CitationRelatesToComponent o = (CitationRelatesToComponent)other_;
            return CitationRelatesToComponent.compareDeep(this.relationshipType, o.relationshipType, true) && CitationRelatesToComponent.compareDeep(this.targetClassifier, o.targetClassifier, true) && CitationRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationRelatesToComponent)) {
                return false;
            }
            CitationRelatesToComponent o = (CitationRelatesToComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.relationshipType, this.targetClassifier, this.target);
        }

        @Override
        public String fhirType() {
            return "Citation.relatesTo";
        }
    }

    @Block
    public static class CitationStatusDateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="activity", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of the status", formalDefinition="Classification of the status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-status-type")
        protected CodeableConcept activity;
        @Child(name="actual", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Either occurred or expected", formalDefinition="Either occurred or expected.")
        protected BooleanType actual;
        @Child(name="period", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the status started and/or ended", formalDefinition="When the status started and/or ended.")
        protected Period period;
        private static final long serialVersionUID = 1123586924L;

        public CitationStatusDateComponent() {
        }

        public CitationStatusDateComponent(CodeableConcept activity, Period period) {
            this.setActivity(activity);
            this.setPeriod(period);
        }

        public CodeableConcept getActivity() {
            if (this.activity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationStatusDateComponent.activity");
                }
                if (Configuration.doAutoCreate()) {
                    this.activity = new CodeableConcept();
                }
            }
            return this.activity;
        }

        public boolean hasActivity() {
            return this.activity != null && !this.activity.isEmpty();
        }

        public CitationStatusDateComponent setActivity(CodeableConcept value) {
            this.activity = value;
            return this;
        }

        public BooleanType getActualElement() {
            if (this.actual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationStatusDateComponent.actual");
                }
                if (Configuration.doAutoCreate()) {
                    this.actual = new BooleanType();
                }
            }
            return this.actual;
        }

        public boolean hasActualElement() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public boolean hasActual() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public CitationStatusDateComponent setActualElement(BooleanType value) {
            this.actual = value;
            return this;
        }

        public boolean getActual() {
            return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
        }

        public CitationStatusDateComponent setActual(boolean value) {
            if (this.actual == null) {
                this.actual = new BooleanType();
            }
            this.actual.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationStatusDateComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CitationStatusDateComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("activity", "CodeableConcept", "Classification of the status.", 0, 1, this.activity));
            children.add(new Property("actual", "boolean", "Either occurred or expected.", 0, 1, this.actual));
            children.add(new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1655966961: {
                    return new Property("activity", "CodeableConcept", "Classification of the status.", 0, 1, this.activity);
                }
                case -1422939762: {
                    return new Property("actual", "boolean", "Either occurred or expected.", 0, 1, this.actual);
                }
                case -991726143: {
                    return new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    Base[] baseArray;
                    if (this.activity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.activity;
                    }
                    return baseArray;
                }
                case -1422939762: {
                    Base[] baseArray;
                    if (this.actual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actual;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    this.activity = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1422939762: {
                    this.actual = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actual")) {
                this.actual = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return this.getActivity();
                }
                case -1422939762: {
                    return this.getActualElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return new String[]{"CodeableConcept"};
                }
                case -1422939762: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = new CodeableConcept();
                return this.activity;
            }
            if (name.equals("actual")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.statusDate.actual");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public CitationStatusDateComponent copy() {
            CitationStatusDateComponent dst = new CitationStatusDateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationStatusDateComponent dst) {
            super.copyValues(dst);
            dst.activity = this.activity == null ? null : this.activity.copy();
            dst.actual = this.actual == null ? null : this.actual.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationStatusDateComponent)) {
                return false;
            }
            CitationStatusDateComponent o = (CitationStatusDateComponent)other_;
            return CitationStatusDateComponent.compareDeep(this.activity, o.activity, true) && CitationStatusDateComponent.compareDeep(this.actual, o.actual, true) && CitationStatusDateComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationStatusDateComponent)) {
                return false;
            }
            CitationStatusDateComponent o = (CitationStatusDateComponent)other_;
            return CitationStatusDateComponent.compareValues(this.actual, o.actual, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.activity, this.actual, this.period);
        }

        @Override
        public String fhirType() {
            return "Citation.statusDate";
        }
    }

    @Block
    public static class CitationClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of classifier (e.g. publication type, keyword)", formalDefinition="The kind of classifier (e.g. publication type, keyword).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-classification-type")
        protected CodeableConcept type;
        @Child(name="classifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific classification value", formalDefinition="The specific classification value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> classifier;
        private static final long serialVersionUID = -283121869L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public CitationClassificationComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public CitationClassificationComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type));
            children.add(new Property("classifier", "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type);
                }
                case -281470431: {
                    return new Property("classifier", "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("classifier")) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -281470431: {
                    return this.addClassifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("classifier")) {
                return this.addClassifier();
            }
            return super.addChild(name);
        }

        @Override
        public CitationClassificationComponent copy() {
            CitationClassificationComponent dst = new CitationClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.classifier) {
                    dst.classifier.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationClassificationComponent)) {
                return false;
            }
            CitationClassificationComponent o = (CitationClassificationComponent)other_;
            return CitationClassificationComponent.compareDeep(this.type, o.type, true) && CitationClassificationComponent.compareDeep(this.classifier, o.classifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationClassificationComponent)) {
                return false;
            }
            CitationClassificationComponent o = (CitationClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.classifier);
        }

        @Override
        public String fhirType() {
            return "Citation.classification";
        }
    }
}

