/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ResourceComparer {
    public static final String COLOR_NO_ROW_LEFT = "#ffffb3";
    public static final String COLOR_NO_CELL_LEFT = "#ffff4d";
    public static final String COLOR_NO_ROW_RIGHT = "#ffecb3";
    public static final String COLOR_NO_CELL_RIGHT = "#ffcc33";
    public static final String COLOR_DIFFERENT = "#f0b3ff";
    public static final String COLOR_DIFFERENT_LESS = "#f8e6ff";
    public static final String COLOR_ISSUE = "#ffad99";
    public static final String COLOR_NO_CHANGE = "#ffffff";
    protected ComparisonSession session;

    public ResourceComparer(ComparisonSession session) {
        this.session = session;
    }

    public HierarchicalTableGenerator.Cell missingCell(HierarchicalTableGenerator gen) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "", null, null);
        return c;
    }

    public HierarchicalTableGenerator.Cell missingCell(HierarchicalTableGenerator gen, String color) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "", null, null);
        if (color != null) {
            c.setStyle("background-color: " + color);
        }
        return c;
    }

    public XhtmlNode renderErrors(ResourceComparison csc) {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode tbl = div.table("grid");
        for (ValidationMessage vm : csc.messages) {
            XhtmlNode tr = tbl.tr();
            tr.style("background-color: " + this.colorForLevel(vm.getLevel()));
            tr.td().tx(vm.getLevel().getDisplay());
            tr.td().tx(vm.getLocation());
            tr.td().tx(vm.getMessage().replace("\"", "'"));
        }
        return div;
    }

    protected ValidationMessage vmI(ValidationMessage.IssueSeverity level, String message, String path) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, message, level == ValidationMessage.IssueSeverity.NULL ? ValidationMessage.IssueSeverity.INFORMATION : level);
        return vm;
    }

    protected void vm(ValidationMessage.IssueSeverity level, String message, String path, List<ValidationMessage> genMessages, List<ValidationMessage> specMessages) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, message, level == ValidationMessage.IssueSeverity.NULL ? ValidationMessage.IssueSeverity.INFORMATION : level);
        genMessages.add(vm);
        if (specMessages != null) {
            specMessages.add(vm);
        }
    }

    protected ValidationMessage vm(ValidationMessage.IssueSeverity level, String message, String path, List<ValidationMessage> genMessages) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path, message, level == ValidationMessage.IssueSeverity.NULL ? ValidationMessage.IssueSeverity.INFORMATION : level);
        genMessages.add(vm);
        return vm;
    }

    private String colorForLevel(ValidationMessage.IssueSeverity level) {
        switch (level) {
            case ERROR: {
                return "#ffcccc";
            }
            case FATAL: {
                return "#ff9999";
            }
            case WARNING: {
                return "#ffebcc";
            }
        }
        return "#ffffe6";
    }

    private String halfColorForLevel(ValidationMessage.IssueSeverity level) {
        switch (level) {
            case ERROR: {
                return "#ffeeee";
            }
            case FATAL: {
                return "#ffcccc";
            }
            case WARNING: {
                return "#fff4ee";
            }
        }
        return "#fffff2";
    }

    protected HierarchicalTableGenerator.Cell cellForMessages(HierarchicalTableGenerator gen, List<ValidationMessage> messages) {
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(gen);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "ul");
        cell.addPiece(piece);
        for (ValidationMessage msg : messages) {
            XhtmlNode li = new XhtmlNode(NodeType.Element, "li");
            piece.getChildren().add(li);
            li.style("background-color: " + this.halfColorForLevel(msg.getLevel()));
            li.tx(msg.getMessage());
        }
        return cell;
    }

    public static class PlaceHolderComparison
    extends ResourceComparison {
        private CanonicalResource left;
        private CanonicalResource right;
        private Throwable e;

        public PlaceHolderComparison(CanonicalResource left, CanonicalResource right) {
            super(left == null ? right.getId() : left.getId(), right == null ? left.getId() : right.getId());
            this.left = left;
            this.right = right;
        }

        public PlaceHolderComparison(CanonicalResource left, CanonicalResource right, Throwable e) {
            super(left == null ? right.getId() : left.getId(), right == null ? left.getId() : right.getId());
            this.e = e;
            this.left = left;
            this.right = right;
        }

        @Override
        protected String abbreviation() {
            CanonicalResource cr;
            CanonicalResource canonicalResource = cr = this.left == null ? this.right : this.left;
            if (cr instanceof CodeSystem) {
                return "cs";
            }
            if (cr instanceof ValueSet) {
                return "vs";
            }
            if (cr instanceof StructureDefinition) {
                return "sd";
            }
            return "xx";
        }

        @Override
        protected String summary() {
            if (this.e != null) {
                return this.e.getMessage();
            }
            CanonicalResource cr = this.left == null ? this.right : this.left;
            return cr.fhirType() + (this.left == null ? " Added" : " Removed");
        }

        @Override
        protected String fhirType() {
            CanonicalResource cr = this.left == null ? this.right : this.left;
            return cr.fhirType();
        }

        @Override
        protected String toTable() {
            String s2 = "";
            String color = null;
            s2 = s2 + this.refCell(this.left);
            s2 = s2 + this.refCell(this.right);
            if (this.left == null) {
                s2 = s2 + "<td>Added</td>";
                color = ResourceComparer.COLOR_NO_ROW_LEFT;
            } else if (this.right == null) {
                s2 = s2 + "<td>Removed</td>";
                color = ResourceComparer.COLOR_NO_ROW_RIGHT;
            } else {
                s2 = s2 + "<td><a href=\"" + this.getId() + ".html\">Failed<a></td>";
                color = ResourceComparer.COLOR_ISSUE;
            }
            s2 = s2 + "<td>" + (this.e != null ? Utilities.escapeXml(this.e.getMessage()) : "") + "</td>";
            return "<tr style=\"background-color: " + color + "\">" + s2 + "</tr>\r\n";
        }

        public Throwable getE() {
            return this.e;
        }

        @Override
        protected void countMessages(MessageCounts cnts) {
            if (this.e != null) {
                cnts.error();
            }
        }
    }

    public static abstract class ResourceComparison {
        private String id;
        private String leftId;
        private String rightId;
        private MessageCounts cnts;
        protected List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        public ResourceComparison(String leftId, String rightId) {
            this.leftId = leftId;
            this.rightId = rightId;
            this.id = this.abbreviation() + "-" + leftId + "-" + rightId;
        }

        protected String refCell(CanonicalResource cr) {
            if (cr == null) {
                return "<td></td>";
            }
            String t = cr.present();
            if (Utilities.noString(t)) {
                t = cr.getId();
            }
            if (cr.hasUserData("path")) {
                String p = cr.getUserString("path");
                return "<td><a href=\"" + (Utilities.isAbsoluteUrl(p) ? "" : "../") + p + "\">" + Utilities.escapeXml(t) + "</td>";
            }
            return "<td>" + Utilities.escapeXml(t) + "</td>";
        }

        protected abstract String abbreviation();

        public String getLeftId() {
            return this.leftId;
        }

        public String getRightId() {
            return this.rightId;
        }

        public List<ValidationMessage> getMessages() {
            return this.messages;
        }

        public String getId() {
            return this.id;
        }

        protected abstract String summary();

        protected abstract String fhirType();

        protected abstract String toTable();

        protected String color() {
            if (this.hasErrors()) {
                return ResourceComparer.COLOR_DIFFERENT;
            }
            if (this.noChange()) {
                return ResourceComparer.COLOR_NO_CHANGE;
            }
            return ResourceComparer.COLOR_DIFFERENT_LESS;
        }

        protected boolean hasErrors() {
            MessageCounts cnts = this.getCounts();
            return cnts.getErrors() > 0;
        }

        protected boolean noChange() {
            MessageCounts cnts = this.getCounts();
            return cnts.getErrors() + cnts.getWarnings() + cnts.getHints() == 0;
        }

        protected String outcomeSummary() {
            MessageCounts cnts = this.getCounts();
            return Integer.toString(cnts.getErrors()) + " " + Utilities.pluralize("Breaking Change", cnts.getErrors()) + ", " + Integer.toString(cnts.getWarnings()) + " " + Utilities.pluralize("Change", cnts.getWarnings()) + ", " + Integer.toString(cnts.getHints()) + " " + Utilities.pluralize("Note", cnts.getHints());
        }

        public MessageCounts getCounts() {
            if (this.cnts == null) {
                this.cnts = new MessageCounts();
                this.countMessages(this.cnts);
            }
            return this.cnts;
        }

        protected abstract void countMessages(MessageCounts var1);
    }

    public static class MessageCounts {
        private int errors;
        private int warnings;
        private int hints;

        public int getErrors() {
            return this.errors;
        }

        public int getWarnings() {
            return this.warnings;
        }

        public int getHints() {
            return this.hints;
        }

        public void error() {
            ++this.errors;
        }

        public void warning() {
            ++this.warnings;
        }

        public void hint() {
            ++this.hints;
        }
    }
}

