/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ContactPointSystem;

public class ContactPointSystemEnumFactory
implements EnumFactory<ContactPointSystem> {
    @Override
    public ContactPointSystem fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("phone".equals(codeString)) {
            return ContactPointSystem.PHONE;
        }
        if ("fax".equals(codeString)) {
            return ContactPointSystem.FAX;
        }
        if ("email".equals(codeString)) {
            return ContactPointSystem.EMAIL;
        }
        if ("pager".equals(codeString)) {
            return ContactPointSystem.PAGER;
        }
        if ("url".equals(codeString)) {
            return ContactPointSystem.URL;
        }
        if ("sms".equals(codeString)) {
            return ContactPointSystem.SMS;
        }
        if ("other".equals(codeString)) {
            return ContactPointSystem.OTHER;
        }
        throw new IllegalArgumentException("Unknown ContactPointSystem code '" + codeString + "'");
    }

    @Override
    public String toCode(ContactPointSystem code) {
        if (code == ContactPointSystem.PHONE) {
            return "phone";
        }
        if (code == ContactPointSystem.FAX) {
            return "fax";
        }
        if (code == ContactPointSystem.EMAIL) {
            return "email";
        }
        if (code == ContactPointSystem.PAGER) {
            return "pager";
        }
        if (code == ContactPointSystem.URL) {
            return "url";
        }
        if (code == ContactPointSystem.SMS) {
            return "sms";
        }
        if (code == ContactPointSystem.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(ContactPointSystem code) {
        return code.getSystem();
    }
}

