/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceNucleicAcid", profile="http://hl7.org/fhir/StructureDefinition/SubstanceNucleicAcid")
public class SubstanceNucleicAcid
extends DomainResource {
    @Child(name="sequenceType", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of the sequence shall be specified based on a controlled vocabulary", formalDefinition="The type of the sequence shall be specified based on a controlled vocabulary.")
    protected CodeableConcept sequenceType;
    @Child(name="numberOfSubunits", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The number of linear sequences of nucleotides linked through phosphodiester bonds shall be described. Subunits would be strands of nucleic acids that are tightly associated typically through Watson-Crick base pairing. NOTE: If not specified in the reference source, the assumption is that there is 1 subunit", formalDefinition="The number of linear sequences of nucleotides linked through phosphodiester bonds shall be described. Subunits would be strands of nucleic acids that are tightly associated typically through Watson-Crick base pairing. NOTE: If not specified in the reference source, the assumption is that there is 1 subunit.")
    protected IntegerType numberOfSubunits;
    @Child(name="areaOfHybridisation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The area of hybridisation shall be described if applicable for double stranded RNA or DNA. The number associated with the subunit followed by the number associated to the residue shall be specified in increasing order. The underscore \u201c\u201d shall be used as separator as follows: \u201cSubunitnumber Residue\u201d", formalDefinition="The area of hybridisation shall be described if applicable for double stranded RNA or DNA. The number associated with the subunit followed by the number associated to the residue shall be specified in increasing order. The underscore \u201c\u201d shall be used as separator as follows: \u201cSubunitnumber Residue\u201d.")
    protected StringType areaOfHybridisation;
    @Child(name="oligoNucleotideType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="(TBC)", formalDefinition="(TBC).")
    protected CodeableConcept oligoNucleotideType;
    @Child(name="subunit", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Subunits are listed in order of decreasing length; sequences of the same length will be ordered by molecular weight; subunits that have identical sequences will be repeated multiple times", formalDefinition="Subunits are listed in order of decreasing length; sequences of the same length will be ordered by molecular weight; subunits that have identical sequences will be repeated multiple times.")
    protected List<SubstanceNucleicAcidSubunitComponent> subunit;
    private static final long serialVersionUID = -1906822433L;

    public CodeableConcept getSequenceType() {
        if (this.sequenceType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceNucleicAcid.sequenceType");
            }
            if (Configuration.doAutoCreate()) {
                this.sequenceType = new CodeableConcept();
            }
        }
        return this.sequenceType;
    }

    public boolean hasSequenceType() {
        return this.sequenceType != null && !this.sequenceType.isEmpty();
    }

    public SubstanceNucleicAcid setSequenceType(CodeableConcept value) {
        this.sequenceType = value;
        return this;
    }

    public IntegerType getNumberOfSubunitsElement() {
        if (this.numberOfSubunits == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceNucleicAcid.numberOfSubunits");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfSubunits = new IntegerType();
            }
        }
        return this.numberOfSubunits;
    }

    public boolean hasNumberOfSubunitsElement() {
        return this.numberOfSubunits != null && !this.numberOfSubunits.isEmpty();
    }

    public boolean hasNumberOfSubunits() {
        return this.numberOfSubunits != null && !this.numberOfSubunits.isEmpty();
    }

    public SubstanceNucleicAcid setNumberOfSubunitsElement(IntegerType value) {
        this.numberOfSubunits = value;
        return this;
    }

    public int getNumberOfSubunits() {
        return this.numberOfSubunits == null || this.numberOfSubunits.isEmpty() ? 0 : (Integer)this.numberOfSubunits.getValue();
    }

    public SubstanceNucleicAcid setNumberOfSubunits(int value) {
        if (this.numberOfSubunits == null) {
            this.numberOfSubunits = new IntegerType();
        }
        this.numberOfSubunits.setValue((Object)value);
        return this;
    }

    public StringType getAreaOfHybridisationElement() {
        if (this.areaOfHybridisation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceNucleicAcid.areaOfHybridisation");
            }
            if (Configuration.doAutoCreate()) {
                this.areaOfHybridisation = new StringType();
            }
        }
        return this.areaOfHybridisation;
    }

    public boolean hasAreaOfHybridisationElement() {
        return this.areaOfHybridisation != null && !this.areaOfHybridisation.isEmpty();
    }

    public boolean hasAreaOfHybridisation() {
        return this.areaOfHybridisation != null && !this.areaOfHybridisation.isEmpty();
    }

    public SubstanceNucleicAcid setAreaOfHybridisationElement(StringType value) {
        this.areaOfHybridisation = value;
        return this;
    }

    public String getAreaOfHybridisation() {
        return this.areaOfHybridisation == null ? null : (String)this.areaOfHybridisation.getValue();
    }

    public SubstanceNucleicAcid setAreaOfHybridisation(String value) {
        if (Utilities.noString(value)) {
            this.areaOfHybridisation = null;
        } else {
            if (this.areaOfHybridisation == null) {
                this.areaOfHybridisation = new StringType();
            }
            this.areaOfHybridisation.setValue(value);
        }
        return this;
    }

    public CodeableConcept getOligoNucleotideType() {
        if (this.oligoNucleotideType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceNucleicAcid.oligoNucleotideType");
            }
            if (Configuration.doAutoCreate()) {
                this.oligoNucleotideType = new CodeableConcept();
            }
        }
        return this.oligoNucleotideType;
    }

    public boolean hasOligoNucleotideType() {
        return this.oligoNucleotideType != null && !this.oligoNucleotideType.isEmpty();
    }

    public SubstanceNucleicAcid setOligoNucleotideType(CodeableConcept value) {
        this.oligoNucleotideType = value;
        return this;
    }

    public List<SubstanceNucleicAcidSubunitComponent> getSubunit() {
        if (this.subunit == null) {
            this.subunit = new ArrayList<SubstanceNucleicAcidSubunitComponent>();
        }
        return this.subunit;
    }

    public SubstanceNucleicAcid setSubunit(List<SubstanceNucleicAcidSubunitComponent> theSubunit) {
        this.subunit = theSubunit;
        return this;
    }

    public boolean hasSubunit() {
        if (this.subunit == null) {
            return false;
        }
        for (SubstanceNucleicAcidSubunitComponent item : this.subunit) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceNucleicAcidSubunitComponent addSubunit() {
        SubstanceNucleicAcidSubunitComponent t = new SubstanceNucleicAcidSubunitComponent();
        if (this.subunit == null) {
            this.subunit = new ArrayList<SubstanceNucleicAcidSubunitComponent>();
        }
        this.subunit.add(t);
        return t;
    }

    public SubstanceNucleicAcid addSubunit(SubstanceNucleicAcidSubunitComponent t) {
        if (t == null) {
            return this;
        }
        if (this.subunit == null) {
            this.subunit = new ArrayList<SubstanceNucleicAcidSubunitComponent>();
        }
        this.subunit.add(t);
        return this;
    }

    public SubstanceNucleicAcidSubunitComponent getSubunitFirstRep() {
        if (this.getSubunit().isEmpty()) {
            this.addSubunit();
        }
        return this.getSubunit().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("sequenceType", "CodeableConcept", "The type of the sequence shall be specified based on a controlled vocabulary.", 0, 1, this.sequenceType));
        children.add(new Property("numberOfSubunits", "integer", "The number of linear sequences of nucleotides linked through phosphodiester bonds shall be described. Subunits would be strands of nucleic acids that are tightly associated typically through Watson-Crick base pairing. NOTE: If not specified in the reference source, the assumption is that there is 1 subunit.", 0, 1, this.numberOfSubunits));
        children.add(new Property("areaOfHybridisation", "string", "The area of hybridisation shall be described if applicable for double stranded RNA or DNA. The number associated with the subunit followed by the number associated to the residue shall be specified in increasing order. The underscore \u201c\u201d shall be used as separator as follows: \u201cSubunitnumber Residue\u201d.", 0, 1, this.areaOfHybridisation));
        children.add(new Property("oligoNucleotideType", "CodeableConcept", "(TBC).", 0, 1, this.oligoNucleotideType));
        children.add(new Property("subunit", "", "Subunits are listed in order of decreasing length; sequences of the same length will be ordered by molecular weight; subunits that have identical sequences will be repeated multiple times.", 0, Integer.MAX_VALUE, this.subunit));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 807711387: {
                return new Property("sequenceType", "CodeableConcept", "The type of the sequence shall be specified based on a controlled vocabulary.", 0, 1, this.sequenceType);
            }
            case -847111089: {
                return new Property("numberOfSubunits", "integer", "The number of linear sequences of nucleotides linked through phosphodiester bonds shall be described. Subunits would be strands of nucleic acids that are tightly associated typically through Watson-Crick base pairing. NOTE: If not specified in the reference source, the assumption is that there is 1 subunit.", 0, 1, this.numberOfSubunits);
            }
            case -617269845: {
                return new Property("areaOfHybridisation", "string", "The area of hybridisation shall be described if applicable for double stranded RNA or DNA. The number associated with the subunit followed by the number associated to the residue shall be specified in increasing order. The underscore \u201c\u201d shall be used as separator as follows: \u201cSubunitnumber Residue\u201d.", 0, 1, this.areaOfHybridisation);
            }
            case -1526251938: {
                return new Property("oligoNucleotideType", "CodeableConcept", "(TBC).", 0, 1, this.oligoNucleotideType);
            }
            case -1867548732: {
                return new Property("subunit", "", "Subunits are listed in order of decreasing length; sequences of the same length will be ordered by molecular weight; subunits that have identical sequences will be repeated multiple times.", 0, Integer.MAX_VALUE, this.subunit);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 807711387: {
                Base[] baseArray;
                if (this.sequenceType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.sequenceType;
                }
                return baseArray;
            }
            case -847111089: {
                Base[] baseArray;
                if (this.numberOfSubunits == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.numberOfSubunits;
                }
                return baseArray;
            }
            case -617269845: {
                Base[] baseArray;
                if (this.areaOfHybridisation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.areaOfHybridisation;
                }
                return baseArray;
            }
            case -1526251938: {
                Base[] baseArray;
                if (this.oligoNucleotideType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.oligoNucleotideType;
                }
                return baseArray;
            }
            case -1867548732: {
                return this.subunit == null ? new Base[]{} : this.subunit.toArray(new Base[this.subunit.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 807711387: {
                this.sequenceType = this.castToCodeableConcept(value);
                return value;
            }
            case -847111089: {
                this.numberOfSubunits = this.castToInteger(value);
                return value;
            }
            case -617269845: {
                this.areaOfHybridisation = this.castToString(value);
                return value;
            }
            case -1526251938: {
                this.oligoNucleotideType = this.castToCodeableConcept(value);
                return value;
            }
            case -1867548732: {
                this.getSubunit().add((SubstanceNucleicAcidSubunitComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("sequenceType")) {
            this.sequenceType = this.castToCodeableConcept(value);
        } else if (name.equals("numberOfSubunits")) {
            this.numberOfSubunits = this.castToInteger(value);
        } else if (name.equals("areaOfHybridisation")) {
            this.areaOfHybridisation = this.castToString(value);
        } else if (name.equals("oligoNucleotideType")) {
            this.oligoNucleotideType = this.castToCodeableConcept(value);
        } else if (name.equals("subunit")) {
            this.getSubunit().add((SubstanceNucleicAcidSubunitComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 807711387: {
                return this.getSequenceType();
            }
            case -847111089: {
                return this.getNumberOfSubunitsElement();
            }
            case -617269845: {
                return this.getAreaOfHybridisationElement();
            }
            case -1526251938: {
                return this.getOligoNucleotideType();
            }
            case -1867548732: {
                return this.addSubunit();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 807711387: {
                return new String[]{"CodeableConcept"};
            }
            case -847111089: {
                return new String[]{"integer"};
            }
            case -617269845: {
                return new String[]{"string"};
            }
            case -1526251938: {
                return new String[]{"CodeableConcept"};
            }
            case -1867548732: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("sequenceType")) {
            this.sequenceType = new CodeableConcept();
            return this.sequenceType;
        }
        if (name.equals("numberOfSubunits")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.numberOfSubunits");
        }
        if (name.equals("areaOfHybridisation")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.areaOfHybridisation");
        }
        if (name.equals("oligoNucleotideType")) {
            this.oligoNucleotideType = new CodeableConcept();
            return this.oligoNucleotideType;
        }
        if (name.equals("subunit")) {
            return this.addSubunit();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceNucleicAcid";
    }

    @Override
    public SubstanceNucleicAcid copy() {
        SubstanceNucleicAcid dst = new SubstanceNucleicAcid();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceNucleicAcid dst) {
        super.copyValues(dst);
        dst.sequenceType = this.sequenceType == null ? null : this.sequenceType.copy();
        dst.numberOfSubunits = this.numberOfSubunits == null ? null : this.numberOfSubunits.copy();
        dst.areaOfHybridisation = this.areaOfHybridisation == null ? null : this.areaOfHybridisation.copy();
        CodeableConcept codeableConcept = dst.oligoNucleotideType = this.oligoNucleotideType == null ? null : this.oligoNucleotideType.copy();
        if (this.subunit != null) {
            dst.subunit = new ArrayList<SubstanceNucleicAcidSubunitComponent>();
            for (SubstanceNucleicAcidSubunitComponent i2 : this.subunit) {
                dst.subunit.add(i2.copy());
            }
        }
    }

    protected SubstanceNucleicAcid typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceNucleicAcid)) {
            return false;
        }
        SubstanceNucleicAcid o = (SubstanceNucleicAcid)other_;
        return SubstanceNucleicAcid.compareDeep(this.sequenceType, o.sequenceType, true) && SubstanceNucleicAcid.compareDeep(this.numberOfSubunits, o.numberOfSubunits, true) && SubstanceNucleicAcid.compareDeep(this.areaOfHybridisation, o.areaOfHybridisation, true) && SubstanceNucleicAcid.compareDeep(this.oligoNucleotideType, o.oligoNucleotideType, true) && SubstanceNucleicAcid.compareDeep(this.subunit, o.subunit, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceNucleicAcid)) {
            return false;
        }
        SubstanceNucleicAcid o = (SubstanceNucleicAcid)other_;
        return SubstanceNucleicAcid.compareValues(this.numberOfSubunits, o.numberOfSubunits, true) && SubstanceNucleicAcid.compareValues(this.areaOfHybridisation, o.areaOfHybridisation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.sequenceType, this.numberOfSubunits, this.areaOfHybridisation, this.oligoNucleotideType, this.subunit);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceNucleicAcid;
    }

    @Block
    public static class SubstanceNucleicAcidSubunitSugarComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Substance ID of the sugar or sugar-like component that make up the nucleotide", formalDefinition="The Substance ID of the sugar or sugar-like component that make up the nucleotide.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name of the sugar or sugar-like component that make up the nucleotide", formalDefinition="The name of the sugar or sugar-like component that make up the nucleotide.")
        protected StringType name;
        @Child(name="residueSite", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The residues that contain a given sugar will be captured. The order of given residues will be captured in the 5\u2018-3\u2018direction consistent with the base sequences listed above", formalDefinition="The residues that contain a given sugar will be captured. The order of given residues will be captured in the 5\u2018-3\u2018direction consistent with the base sequences listed above.")
        protected StringType residueSite;
        private static final long serialVersionUID = 1933713781L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitSugarComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceNucleicAcidSubunitSugarComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitSugarComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceNucleicAcidSubunitSugarComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceNucleicAcidSubunitSugarComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getResidueSiteElement() {
            if (this.residueSite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitSugarComponent.residueSite");
                }
                if (Configuration.doAutoCreate()) {
                    this.residueSite = new StringType();
                }
            }
            return this.residueSite;
        }

        public boolean hasResidueSiteElement() {
            return this.residueSite != null && !this.residueSite.isEmpty();
        }

        public boolean hasResidueSite() {
            return this.residueSite != null && !this.residueSite.isEmpty();
        }

        public SubstanceNucleicAcidSubunitSugarComponent setResidueSiteElement(StringType value) {
            this.residueSite = value;
            return this;
        }

        public String getResidueSite() {
            return this.residueSite == null ? null : (String)this.residueSite.getValue();
        }

        public SubstanceNucleicAcidSubunitSugarComponent setResidueSite(String value) {
            if (Utilities.noString(value)) {
                this.residueSite = null;
            } else {
                if (this.residueSite == null) {
                    this.residueSite = new StringType();
                }
                this.residueSite.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identifier", "Identifier", "The Substance ID of the sugar or sugar-like component that make up the nucleotide.", 0, 1, this.identifier));
            children.add(new Property("name", "string", "The name of the sugar or sugar-like component that make up the nucleotide.", 0, 1, this.name));
            children.add(new Property("residueSite", "string", "The residues that contain a given sugar will be captured. The order of given residues will be captured in the 5\u2018-3\u2018direction consistent with the base sequences listed above.", 0, 1, this.residueSite));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property("identifier", "Identifier", "The Substance ID of the sugar or sugar-like component that make up the nucleotide.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property("name", "string", "The name of the sugar or sugar-like component that make up the nucleotide.", 0, 1, this.name);
                }
                case 1547124594: {
                    return new Property("residueSite", "string", "The residues that contain a given sugar will be captured. The order of given residues will be captured in the 5\u2018-3\u2018direction consistent with the base sequences listed above.", 0, 1, this.residueSite);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case 1547124594: {
                    Base[] baseArray;
                    if (this.residueSite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.residueSite;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 1547124594: {
                    this.residueSite = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("residueSite")) {
                this.residueSite = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 1547124594: {
                    return this.getResidueSiteElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 1547124594: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.name");
            }
            if (name.equals("residueSite")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.residueSite");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceNucleicAcidSubunitSugarComponent copy() {
            SubstanceNucleicAcidSubunitSugarComponent dst = new SubstanceNucleicAcidSubunitSugarComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceNucleicAcidSubunitSugarComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.residueSite = this.residueSite == null ? null : this.residueSite.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceNucleicAcidSubunitSugarComponent)) {
                return false;
            }
            SubstanceNucleicAcidSubunitSugarComponent o = (SubstanceNucleicAcidSubunitSugarComponent)other_;
            return SubstanceNucleicAcidSubunitSugarComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceNucleicAcidSubunitSugarComponent.compareDeep(this.name, o.name, true) && SubstanceNucleicAcidSubunitSugarComponent.compareDeep(this.residueSite, o.residueSite, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceNucleicAcidSubunitSugarComponent)) {
                return false;
            }
            SubstanceNucleicAcidSubunitSugarComponent o = (SubstanceNucleicAcidSubunitSugarComponent)other_;
            return SubstanceNucleicAcidSubunitSugarComponent.compareValues(this.name, o.name, true) && SubstanceNucleicAcidSubunitSugarComponent.compareValues(this.residueSite, o.residueSite, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.name, this.residueSite);
        }

        @Override
        public String fhirType() {
            return "SubstanceNucleicAcid.subunit.sugar";
        }
    }

    @Block
    public static class SubstanceNucleicAcidSubunitLinkageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="connectivity", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The entity that links the sugar residues together should also be captured for nearly all naturally occurring nucleic acid the linkage is a phosphate group. For many synthetic oligonucleotides phosphorothioate linkages are often seen. Linkage connectivity is assumed to be 3\u2019-5\u2019. If the linkage is either 3\u2019-3\u2019 or 5\u2019-5\u2019 this should be specified", formalDefinition="The entity that links the sugar residues together should also be captured for nearly all naturally occurring nucleic acid the linkage is a phosphate group. For many synthetic oligonucleotides phosphorothioate linkages are often seen. Linkage connectivity is assumed to be 3\u2019-5\u2019. If the linkage is either 3\u2019-3\u2019 or 5\u2019-5\u2019 this should be specified.")
        protected StringType connectivity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Each linkage will be registered as a fragment and have an ID", formalDefinition="Each linkage will be registered as a fragment and have an ID.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Each linkage will be registered as a fragment and have at least one name. A single name shall be assigned to each linkage", formalDefinition="Each linkage will be registered as a fragment and have at least one name. A single name shall be assigned to each linkage.")
        protected StringType name;
        @Child(name="residueSite", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Residues shall be captured as described in 5.3.6.8.3", formalDefinition="Residues shall be captured as described in 5.3.6.8.3.")
        protected StringType residueSite;
        private static final long serialVersionUID = 1392155799L;

        public StringType getConnectivityElement() {
            if (this.connectivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitLinkageComponent.connectivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.connectivity = new StringType();
                }
            }
            return this.connectivity;
        }

        public boolean hasConnectivityElement() {
            return this.connectivity != null && !this.connectivity.isEmpty();
        }

        public boolean hasConnectivity() {
            return this.connectivity != null && !this.connectivity.isEmpty();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setConnectivityElement(StringType value) {
            this.connectivity = value;
            return this;
        }

        public String getConnectivity() {
            return this.connectivity == null ? null : (String)this.connectivity.getValue();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setConnectivity(String value) {
            if (Utilities.noString(value)) {
                this.connectivity = null;
            } else {
                if (this.connectivity == null) {
                    this.connectivity = new StringType();
                }
                this.connectivity.setValue(value);
            }
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitLinkageComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitLinkageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getResidueSiteElement() {
            if (this.residueSite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitLinkageComponent.residueSite");
                }
                if (Configuration.doAutoCreate()) {
                    this.residueSite = new StringType();
                }
            }
            return this.residueSite;
        }

        public boolean hasResidueSiteElement() {
            return this.residueSite != null && !this.residueSite.isEmpty();
        }

        public boolean hasResidueSite() {
            return this.residueSite != null && !this.residueSite.isEmpty();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setResidueSiteElement(StringType value) {
            this.residueSite = value;
            return this;
        }

        public String getResidueSite() {
            return this.residueSite == null ? null : (String)this.residueSite.getValue();
        }

        public SubstanceNucleicAcidSubunitLinkageComponent setResidueSite(String value) {
            if (Utilities.noString(value)) {
                this.residueSite = null;
            } else {
                if (this.residueSite == null) {
                    this.residueSite = new StringType();
                }
                this.residueSite.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("connectivity", "string", "The entity that links the sugar residues together should also be captured for nearly all naturally occurring nucleic acid the linkage is a phosphate group. For many synthetic oligonucleotides phosphorothioate linkages are often seen. Linkage connectivity is assumed to be 3\u2019-5\u2019. If the linkage is either 3\u2019-3\u2019 or 5\u2019-5\u2019 this should be specified.", 0, 1, this.connectivity));
            children.add(new Property("identifier", "Identifier", "Each linkage will be registered as a fragment and have an ID.", 0, 1, this.identifier));
            children.add(new Property("name", "string", "Each linkage will be registered as a fragment and have at least one name. A single name shall be assigned to each linkage.", 0, 1, this.name));
            children.add(new Property("residueSite", "string", "Residues shall be captured as described in 5.3.6.8.3.", 0, 1, this.residueSite));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1923312055: {
                    return new Property("connectivity", "string", "The entity that links the sugar residues together should also be captured for nearly all naturally occurring nucleic acid the linkage is a phosphate group. For many synthetic oligonucleotides phosphorothioate linkages are often seen. Linkage connectivity is assumed to be 3\u2019-5\u2019. If the linkage is either 3\u2019-3\u2019 or 5\u2019-5\u2019 this should be specified.", 0, 1, this.connectivity);
                }
                case -1618432855: {
                    return new Property("identifier", "Identifier", "Each linkage will be registered as a fragment and have an ID.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property("name", "string", "Each linkage will be registered as a fragment and have at least one name. A single name shall be assigned to each linkage.", 0, 1, this.name);
                }
                case 1547124594: {
                    return new Property("residueSite", "string", "Residues shall be captured as described in 5.3.6.8.3.", 0, 1, this.residueSite);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1923312055: {
                    Base[] baseArray;
                    if (this.connectivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.connectivity;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 1547124594: {
                    Base[] baseArray;
                    if (this.residueSite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.residueSite;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1923312055: {
                    this.connectivity = this.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 1547124594: {
                    this.residueSite = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("connectivity")) {
                this.connectivity = this.castToString(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("residueSite")) {
                this.residueSite = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1923312055: {
                    return this.getConnectivityElement();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 1547124594: {
                    return this.getResidueSiteElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1923312055: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 1547124594: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("connectivity")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.connectivity");
            }
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.name");
            }
            if (name.equals("residueSite")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.residueSite");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceNucleicAcidSubunitLinkageComponent copy() {
            SubstanceNucleicAcidSubunitLinkageComponent dst = new SubstanceNucleicAcidSubunitLinkageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceNucleicAcidSubunitLinkageComponent dst) {
            super.copyValues(dst);
            dst.connectivity = this.connectivity == null ? null : this.connectivity.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.residueSite = this.residueSite == null ? null : this.residueSite.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceNucleicAcidSubunitLinkageComponent)) {
                return false;
            }
            SubstanceNucleicAcidSubunitLinkageComponent o = (SubstanceNucleicAcidSubunitLinkageComponent)other_;
            return SubstanceNucleicAcidSubunitLinkageComponent.compareDeep(this.connectivity, o.connectivity, true) && SubstanceNucleicAcidSubunitLinkageComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceNucleicAcidSubunitLinkageComponent.compareDeep(this.name, o.name, true) && SubstanceNucleicAcidSubunitLinkageComponent.compareDeep(this.residueSite, o.residueSite, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceNucleicAcidSubunitLinkageComponent)) {
                return false;
            }
            SubstanceNucleicAcidSubunitLinkageComponent o = (SubstanceNucleicAcidSubunitLinkageComponent)other_;
            return SubstanceNucleicAcidSubunitLinkageComponent.compareValues(this.connectivity, o.connectivity, true) && SubstanceNucleicAcidSubunitLinkageComponent.compareValues(this.name, o.name, true) && SubstanceNucleicAcidSubunitLinkageComponent.compareValues(this.residueSite, o.residueSite, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.connectivity, this.identifier, this.name, this.residueSite);
        }

        @Override
        public String fhirType() {
            return "SubstanceNucleicAcid.subunit.linkage";
        }
    }

    @Block
    public static class SubstanceNucleicAcidSubunitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="subunit", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Index of linear sequences of nucleic acids in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts", formalDefinition="Index of linear sequences of nucleic acids in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.")
        protected IntegerType subunit;
        @Child(name="sequence", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual nucleotide sequence notation from 5' to 3' end using standard single letter codes. In addition to the base sequence, sugar and type of phosphate or non-phosphate linkage should also be captured", formalDefinition="Actual nucleotide sequence notation from 5' to 3' end using standard single letter codes. In addition to the base sequence, sugar and type of phosphate or non-phosphate linkage should also be captured.")
        protected StringType sequence;
        @Child(name="length", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The length of the sequence shall be captured", formalDefinition="The length of the sequence shall be captured.")
        protected IntegerType length;
        @Child(name="sequenceAttachment", type={Attachment.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="(TBC)", formalDefinition="(TBC).")
        protected Attachment sequenceAttachment;
        @Child(name="fivePrime", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The nucleotide present at the 5\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the first position in the sequence. A separate representation would be redundant", formalDefinition="The nucleotide present at the 5\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the first position in the sequence. A separate representation would be redundant.")
        protected CodeableConcept fivePrime;
        @Child(name="threePrime", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The nucleotide present at the 3\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the last position in the sequence. A separate representation would be redundant", formalDefinition="The nucleotide present at the 3\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the last position in the sequence. A separate representation would be redundant.")
        protected CodeableConcept threePrime;
        @Child(name="linkage", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The linkages between sugar residues will also be captured", formalDefinition="The linkages between sugar residues will also be captured.")
        protected List<SubstanceNucleicAcidSubunitLinkageComponent> linkage;
        @Child(name="sugar", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="5.3.6.8.1 Sugar ID (Mandatory)", formalDefinition="5.3.6.8.1 Sugar ID (Mandatory).")
        protected List<SubstanceNucleicAcidSubunitSugarComponent> sugar;
        private static final long serialVersionUID = 1835593659L;

        public IntegerType getSubunitElement() {
            if (this.subunit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitComponent.subunit");
                }
                if (Configuration.doAutoCreate()) {
                    this.subunit = new IntegerType();
                }
            }
            return this.subunit;
        }

        public boolean hasSubunitElement() {
            return this.subunit != null && !this.subunit.isEmpty();
        }

        public boolean hasSubunit() {
            return this.subunit != null && !this.subunit.isEmpty();
        }

        public SubstanceNucleicAcidSubunitComponent setSubunitElement(IntegerType value) {
            this.subunit = value;
            return this;
        }

        public int getSubunit() {
            return this.subunit == null || this.subunit.isEmpty() ? 0 : (Integer)this.subunit.getValue();
        }

        public SubstanceNucleicAcidSubunitComponent setSubunit(int value) {
            if (this.subunit == null) {
                this.subunit = new IntegerType();
            }
            this.subunit.setValue((Object)value);
            return this;
        }

        public StringType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new StringType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubstanceNucleicAcidSubunitComponent setSequenceElement(StringType value) {
            this.sequence = value;
            return this;
        }

        public String getSequence() {
            return this.sequence == null ? null : (String)this.sequence.getValue();
        }

        public SubstanceNucleicAcidSubunitComponent setSequence(String value) {
            if (Utilities.noString(value)) {
                this.sequence = null;
            } else {
                if (this.sequence == null) {
                    this.sequence = new StringType();
                }
                this.sequence.setValue(value);
            }
            return this;
        }

        public IntegerType getLengthElement() {
            if (this.length == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitComponent.length");
                }
                if (Configuration.doAutoCreate()) {
                    this.length = new IntegerType();
                }
            }
            return this.length;
        }

        public boolean hasLengthElement() {
            return this.length != null && !this.length.isEmpty();
        }

        public boolean hasLength() {
            return this.length != null && !this.length.isEmpty();
        }

        public SubstanceNucleicAcidSubunitComponent setLengthElement(IntegerType value) {
            this.length = value;
            return this;
        }

        public int getLength() {
            return this.length == null || this.length.isEmpty() ? 0 : (Integer)this.length.getValue();
        }

        public SubstanceNucleicAcidSubunitComponent setLength(int value) {
            if (this.length == null) {
                this.length = new IntegerType();
            }
            this.length.setValue((Object)value);
            return this;
        }

        public Attachment getSequenceAttachment() {
            if (this.sequenceAttachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitComponent.sequenceAttachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceAttachment = new Attachment();
                }
            }
            return this.sequenceAttachment;
        }

        public boolean hasSequenceAttachment() {
            return this.sequenceAttachment != null && !this.sequenceAttachment.isEmpty();
        }

        public SubstanceNucleicAcidSubunitComponent setSequenceAttachment(Attachment value) {
            this.sequenceAttachment = value;
            return this;
        }

        public CodeableConcept getFivePrime() {
            if (this.fivePrime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitComponent.fivePrime");
                }
                if (Configuration.doAutoCreate()) {
                    this.fivePrime = new CodeableConcept();
                }
            }
            return this.fivePrime;
        }

        public boolean hasFivePrime() {
            return this.fivePrime != null && !this.fivePrime.isEmpty();
        }

        public SubstanceNucleicAcidSubunitComponent setFivePrime(CodeableConcept value) {
            this.fivePrime = value;
            return this;
        }

        public CodeableConcept getThreePrime() {
            if (this.threePrime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceNucleicAcidSubunitComponent.threePrime");
                }
                if (Configuration.doAutoCreate()) {
                    this.threePrime = new CodeableConcept();
                }
            }
            return this.threePrime;
        }

        public boolean hasThreePrime() {
            return this.threePrime != null && !this.threePrime.isEmpty();
        }

        public SubstanceNucleicAcidSubunitComponent setThreePrime(CodeableConcept value) {
            this.threePrime = value;
            return this;
        }

        public List<SubstanceNucleicAcidSubunitLinkageComponent> getLinkage() {
            if (this.linkage == null) {
                this.linkage = new ArrayList<SubstanceNucleicAcidSubunitLinkageComponent>();
            }
            return this.linkage;
        }

        public SubstanceNucleicAcidSubunitComponent setLinkage(List<SubstanceNucleicAcidSubunitLinkageComponent> theLinkage) {
            this.linkage = theLinkage;
            return this;
        }

        public boolean hasLinkage() {
            if (this.linkage == null) {
                return false;
            }
            for (SubstanceNucleicAcidSubunitLinkageComponent item : this.linkage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceNucleicAcidSubunitLinkageComponent addLinkage() {
            SubstanceNucleicAcidSubunitLinkageComponent t = new SubstanceNucleicAcidSubunitLinkageComponent();
            if (this.linkage == null) {
                this.linkage = new ArrayList<SubstanceNucleicAcidSubunitLinkageComponent>();
            }
            this.linkage.add(t);
            return t;
        }

        public SubstanceNucleicAcidSubunitComponent addLinkage(SubstanceNucleicAcidSubunitLinkageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.linkage == null) {
                this.linkage = new ArrayList<SubstanceNucleicAcidSubunitLinkageComponent>();
            }
            this.linkage.add(t);
            return this;
        }

        public SubstanceNucleicAcidSubunitLinkageComponent getLinkageFirstRep() {
            if (this.getLinkage().isEmpty()) {
                this.addLinkage();
            }
            return this.getLinkage().get(0);
        }

        public List<SubstanceNucleicAcidSubunitSugarComponent> getSugar() {
            if (this.sugar == null) {
                this.sugar = new ArrayList<SubstanceNucleicAcidSubunitSugarComponent>();
            }
            return this.sugar;
        }

        public SubstanceNucleicAcidSubunitComponent setSugar(List<SubstanceNucleicAcidSubunitSugarComponent> theSugar) {
            this.sugar = theSugar;
            return this;
        }

        public boolean hasSugar() {
            if (this.sugar == null) {
                return false;
            }
            for (SubstanceNucleicAcidSubunitSugarComponent item : this.sugar) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceNucleicAcidSubunitSugarComponent addSugar() {
            SubstanceNucleicAcidSubunitSugarComponent t = new SubstanceNucleicAcidSubunitSugarComponent();
            if (this.sugar == null) {
                this.sugar = new ArrayList<SubstanceNucleicAcidSubunitSugarComponent>();
            }
            this.sugar.add(t);
            return t;
        }

        public SubstanceNucleicAcidSubunitComponent addSugar(SubstanceNucleicAcidSubunitSugarComponent t) {
            if (t == null) {
                return this;
            }
            if (this.sugar == null) {
                this.sugar = new ArrayList<SubstanceNucleicAcidSubunitSugarComponent>();
            }
            this.sugar.add(t);
            return this;
        }

        public SubstanceNucleicAcidSubunitSugarComponent getSugarFirstRep() {
            if (this.getSugar().isEmpty()) {
                this.addSugar();
            }
            return this.getSugar().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("subunit", "integer", "Index of linear sequences of nucleic acids in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.", 0, 1, this.subunit));
            children.add(new Property("sequence", "string", "Actual nucleotide sequence notation from 5' to 3' end using standard single letter codes. In addition to the base sequence, sugar and type of phosphate or non-phosphate linkage should also be captured.", 0, 1, this.sequence));
            children.add(new Property("length", "integer", "The length of the sequence shall be captured.", 0, 1, this.length));
            children.add(new Property("sequenceAttachment", "Attachment", "(TBC).", 0, 1, this.sequenceAttachment));
            children.add(new Property("fivePrime", "CodeableConcept", "The nucleotide present at the 5\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the first position in the sequence. A separate representation would be redundant.", 0, 1, this.fivePrime));
            children.add(new Property("threePrime", "CodeableConcept", "The nucleotide present at the 3\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the last position in the sequence. A separate representation would be redundant.", 0, 1, this.threePrime));
            children.add(new Property("linkage", "", "The linkages between sugar residues will also be captured.", 0, Integer.MAX_VALUE, this.linkage));
            children.add(new Property("sugar", "", "5.3.6.8.1 Sugar ID (Mandatory).", 0, Integer.MAX_VALUE, this.sugar));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1867548732: {
                    return new Property("subunit", "integer", "Index of linear sequences of nucleic acids in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.", 0, 1, this.subunit);
                }
                case 1349547969: {
                    return new Property("sequence", "string", "Actual nucleotide sequence notation from 5' to 3' end using standard single letter codes. In addition to the base sequence, sugar and type of phosphate or non-phosphate linkage should also be captured.", 0, 1, this.sequence);
                }
                case -1106363674: {
                    return new Property("length", "integer", "The length of the sequence shall be captured.", 0, 1, this.length);
                }
                case 364621764: {
                    return new Property("sequenceAttachment", "Attachment", "(TBC).", 0, 1, this.sequenceAttachment);
                }
                case -1045091603: {
                    return new Property("fivePrime", "CodeableConcept", "The nucleotide present at the 5\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the first position in the sequence. A separate representation would be redundant.", 0, 1, this.fivePrime);
                }
                case -1088032895: {
                    return new Property("threePrime", "CodeableConcept", "The nucleotide present at the 3\u2019 terminal shall be specified based on a controlled vocabulary. Since the sequence is represented from the 5' to the 3' end, the 5\u2019 prime nucleotide is the letter at the last position in the sequence. A separate representation would be redundant.", 0, 1, this.threePrime);
                }
                case 177082053: {
                    return new Property("linkage", "", "The linkages between sugar residues will also be captured.", 0, Integer.MAX_VALUE, this.linkage);
                }
                case 109792566: {
                    return new Property("sugar", "", "5.3.6.8.1 Sugar ID (Mandatory).", 0, Integer.MAX_VALUE, this.sugar);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    Base[] baseArray;
                    if (this.subunit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.subunit;
                    }
                    return baseArray;
                }
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -1106363674: {
                    Base[] baseArray;
                    if (this.length == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.length;
                    }
                    return baseArray;
                }
                case 364621764: {
                    Base[] baseArray;
                    if (this.sequenceAttachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.sequenceAttachment;
                    }
                    return baseArray;
                }
                case -1045091603: {
                    Base[] baseArray;
                    if (this.fivePrime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.fivePrime;
                    }
                    return baseArray;
                }
                case -1088032895: {
                    Base[] baseArray;
                    if (this.threePrime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.threePrime;
                    }
                    return baseArray;
                }
                case 177082053: {
                    return this.linkage == null ? new Base[]{} : this.linkage.toArray(new Base[this.linkage.size()]);
                }
                case 109792566: {
                    return this.sugar == null ? new Base[]{} : this.sugar.toArray(new Base[this.sugar.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    this.subunit = this.castToInteger(value);
                    return value;
                }
                case 1349547969: {
                    this.sequence = this.castToString(value);
                    return value;
                }
                case -1106363674: {
                    this.length = this.castToInteger(value);
                    return value;
                }
                case 364621764: {
                    this.sequenceAttachment = this.castToAttachment(value);
                    return value;
                }
                case -1045091603: {
                    this.fivePrime = this.castToCodeableConcept(value);
                    return value;
                }
                case -1088032895: {
                    this.threePrime = this.castToCodeableConcept(value);
                    return value;
                }
                case 177082053: {
                    this.getLinkage().add((SubstanceNucleicAcidSubunitLinkageComponent)value);
                    return value;
                }
                case 109792566: {
                    this.getSugar().add((SubstanceNucleicAcidSubunitSugarComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("subunit")) {
                this.subunit = this.castToInteger(value);
            } else if (name.equals("sequence")) {
                this.sequence = this.castToString(value);
            } else if (name.equals("length")) {
                this.length = this.castToInteger(value);
            } else if (name.equals("sequenceAttachment")) {
                this.sequenceAttachment = this.castToAttachment(value);
            } else if (name.equals("fivePrime")) {
                this.fivePrime = this.castToCodeableConcept(value);
            } else if (name.equals("threePrime")) {
                this.threePrime = this.castToCodeableConcept(value);
            } else if (name.equals("linkage")) {
                this.getLinkage().add((SubstanceNucleicAcidSubunitLinkageComponent)value);
            } else if (name.equals("sugar")) {
                this.getSugar().add((SubstanceNucleicAcidSubunitSugarComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    return this.getSubunitElement();
                }
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -1106363674: {
                    return this.getLengthElement();
                }
                case 364621764: {
                    return this.getSequenceAttachment();
                }
                case -1045091603: {
                    return this.getFivePrime();
                }
                case -1088032895: {
                    return this.getThreePrime();
                }
                case 177082053: {
                    return this.addLinkage();
                }
                case 109792566: {
                    return this.addSugar();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    return new String[]{"integer"};
                }
                case 1349547969: {
                    return new String[]{"string"};
                }
                case -1106363674: {
                    return new String[]{"integer"};
                }
                case 364621764: {
                    return new String[]{"Attachment"};
                }
                case -1045091603: {
                    return new String[]{"CodeableConcept"};
                }
                case -1088032895: {
                    return new String[]{"CodeableConcept"};
                }
                case 177082053: {
                    return new String[0];
                }
                case 109792566: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("subunit")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.subunit");
            }
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.sequence");
            }
            if (name.equals("length")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceNucleicAcid.length");
            }
            if (name.equals("sequenceAttachment")) {
                this.sequenceAttachment = new Attachment();
                return this.sequenceAttachment;
            }
            if (name.equals("fivePrime")) {
                this.fivePrime = new CodeableConcept();
                return this.fivePrime;
            }
            if (name.equals("threePrime")) {
                this.threePrime = new CodeableConcept();
                return this.threePrime;
            }
            if (name.equals("linkage")) {
                return this.addLinkage();
            }
            if (name.equals("sugar")) {
                return this.addSugar();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceNucleicAcidSubunitComponent copy() {
            SubstanceNucleicAcidSubunitComponent dst = new SubstanceNucleicAcidSubunitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceNucleicAcidSubunitComponent dst) {
            super.copyValues(dst);
            dst.subunit = this.subunit == null ? null : this.subunit.copy();
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.length = this.length == null ? null : this.length.copy();
            dst.sequenceAttachment = this.sequenceAttachment == null ? null : this.sequenceAttachment.copy();
            dst.fivePrime = this.fivePrime == null ? null : this.fivePrime.copy();
            CodeableConcept codeableConcept = dst.threePrime = this.threePrime == null ? null : this.threePrime.copy();
            if (this.linkage != null) {
                dst.linkage = new ArrayList<SubstanceNucleicAcidSubunitLinkageComponent>();
                for (SubstanceNucleicAcidSubunitLinkageComponent substanceNucleicAcidSubunitLinkageComponent : this.linkage) {
                    dst.linkage.add(substanceNucleicAcidSubunitLinkageComponent.copy());
                }
            }
            if (this.sugar != null) {
                dst.sugar = new ArrayList<SubstanceNucleicAcidSubunitSugarComponent>();
                for (SubstanceNucleicAcidSubunitSugarComponent substanceNucleicAcidSubunitSugarComponent : this.sugar) {
                    dst.sugar.add(substanceNucleicAcidSubunitSugarComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceNucleicAcidSubunitComponent)) {
                return false;
            }
            SubstanceNucleicAcidSubunitComponent o = (SubstanceNucleicAcidSubunitComponent)other_;
            return SubstanceNucleicAcidSubunitComponent.compareDeep(this.subunit, o.subunit, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.sequence, o.sequence, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.length, o.length, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.sequenceAttachment, o.sequenceAttachment, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.fivePrime, o.fivePrime, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.threePrime, o.threePrime, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.linkage, o.linkage, true) && SubstanceNucleicAcidSubunitComponent.compareDeep(this.sugar, o.sugar, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceNucleicAcidSubunitComponent)) {
                return false;
            }
            SubstanceNucleicAcidSubunitComponent o = (SubstanceNucleicAcidSubunitComponent)other_;
            return SubstanceNucleicAcidSubunitComponent.compareValues(this.subunit, o.subunit, true) && SubstanceNucleicAcidSubunitComponent.compareValues(this.sequence, o.sequence, true) && SubstanceNucleicAcidSubunitComponent.compareValues(this.length, o.length, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.subunit, this.sequence, this.length, this.sequenceAttachment, this.fivePrime, this.threePrime, this.linkage, this.sugar);
        }

        @Override
        public String fhirType() {
            return "SubstanceNucleicAcid.subunit";
        }
    }
}

