/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.EvidenceVariable;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RiskEvidenceSynthesis", profile="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "date", "publisher", "contact", "description", "note", "useContext", "jurisdiction", "copyright", "approvalDate", "lastReviewDate", "effectivePeriod", "topic", "author", "editor", "reviewer", "endorser", "relatedArtifact", "synthesisType", "studyType", "population", "exposure", "outcome", "sampleSize", "riskEstimate", "certainty"})
public class RiskEvidenceSynthesis
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the risk evidence synthesis", formalDefinition="A formal identifier that is used to identify this risk evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="note", type={Annotation.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
    protected List<Annotation> note;
    @Child(name="copyright", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the risk evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the risk evidence synthesis.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the risk evidence synthesis was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the risk evidence synthesis was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the risk evidence synthesis is expected to be used", formalDefinition="The period during which the risk evidence synthesis content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the EffectEvidenceSynthesis, such as Education, Treatment, Assessment, etc.", formalDefinition="Descriptive topics related to the content of the RiskEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="synthesisType", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of synthesis", formalDefinition="Type of synthesis eg meta-analysis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/synthesis-type")
    protected CodeableConcept synthesisType;
    @Child(name="studyType", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of study", formalDefinition="Type of study eg randomized trial.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/study-type")
    protected CodeableConcept studyType;
    @Child(name="population", type={EvidenceVariable.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What population?", formalDefinition="A reference to a EvidenceVariable resource that defines the population for the research.")
    protected Reference population;
    protected EvidenceVariable populationTarget;
    @Child(name="exposure", type={EvidenceVariable.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What exposure?", formalDefinition="A reference to a EvidenceVariable resource that defines the exposure for the research.")
    protected Reference exposure;
    protected EvidenceVariable exposureTarget;
    @Child(name="outcome", type={EvidenceVariable.class}, order=16, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What outcome?", formalDefinition="A reference to a EvidenceVariable resomece that defines the outcome for the research.")
    protected Reference outcome;
    protected EvidenceVariable outcomeTarget;
    @Child(name="sampleSize", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What sample size was involved?", formalDefinition="A description of the size of the sample involved in the synthesis.")
    protected RiskEvidenceSynthesisSampleSizeComponent sampleSize;
    @Child(name="riskEstimate", type={}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What was the estimated risk", formalDefinition="The estimated risk of the outcome.")
    protected RiskEvidenceSynthesisRiskEstimateComponent riskEstimate;
    @Child(name="certainty", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="How certain is the risk", formalDefinition="A description of the certainty of the risk estimate.")
    protected List<RiskEvidenceSynthesisCertaintyComponent> certainty;
    private static final long serialVersionUID = 706492815L;
    @SearchParamDefinition(name="date", path="RiskEvidenceSynthesis.date", description="The risk evidence synthesis publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="RiskEvidenceSynthesis.identifier", description="External identifier for the risk evidence synthesis", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="context-type-value", path="RiskEvidenceSynthesis.useContext", description="A use context type and value assigned to the risk evidence synthesis", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="RiskEvidenceSynthesis.jurisdiction", description="Intended jurisdiction for the risk evidence synthesis", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="RiskEvidenceSynthesis.description", description="The description of the risk evidence synthesis", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="RiskEvidenceSynthesis.useContext.code", description="A type of use context assigned to the risk evidence synthesis", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="RiskEvidenceSynthesis.title", description="The human-friendly name of the risk evidence synthesis", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="RiskEvidenceSynthesis.version", description="The business version of the risk evidence synthesis", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="RiskEvidenceSynthesis.url", description="The uri that identifies the risk evidence synthesis", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(RiskEvidenceSynthesis.useContext.value as Quantity) | (RiskEvidenceSynthesis.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the risk evidence synthesis", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="effective", path="RiskEvidenceSynthesis.effectivePeriod", description="The time during which the risk evidence synthesis is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="name", path="RiskEvidenceSynthesis.name", description="Computationally friendly name of the risk evidence synthesis", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(RiskEvidenceSynthesis.useContext.value as CodeableConcept)", description="A use context assigned to the risk evidence synthesis", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="RiskEvidenceSynthesis.publisher", description="Name of the publisher of the risk evidence synthesis", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="context-type-quantity", path="RiskEvidenceSynthesis.useContext", description="A use context type and quantity- or range-based value assigned to the risk evidence synthesis", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="RiskEvidenceSynthesis.status", description="The current status of the risk evidence synthesis", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public RiskEvidenceSynthesis() {
    }

    public RiskEvidenceSynthesis(Enumeration<Enumerations.PublicationStatus> status, Reference population, Reference outcome) {
        this.status = status;
        this.population = population;
        this.outcome = outcome;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RiskEvidenceSynthesis setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public RiskEvidenceSynthesis setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public RiskEvidenceSynthesis setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public RiskEvidenceSynthesis addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public RiskEvidenceSynthesis setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public RiskEvidenceSynthesis setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public RiskEvidenceSynthesis setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public RiskEvidenceSynthesis setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public RiskEvidenceSynthesis addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public RiskEvidenceSynthesis setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public RiskEvidenceSynthesis addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public RiskEvidenceSynthesis setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public RiskEvidenceSynthesis setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public RiskEvidenceSynthesis setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public RiskEvidenceSynthesis setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public RiskEvidenceSynthesis setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public RiskEvidenceSynthesis setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public RiskEvidenceSynthesis setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public RiskEvidenceSynthesis setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    public RiskEvidenceSynthesis setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    public RiskEvidenceSynthesis setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    public RiskEvidenceSynthesis setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    public RiskEvidenceSynthesis setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public RiskEvidenceSynthesis setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public CodeableConcept getSynthesisType() {
        if (this.synthesisType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.synthesisType");
            }
            if (Configuration.doAutoCreate()) {
                this.synthesisType = new CodeableConcept();
            }
        }
        return this.synthesisType;
    }

    public boolean hasSynthesisType() {
        return this.synthesisType != null && !this.synthesisType.isEmpty();
    }

    public RiskEvidenceSynthesis setSynthesisType(CodeableConcept value) {
        this.synthesisType = value;
        return this;
    }

    public CodeableConcept getStudyType() {
        if (this.studyType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.studyType");
            }
            if (Configuration.doAutoCreate()) {
                this.studyType = new CodeableConcept();
            }
        }
        return this.studyType;
    }

    public boolean hasStudyType() {
        return this.studyType != null && !this.studyType.isEmpty();
    }

    public RiskEvidenceSynthesis setStudyType(CodeableConcept value) {
        this.studyType = value;
        return this;
    }

    public Reference getPopulation() {
        if (this.population == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.population");
            }
            if (Configuration.doAutoCreate()) {
                this.population = new Reference();
            }
        }
        return this.population;
    }

    public boolean hasPopulation() {
        return this.population != null && !this.population.isEmpty();
    }

    public RiskEvidenceSynthesis setPopulation(Reference value) {
        this.population = value;
        return this;
    }

    public EvidenceVariable getPopulationTarget() {
        if (this.populationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.population");
            }
            if (Configuration.doAutoCreate()) {
                this.populationTarget = new EvidenceVariable();
            }
        }
        return this.populationTarget;
    }

    public RiskEvidenceSynthesis setPopulationTarget(EvidenceVariable value) {
        this.populationTarget = value;
        return this;
    }

    public Reference getExposure() {
        if (this.exposure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.exposure");
            }
            if (Configuration.doAutoCreate()) {
                this.exposure = new Reference();
            }
        }
        return this.exposure;
    }

    public boolean hasExposure() {
        return this.exposure != null && !this.exposure.isEmpty();
    }

    public RiskEvidenceSynthesis setExposure(Reference value) {
        this.exposure = value;
        return this;
    }

    public EvidenceVariable getExposureTarget() {
        if (this.exposureTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.exposure");
            }
            if (Configuration.doAutoCreate()) {
                this.exposureTarget = new EvidenceVariable();
            }
        }
        return this.exposureTarget;
    }

    public RiskEvidenceSynthesis setExposureTarget(EvidenceVariable value) {
        this.exposureTarget = value;
        return this;
    }

    public Reference getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Reference();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public RiskEvidenceSynthesis setOutcome(Reference value) {
        this.outcome = value;
        return this;
    }

    public EvidenceVariable getOutcomeTarget() {
        if (this.outcomeTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcomeTarget = new EvidenceVariable();
            }
        }
        return this.outcomeTarget;
    }

    public RiskEvidenceSynthesis setOutcomeTarget(EvidenceVariable value) {
        this.outcomeTarget = value;
        return this;
    }

    public RiskEvidenceSynthesisSampleSizeComponent getSampleSize() {
        if (this.sampleSize == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.sampleSize");
            }
            if (Configuration.doAutoCreate()) {
                this.sampleSize = new RiskEvidenceSynthesisSampleSizeComponent();
            }
        }
        return this.sampleSize;
    }

    public boolean hasSampleSize() {
        return this.sampleSize != null && !this.sampleSize.isEmpty();
    }

    public RiskEvidenceSynthesis setSampleSize(RiskEvidenceSynthesisSampleSizeComponent value) {
        this.sampleSize = value;
        return this;
    }

    public RiskEvidenceSynthesisRiskEstimateComponent getRiskEstimate() {
        if (this.riskEstimate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskEvidenceSynthesis.riskEstimate");
            }
            if (Configuration.doAutoCreate()) {
                this.riskEstimate = new RiskEvidenceSynthesisRiskEstimateComponent();
            }
        }
        return this.riskEstimate;
    }

    public boolean hasRiskEstimate() {
        return this.riskEstimate != null && !this.riskEstimate.isEmpty();
    }

    public RiskEvidenceSynthesis setRiskEstimate(RiskEvidenceSynthesisRiskEstimateComponent value) {
        this.riskEstimate = value;
        return this;
    }

    public List<RiskEvidenceSynthesisCertaintyComponent> getCertainty() {
        if (this.certainty == null) {
            this.certainty = new ArrayList<RiskEvidenceSynthesisCertaintyComponent>();
        }
        return this.certainty;
    }

    public RiskEvidenceSynthesis setCertainty(List<RiskEvidenceSynthesisCertaintyComponent> theCertainty) {
        this.certainty = theCertainty;
        return this;
    }

    public boolean hasCertainty() {
        if (this.certainty == null) {
            return false;
        }
        for (RiskEvidenceSynthesisCertaintyComponent item : this.certainty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RiskEvidenceSynthesisCertaintyComponent addCertainty() {
        RiskEvidenceSynthesisCertaintyComponent t = new RiskEvidenceSynthesisCertaintyComponent();
        if (this.certainty == null) {
            this.certainty = new ArrayList<RiskEvidenceSynthesisCertaintyComponent>();
        }
        this.certainty.add(t);
        return t;
    }

    public RiskEvidenceSynthesis addCertainty(RiskEvidenceSynthesisCertaintyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.certainty == null) {
            this.certainty = new ArrayList<RiskEvidenceSynthesisCertaintyComponent>();
        }
        this.certainty.add(t);
        return this;
    }

    public RiskEvidenceSynthesisCertaintyComponent getCertaintyFirstRep() {
        if (this.getCertainty().isEmpty()) {
            this.addCertainty();
        }
        return this.getCertainty().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this risk evidence synthesis when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this risk evidence synthesis is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the risk evidence synthesis is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this risk evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the risk evidence synthesis when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the risk evidence synthesis author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the risk evidence synthesis. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the risk evidence synthesis.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this risk evidence synthesis. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the risk evidence synthesis was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the risk evidence synthesis changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the risk evidence synthesis.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the risk evidence synthesis from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate risk evidence synthesis instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the risk evidence synthesis is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the risk evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the risk evidence synthesis.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the risk evidence synthesis content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("topic", "CodeableConcept", "Descriptive topics related to the content of the RiskEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("synthesisType", "CodeableConcept", "Type of synthesis eg meta-analysis.", 0, 1, this.synthesisType));
        children.add(new Property("studyType", "CodeableConcept", "Type of study eg randomized trial.", 0, 1, this.studyType));
        children.add(new Property("population", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the population for the research.", 0, 1, this.population));
        children.add(new Property("exposure", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the exposure for the research.", 0, 1, this.exposure));
        children.add(new Property("outcome", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resomece that defines the outcome for the research.", 0, 1, this.outcome));
        children.add(new Property("sampleSize", "", "A description of the size of the sample involved in the synthesis.", 0, 1, this.sampleSize));
        children.add(new Property("riskEstimate", "", "The estimated risk of the outcome.", 0, 1, this.riskEstimate));
        children.add(new Property("certainty", "", "A description of the certainty of the risk estimate.", 0, Integer.MAX_VALUE, this.certainty));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this risk evidence synthesis when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this risk evidence synthesis is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the risk evidence synthesis is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this risk evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the risk evidence synthesis when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the risk evidence synthesis author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the risk evidence synthesis. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the risk evidence synthesis.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this risk evidence synthesis. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the risk evidence synthesis was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the risk evidence synthesis changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the risk evidence synthesis.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the risk evidence synthesis from a consumer's perspective.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate risk evidence synthesis instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the risk evidence synthesis is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the risk evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the risk evidence synthesis.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the risk evidence synthesis content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property("topic", "CodeableConcept", "Descriptive topics related to the content of the RiskEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 672726254: {
                return new Property("synthesisType", "CodeableConcept", "Type of synthesis eg meta-analysis.", 0, 1, this.synthesisType);
            }
            case -1955265373: {
                return new Property("studyType", "CodeableConcept", "Type of study eg randomized trial.", 0, 1, this.studyType);
            }
            case -2023558323: {
                return new Property("population", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the population for the research.", 0, 1, this.population);
            }
            case -1926005497: {
                return new Property("exposure", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resource that defines the exposure for the research.", 0, 1, this.exposure);
            }
            case -1106507950: {
                return new Property("outcome", "Reference(EvidenceVariable)", "A reference to a EvidenceVariable resomece that defines the outcome for the research.", 0, 1, this.outcome);
            }
            case 143123659: {
                return new Property("sampleSize", "", "A description of the size of the sample involved in the synthesis.", 0, 1, this.sampleSize);
            }
            case -1014254313: {
                return new Property("riskEstimate", "", "The estimated risk of the outcome.", 0, 1, this.riskEstimate);
            }
            case -1404142937: {
                return new Property("certainty", "", "A description of the certainty of the risk estimate.", 0, Integer.MAX_VALUE, this.certainty);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 672726254: {
                Base[] baseArray;
                if (this.synthesisType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.synthesisType;
                }
                return baseArray;
            }
            case -1955265373: {
                Base[] baseArray;
                if (this.studyType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.studyType;
                }
                return baseArray;
            }
            case -2023558323: {
                Base[] baseArray;
                if (this.population == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.population;
                }
                return baseArray;
            }
            case -1926005497: {
                Base[] baseArray;
                if (this.exposure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.exposure;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.outcome;
                }
                return baseArray;
            }
            case 143123659: {
                Base[] baseArray;
                if (this.sampleSize == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.sampleSize;
                }
                return baseArray;
            }
            case -1014254313: {
                Base[] baseArray;
                if (this.riskEstimate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.riskEstimate;
                }
                return baseArray;
            }
            case -1404142937: {
                return this.certainty == null ? new Base[]{} : this.certainty.toArray(new Base[this.certainty.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(this.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(this.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 672726254: {
                this.synthesisType = this.castToCodeableConcept(value);
                return value;
            }
            case -1955265373: {
                this.studyType = this.castToCodeableConcept(value);
                return value;
            }
            case -2023558323: {
                this.population = this.castToReference(value);
                return value;
            }
            case -1926005497: {
                this.exposure = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                this.outcome = this.castToReference(value);
                return value;
            }
            case 143123659: {
                this.sampleSize = (RiskEvidenceSynthesisSampleSizeComponent)((Object)value);
                return value;
            }
            case -1014254313: {
                this.riskEstimate = (RiskEvidenceSynthesisRiskEstimateComponent)((Object)value);
                return value;
            }
            case -1404142937: {
                this.getCertainty().add((RiskEvidenceSynthesisCertaintyComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("topic")) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(this.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(this.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("synthesisType")) {
            this.synthesisType = this.castToCodeableConcept(value);
        } else if (name.equals("studyType")) {
            this.studyType = this.castToCodeableConcept(value);
        } else if (name.equals("population")) {
            this.population = this.castToReference(value);
        } else if (name.equals("exposure")) {
            this.exposure = this.castToReference(value);
        } else if (name.equals("outcome")) {
            this.outcome = this.castToReference(value);
        } else if (name.equals("sampleSize")) {
            this.sampleSize = (RiskEvidenceSynthesisSampleSizeComponent)((Object)value);
        } else if (name.equals("riskEstimate")) {
            this.riskEstimate = (RiskEvidenceSynthesisRiskEstimateComponent)((Object)value);
        } else if (name.equals("certainty")) {
            this.getCertainty().add((RiskEvidenceSynthesisCertaintyComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 672726254: {
                return this.getSynthesisType();
            }
            case -1955265373: {
                return this.getStudyType();
            }
            case -2023558323: {
                return this.getPopulation();
            }
            case -1926005497: {
                return this.getExposure();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case 143123659: {
                return this.getSampleSize();
            }
            case -1014254313: {
                return this.getRiskEstimate();
            }
            case -1404142937: {
                return this.addCertainty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 672726254: {
                return new String[]{"CodeableConcept"};
            }
            case -1955265373: {
                return new String[]{"CodeableConcept"};
            }
            case -2023558323: {
                return new String[]{"Reference"};
            }
            case -1926005497: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"Reference"};
            }
            case 143123659: {
                return new String[0];
            }
            case -1014254313: {
                return new String[0];
            }
            case -1404142937: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("topic")) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("synthesisType")) {
            this.synthesisType = new CodeableConcept();
            return this.synthesisType;
        }
        if (name.equals("studyType")) {
            this.studyType = new CodeableConcept();
            return this.studyType;
        }
        if (name.equals("population")) {
            this.population = new Reference();
            return this.population;
        }
        if (name.equals("exposure")) {
            this.exposure = new Reference();
            return this.exposure;
        }
        if (name.equals("outcome")) {
            this.outcome = new Reference();
            return this.outcome;
        }
        if (name.equals("sampleSize")) {
            this.sampleSize = new RiskEvidenceSynthesisSampleSizeComponent();
            return this.sampleSize;
        }
        if (name.equals("riskEstimate")) {
            this.riskEstimate = new RiskEvidenceSynthesisRiskEstimateComponent();
            return this.riskEstimate;
        }
        if (name.equals("certainty")) {
            return this.addCertainty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RiskEvidenceSynthesis";
    }

    @Override
    public RiskEvidenceSynthesis copy() {
        RiskEvidenceSynthesis dst = new RiskEvidenceSynthesis();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RiskEvidenceSynthesis dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.synthesisType = this.synthesisType == null ? null : this.synthesisType.copy();
        dst.studyType = this.studyType == null ? null : this.studyType.copy();
        dst.population = this.population == null ? null : this.population.copy();
        dst.exposure = this.exposure == null ? null : this.exposure.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.sampleSize = this.sampleSize == null ? null : this.sampleSize.copy();
        RiskEvidenceSynthesisRiskEstimateComponent riskEvidenceSynthesisRiskEstimateComponent = dst.riskEstimate = this.riskEstimate == null ? null : this.riskEstimate.copy();
        if (this.certainty != null) {
            dst.certainty = new ArrayList<RiskEvidenceSynthesisCertaintyComponent>();
            for (RiskEvidenceSynthesisCertaintyComponent riskEvidenceSynthesisCertaintyComponent : this.certainty) {
                dst.certainty.add(riskEvidenceSynthesisCertaintyComponent.copy());
            }
        }
    }

    protected RiskEvidenceSynthesis typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RiskEvidenceSynthesis)) {
            return false;
        }
        RiskEvidenceSynthesis o = (RiskEvidenceSynthesis)other_;
        return RiskEvidenceSynthesis.compareDeep(this.identifier, o.identifier, true) && RiskEvidenceSynthesis.compareDeep(this.note, o.note, true) && RiskEvidenceSynthesis.compareDeep(this.copyright, o.copyright, true) && RiskEvidenceSynthesis.compareDeep(this.approvalDate, o.approvalDate, true) && RiskEvidenceSynthesis.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && RiskEvidenceSynthesis.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && RiskEvidenceSynthesis.compareDeep(this.topic, o.topic, true) && RiskEvidenceSynthesis.compareDeep(this.author, o.author, true) && RiskEvidenceSynthesis.compareDeep(this.editor, o.editor, true) && RiskEvidenceSynthesis.compareDeep(this.reviewer, o.reviewer, true) && RiskEvidenceSynthesis.compareDeep(this.endorser, o.endorser, true) && RiskEvidenceSynthesis.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && RiskEvidenceSynthesis.compareDeep(this.synthesisType, o.synthesisType, true) && RiskEvidenceSynthesis.compareDeep(this.studyType, o.studyType, true) && RiskEvidenceSynthesis.compareDeep(this.population, o.population, true) && RiskEvidenceSynthesis.compareDeep(this.exposure, o.exposure, true) && RiskEvidenceSynthesis.compareDeep(this.outcome, o.outcome, true) && RiskEvidenceSynthesis.compareDeep(this.sampleSize, o.sampleSize, true) && RiskEvidenceSynthesis.compareDeep(this.riskEstimate, o.riskEstimate, true) && RiskEvidenceSynthesis.compareDeep(this.certainty, o.certainty, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RiskEvidenceSynthesis)) {
            return false;
        }
        RiskEvidenceSynthesis o = (RiskEvidenceSynthesis)other_;
        return RiskEvidenceSynthesis.compareValues(this.copyright, o.copyright, true) && RiskEvidenceSynthesis.compareValues(this.approvalDate, o.approvalDate, true) && RiskEvidenceSynthesis.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.note, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.synthesisType, this.studyType, this.population, this.exposure, this.outcome, this.sampleSize, this.riskEstimate, this.certainty);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RiskEvidenceSynthesis;
    }

    @Block
    public static class RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of subcomponent of certainty rating", formalDefinition="Type of subcomponent of certainty rating.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-type")
        protected CodeableConcept type;
        @Child(name="rating", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subcomponent certainty rating", formalDefinition="A rating of a subcomponent of rating certainty.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-rating")
        protected List<CodeableConcept> rating;
        @Child(name="note", type={Annotation.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -411994816L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getRating() {
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            return this.rating;
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent setRating(List<CodeableConcept> theRating) {
            this.rating = theRating;
            return this;
        }

        public boolean hasRating() {
            if (this.rating == null) {
                return false;
            }
            for (CodeableConcept item : this.rating) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRating() {
            CodeableConcept t = new CodeableConcept();
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return t;
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent addRating(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return this;
        }

        public CodeableConcept getRatingFirstRep() {
            if (this.getRating().isEmpty()) {
                this.addRating();
            }
            return this.getRating().get(0);
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of subcomponent of certainty rating.", 0, 1, this.type));
            children.add(new Property("rating", "CodeableConcept", "A rating of a subcomponent of rating certainty.", 0, Integer.MAX_VALUE, this.rating));
            children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of subcomponent of certainty rating.", 0, 1, this.type);
                }
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "A rating of a subcomponent of rating certainty.", 0, Integer.MAX_VALUE, this.rating);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -938102371: {
                    return this.rating == null ? new Base[]{} : this.rating.toArray(new Base[this.rating.size()]);
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -938102371: {
                    this.getRating().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("rating")) {
                this.getRating().add(this.castToCodeableConcept(value));
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -938102371: {
                    return this.addRating();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("rating")) {
                return this.addRating();
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent copy() {
            RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent dst = new RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.rating != null) {
                dst.rating = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.rating) {
                    dst.rating.add(codeableConcept2.copy());
                }
            }
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent)) {
                return false;
            }
            RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent o = (RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent)other_;
            return RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent.compareDeep(this.type, o.type, true) && RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent.compareDeep(this.rating, o.rating, true) && RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent)) {
                return false;
            }
            RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent o = (RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.rating, this.note);
        }

        @Override
        public String fhirType() {
            return "RiskEvidenceSynthesis.certainty.certaintySubcomponent";
        }
    }

    @Block
    public static class RiskEvidenceSynthesisCertaintyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="rating", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Certainty rating", formalDefinition="A rating of the certainty of the effect estimate.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-quality")
        protected List<CodeableConcept> rating;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
        protected List<Annotation> note;
        @Child(name="certaintySubcomponent", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A component that contributes to the overall certainty", formalDefinition="A description of a component of the overall certainty.")
        protected List<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent> certaintySubcomponent;
        private static final long serialVersionUID = 663360871L;

        public List<CodeableConcept> getRating() {
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            return this.rating;
        }

        public RiskEvidenceSynthesisCertaintyComponent setRating(List<CodeableConcept> theRating) {
            this.rating = theRating;
            return this;
        }

        public boolean hasRating() {
            if (this.rating == null) {
                return false;
            }
            for (CodeableConcept item : this.rating) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRating() {
            CodeableConcept t = new CodeableConcept();
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return t;
        }

        public RiskEvidenceSynthesisCertaintyComponent addRating(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rating == null) {
                this.rating = new ArrayList<CodeableConcept>();
            }
            this.rating.add(t);
            return this;
        }

        public CodeableConcept getRatingFirstRep() {
            if (this.getRating().isEmpty()) {
                this.addRating();
            }
            return this.getRating().get(0);
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public RiskEvidenceSynthesisCertaintyComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public RiskEvidenceSynthesisCertaintyComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public List<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent> getCertaintySubcomponent() {
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
            }
            return this.certaintySubcomponent;
        }

        public RiskEvidenceSynthesisCertaintyComponent setCertaintySubcomponent(List<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent> theCertaintySubcomponent) {
            this.certaintySubcomponent = theCertaintySubcomponent;
            return this;
        }

        public boolean hasCertaintySubcomponent() {
            if (this.certaintySubcomponent == null) {
                return false;
            }
            for (RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent item : this.certaintySubcomponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent addCertaintySubcomponent() {
            RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent t = new RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent();
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
            }
            this.certaintySubcomponent.add(t);
            return t;
        }

        public RiskEvidenceSynthesisCertaintyComponent addCertaintySubcomponent(RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.certaintySubcomponent == null) {
                this.certaintySubcomponent = new ArrayList<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
            }
            this.certaintySubcomponent.add(t);
            return this;
        }

        public RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent getCertaintySubcomponentFirstRep() {
            if (this.getCertaintySubcomponent().isEmpty()) {
                this.addCertaintySubcomponent();
            }
            return this.getCertaintySubcomponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("rating", "CodeableConcept", "A rating of the certainty of the effect estimate.", 0, Integer.MAX_VALUE, this.rating));
            children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("certaintySubcomponent", "", "A description of a component of the overall certainty.", 0, Integer.MAX_VALUE, this.certaintySubcomponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -938102371: {
                    return new Property("rating", "CodeableConcept", "A rating of the certainty of the effect estimate.", 0, Integer.MAX_VALUE, this.rating);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
                }
                case 1806398212: {
                    return new Property("certaintySubcomponent", "", "A description of a component of the overall certainty.", 0, Integer.MAX_VALUE, this.certaintySubcomponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    return this.rating == null ? new Base[]{} : this.rating.toArray(new Base[this.rating.size()]);
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 1806398212: {
                    return this.certaintySubcomponent == null ? new Base[]{} : this.certaintySubcomponent.toArray(new Base[this.certaintySubcomponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    this.getRating().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
                case 1806398212: {
                    this.getCertaintySubcomponent().add((RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("rating")) {
                this.getRating().add(this.castToCodeableConcept(value));
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else if (name.equals("certaintySubcomponent")) {
                this.getCertaintySubcomponent().add((RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    return this.addRating();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 1806398212: {
                    return this.addCertaintySubcomponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -938102371: {
                    return new String[]{"CodeableConcept"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 1806398212: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("rating")) {
                return this.addRating();
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("certaintySubcomponent")) {
                return this.addCertaintySubcomponent();
            }
            return super.addChild(name);
        }

        @Override
        public RiskEvidenceSynthesisCertaintyComponent copy() {
            RiskEvidenceSynthesisCertaintyComponent dst = new RiskEvidenceSynthesisCertaintyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RiskEvidenceSynthesisCertaintyComponent dst) {
            super.copyValues(dst);
            if (this.rating != null) {
                dst.rating = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.rating) {
                    dst.rating.add(codeableConcept.copy());
                }
            }
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            if (this.certaintySubcomponent != null) {
                dst.certaintySubcomponent = new ArrayList<RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent>();
                for (RiskEvidenceSynthesisCertaintyCertaintySubcomponentComponent riskEvidenceSynthesisCertaintyCertaintySubcomponentComponent : this.certaintySubcomponent) {
                    dst.certaintySubcomponent.add(riskEvidenceSynthesisCertaintyCertaintySubcomponentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisCertaintyComponent)) {
                return false;
            }
            RiskEvidenceSynthesisCertaintyComponent o = (RiskEvidenceSynthesisCertaintyComponent)other_;
            return RiskEvidenceSynthesisCertaintyComponent.compareDeep(this.rating, o.rating, true) && RiskEvidenceSynthesisCertaintyComponent.compareDeep(this.note, o.note, true) && RiskEvidenceSynthesisCertaintyComponent.compareDeep(this.certaintySubcomponent, o.certaintySubcomponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisCertaintyComponent)) {
                return false;
            }
            RiskEvidenceSynthesisCertaintyComponent o = (RiskEvidenceSynthesisCertaintyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.rating, this.note, this.certaintySubcomponent);
        }

        @Override
        public String fhirType() {
            return "RiskEvidenceSynthesis.certainty";
        }
    }

    @Block
    public static class RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of precision estimate", formalDefinition="Examples include confidence interval and interquartile range.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/precision-estimate-type")
        protected CodeableConcept type;
        @Child(name="level", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Level of confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="from", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Lower bound", formalDefinition="Lower bound of confidence interval.")
        protected DecimalType from;
        @Child(name="to", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Upper bound", formalDefinition="Upper bound of confidence interval.")
        protected DecimalType to;
        private static final long serialVersionUID = -110178057L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public DecimalType getFromElement() {
            if (this.from == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.from");
                }
                if (Configuration.doAutoCreate()) {
                    this.from = new DecimalType();
                }
            }
            return this.from;
        }

        public boolean hasFromElement() {
            return this.from != null && !this.from.isEmpty();
        }

        public boolean hasFrom() {
            return this.from != null && !this.from.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setFromElement(DecimalType value) {
            this.from = value;
            return this;
        }

        public BigDecimal getFrom() {
            return this.from == null ? null : (BigDecimal)this.from.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setFrom(BigDecimal value) {
            if (value == null) {
                this.from = null;
            } else {
                if (this.from == null) {
                    this.from = new DecimalType();
                }
                this.from.setValue(value);
            }
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setFrom(long value) {
            this.from = new DecimalType();
            this.from.setValue(value);
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setFrom(double value) {
            this.from = new DecimalType();
            this.from.setValue(value);
            return this;
        }

        public DecimalType getToElement() {
            if (this.to == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.to");
                }
                if (Configuration.doAutoCreate()) {
                    this.to = new DecimalType();
                }
            }
            return this.to;
        }

        public boolean hasToElement() {
            return this.to != null && !this.to.isEmpty();
        }

        public boolean hasTo() {
            return this.to != null && !this.to.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setToElement(DecimalType value) {
            this.to = value;
            return this;
        }

        public BigDecimal getTo() {
            return this.to == null ? null : (BigDecimal)this.to.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setTo(BigDecimal value) {
            if (value == null) {
                this.to = null;
            } else {
                if (this.to == null) {
                    this.to = new DecimalType();
                }
                this.to.setValue(value);
            }
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setTo(long value) {
            this.to = new DecimalType();
            this.to.setValue(value);
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent setTo(double value) {
            this.to = new DecimalType();
            this.to.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Examples include confidence interval and interquartile range.", 0, 1, this.type));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("from", "decimal", "Lower bound of confidence interval.", 0, 1, this.from));
            children.add(new Property("to", "decimal", "Upper bound of confidence interval.", 0, 1, this.to));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Examples include confidence interval and interquartile range.", 0, 1, this.type);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 3151786: {
                    return new Property("from", "decimal", "Lower bound of confidence interval.", 0, 1, this.from);
                }
                case 3707: {
                    return new Property("to", "decimal", "Upper bound of confidence interval.", 0, 1, this.to);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.level;
                    }
                    return baseArray;
                }
                case 3151786: {
                    Base[] baseArray;
                    if (this.from == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.from;
                    }
                    return baseArray;
                }
                case 3707: {
                    Base[] baseArray;
                    if (this.to == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.to;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 102865796: {
                    this.level = this.castToDecimal(value);
                    return value;
                }
                case 3151786: {
                    this.from = this.castToDecimal(value);
                    return value;
                }
                case 3707: {
                    this.to = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("level")) {
                this.level = this.castToDecimal(value);
            } else if (name.equals("from")) {
                this.from = this.castToDecimal(value);
            } else if (name.equals("to")) {
                this.to = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 3151786: {
                    return this.getFromElement();
                }
                case 3707: {
                    return this.getToElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 3151786: {
                    return new String[]{"decimal"};
                }
                case 3707: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.level");
            }
            if (name.equals("from")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.from");
            }
            if (name.equals("to")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.to");
            }
            return super.addChild(name);
        }

        @Override
        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent copy() {
            RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent dst = new RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.level = this.level == null ? null : this.level.copy();
            dst.from = this.from == null ? null : this.from.copy();
            dst.to = this.to == null ? null : this.to.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent)) {
                return false;
            }
            RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent o = (RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent)other_;
            return RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareDeep(this.type, o.type, true) && RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareDeep(this.level, o.level, true) && RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareDeep(this.from, o.from, true) && RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareDeep(this.to, o.to, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent)) {
                return false;
            }
            RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent o = (RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent)other_;
            return RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareValues(this.level, o.level, true) && RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareValues(this.from, o.from, true) && RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent.compareValues(this.to, o.to, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.level, this.from, this.to);
        }

        @Override
        public String fhirType() {
            return "RiskEvidenceSynthesis.riskEstimate.precisionEstimate";
        }
    }

    @Block
    public static class RiskEvidenceSynthesisRiskEstimateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of risk estimate", formalDefinition="Human-readable summary of risk estimate.")
        protected StringType description;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of risk estimate", formalDefinition="Examples include proportion and mean.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/risk-estimate-type")
        protected CodeableConcept type;
        @Child(name="value", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Point estimate", formalDefinition="The point estimate of the risk estimate.")
        protected DecimalType value;
        @Child(name="unitOfMeasure", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What unit is the outcome described in?", formalDefinition="Specifies the UCUM unit for the outcome.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ucum-units")
        protected CodeableConcept unitOfMeasure;
        @Child(name="denominatorCount", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sample size for group measured", formalDefinition="The sample size for the group that was measured for this risk estimate.")
        protected IntegerType denominatorCount;
        @Child(name="numeratorCount", type={IntegerType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number with the outcome", formalDefinition="The number of group members with the outcome of interest.")
        protected IntegerType numeratorCount;
        @Child(name="precisionEstimate", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="How precise the estimate is", formalDefinition="A description of the precision of the estimate for the effect.")
        protected List<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent> precisionEstimate;
        private static final long serialVersionUID = -15987415L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimateComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimateComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public CodeableConcept getUnitOfMeasure() {
            if (this.unitOfMeasure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimateComponent.unitOfMeasure");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitOfMeasure = new CodeableConcept();
                }
            }
            return this.unitOfMeasure;
        }

        public boolean hasUnitOfMeasure() {
            return this.unitOfMeasure != null && !this.unitOfMeasure.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setUnitOfMeasure(CodeableConcept value) {
            this.unitOfMeasure = value;
            return this;
        }

        public IntegerType getDenominatorCountElement() {
            if (this.denominatorCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimateComponent.denominatorCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.denominatorCount = new IntegerType();
                }
            }
            return this.denominatorCount;
        }

        public boolean hasDenominatorCountElement() {
            return this.denominatorCount != null && !this.denominatorCount.isEmpty();
        }

        public boolean hasDenominatorCount() {
            return this.denominatorCount != null && !this.denominatorCount.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setDenominatorCountElement(IntegerType value) {
            this.denominatorCount = value;
            return this;
        }

        public int getDenominatorCount() {
            return this.denominatorCount == null || this.denominatorCount.isEmpty() ? 0 : (Integer)this.denominatorCount.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setDenominatorCount(int value) {
            if (this.denominatorCount == null) {
                this.denominatorCount = new IntegerType();
            }
            this.denominatorCount.setValue((Object)value);
            return this;
        }

        public IntegerType getNumeratorCountElement() {
            if (this.numeratorCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisRiskEstimateComponent.numeratorCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.numeratorCount = new IntegerType();
                }
            }
            return this.numeratorCount;
        }

        public boolean hasNumeratorCountElement() {
            return this.numeratorCount != null && !this.numeratorCount.isEmpty();
        }

        public boolean hasNumeratorCount() {
            return this.numeratorCount != null && !this.numeratorCount.isEmpty();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setNumeratorCountElement(IntegerType value) {
            this.numeratorCount = value;
            return this;
        }

        public int getNumeratorCount() {
            return this.numeratorCount == null || this.numeratorCount.isEmpty() ? 0 : (Integer)this.numeratorCount.getValue();
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setNumeratorCount(int value) {
            if (this.numeratorCount == null) {
                this.numeratorCount = new IntegerType();
            }
            this.numeratorCount.setValue((Object)value);
            return this;
        }

        public List<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent> getPrecisionEstimate() {
            if (this.precisionEstimate == null) {
                this.precisionEstimate = new ArrayList<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent>();
            }
            return this.precisionEstimate;
        }

        public RiskEvidenceSynthesisRiskEstimateComponent setPrecisionEstimate(List<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent> thePrecisionEstimate) {
            this.precisionEstimate = thePrecisionEstimate;
            return this;
        }

        public boolean hasPrecisionEstimate() {
            if (this.precisionEstimate == null) {
                return false;
            }
            for (RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent item : this.precisionEstimate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent addPrecisionEstimate() {
            RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent t = new RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent();
            if (this.precisionEstimate == null) {
                this.precisionEstimate = new ArrayList<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent>();
            }
            this.precisionEstimate.add(t);
            return t;
        }

        public RiskEvidenceSynthesisRiskEstimateComponent addPrecisionEstimate(RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.precisionEstimate == null) {
                this.precisionEstimate = new ArrayList<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent>();
            }
            this.precisionEstimate.add(t);
            return this;
        }

        public RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent getPrecisionEstimateFirstRep() {
            if (this.getPrecisionEstimate().isEmpty()) {
                this.addPrecisionEstimate();
            }
            return this.getPrecisionEstimate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(RiskEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of risk estimate.", 0, 1, this.description));
            children.add(new Property("type", "CodeableConcept", "Examples include proportion and mean.", 0, 1, this.type));
            children.add(new Property("value", "decimal", "The point estimate of the risk estimate.", 0, 1, this.value));
            children.add(new Property("unitOfMeasure", "CodeableConcept", "Specifies the UCUM unit for the outcome.", 0, 1, this.unitOfMeasure));
            children.add(new Property("denominatorCount", "integer", "The sample size for the group that was measured for this risk estimate.", 0, 1, this.denominatorCount));
            children.add(new Property("numeratorCount", "integer", "The number of group members with the outcome of interest.", 0, 1, this.numeratorCount));
            children.add(new Property("precisionEstimate", "", "A description of the precision of the estimate for the effect.", 0, Integer.MAX_VALUE, this.precisionEstimate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(RiskEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of risk estimate.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Examples include proportion and mean.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "decimal", "The point estimate of the risk estimate.", 0, 1, this.value);
                }
                case -750257565: {
                    return new Property("unitOfMeasure", "CodeableConcept", "Specifies the UCUM unit for the outcome.", 0, 1, this.unitOfMeasure);
                }
                case 1323191881: {
                    return new Property("denominatorCount", "integer", "The sample size for the group that was measured for this risk estimate.", 0, 1, this.denominatorCount);
                }
                case -755509242: {
                    return new Property("numeratorCount", "integer", "The number of group members with the outcome of interest.", 0, 1, this.numeratorCount);
                }
                case 339632070: {
                    return new Property("precisionEstimate", "", "A description of the precision of the estimate for the effect.", 0, Integer.MAX_VALUE, this.precisionEstimate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
                case -750257565: {
                    Base[] baseArray;
                    if (this.unitOfMeasure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.unitOfMeasure;
                    }
                    return baseArray;
                }
                case 1323191881: {
                    Base[] baseArray;
                    if (this.denominatorCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.denominatorCount;
                    }
                    return baseArray;
                }
                case -755509242: {
                    Base[] baseArray;
                    if (this.numeratorCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.numeratorCount;
                    }
                    return baseArray;
                }
                case 339632070: {
                    return this.precisionEstimate == null ? new Base[]{} : this.precisionEstimate.toArray(new Base[this.precisionEstimate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    return value;
                }
                case -750257565: {
                    this.unitOfMeasure = this.castToCodeableConcept(value);
                    return value;
                }
                case 1323191881: {
                    this.denominatorCount = this.castToInteger(value);
                    return value;
                }
                case -755509242: {
                    this.numeratorCount = this.castToInteger(value);
                    return value;
                }
                case 339632070: {
                    this.getPrecisionEstimate().add((RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(RiskEvidenceSynthesis.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else if (name.equals("unitOfMeasure")) {
                this.unitOfMeasure = this.castToCodeableConcept(value);
            } else if (name.equals("denominatorCount")) {
                this.denominatorCount = this.castToInteger(value);
            } else if (name.equals("numeratorCount")) {
                this.numeratorCount = this.castToInteger(value);
            } else if (name.equals("precisionEstimate")) {
                this.getPrecisionEstimate().add((RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case -750257565: {
                    return this.getUnitOfMeasure();
                }
                case 1323191881: {
                    return this.getDenominatorCountElement();
                }
                case -755509242: {
                    return this.getNumeratorCountElement();
                }
                case 339632070: {
                    return this.addPrecisionEstimate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"decimal"};
                }
                case -750257565: {
                    return new String[]{"CodeableConcept"};
                }
                case 1323191881: {
                    return new String[]{"integer"};
                }
                case -755509242: {
                    return new String[]{"integer"};
                }
                case 339632070: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(RiskEvidenceSynthesis.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.description");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.value");
            }
            if (name.equals("unitOfMeasure")) {
                this.unitOfMeasure = new CodeableConcept();
                return this.unitOfMeasure;
            }
            if (name.equals("denominatorCount")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.denominatorCount");
            }
            if (name.equals("numeratorCount")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.numeratorCount");
            }
            if (name.equals("precisionEstimate")) {
                return this.addPrecisionEstimate();
            }
            return super.addChild(name);
        }

        @Override
        public RiskEvidenceSynthesisRiskEstimateComponent copy() {
            RiskEvidenceSynthesisRiskEstimateComponent dst = new RiskEvidenceSynthesisRiskEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RiskEvidenceSynthesisRiskEstimateComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.unitOfMeasure = this.unitOfMeasure == null ? null : this.unitOfMeasure.copy();
            dst.denominatorCount = this.denominatorCount == null ? null : this.denominatorCount.copy();
            IntegerType integerType = dst.numeratorCount = this.numeratorCount == null ? null : this.numeratorCount.copy();
            if (this.precisionEstimate != null) {
                dst.precisionEstimate = new ArrayList<RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent>();
                for (RiskEvidenceSynthesisRiskEstimatePrecisionEstimateComponent i2 : this.precisionEstimate) {
                    dst.precisionEstimate.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisRiskEstimateComponent)) {
                return false;
            }
            RiskEvidenceSynthesisRiskEstimateComponent o = (RiskEvidenceSynthesisRiskEstimateComponent)other_;
            return RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.description, o.description, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.type, o.type, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.value, o.value, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.unitOfMeasure, o.unitOfMeasure, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.denominatorCount, o.denominatorCount, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.numeratorCount, o.numeratorCount, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareDeep(this.precisionEstimate, o.precisionEstimate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisRiskEstimateComponent)) {
                return false;
            }
            RiskEvidenceSynthesisRiskEstimateComponent o = (RiskEvidenceSynthesisRiskEstimateComponent)other_;
            return RiskEvidenceSynthesisRiskEstimateComponent.compareValues(this.description, o.description, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareValues(this.value, o.value, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareValues(this.denominatorCount, o.denominatorCount, true) && RiskEvidenceSynthesisRiskEstimateComponent.compareValues(this.numeratorCount, o.numeratorCount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.description, this.type, this.value, this.unitOfMeasure, this.denominatorCount, this.numeratorCount, this.precisionEstimate);
        }

        @Override
        public String fhirType() {
            return "RiskEvidenceSynthesis.riskEstimate";
        }
    }

    @Block
    public static class RiskEvidenceSynthesisSampleSizeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of sample size", formalDefinition="Human-readable summary of sample size.")
        protected StringType description;
        @Child(name="numberOfStudies", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many studies?", formalDefinition="Number of studies included in this evidence synthesis.")
        protected IntegerType numberOfStudies;
        @Child(name="numberOfParticipants", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many participants?", formalDefinition="Number of participants included in this evidence synthesis.")
        protected IntegerType numberOfParticipants;
        private static final long serialVersionUID = -1116074476L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisSampleSizeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public RiskEvidenceSynthesisSampleSizeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public RiskEvidenceSynthesisSampleSizeComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public IntegerType getNumberOfStudiesElement() {
            if (this.numberOfStudies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisSampleSizeComponent.numberOfStudies");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfStudies = new IntegerType();
                }
            }
            return this.numberOfStudies;
        }

        public boolean hasNumberOfStudiesElement() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public boolean hasNumberOfStudies() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public RiskEvidenceSynthesisSampleSizeComponent setNumberOfStudiesElement(IntegerType value) {
            this.numberOfStudies = value;
            return this;
        }

        public int getNumberOfStudies() {
            return this.numberOfStudies == null || this.numberOfStudies.isEmpty() ? 0 : (Integer)this.numberOfStudies.getValue();
        }

        public RiskEvidenceSynthesisSampleSizeComponent setNumberOfStudies(int value) {
            if (this.numberOfStudies == null) {
                this.numberOfStudies = new IntegerType();
            }
            this.numberOfStudies.setValue((Object)value);
            return this;
        }

        public IntegerType getNumberOfParticipantsElement() {
            if (this.numberOfParticipants == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskEvidenceSynthesisSampleSizeComponent.numberOfParticipants");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfParticipants = new IntegerType();
                }
            }
            return this.numberOfParticipants;
        }

        public boolean hasNumberOfParticipantsElement() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public boolean hasNumberOfParticipants() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public RiskEvidenceSynthesisSampleSizeComponent setNumberOfParticipantsElement(IntegerType value) {
            this.numberOfParticipants = value;
            return this;
        }

        public int getNumberOfParticipants() {
            return this.numberOfParticipants == null || this.numberOfParticipants.isEmpty() ? 0 : (Integer)this.numberOfParticipants.getValue();
        }

        public RiskEvidenceSynthesisSampleSizeComponent setNumberOfParticipants(int value) {
            if (this.numberOfParticipants == null) {
                this.numberOfParticipants = new IntegerType();
            }
            this.numberOfParticipants.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(RiskEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of sample size.", 0, 1, this.description));
            children.add(new Property("numberOfStudies", "integer", "Number of studies included in this evidence synthesis.", 0, 1, this.numberOfStudies));
            children.add(new Property("numberOfParticipants", "integer", "Number of participants included in this evidence synthesis.", 0, 1, this.numberOfParticipants));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(RiskEvidenceSynthesis.SP_DESCRIPTION, "string", "Human-readable summary of sample size.", 0, 1, this.description);
                }
                case -177467129: {
                    return new Property("numberOfStudies", "integer", "Number of studies included in this evidence synthesis.", 0, 1, this.numberOfStudies);
                }
                case 1799357120: {
                    return new Property("numberOfParticipants", "integer", "Number of participants included in this evidence synthesis.", 0, 1, this.numberOfParticipants);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -177467129: {
                    Base[] baseArray;
                    if (this.numberOfStudies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.numberOfStudies;
                    }
                    return baseArray;
                }
                case 1799357120: {
                    Base[] baseArray;
                    if (this.numberOfParticipants == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.numberOfParticipants;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -177467129: {
                    this.numberOfStudies = this.castToInteger(value);
                    return value;
                }
                case 1799357120: {
                    this.numberOfParticipants = this.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(RiskEvidenceSynthesis.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("numberOfStudies")) {
                this.numberOfStudies = this.castToInteger(value);
            } else if (name.equals("numberOfParticipants")) {
                this.numberOfParticipants = this.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -177467129: {
                    return this.getNumberOfStudiesElement();
                }
                case 1799357120: {
                    return this.getNumberOfParticipantsElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -177467129: {
                    return new String[]{"integer"};
                }
                case 1799357120: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(RiskEvidenceSynthesis.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.description");
            }
            if (name.equals("numberOfStudies")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.numberOfStudies");
            }
            if (name.equals("numberOfParticipants")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskEvidenceSynthesis.numberOfParticipants");
            }
            return super.addChild(name);
        }

        @Override
        public RiskEvidenceSynthesisSampleSizeComponent copy() {
            RiskEvidenceSynthesisSampleSizeComponent dst = new RiskEvidenceSynthesisSampleSizeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RiskEvidenceSynthesisSampleSizeComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.numberOfStudies = this.numberOfStudies == null ? null : this.numberOfStudies.copy();
            dst.numberOfParticipants = this.numberOfParticipants == null ? null : this.numberOfParticipants.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisSampleSizeComponent)) {
                return false;
            }
            RiskEvidenceSynthesisSampleSizeComponent o = (RiskEvidenceSynthesisSampleSizeComponent)other_;
            return RiskEvidenceSynthesisSampleSizeComponent.compareDeep(this.description, o.description, true) && RiskEvidenceSynthesisSampleSizeComponent.compareDeep(this.numberOfStudies, o.numberOfStudies, true) && RiskEvidenceSynthesisSampleSizeComponent.compareDeep(this.numberOfParticipants, o.numberOfParticipants, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskEvidenceSynthesisSampleSizeComponent)) {
                return false;
            }
            RiskEvidenceSynthesisSampleSizeComponent o = (RiskEvidenceSynthesisSampleSizeComponent)other_;
            return RiskEvidenceSynthesisSampleSizeComponent.compareValues(this.description, o.description, true) && RiskEvidenceSynthesisSampleSizeComponent.compareValues(this.numberOfStudies, o.numberOfStudies, true) && RiskEvidenceSynthesisSampleSizeComponent.compareValues(this.numberOfParticipants, o.numberOfParticipants, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.description, this.numberOfStudies, this.numberOfParticipants);
        }

        @Override
        public String fhirType() {
            return "RiskEvidenceSynthesis.sampleSize";
        }
    }
}

