/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="InsurancePlan", profile="http://hl7.org/fhir/StructureDefinition/InsurancePlan")
public class InsurancePlan
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for Product", formalDefinition="Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the health insurance product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of product", formalDefinition="The kind of health insurance product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/insuranceplan-type")
    protected List<CodeableConcept> type;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Official name", formalDefinition="Official name of the health insurance product as designated by the owner.")
    protected StringType name;
    @Child(name="alias", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Alternate names", formalDefinition="A list of alternate names that the product is known as, or was known as in the past.")
    protected List<StringType> alias;
    @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the product is available", formalDefinition="The period of time that the health insurance product is available.")
    protected Period period;
    @Child(name="ownedBy", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Plan issuer", formalDefinition="The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.")
    protected Reference ownedBy;
    protected Organization ownedByTarget;
    @Child(name="administeredBy", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Product administrator", formalDefinition="An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.")
    protected Reference administeredBy;
    protected Organization administeredByTarget;
    @Child(name="coverageArea", type={Location.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Where product applies", formalDefinition="The geographic region in which a health insurance product's benefits apply.")
    protected List<Reference> coverageArea;
    protected List<Location> coverageAreaTarget;
    @Child(name="contact", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact for the product", formalDefinition="The contact for the health insurance product for a certain purpose.")
    protected List<InsurancePlanContactComponent> contact;
    @Child(name="endpoint", type={Endpoint.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoint", formalDefinition="The technical endpoints providing access to services operated for the health insurance product.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    @Child(name="network", type={Organization.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What networks are Included", formalDefinition="Reference to the network included in the health insurance product.")
    protected List<Reference> network;
    protected List<Organization> networkTarget;
    @Child(name="coverage", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Coverage details", formalDefinition="Details about the coverage offered by the insurance product.")
    protected List<InsurancePlanCoverageComponent> coverage;
    @Child(name="plan", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plan details", formalDefinition="Details about an insurance plan.")
    protected List<InsurancePlanPlanComponent> plan;
    private static final long serialVersionUID = -1910594688L;
    @SearchParamDefinition(name="identifier", path="InsurancePlan.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="address", path="InsurancePlan.contact.address", description="A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-state", path="InsurancePlan.contact.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="owned-by", path="InsurancePlan.ownedBy", description="An organization of which this organization forms a part", type="reference", target={Organization.class})
    public static final String SP_OWNED_BY = "owned-by";
    public static final ReferenceClientParam OWNED_BY = new ReferenceClientParam("owned-by");
    public static final Include INCLUDE_OWNED_BY = new Include("InsurancePlan:owned-by").toLocked();
    @SearchParamDefinition(name="type", path="InsurancePlan.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="address-postalcode", path="InsurancePlan.contact.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="administered-by", path="InsurancePlan.administeredBy", description="Product administrator", type="reference", target={Organization.class})
    public static final String SP_ADMINISTERED_BY = "administered-by";
    public static final ReferenceClientParam ADMINISTERED_BY = new ReferenceClientParam("administered-by");
    public static final Include INCLUDE_ADMINISTERED_BY = new Include("InsurancePlan:administered-by").toLocked();
    @SearchParamDefinition(name="address-country", path="InsurancePlan.contact.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="endpoint", path="InsurancePlan.endpoint", description="Technical endpoint", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("InsurancePlan:endpoint").toLocked();
    @SearchParamDefinition(name="phonetic", path="InsurancePlan.name", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="name", path="name | alias", description="A portion of the organization's name or alias", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address-use", path="InsurancePlan.contact.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="address-city", path="InsurancePlan.contact.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="status", path="InsurancePlan.status", description="Is the Organization record active", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public InsurancePlan setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public InsurancePlan addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public InsurancePlan setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public InsurancePlan setStatus(Enumerations.PublicationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public InsurancePlan setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public InsurancePlan addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public InsurancePlan setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public InsurancePlan setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public InsurancePlan setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public InsurancePlan addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public InsurancePlan setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getOwnedBy() {
        if (this.ownedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.ownedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.ownedBy = new Reference();
            }
        }
        return this.ownedBy;
    }

    public boolean hasOwnedBy() {
        return this.ownedBy != null && !this.ownedBy.isEmpty();
    }

    public InsurancePlan setOwnedBy(Reference value) {
        this.ownedBy = value;
        return this;
    }

    public Organization getOwnedByTarget() {
        if (this.ownedByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.ownedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.ownedByTarget = new Organization();
            }
        }
        return this.ownedByTarget;
    }

    public InsurancePlan setOwnedByTarget(Organization value) {
        this.ownedByTarget = value;
        return this;
    }

    public Reference getAdministeredBy() {
        if (this.administeredBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.administeredBy");
            }
            if (Configuration.doAutoCreate()) {
                this.administeredBy = new Reference();
            }
        }
        return this.administeredBy;
    }

    public boolean hasAdministeredBy() {
        return this.administeredBy != null && !this.administeredBy.isEmpty();
    }

    public InsurancePlan setAdministeredBy(Reference value) {
        this.administeredBy = value;
        return this;
    }

    public Organization getAdministeredByTarget() {
        if (this.administeredByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InsurancePlan.administeredBy");
            }
            if (Configuration.doAutoCreate()) {
                this.administeredByTarget = new Organization();
            }
        }
        return this.administeredByTarget;
    }

    public InsurancePlan setAdministeredByTarget(Organization value) {
        this.administeredByTarget = value;
        return this;
    }

    public List<Reference> getCoverageArea() {
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        return this.coverageArea;
    }

    public InsurancePlan setCoverageArea(List<Reference> theCoverageArea) {
        this.coverageArea = theCoverageArea;
        return this;
    }

    public boolean hasCoverageArea() {
        if (this.coverageArea == null) {
            return false;
        }
        for (Reference item : this.coverageArea) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCoverageArea() {
        Reference t = new Reference();
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return t;
    }

    public InsurancePlan addCoverageArea(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return this;
    }

    public Reference getCoverageAreaFirstRep() {
        if (this.getCoverageArea().isEmpty()) {
            this.addCoverageArea();
        }
        return this.getCoverageArea().get(0);
    }

    @Deprecated
    public List<Location> getCoverageAreaTarget() {
        if (this.coverageAreaTarget == null) {
            this.coverageAreaTarget = new ArrayList<Location>();
        }
        return this.coverageAreaTarget;
    }

    @Deprecated
    public Location addCoverageAreaTarget() {
        Location r = new Location();
        if (this.coverageAreaTarget == null) {
            this.coverageAreaTarget = new ArrayList<Location>();
        }
        this.coverageAreaTarget.add(r);
        return r;
    }

    public List<InsurancePlanContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<InsurancePlanContactComponent>();
        }
        return this.contact;
    }

    public InsurancePlan setContact(List<InsurancePlanContactComponent> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (InsurancePlanContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsurancePlanContactComponent addContact() {
        InsurancePlanContactComponent t = new InsurancePlanContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<InsurancePlanContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public InsurancePlan addContact(InsurancePlanContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<InsurancePlanContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public InsurancePlanContactComponent getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public InsurancePlan setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public InsurancePlan addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    public List<Reference> getNetwork() {
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        return this.network;
    }

    public InsurancePlan setNetwork(List<Reference> theNetwork) {
        this.network = theNetwork;
        return this;
    }

    public boolean hasNetwork() {
        if (this.network == null) {
            return false;
        }
        for (Reference item : this.network) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addNetwork() {
        Reference t = new Reference();
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return t;
    }

    public InsurancePlan addNetwork(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return this;
    }

    public Reference getNetworkFirstRep() {
        if (this.getNetwork().isEmpty()) {
            this.addNetwork();
        }
        return this.getNetwork().get(0);
    }

    @Deprecated
    public List<Organization> getNetworkTarget() {
        if (this.networkTarget == null) {
            this.networkTarget = new ArrayList<Organization>();
        }
        return this.networkTarget;
    }

    @Deprecated
    public Organization addNetworkTarget() {
        Organization r = new Organization();
        if (this.networkTarget == null) {
            this.networkTarget = new ArrayList<Organization>();
        }
        this.networkTarget.add(r);
        return r;
    }

    public List<InsurancePlanCoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<InsurancePlanCoverageComponent>();
        }
        return this.coverage;
    }

    public InsurancePlan setCoverage(List<InsurancePlanCoverageComponent> theCoverage) {
        this.coverage = theCoverage;
        return this;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (InsurancePlanCoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsurancePlanCoverageComponent addCoverage() {
        InsurancePlanCoverageComponent t = new InsurancePlanCoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<InsurancePlanCoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public InsurancePlan addCoverage(InsurancePlanCoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<InsurancePlanCoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    public InsurancePlanCoverageComponent getCoverageFirstRep() {
        if (this.getCoverage().isEmpty()) {
            this.addCoverage();
        }
        return this.getCoverage().get(0);
    }

    public List<InsurancePlanPlanComponent> getPlan() {
        if (this.plan == null) {
            this.plan = new ArrayList<InsurancePlanPlanComponent>();
        }
        return this.plan;
    }

    public InsurancePlan setPlan(List<InsurancePlanPlanComponent> thePlan) {
        this.plan = thePlan;
        return this;
    }

    public boolean hasPlan() {
        if (this.plan == null) {
            return false;
        }
        for (InsurancePlanPlanComponent item : this.plan) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsurancePlanPlanComponent addPlan() {
        InsurancePlanPlanComponent t = new InsurancePlanPlanComponent();
        if (this.plan == null) {
            this.plan = new ArrayList<InsurancePlanPlanComponent>();
        }
        this.plan.add(t);
        return t;
    }

    public InsurancePlan addPlan(InsurancePlanPlanComponent t) {
        if (t == null) {
            return this;
        }
        if (this.plan == null) {
            this.plan = new ArrayList<InsurancePlanPlanComponent>();
        }
        this.plan.add(t);
        return this;
    }

    public InsurancePlanPlanComponent getPlanFirstRep() {
        if (this.getPlan().isEmpty()) {
            this.addPlan();
        }
        return this.getPlan().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the health insurance product.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind of health insurance product.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_NAME, "string", "Official name of the health insurance product as designated by the owner.", 0, 1, this.name));
        children.add(new Property("alias", "string", "A list of alternate names that the product is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("period", "Period", "The period of time that the health insurance product is available.", 0, 1, this.period));
        children.add(new Property("ownedBy", "Reference(Organization)", "The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.", 0, 1, this.ownedBy));
        children.add(new Property("administeredBy", "Reference(Organization)", "An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.", 0, 1, this.administeredBy));
        children.add(new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance product's benefits apply.", 0, Integer.MAX_VALUE, this.coverageArea));
        children.add(new Property("contact", "", "The contact for the health insurance product for a certain purpose.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "The technical endpoints providing access to services operated for the health insurance product.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("network", "Reference(Organization)", "Reference to the network included in the health insurance product.", 0, Integer.MAX_VALUE, this.network));
        children.add(new Property("coverage", "", "Details about the coverage offered by the insurance product.", 0, Integer.MAX_VALUE, this.coverage));
        children.add(new Property("plan", "", "Details about an insurance plan.", 0, Integer.MAX_VALUE, this.plan));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the health insurance product.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind of health insurance product.", 0, Integer.MAX_VALUE, this.type);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Official name of the health insurance product as designated by the owner.", 0, 1, this.name);
            }
            case 92902992: {
                return new Property("alias", "string", "A list of alternate names that the product is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias);
            }
            case -991726143: {
                return new Property("period", "Period", "The period of time that the health insurance product is available.", 0, 1, this.period);
            }
            case -1054743076: {
                return new Property("ownedBy", "Reference(Organization)", "The entity that is providing  the health insurance product and underwriting the risk.  This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.", 0, 1, this.ownedBy);
            }
            case 898770462: {
                return new Property("administeredBy", "Reference(Organization)", "An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.", 0, 1, this.administeredBy);
            }
            case -1532328299: {
                return new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance product's benefits apply.", 0, Integer.MAX_VALUE, this.coverageArea);
            }
            case 951526432: {
                return new Property("contact", "", "The contact for the health insurance product for a certain purpose.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "The technical endpoints providing access to services operated for the health insurance product.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case 1843485230: {
                return new Property("network", "Reference(Organization)", "Reference to the network included in the health insurance product.", 0, Integer.MAX_VALUE, this.network);
            }
            case -351767064: {
                return new Property("coverage", "", "Details about the coverage offered by the insurance product.", 0, Integer.MAX_VALUE, this.coverage);
            }
            case 3443497: {
                return new Property("plan", "", "Details about an insurance plan.", 0, Integer.MAX_VALUE, this.plan);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case -1054743076: {
                Base[] baseArray;
                if (this.ownedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.ownedBy;
                }
                return baseArray;
            }
            case 898770462: {
                Base[] baseArray;
                if (this.administeredBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.administeredBy;
                }
                return baseArray;
            }
            case -1532328299: {
                return this.coverageArea == null ? new Base[]{} : this.coverageArea.toArray(new Base[this.coverageArea.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case 1843485230: {
                return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
            }
            case -351767064: {
                return this.coverage == null ? new Base[]{} : this.coverage.toArray(new Base[this.coverage.size()]);
            }
            case 3443497: {
                return this.plan == null ? new Base[]{} : this.plan.toArray(new Base[this.plan.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(this.castToString(value));
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -1054743076: {
                this.ownedBy = this.castToReference(value);
                return value;
            }
            case 898770462: {
                this.administeredBy = this.castToReference(value);
                return value;
            }
            case -1532328299: {
                this.getCoverageArea().add(this.castToReference(value));
                return value;
            }
            case 951526432: {
                this.getContact().add((InsurancePlanContactComponent)((Object)value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
            case 1843485230: {
                this.getNetwork().add(this.castToReference(value));
                return value;
            }
            case -351767064: {
                this.getCoverage().add((InsurancePlanCoverageComponent)((Object)value));
                return value;
            }
            case 3443497: {
                this.getPlan().add((InsurancePlanPlanComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(this.castToString(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("ownedBy")) {
            this.ownedBy = this.castToReference(value);
        } else if (name.equals("administeredBy")) {
            this.administeredBy = this.castToReference(value);
        } else if (name.equals("coverageArea")) {
            this.getCoverageArea().add(this.castToReference(value));
        } else if (name.equals("contact")) {
            this.getContact().add((InsurancePlanContactComponent)((Object)value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else if (name.equals("network")) {
            this.getNetwork().add(this.castToReference(value));
        } else if (name.equals("coverage")) {
            this.getCoverage().add((InsurancePlanCoverageComponent)((Object)value));
        } else if (name.equals("plan")) {
            this.getPlan().add((InsurancePlanPlanComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.addType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1054743076: {
                return this.getOwnedBy();
            }
            case 898770462: {
                return this.getAdministeredBy();
            }
            case -1532328299: {
                return this.addCoverageArea();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case 1843485230: {
                return this.addNetwork();
            }
            case -351767064: {
                return this.addCoverage();
            }
            case 3443497: {
                return this.addPlan();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1054743076: {
                return new String[]{"Reference"};
            }
            case 898770462: {
                return new String[]{"Reference"};
            }
            case -1532328299: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[0];
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case 1843485230: {
                return new String[]{"Reference"};
            }
            case -351767064: {
                return new String[0];
            }
            case 3443497: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type InsurancePlan.status");
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type InsurancePlan.name");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type InsurancePlan.alias");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("ownedBy")) {
            this.ownedBy = new Reference();
            return this.ownedBy;
        }
        if (name.equals("administeredBy")) {
            this.administeredBy = new Reference();
            return this.administeredBy;
        }
        if (name.equals("coverageArea")) {
            return this.addCoverageArea();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        if (name.equals("network")) {
            return this.addNetwork();
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        if (name.equals("plan")) {
            return this.addPlan();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "InsurancePlan";
    }

    @Override
    public InsurancePlan copy() {
        InsurancePlan dst = new InsurancePlan();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(InsurancePlan dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType2 : this.alias) {
                dst.alias.add(stringType2.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.ownedBy = this.ownedBy == null ? null : this.ownedBy.copy();
        Reference reference = dst.administeredBy = this.administeredBy == null ? null : this.administeredBy.copy();
        if (this.coverageArea != null) {
            dst.coverageArea = new ArrayList<Reference>();
            for (Reference reference2 : this.coverageArea) {
                dst.coverageArea.add(reference2.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<InsurancePlanContactComponent>();
            for (InsurancePlanContactComponent insurancePlanContactComponent : this.contact) {
                dst.contact.add(insurancePlanContactComponent.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference3 : this.endpoint) {
                dst.endpoint.add(reference3.copy());
            }
        }
        if (this.network != null) {
            dst.network = new ArrayList<Reference>();
            for (Reference reference4 : this.network) {
                dst.network.add(reference4.copy());
            }
        }
        if (this.coverage != null) {
            dst.coverage = new ArrayList<InsurancePlanCoverageComponent>();
            for (InsurancePlanCoverageComponent insurancePlanCoverageComponent : this.coverage) {
                dst.coverage.add(insurancePlanCoverageComponent.copy());
            }
        }
        if (this.plan != null) {
            dst.plan = new ArrayList<InsurancePlanPlanComponent>();
            for (InsurancePlanPlanComponent insurancePlanPlanComponent : this.plan) {
                dst.plan.add(insurancePlanPlanComponent.copy());
            }
        }
    }

    protected InsurancePlan typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof InsurancePlan)) {
            return false;
        }
        InsurancePlan o = (InsurancePlan)other_;
        return InsurancePlan.compareDeep(this.identifier, o.identifier, true) && InsurancePlan.compareDeep(this.status, o.status, true) && InsurancePlan.compareDeep(this.type, o.type, true) && InsurancePlan.compareDeep(this.name, o.name, true) && InsurancePlan.compareDeep(this.alias, o.alias, true) && InsurancePlan.compareDeep(this.period, o.period, true) && InsurancePlan.compareDeep(this.ownedBy, o.ownedBy, true) && InsurancePlan.compareDeep(this.administeredBy, o.administeredBy, true) && InsurancePlan.compareDeep(this.coverageArea, o.coverageArea, true) && InsurancePlan.compareDeep(this.contact, o.contact, true) && InsurancePlan.compareDeep(this.endpoint, o.endpoint, true) && InsurancePlan.compareDeep(this.network, o.network, true) && InsurancePlan.compareDeep(this.coverage, o.coverage, true) && InsurancePlan.compareDeep(this.plan, o.plan, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof InsurancePlan)) {
            return false;
        }
        InsurancePlan o = (InsurancePlan)other_;
        return InsurancePlan.compareValues(this.status, o.status, true) && InsurancePlan.compareValues(this.name, o.name, true) && InsurancePlan.compareValues(this.alias, o.alias, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.type, this.name, this.alias, this.period, this.ownedBy, this.administeredBy, this.coverageArea, this.contact, this.endpoint, this.network, this.coverage, this.plan);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.InsurancePlan;
    }

    @Block
    public static class PlanBenefitCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of cost", formalDefinition="Type of cost (copay; individual cap; family cap; coinsurance; deductible).")
        protected CodeableConcept type;
        @Child(name="applicability", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="in-network | out-of-network | other", formalDefinition="Whether the cost applies to in-network or out-of-network providers (in-network; out-of-network; other).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/insuranceplan-applicability")
        protected CodeableConcept applicability;
        @Child(name="qualifiers", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information about the cost", formalDefinition="Additional information about the cost, such as information about funding sources (e.g. HSA, HRA, FSA, RRA).")
        protected List<CodeableConcept> qualifiers;
        @Child(name="value", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual cost value", formalDefinition="The actual cost value. (some of the costs may be represented as percentages rather than currency, e.g. 10% coinsurance).")
        protected Quantity value;
        private static final long serialVersionUID = -340688733L;

        public PlanBenefitCostComponent() {
        }

        public PlanBenefitCostComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanBenefitCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanBenefitCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getApplicability() {
            if (this.applicability == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanBenefitCostComponent.applicability");
                }
                if (Configuration.doAutoCreate()) {
                    this.applicability = new CodeableConcept();
                }
            }
            return this.applicability;
        }

        public boolean hasApplicability() {
            return this.applicability != null && !this.applicability.isEmpty();
        }

        public PlanBenefitCostComponent setApplicability(CodeableConcept value) {
            this.applicability = value;
            return this;
        }

        public List<CodeableConcept> getQualifiers() {
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList<CodeableConcept>();
            }
            return this.qualifiers;
        }

        public PlanBenefitCostComponent setQualifiers(List<CodeableConcept> theQualifiers) {
            this.qualifiers = theQualifiers;
            return this;
        }

        public boolean hasQualifiers() {
            if (this.qualifiers == null) {
                return false;
            }
            for (CodeableConcept item : this.qualifiers) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addQualifiers() {
            CodeableConcept t = new CodeableConcept();
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList<CodeableConcept>();
            }
            this.qualifiers.add(t);
            return t;
        }

        public PlanBenefitCostComponent addQualifiers(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList<CodeableConcept>();
            }
            this.qualifiers.add(t);
            return this;
        }

        public CodeableConcept getQualifiersFirstRep() {
            if (this.getQualifiers().isEmpty()) {
                this.addQualifiers();
            }
            return this.getQualifiers().get(0);
        }

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanBenefitCostComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public PlanBenefitCostComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of cost (copay; individual cap; family cap; coinsurance; deductible).", 0, 1, this.type));
            children.add(new Property("applicability", "CodeableConcept", "Whether the cost applies to in-network or out-of-network providers (in-network; out-of-network; other).", 0, 1, this.applicability));
            children.add(new Property("qualifiers", "CodeableConcept", "Additional information about the cost, such as information about funding sources (e.g. HSA, HRA, FSA, RRA).", 0, Integer.MAX_VALUE, this.qualifiers));
            children.add(new Property("value", "Quantity", "The actual cost value. (some of the costs may be represented as percentages rather than currency, e.g. 10% coinsurance).", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of cost (copay; individual cap; family cap; coinsurance; deductible).", 0, 1, this.type);
                }
                case -1526770491: {
                    return new Property("applicability", "CodeableConcept", "Whether the cost applies to in-network or out-of-network providers (in-network; out-of-network; other).", 0, 1, this.applicability);
                }
                case -31447799: {
                    return new Property("qualifiers", "CodeableConcept", "Additional information about the cost, such as information about funding sources (e.g. HSA, HRA, FSA, RRA).", 0, Integer.MAX_VALUE, this.qualifiers);
                }
                case 111972721: {
                    return new Property("value", "Quantity", "The actual cost value. (some of the costs may be represented as percentages rather than currency, e.g. 10% coinsurance).", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1526770491: {
                    Base[] baseArray;
                    if (this.applicability == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.applicability;
                    }
                    return baseArray;
                }
                case -31447799: {
                    return this.qualifiers == null ? new Base[]{} : this.qualifiers.toArray(new Base[this.qualifiers.size()]);
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1526770491: {
                    this.applicability = this.castToCodeableConcept(value);
                    return value;
                }
                case -31447799: {
                    this.getQualifiers().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 111972721: {
                    this.value = this.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("applicability")) {
                this.applicability = this.castToCodeableConcept(value);
            } else if (name.equals("qualifiers")) {
                this.getQualifiers().add(this.castToCodeableConcept(value));
            } else if (name.equals("value")) {
                this.value = this.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1526770491: {
                    return this.getApplicability();
                }
                case -31447799: {
                    return this.addQualifiers();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1526770491: {
                    return new String[]{"CodeableConcept"};
                }
                case -31447799: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("applicability")) {
                this.applicability = new CodeableConcept();
                return this.applicability;
            }
            if (name.equals("qualifiers")) {
                return this.addQualifiers();
            }
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public PlanBenefitCostComponent copy() {
            PlanBenefitCostComponent dst = new PlanBenefitCostComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanBenefitCostComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            CodeableConcept codeableConcept = dst.applicability = this.applicability == null ? null : this.applicability.copy();
            if (this.qualifiers != null) {
                dst.qualifiers = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.qualifiers) {
                    dst.qualifiers.add(i2.copy());
                }
            }
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanBenefitCostComponent)) {
                return false;
            }
            PlanBenefitCostComponent o = (PlanBenefitCostComponent)other_;
            return PlanBenefitCostComponent.compareDeep(this.type, o.type, true) && PlanBenefitCostComponent.compareDeep(this.applicability, o.applicability, true) && PlanBenefitCostComponent.compareDeep(this.qualifiers, o.qualifiers, true) && PlanBenefitCostComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanBenefitCostComponent)) {
                return false;
            }
            PlanBenefitCostComponent o = (PlanBenefitCostComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.applicability, this.qualifiers, this.value);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.plan.specificCost.benefit.cost";
        }
    }

    @Block
    public static class PlanBenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of specific benefit", formalDefinition="Type of specific benefit (preventative; primary care office visit; speciality office visit; hospitalization; emergency room; urgent care).")
        protected CodeableConcept type;
        @Child(name="cost", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of the costs", formalDefinition="List of the costs associated with a specific benefit.")
        protected List<PlanBenefitCostComponent> cost;
        private static final long serialVersionUID = 792296200L;

        public PlanBenefitComponent() {
        }

        public PlanBenefitComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanBenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanBenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<PlanBenefitCostComponent> getCost() {
            if (this.cost == null) {
                this.cost = new ArrayList<PlanBenefitCostComponent>();
            }
            return this.cost;
        }

        public PlanBenefitComponent setCost(List<PlanBenefitCostComponent> theCost) {
            this.cost = theCost;
            return this;
        }

        public boolean hasCost() {
            if (this.cost == null) {
                return false;
            }
            for (PlanBenefitCostComponent item : this.cost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanBenefitCostComponent addCost() {
            PlanBenefitCostComponent t = new PlanBenefitCostComponent();
            if (this.cost == null) {
                this.cost = new ArrayList<PlanBenefitCostComponent>();
            }
            this.cost.add(t);
            return t;
        }

        public PlanBenefitComponent addCost(PlanBenefitCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.cost == null) {
                this.cost = new ArrayList<PlanBenefitCostComponent>();
            }
            this.cost.add(t);
            return this;
        }

        public PlanBenefitCostComponent getCostFirstRep() {
            if (this.getCost().isEmpty()) {
                this.addCost();
            }
            return this.getCost().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of specific benefit (preventative; primary care office visit; speciality office visit; hospitalization; emergency room; urgent care).", 0, 1, this.type));
            children.add(new Property("cost", "", "List of the costs associated with a specific benefit.", 0, Integer.MAX_VALUE, this.cost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of specific benefit (preventative; primary care office visit; speciality office visit; hospitalization; emergency room; urgent care).", 0, 1, this.type);
                }
                case 3059661: {
                    return new Property("cost", "", "List of the costs associated with a specific benefit.", 0, Integer.MAX_VALUE, this.cost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3059661: {
                    return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3059661: {
                    this.getCost().add((PlanBenefitCostComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("cost")) {
                this.getCost().add((PlanBenefitCostComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3059661: {
                    return this.addCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059661: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("cost")) {
                return this.addCost();
            }
            return super.addChild(name);
        }

        @Override
        public PlanBenefitComponent copy() {
            PlanBenefitComponent dst = new PlanBenefitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanBenefitComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.cost != null) {
                dst.cost = new ArrayList<PlanBenefitCostComponent>();
                for (PlanBenefitCostComponent i2 : this.cost) {
                    dst.cost.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanBenefitComponent)) {
                return false;
            }
            PlanBenefitComponent o = (PlanBenefitComponent)other_;
            return PlanBenefitComponent.compareDeep(this.type, o.type, true) && PlanBenefitComponent.compareDeep(this.cost, o.cost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanBenefitComponent)) {
                return false;
            }
            PlanBenefitComponent o = (PlanBenefitComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.cost);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.plan.specificCost.benefit";
        }
    }

    @Block
    public static class InsurancePlanPlanSpecificCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General category of benefit", formalDefinition="General category of benefit (Medical; Dental; Vision; Drug; Mental Health; Substance Abuse; Hospice, Home Health).")
        protected CodeableConcept category;
        @Child(name="benefit", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits list", formalDefinition="List of the specific benefits under this category of benefit.")
        protected List<PlanBenefitComponent> benefit;
        private static final long serialVersionUID = 922585525L;

        public InsurancePlanPlanSpecificCostComponent() {
        }

        public InsurancePlanPlanSpecificCostComponent(CodeableConcept category) {
            this.category = category;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanPlanSpecificCostComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public InsurancePlanPlanSpecificCostComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public List<PlanBenefitComponent> getBenefit() {
            if (this.benefit == null) {
                this.benefit = new ArrayList<PlanBenefitComponent>();
            }
            return this.benefit;
        }

        public InsurancePlanPlanSpecificCostComponent setBenefit(List<PlanBenefitComponent> theBenefit) {
            this.benefit = theBenefit;
            return this;
        }

        public boolean hasBenefit() {
            if (this.benefit == null) {
                return false;
            }
            for (PlanBenefitComponent item : this.benefit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanBenefitComponent addBenefit() {
            PlanBenefitComponent t = new PlanBenefitComponent();
            if (this.benefit == null) {
                this.benefit = new ArrayList<PlanBenefitComponent>();
            }
            this.benefit.add(t);
            return t;
        }

        public InsurancePlanPlanSpecificCostComponent addBenefit(PlanBenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.benefit == null) {
                this.benefit = new ArrayList<PlanBenefitComponent>();
            }
            this.benefit.add(t);
            return this;
        }

        public PlanBenefitComponent getBenefitFirstRep() {
            if (this.getBenefit().isEmpty()) {
                this.addBenefit();
            }
            return this.getBenefit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "General category of benefit (Medical; Dental; Vision; Drug; Mental Health; Substance Abuse; Hospice, Home Health).", 0, 1, this.category));
            children.add(new Property("benefit", "", "List of the specific benefits under this category of benefit.", 0, Integer.MAX_VALUE, this.benefit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "General category of benefit (Medical; Dental; Vision; Drug; Mental Health; Substance Abuse; Hospice, Home Health).", 0, 1, this.category);
                }
                case -222710633: {
                    return new Property("benefit", "", "List of the specific benefits under this category of benefit.", 0, Integer.MAX_VALUE, this.benefit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -222710633: {
                    return this.benefit == null ? new Base[]{} : this.benefit.toArray(new Base[this.benefit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -222710633: {
                    this.getBenefit().add((PlanBenefitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("benefit")) {
                this.getBenefit().add((PlanBenefitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -222710633: {
                    return this.addBenefit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -222710633: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("benefit")) {
                return this.addBenefit();
            }
            return super.addChild(name);
        }

        @Override
        public InsurancePlanPlanSpecificCostComponent copy() {
            InsurancePlanPlanSpecificCostComponent dst = new InsurancePlanPlanSpecificCostComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsurancePlanPlanSpecificCostComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.category = this.category == null ? null : this.category.copy();
            if (this.benefit != null) {
                dst.benefit = new ArrayList<PlanBenefitComponent>();
                for (PlanBenefitComponent i2 : this.benefit) {
                    dst.benefit.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanPlanSpecificCostComponent)) {
                return false;
            }
            InsurancePlanPlanSpecificCostComponent o = (InsurancePlanPlanSpecificCostComponent)other_;
            return InsurancePlanPlanSpecificCostComponent.compareDeep(this.category, o.category, true) && InsurancePlanPlanSpecificCostComponent.compareDeep(this.benefit, o.benefit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanPlanSpecificCostComponent)) {
                return false;
            }
            InsurancePlanPlanSpecificCostComponent o = (InsurancePlanPlanSpecificCostComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.category, this.benefit);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.plan.specificCost";
        }
    }

    @Block
    public static class InsurancePlanPlanGeneralCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of cost", formalDefinition="Type of cost.")
        protected CodeableConcept type;
        @Child(name="groupSize", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of enrollees", formalDefinition="Number of participants enrolled in the plan.")
        protected PositiveIntType groupSize;
        @Child(name="cost", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Cost value", formalDefinition="Value of the cost.")
        protected Money cost;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional cost information", formalDefinition="Additional information about the general costs associated with this plan.")
        protected StringType comment;
        private static final long serialVersionUID = 1563949866L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanPlanGeneralCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public InsurancePlanPlanGeneralCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public PositiveIntType getGroupSizeElement() {
            if (this.groupSize == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanPlanGeneralCostComponent.groupSize");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupSize = new PositiveIntType();
                }
            }
            return this.groupSize;
        }

        public boolean hasGroupSizeElement() {
            return this.groupSize != null && !this.groupSize.isEmpty();
        }

        public boolean hasGroupSize() {
            return this.groupSize != null && !this.groupSize.isEmpty();
        }

        public InsurancePlanPlanGeneralCostComponent setGroupSizeElement(PositiveIntType value) {
            this.groupSize = value;
            return this;
        }

        public int getGroupSize() {
            return this.groupSize == null || this.groupSize.isEmpty() ? 0 : (Integer)this.groupSize.getValue();
        }

        public InsurancePlanPlanGeneralCostComponent setGroupSize(int value) {
            if (this.groupSize == null) {
                this.groupSize = new PositiveIntType();
            }
            this.groupSize.setValue((Object)value);
            return this;
        }

        public Money getCost() {
            if (this.cost == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanPlanGeneralCostComponent.cost");
                }
                if (Configuration.doAutoCreate()) {
                    this.cost = new Money();
                }
            }
            return this.cost;
        }

        public boolean hasCost() {
            return this.cost != null && !this.cost.isEmpty();
        }

        public InsurancePlanPlanGeneralCostComponent setCost(Money value) {
            this.cost = value;
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanPlanGeneralCostComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public InsurancePlanPlanGeneralCostComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public InsurancePlanPlanGeneralCostComponent setComment(String value) {
            if (Utilities.noString(value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of cost.", 0, 1, this.type));
            children.add(new Property("groupSize", "positiveInt", "Number of participants enrolled in the plan.", 0, 1, this.groupSize));
            children.add(new Property("cost", "Money", "Value of the cost.", 0, 1, this.cost));
            children.add(new Property("comment", "string", "Additional information about the general costs associated with this plan.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of cost.", 0, 1, this.type);
                }
                case -1483017440: {
                    return new Property("groupSize", "positiveInt", "Number of participants enrolled in the plan.", 0, 1, this.groupSize);
                }
                case 3059661: {
                    return new Property("cost", "Money", "Value of the cost.", 0, 1, this.cost);
                }
                case 950398559: {
                    return new Property("comment", "string", "Additional information about the general costs associated with this plan.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1483017440: {
                    Base[] baseArray;
                    if (this.groupSize == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.groupSize;
                    }
                    return baseArray;
                }
                case 3059661: {
                    Base[] baseArray;
                    if (this.cost == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cost;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1483017440: {
                    this.groupSize = this.castToPositiveInt(value);
                    return value;
                }
                case 3059661: {
                    this.cost = this.castToMoney(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("groupSize")) {
                this.groupSize = this.castToPositiveInt(value);
            } else if (name.equals("cost")) {
                this.cost = this.castToMoney(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1483017440: {
                    return this.getGroupSizeElement();
                }
                case 3059661: {
                    return this.getCost();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1483017440: {
                    return new String[]{"positiveInt"};
                }
                case 3059661: {
                    return new String[]{"Money"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("groupSize")) {
                throw new FHIRException("Cannot call addChild on a primitive type InsurancePlan.groupSize");
            }
            if (name.equals("cost")) {
                this.cost = new Money();
                return this.cost;
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type InsurancePlan.comment");
            }
            return super.addChild(name);
        }

        @Override
        public InsurancePlanPlanGeneralCostComponent copy() {
            InsurancePlanPlanGeneralCostComponent dst = new InsurancePlanPlanGeneralCostComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsurancePlanPlanGeneralCostComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupSize = this.groupSize == null ? null : this.groupSize.copy();
            dst.cost = this.cost == null ? null : this.cost.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanPlanGeneralCostComponent)) {
                return false;
            }
            InsurancePlanPlanGeneralCostComponent o = (InsurancePlanPlanGeneralCostComponent)other_;
            return InsurancePlanPlanGeneralCostComponent.compareDeep(this.type, o.type, true) && InsurancePlanPlanGeneralCostComponent.compareDeep(this.groupSize, o.groupSize, true) && InsurancePlanPlanGeneralCostComponent.compareDeep(this.cost, o.cost, true) && InsurancePlanPlanGeneralCostComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanPlanGeneralCostComponent)) {
                return false;
            }
            InsurancePlanPlanGeneralCostComponent o = (InsurancePlanPlanGeneralCostComponent)other_;
            return InsurancePlanPlanGeneralCostComponent.compareValues(this.groupSize, o.groupSize, true) && InsurancePlanPlanGeneralCostComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.groupSize, this.cost, this.comment);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.plan.generalCost";
        }
    }

    @Block
    public static class InsurancePlanPlanComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Business Identifier for Product", formalDefinition="Business identifiers assigned to this health insurance plan which remain constant as the resource is updated and propagates from server to server.")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of plan", formalDefinition="Type of plan. For example, \"Platinum\" or \"High Deductable\".")
        protected CodeableConcept type;
        @Child(name="coverageArea", type={Location.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Where product applies", formalDefinition="The geographic region in which a health insurance plan's benefits apply.")
        protected List<Reference> coverageArea;
        protected List<Location> coverageAreaTarget;
        @Child(name="network", type={Organization.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What networks provide coverage", formalDefinition="Reference to the network that providing the type of coverage.")
        protected List<Reference> network;
        protected List<Organization> networkTarget;
        @Child(name="generalCost", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Overall costs", formalDefinition="Overall costs associated with the plan.")
        protected List<InsurancePlanPlanGeneralCostComponent> generalCost;
        @Child(name="specificCost", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific costs", formalDefinition="Costs associated with the coverage provided by the product.")
        protected List<InsurancePlanPlanSpecificCostComponent> specificCost;
        private static final long serialVersionUID = -2063324071L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public InsurancePlanPlanComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public InsurancePlanPlanComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanPlanComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public InsurancePlanPlanComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Reference> getCoverageArea() {
            if (this.coverageArea == null) {
                this.coverageArea = new ArrayList<Reference>();
            }
            return this.coverageArea;
        }

        public InsurancePlanPlanComponent setCoverageArea(List<Reference> theCoverageArea) {
            this.coverageArea = theCoverageArea;
            return this;
        }

        public boolean hasCoverageArea() {
            if (this.coverageArea == null) {
                return false;
            }
            for (Reference item : this.coverageArea) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addCoverageArea() {
            Reference t = new Reference();
            if (this.coverageArea == null) {
                this.coverageArea = new ArrayList<Reference>();
            }
            this.coverageArea.add(t);
            return t;
        }

        public InsurancePlanPlanComponent addCoverageArea(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.coverageArea == null) {
                this.coverageArea = new ArrayList<Reference>();
            }
            this.coverageArea.add(t);
            return this;
        }

        public Reference getCoverageAreaFirstRep() {
            if (this.getCoverageArea().isEmpty()) {
                this.addCoverageArea();
            }
            return this.getCoverageArea().get(0);
        }

        @Deprecated
        public List<Location> getCoverageAreaTarget() {
            if (this.coverageAreaTarget == null) {
                this.coverageAreaTarget = new ArrayList<Location>();
            }
            return this.coverageAreaTarget;
        }

        @Deprecated
        public Location addCoverageAreaTarget() {
            Location r = new Location();
            if (this.coverageAreaTarget == null) {
                this.coverageAreaTarget = new ArrayList<Location>();
            }
            this.coverageAreaTarget.add(r);
            return r;
        }

        public List<Reference> getNetwork() {
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            return this.network;
        }

        public InsurancePlanPlanComponent setNetwork(List<Reference> theNetwork) {
            this.network = theNetwork;
            return this;
        }

        public boolean hasNetwork() {
            if (this.network == null) {
                return false;
            }
            for (Reference item : this.network) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addNetwork() {
            Reference t = new Reference();
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return t;
        }

        public InsurancePlanPlanComponent addNetwork(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return this;
        }

        public Reference getNetworkFirstRep() {
            if (this.getNetwork().isEmpty()) {
                this.addNetwork();
            }
            return this.getNetwork().get(0);
        }

        @Deprecated
        public List<Organization> getNetworkTarget() {
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            return this.networkTarget;
        }

        @Deprecated
        public Organization addNetworkTarget() {
            Organization r = new Organization();
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            this.networkTarget.add(r);
            return r;
        }

        public List<InsurancePlanPlanGeneralCostComponent> getGeneralCost() {
            if (this.generalCost == null) {
                this.generalCost = new ArrayList<InsurancePlanPlanGeneralCostComponent>();
            }
            return this.generalCost;
        }

        public InsurancePlanPlanComponent setGeneralCost(List<InsurancePlanPlanGeneralCostComponent> theGeneralCost) {
            this.generalCost = theGeneralCost;
            return this;
        }

        public boolean hasGeneralCost() {
            if (this.generalCost == null) {
                return false;
            }
            for (InsurancePlanPlanGeneralCostComponent item : this.generalCost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InsurancePlanPlanGeneralCostComponent addGeneralCost() {
            InsurancePlanPlanGeneralCostComponent t = new InsurancePlanPlanGeneralCostComponent();
            if (this.generalCost == null) {
                this.generalCost = new ArrayList<InsurancePlanPlanGeneralCostComponent>();
            }
            this.generalCost.add(t);
            return t;
        }

        public InsurancePlanPlanComponent addGeneralCost(InsurancePlanPlanGeneralCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.generalCost == null) {
                this.generalCost = new ArrayList<InsurancePlanPlanGeneralCostComponent>();
            }
            this.generalCost.add(t);
            return this;
        }

        public InsurancePlanPlanGeneralCostComponent getGeneralCostFirstRep() {
            if (this.getGeneralCost().isEmpty()) {
                this.addGeneralCost();
            }
            return this.getGeneralCost().get(0);
        }

        public List<InsurancePlanPlanSpecificCostComponent> getSpecificCost() {
            if (this.specificCost == null) {
                this.specificCost = new ArrayList<InsurancePlanPlanSpecificCostComponent>();
            }
            return this.specificCost;
        }

        public InsurancePlanPlanComponent setSpecificCost(List<InsurancePlanPlanSpecificCostComponent> theSpecificCost) {
            this.specificCost = theSpecificCost;
            return this;
        }

        public boolean hasSpecificCost() {
            if (this.specificCost == null) {
                return false;
            }
            for (InsurancePlanPlanSpecificCostComponent item : this.specificCost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InsurancePlanPlanSpecificCostComponent addSpecificCost() {
            InsurancePlanPlanSpecificCostComponent t = new InsurancePlanPlanSpecificCostComponent();
            if (this.specificCost == null) {
                this.specificCost = new ArrayList<InsurancePlanPlanSpecificCostComponent>();
            }
            this.specificCost.add(t);
            return t;
        }

        public InsurancePlanPlanComponent addSpecificCost(InsurancePlanPlanSpecificCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.specificCost == null) {
                this.specificCost = new ArrayList<InsurancePlanPlanSpecificCostComponent>();
            }
            this.specificCost.add(t);
            return this;
        }

        public InsurancePlanPlanSpecificCostComponent getSpecificCostFirstRep() {
            if (this.getSpecificCost().isEmpty()) {
                this.addSpecificCost();
            }
            return this.getSpecificCost().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InsurancePlan.SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance plan which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of plan. For example, \"Platinum\" or \"High Deductable\".", 0, 1, this.type));
            children.add(new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance plan's benefits apply.", 0, Integer.MAX_VALUE, this.coverageArea));
            children.add(new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network));
            children.add(new Property("generalCost", "", "Overall costs associated with the plan.", 0, Integer.MAX_VALUE, this.generalCost));
            children.add(new Property("specificCost", "", "Costs associated with the coverage provided by the product.", 0, Integer.MAX_VALUE, this.specificCost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(InsurancePlan.SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this health insurance plan which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of plan. For example, \"Platinum\" or \"High Deductable\".", 0, 1, this.type);
                }
                case -1532328299: {
                    return new Property("coverageArea", "Reference(Location)", "The geographic region in which a health insurance plan's benefits apply.", 0, Integer.MAX_VALUE, this.coverageArea);
                }
                case 1843485230: {
                    return new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network);
                }
                case 878344405: {
                    return new Property("generalCost", "", "Overall costs associated with the plan.", 0, Integer.MAX_VALUE, this.generalCost);
                }
                case -1205656545: {
                    return new Property("specificCost", "", "Costs associated with the coverage provided by the product.", 0, Integer.MAX_VALUE, this.specificCost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1532328299: {
                    return this.coverageArea == null ? new Base[]{} : this.coverageArea.toArray(new Base[this.coverageArea.size()]);
                }
                case 1843485230: {
                    return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
                }
                case 878344405: {
                    return this.generalCost == null ? new Base[]{} : this.generalCost.toArray(new Base[this.generalCost.size()]);
                }
                case -1205656545: {
                    return this.specificCost == null ? new Base[]{} : this.specificCost.toArray(new Base[this.specificCost.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1532328299: {
                    this.getCoverageArea().add(this.castToReference(value));
                    return value;
                }
                case 1843485230: {
                    this.getNetwork().add(this.castToReference(value));
                    return value;
                }
                case 878344405: {
                    this.getGeneralCost().add((InsurancePlanPlanGeneralCostComponent)value);
                    return value;
                }
                case -1205656545: {
                    this.getSpecificCost().add((InsurancePlanPlanSpecificCostComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InsurancePlan.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("coverageArea")) {
                this.getCoverageArea().add(this.castToReference(value));
            } else if (name.equals("network")) {
                this.getNetwork().add(this.castToReference(value));
            } else if (name.equals("generalCost")) {
                this.getGeneralCost().add((InsurancePlanPlanGeneralCostComponent)value);
            } else if (name.equals("specificCost")) {
                this.getSpecificCost().add((InsurancePlanPlanSpecificCostComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1532328299: {
                    return this.addCoverageArea();
                }
                case 1843485230: {
                    return this.addNetwork();
                }
                case 878344405: {
                    return this.addGeneralCost();
                }
                case -1205656545: {
                    return this.addSpecificCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1532328299: {
                    return new String[]{"Reference"};
                }
                case 1843485230: {
                    return new String[]{"Reference"};
                }
                case 878344405: {
                    return new String[0];
                }
                case -1205656545: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InsurancePlan.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("coverageArea")) {
                return this.addCoverageArea();
            }
            if (name.equals("network")) {
                return this.addNetwork();
            }
            if (name.equals("generalCost")) {
                return this.addGeneralCost();
            }
            if (name.equals("specificCost")) {
                return this.addSpecificCost();
            }
            return super.addChild(name);
        }

        @Override
        public InsurancePlanPlanComponent copy() {
            InsurancePlanPlanComponent dst = new InsurancePlanPlanComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsurancePlanPlanComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.coverageArea != null) {
                dst.coverageArea = new ArrayList<Reference>();
                for (Reference reference : this.coverageArea) {
                    dst.coverageArea.add(reference.copy());
                }
            }
            if (this.network != null) {
                dst.network = new ArrayList<Reference>();
                for (Reference reference : this.network) {
                    dst.network.add(reference.copy());
                }
            }
            if (this.generalCost != null) {
                dst.generalCost = new ArrayList<InsurancePlanPlanGeneralCostComponent>();
                for (InsurancePlanPlanGeneralCostComponent insurancePlanPlanGeneralCostComponent : this.generalCost) {
                    dst.generalCost.add(insurancePlanPlanGeneralCostComponent.copy());
                }
            }
            if (this.specificCost != null) {
                dst.specificCost = new ArrayList<InsurancePlanPlanSpecificCostComponent>();
                for (InsurancePlanPlanSpecificCostComponent insurancePlanPlanSpecificCostComponent : this.specificCost) {
                    dst.specificCost.add(insurancePlanPlanSpecificCostComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanPlanComponent)) {
                return false;
            }
            InsurancePlanPlanComponent o = (InsurancePlanPlanComponent)other_;
            return InsurancePlanPlanComponent.compareDeep(this.identifier, o.identifier, true) && InsurancePlanPlanComponent.compareDeep(this.type, o.type, true) && InsurancePlanPlanComponent.compareDeep(this.coverageArea, o.coverageArea, true) && InsurancePlanPlanComponent.compareDeep(this.network, o.network, true) && InsurancePlanPlanComponent.compareDeep(this.generalCost, o.generalCost, true) && InsurancePlanPlanComponent.compareDeep(this.specificCost, o.specificCost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanPlanComponent)) {
                return false;
            }
            InsurancePlanPlanComponent o = (InsurancePlanPlanComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.type, this.coverageArea, this.network, this.generalCost, this.specificCost);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.plan";
        }
    }

    @Block
    public static class CoverageBenefitLimitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum value allowed", formalDefinition="The maximum amount of a service item a plan will pay for a covered benefit.  For examples. wellness visits, or eyeglasses.")
        protected Quantity value;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit limit details", formalDefinition="The specific limit on the benefit.")
        protected CodeableConcept code;
        private static final long serialVersionUID = -304318128L;

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageBenefitLimitComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CoverageBenefitLimitComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageBenefitLimitComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CoverageBenefitLimitComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value", "Quantity", "The maximum amount of a service item a plan will pay for a covered benefit.  For examples. wellness visits, or eyeglasses.", 0, 1, this.value));
            children.add(new Property("code", "CodeableConcept", "The specific limit on the benefit.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 111972721: {
                    return new Property("value", "Quantity", "The maximum amount of a service item a plan will pay for a covered benefit.  For examples. wellness visits, or eyeglasses.", 0, 1, this.value);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The specific limit on the benefit.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToQuantity(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = this.castToQuantity(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return this.getValue();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"Quantity"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public CoverageBenefitLimitComponent copy() {
            CoverageBenefitLimitComponent dst = new CoverageBenefitLimitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CoverageBenefitLimitComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageBenefitLimitComponent)) {
                return false;
            }
            CoverageBenefitLimitComponent o = (CoverageBenefitLimitComponent)other_;
            return CoverageBenefitLimitComponent.compareDeep(this.value, o.value, true) && CoverageBenefitLimitComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageBenefitLimitComponent)) {
                return false;
            }
            CoverageBenefitLimitComponent o = (CoverageBenefitLimitComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.value, this.code);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.coverage.benefit.limit";
        }
    }

    @Block
    public static class CoverageBenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of benefit", formalDefinition="Type of benefit (primary care; speciality care; inpatient; outpatient).")
        protected CodeableConcept type;
        @Child(name="requirement", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Referral requirements", formalDefinition="The referral requirements to have access/coverage for this benefit.")
        protected StringType requirement;
        @Child(name="limit", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit limits", formalDefinition="The specific limits on the benefit.")
        protected List<CoverageBenefitLimitComponent> limit;
        private static final long serialVersionUID = -113658449L;

        public CoverageBenefitComponent() {
        }

        public CoverageBenefitComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageBenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CoverageBenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getRequirementElement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageBenefitComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new StringType();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirementElement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public CoverageBenefitComponent setRequirementElement(StringType value) {
            this.requirement = value;
            return this;
        }

        public String getRequirement() {
            return this.requirement == null ? null : (String)this.requirement.getValue();
        }

        public CoverageBenefitComponent setRequirement(String value) {
            if (Utilities.noString(value)) {
                this.requirement = null;
            } else {
                if (this.requirement == null) {
                    this.requirement = new StringType();
                }
                this.requirement.setValue(value);
            }
            return this;
        }

        public List<CoverageBenefitLimitComponent> getLimit() {
            if (this.limit == null) {
                this.limit = new ArrayList<CoverageBenefitLimitComponent>();
            }
            return this.limit;
        }

        public CoverageBenefitComponent setLimit(List<CoverageBenefitLimitComponent> theLimit) {
            this.limit = theLimit;
            return this;
        }

        public boolean hasLimit() {
            if (this.limit == null) {
                return false;
            }
            for (CoverageBenefitLimitComponent item : this.limit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CoverageBenefitLimitComponent addLimit() {
            CoverageBenefitLimitComponent t = new CoverageBenefitLimitComponent();
            if (this.limit == null) {
                this.limit = new ArrayList<CoverageBenefitLimitComponent>();
            }
            this.limit.add(t);
            return t;
        }

        public CoverageBenefitComponent addLimit(CoverageBenefitLimitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.limit == null) {
                this.limit = new ArrayList<CoverageBenefitLimitComponent>();
            }
            this.limit.add(t);
            return this;
        }

        public CoverageBenefitLimitComponent getLimitFirstRep() {
            if (this.getLimit().isEmpty()) {
                this.addLimit();
            }
            return this.getLimit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of benefit (primary care; speciality care; inpatient; outpatient).", 0, 1, this.type));
            children.add(new Property("requirement", "string", "The referral requirements to have access/coverage for this benefit.", 0, 1, this.requirement));
            children.add(new Property("limit", "", "The specific limits on the benefit.", 0, Integer.MAX_VALUE, this.limit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of benefit (primary care; speciality care; inpatient; outpatient).", 0, 1, this.type);
                }
                case 363387971: {
                    return new Property("requirement", "string", "The referral requirements to have access/coverage for this benefit.", 0, 1, this.requirement);
                }
                case 102976443: {
                    return new Property("limit", "", "The specific limits on the benefit.", 0, Integer.MAX_VALUE, this.limit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 102976443: {
                    return this.limit == null ? new Base[]{} : this.limit.toArray(new Base[this.limit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = this.castToString(value);
                    return value;
                }
                case 102976443: {
                    this.getLimit().add((CoverageBenefitLimitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("requirement")) {
                this.requirement = this.castToString(value);
            } else if (name.equals("limit")) {
                this.getLimit().add((CoverageBenefitLimitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 363387971: {
                    return this.getRequirementElement();
                }
                case 102976443: {
                    return this.addLimit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 363387971: {
                    return new String[]{"string"};
                }
                case 102976443: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("requirement")) {
                throw new FHIRException("Cannot call addChild on a primitive type InsurancePlan.requirement");
            }
            if (name.equals("limit")) {
                return this.addLimit();
            }
            return super.addChild(name);
        }

        @Override
        public CoverageBenefitComponent copy() {
            CoverageBenefitComponent dst = new CoverageBenefitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CoverageBenefitComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.requirement = this.requirement == null ? null : this.requirement.copy();
            if (this.limit != null) {
                dst.limit = new ArrayList<CoverageBenefitLimitComponent>();
                for (CoverageBenefitLimitComponent i2 : this.limit) {
                    dst.limit.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageBenefitComponent)) {
                return false;
            }
            CoverageBenefitComponent o = (CoverageBenefitComponent)other_;
            return CoverageBenefitComponent.compareDeep(this.type, o.type, true) && CoverageBenefitComponent.compareDeep(this.requirement, o.requirement, true) && CoverageBenefitComponent.compareDeep(this.limit, o.limit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageBenefitComponent)) {
                return false;
            }
            CoverageBenefitComponent o = (CoverageBenefitComponent)other_;
            return CoverageBenefitComponent.compareValues(this.requirement, o.requirement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.requirement, this.limit);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.coverage.benefit";
        }
    }

    @Block
    public static class InsurancePlanCoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of coverage", formalDefinition="Type of coverage  (Medical; Dental; Mental Health; Substance Abuse; Vision; Drug; Short Term; Long Term Care; Hospice; Home Health).")
        protected CodeableConcept type;
        @Child(name="network", type={Organization.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What networks provide coverage", formalDefinition="Reference to the network that providing the type of coverage.")
        protected List<Reference> network;
        protected List<Organization> networkTarget;
        @Child(name="benefit", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of benefits", formalDefinition="Specific benefits under this type of coverage.")
        protected List<CoverageBenefitComponent> benefit;
        private static final long serialVersionUID = -1186191877L;

        public InsurancePlanCoverageComponent() {
        }

        public InsurancePlanCoverageComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanCoverageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public InsurancePlanCoverageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Reference> getNetwork() {
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            return this.network;
        }

        public InsurancePlanCoverageComponent setNetwork(List<Reference> theNetwork) {
            this.network = theNetwork;
            return this;
        }

        public boolean hasNetwork() {
            if (this.network == null) {
                return false;
            }
            for (Reference item : this.network) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addNetwork() {
            Reference t = new Reference();
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return t;
        }

        public InsurancePlanCoverageComponent addNetwork(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.network == null) {
                this.network = new ArrayList<Reference>();
            }
            this.network.add(t);
            return this;
        }

        public Reference getNetworkFirstRep() {
            if (this.getNetwork().isEmpty()) {
                this.addNetwork();
            }
            return this.getNetwork().get(0);
        }

        @Deprecated
        public List<Organization> getNetworkTarget() {
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            return this.networkTarget;
        }

        @Deprecated
        public Organization addNetworkTarget() {
            Organization r = new Organization();
            if (this.networkTarget == null) {
                this.networkTarget = new ArrayList<Organization>();
            }
            this.networkTarget.add(r);
            return r;
        }

        public List<CoverageBenefitComponent> getBenefit() {
            if (this.benefit == null) {
                this.benefit = new ArrayList<CoverageBenefitComponent>();
            }
            return this.benefit;
        }

        public InsurancePlanCoverageComponent setBenefit(List<CoverageBenefitComponent> theBenefit) {
            this.benefit = theBenefit;
            return this;
        }

        public boolean hasBenefit() {
            if (this.benefit == null) {
                return false;
            }
            for (CoverageBenefitComponent item : this.benefit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CoverageBenefitComponent addBenefit() {
            CoverageBenefitComponent t = new CoverageBenefitComponent();
            if (this.benefit == null) {
                this.benefit = new ArrayList<CoverageBenefitComponent>();
            }
            this.benefit.add(t);
            return t;
        }

        public InsurancePlanCoverageComponent addBenefit(CoverageBenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.benefit == null) {
                this.benefit = new ArrayList<CoverageBenefitComponent>();
            }
            this.benefit.add(t);
            return this;
        }

        public CoverageBenefitComponent getBenefitFirstRep() {
            if (this.getBenefit().isEmpty()) {
                this.addBenefit();
            }
            return this.getBenefit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of coverage  (Medical; Dental; Mental Health; Substance Abuse; Vision; Drug; Short Term; Long Term Care; Hospice; Home Health).", 0, 1, this.type));
            children.add(new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network));
            children.add(new Property("benefit", "", "Specific benefits under this type of coverage.", 0, Integer.MAX_VALUE, this.benefit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(InsurancePlan.SP_TYPE, "CodeableConcept", "Type of coverage  (Medical; Dental; Mental Health; Substance Abuse; Vision; Drug; Short Term; Long Term Care; Hospice; Home Health).", 0, 1, this.type);
                }
                case 1843485230: {
                    return new Property("network", "Reference(Organization)", "Reference to the network that providing the type of coverage.", 0, Integer.MAX_VALUE, this.network);
                }
                case -222710633: {
                    return new Property("benefit", "", "Specific benefits under this type of coverage.", 0, Integer.MAX_VALUE, this.benefit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
                }
                case -222710633: {
                    return this.benefit == null ? new Base[]{} : this.benefit.toArray(new Base[this.benefit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1843485230: {
                    this.getNetwork().add(this.castToReference(value));
                    return value;
                }
                case -222710633: {
                    this.getBenefit().add((CoverageBenefitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("network")) {
                this.getNetwork().add(this.castToReference(value));
            } else if (name.equals("benefit")) {
                this.getBenefit().add((CoverageBenefitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1843485230: {
                    return this.addNetwork();
                }
                case -222710633: {
                    return this.addBenefit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1843485230: {
                    return new String[]{"Reference"};
                }
                case -222710633: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InsurancePlan.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("network")) {
                return this.addNetwork();
            }
            if (name.equals("benefit")) {
                return this.addBenefit();
            }
            return super.addChild(name);
        }

        @Override
        public InsurancePlanCoverageComponent copy() {
            InsurancePlanCoverageComponent dst = new InsurancePlanCoverageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsurancePlanCoverageComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.network != null) {
                dst.network = new ArrayList<Reference>();
                for (Reference reference : this.network) {
                    dst.network.add(reference.copy());
                }
            }
            if (this.benefit != null) {
                dst.benefit = new ArrayList<CoverageBenefitComponent>();
                for (CoverageBenefitComponent coverageBenefitComponent : this.benefit) {
                    dst.benefit.add(coverageBenefitComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanCoverageComponent)) {
                return false;
            }
            InsurancePlanCoverageComponent o = (InsurancePlanCoverageComponent)other_;
            return InsurancePlanCoverageComponent.compareDeep(this.type, o.type, true) && InsurancePlanCoverageComponent.compareDeep(this.network, o.network, true) && InsurancePlanCoverageComponent.compareDeep(this.benefit, o.benefit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanCoverageComponent)) {
                return false;
            }
            InsurancePlanCoverageComponent o = (InsurancePlanCoverageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.network, this.benefit);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.coverage";
        }
    }

    @Block
    public static class InsurancePlanContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="purpose", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of contact", formalDefinition="Indicates a purpose for which the contact can be reached.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contactentity-type")
        protected CodeableConcept purpose;
        @Child(name="name", type={HumanName.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the contact", formalDefinition="A name associated with the contact.")
        protected HumanName name;
        @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details (telephone, email, etc.)  for a contact", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
        protected List<ContactPoint> telecom;
        @Child(name="address", type={Address.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Visiting or postal addresses for the contact", formalDefinition="Visiting or postal addresses for the contact.")
        protected Address address;
        private static final long serialVersionUID = 1831121305L;

        public CodeableConcept getPurpose() {
            if (this.purpose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanContactComponent.purpose");
                }
                if (Configuration.doAutoCreate()) {
                    this.purpose = new CodeableConcept();
                }
            }
            return this.purpose;
        }

        public boolean hasPurpose() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public InsurancePlanContactComponent setPurpose(CodeableConcept value) {
            this.purpose = value;
            return this;
        }

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public InsurancePlanContactComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public InsurancePlanContactComponent setTelecom(List<ContactPoint> theTelecom) {
            this.telecom = theTelecom;
            return this;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public InsurancePlanContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public ContactPoint getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public Address getAddress() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsurancePlanContactComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new Address();
                }
            }
            return this.address;
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public InsurancePlanContactComponent setAddress(Address value) {
            this.address = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, 1, this.purpose));
            children.add(new Property(InsurancePlan.SP_NAME, "HumanName", "A name associated with the contact.", 0, 1, this.name));
            children.add(new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
            children.add(new Property(InsurancePlan.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, 1, this.address));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -220463842: {
                    return new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, 1, this.purpose);
                }
                case 3373707: {
                    return new Property(InsurancePlan.SP_NAME, "HumanName", "A name associated with the contact.", 0, 1, this.name);
                }
                case -1429363305: {
                    return new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom);
                }
                case -1147692044: {
                    return new Property(InsurancePlan.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, 1, this.address);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    Base[] baseArray;
                    if (this.purpose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.purpose;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case -1147692044: {
                    Base[] baseArray;
                    if (this.address == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.address;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    this.purpose = this.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToHumanName(value);
                    return value;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    return value;
                }
                case -1147692044: {
                    this.address = this.castToAddress(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = this.castToCodeableConcept(value);
            } else if (name.equals(InsurancePlan.SP_NAME)) {
                this.name = this.castToHumanName(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals(InsurancePlan.SP_ADDRESS)) {
                this.address = this.castToAddress(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return this.getPurpose();
                }
                case 3373707: {
                    return this.getName();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case -1147692044: {
                    return this.getAddress();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"HumanName"};
                }
                case -1429363305: {
                    return new String[]{"ContactPoint"};
                }
                case -1147692044: {
                    return new String[]{"Address"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = new CodeableConcept();
                return this.purpose;
            }
            if (name.equals(InsurancePlan.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            if (name.equals(InsurancePlan.SP_ADDRESS)) {
                this.address = new Address();
                return this.address;
            }
            return super.addChild(name);
        }

        @Override
        public InsurancePlanContactComponent copy() {
            InsurancePlanContactComponent dst = new InsurancePlanContactComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsurancePlanContactComponent dst) {
            super.copyValues(dst);
            dst.purpose = this.purpose == null ? null : this.purpose.copy();
            HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i2 : this.telecom) {
                    dst.telecom.add(i2.copy());
                }
            }
            dst.address = this.address == null ? null : this.address.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanContactComponent)) {
                return false;
            }
            InsurancePlanContactComponent o = (InsurancePlanContactComponent)other_;
            return InsurancePlanContactComponent.compareDeep(this.purpose, o.purpose, true) && InsurancePlanContactComponent.compareDeep(this.name, o.name, true) && InsurancePlanContactComponent.compareDeep(this.telecom, o.telecom, true) && InsurancePlanContactComponent.compareDeep(this.address, o.address, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsurancePlanContactComponent)) {
                return false;
            }
            InsurancePlanContactComponent o = (InsurancePlanContactComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.purpose, this.name, this.telecom, this.address);
        }

        @Override
        public String fhirType() {
            return "InsurancePlan.contact";
        }
    }
}

