/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;

@ResourceDef(name="EnrollmentRequest", profile="http://hl7.org/fhir/StructureDefinition/EnrollmentRequest")
public class EnrollmentRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<EnrollmentRequestStatus> status;
    @Child(name="created", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="insurer", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Target", formalDefinition="The Insurer who is target  of the request.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference provider;
    protected Resource providerTarget;
    @Child(name="candidate", type={Patient.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject to be enrolled", formalDefinition="Patient Resource.")
    protected Reference candidate;
    protected Patient candidateTarget;
    @Child(name="coverage", type={Coverage.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
    protected Reference coverage;
    protected Coverage coverageTarget;
    private static final long serialVersionUID = 631501951L;
    @SearchParamDefinition(name="identifier", path="EnrollmentRequest.identifier", description="The business identifier of the Enrollment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="EnrollmentRequest.candidate", description="The party to be enrolled", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("EnrollmentRequest:subject").toLocked();
    @SearchParamDefinition(name="patient", path="EnrollmentRequest.candidate", description="The party to be enrolled", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EnrollmentRequest:patient").toLocked();
    @SearchParamDefinition(name="status", path="EnrollmentRequest.status", description="The status of the enrollment", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EnrollmentRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EnrollmentRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EnrollmentRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EnrollmentRequestStatus>(new EnrollmentRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EnrollmentRequest setStatusElement(Enumeration<EnrollmentRequestStatus> value) {
        this.status = value;
        return this;
    }

    public EnrollmentRequestStatus getStatus() {
        return this.status == null ? null : (EnrollmentRequestStatus)((Object)this.status.getValue());
    }

    public EnrollmentRequest setStatus(EnrollmentRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<EnrollmentRequestStatus>(new EnrollmentRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EnrollmentRequest setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EnrollmentRequest setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public EnrollmentRequest setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public EnrollmentRequest setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public EnrollmentRequest setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Resource getProviderTarget() {
        return this.providerTarget;
    }

    public EnrollmentRequest setProviderTarget(Resource value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getCandidate() {
        if (this.candidate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.candidate");
            }
            if (Configuration.doAutoCreate()) {
                this.candidate = new Reference();
            }
        }
        return this.candidate;
    }

    public boolean hasCandidate() {
        return this.candidate != null && !this.candidate.isEmpty();
    }

    public EnrollmentRequest setCandidate(Reference value) {
        this.candidate = value;
        return this;
    }

    public Patient getCandidateTarget() {
        if (this.candidateTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.candidate");
            }
            if (Configuration.doAutoCreate()) {
                this.candidateTarget = new Patient();
            }
        }
        return this.candidateTarget;
    }

    public EnrollmentRequest setCandidateTarget(Patient value) {
        this.candidateTarget = value;
        return this;
    }

    public Reference getCoverage() {
        if (this.coverage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.coverage");
            }
            if (Configuration.doAutoCreate()) {
                this.coverage = new Reference();
            }
        }
        return this.coverage;
    }

    public boolean hasCoverage() {
        return this.coverage != null && !this.coverage.isEmpty();
    }

    public EnrollmentRequest setCoverage(Reference value) {
        this.coverage = value;
        return this;
    }

    public Coverage getCoverageTarget() {
        if (this.coverageTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentRequest.coverage");
            }
            if (Configuration.doAutoCreate()) {
                this.coverageTarget = new Coverage();
            }
        }
        return this.coverageTarget;
    }

    public EnrollmentRequest setCoverageTarget(Coverage value) {
        this.coverageTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("created", "dateTime", "The date when this resource was created.", 0, 1, this.created));
        children.add(new Property("insurer", "Reference(Organization)", "The Insurer who is target  of the request.", 0, 1, this.insurer));
        children.add(new Property("provider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.provider));
        children.add(new Property("candidate", "Reference(Patient)", "Patient Resource.", 0, 1, this.candidate));
        children.add(new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date when this resource was created.", 0, 1, this.created);
            }
            case 1957615864: {
                return new Property("insurer", "Reference(Organization)", "The Insurer who is target  of the request.", 0, 1, this.insurer);
            }
            case -987494927: {
                return new Property("provider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.provider);
            }
            case 508663171: {
                return new Property("candidate", "Reference(Patient)", "Patient Resource.", 0, 1, this.candidate);
            }
            case -351767064: {
                return new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.created;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.insurer;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.provider;
                }
                return baseArray;
            }
            case 508663171: {
                Base[] baseArray;
                if (this.candidate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.candidate;
                }
                return baseArray;
            }
            case -351767064: {
                Base[] baseArray;
                if (this.coverage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.coverage;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EnrollmentRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case 508663171: {
                this.candidate = this.castToReference(value);
                return value;
            }
            case -351767064: {
                this.coverage = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EnrollmentRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("insurer")) {
            this.insurer = this.castToReference(value);
        } else if (name.equals("provider")) {
            this.provider = this.castToReference(value);
        } else if (name.equals("candidate")) {
            this.candidate = this.castToReference(value);
        } else if (name.equals("coverage")) {
            this.coverage = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case -987494927: {
                return this.getProvider();
            }
            case 508663171: {
                return this.getCandidate();
            }
            case -351767064: {
                return this.getCoverage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case 508663171: {
                return new String[]{"Reference"};
            }
            case -351767064: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EnrollmentRequest.status");
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type EnrollmentRequest.created");
        }
        if (name.equals("insurer")) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals("provider")) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("candidate")) {
            this.candidate = new Reference();
            return this.candidate;
        }
        if (name.equals("coverage")) {
            this.coverage = new Reference();
            return this.coverage;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EnrollmentRequest";
    }

    @Override
    public EnrollmentRequest copy() {
        EnrollmentRequest dst = new EnrollmentRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EnrollmentRequest dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i2 : this.identifier) {
                dst.identifier.add(i2.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.candidate = this.candidate == null ? null : this.candidate.copy();
        dst.coverage = this.coverage == null ? null : this.coverage.copy();
    }

    protected EnrollmentRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EnrollmentRequest)) {
            return false;
        }
        EnrollmentRequest o = (EnrollmentRequest)other_;
        return EnrollmentRequest.compareDeep(this.identifier, o.identifier, true) && EnrollmentRequest.compareDeep(this.status, o.status, true) && EnrollmentRequest.compareDeep(this.created, o.created, true) && EnrollmentRequest.compareDeep(this.insurer, o.insurer, true) && EnrollmentRequest.compareDeep(this.provider, o.provider, true) && EnrollmentRequest.compareDeep(this.candidate, o.candidate, true) && EnrollmentRequest.compareDeep(this.coverage, o.coverage, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EnrollmentRequest)) {
            return false;
        }
        EnrollmentRequest o = (EnrollmentRequest)other_;
        return EnrollmentRequest.compareValues(this.status, o.status, true) && EnrollmentRequest.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.created, this.insurer, this.provider, this.candidate, this.coverage);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EnrollmentRequest;
    }

    public static class EnrollmentRequestStatusEnumFactory
    implements EnumFactory<EnrollmentRequestStatus> {
        @Override
        public EnrollmentRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EnrollmentRequestStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return EnrollmentRequestStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return EnrollmentRequestStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return EnrollmentRequestStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EnrollmentRequestStatus code '" + codeString + "'");
        }

        public Enumeration<EnrollmentRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EnrollmentRequestStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EnrollmentRequestStatus>(this, EnrollmentRequestStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EnrollmentRequestStatus>(this, EnrollmentRequestStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<EnrollmentRequestStatus>(this, EnrollmentRequestStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EnrollmentRequestStatus>(this, EnrollmentRequestStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown EnrollmentRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EnrollmentRequestStatus code) {
            if (code == EnrollmentRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == EnrollmentRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EnrollmentRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == EnrollmentRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EnrollmentRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum EnrollmentRequestStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static EnrollmentRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EnrollmentRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

