/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.utilities.Utilities;

public class Comparison {
    public static boolean matches(String c1, String c2, MatchProfile profile2) {
        if (Utilities.noString(c1) || Utilities.noString(c2)) {
            return false;
        }
        c1 = Utilities.normalize(c1);
        c2 = Utilities.normalize(c2);
        return c1.equals(c2);
    }

    public static <T extends Enum<?>> boolean matches(Enumeration<T> e1, Enumeration<T> e2, MatchProfile profile2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        return ((Enum)e1.getValue()).equals(e2.getValue());
    }

    public static boolean matches(CodeableConcept c1, CodeableConcept c2, MatchProfile profile2) throws FHIRException {
        if (profile2 != null) {
            throw new NotImplementedException("Not Implemented Yet");
        }
        if (c1.getCoding().isEmpty() && c2.getCoding().isEmpty()) {
            return Comparison.matches(c1.getText(), c2.getText(), null);
        }
        boolean ok = true;
        for (Coding c : c1.getCoding()) {
            ok = ok && Comparison.inList(c2.getCoding(), c, null);
        }
        for (Coding c : c2.getCoding()) {
            ok = ok && Comparison.inList(c1.getCoding(), c, null);
        }
        return ok;
    }

    public static void merge(CodeableConcept dst, CodeableConcept src) {
        if (dst.getTextElement() == null && src.getTextElement() != null) {
            dst.setTextElement(src.getTextElement());
        }
    }

    public static boolean inList(List<Coding> list, Coding c, MatchProfile profile2) {
        for (Coding item : list) {
            if (!Comparison.matches(item, c, profile2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Coding c1, Coding c2, MatchProfile profile2) {
        if (profile2 != null) {
            throw new NotImplementedException("Not Implemented Yet");
        }
        return Comparison.matches(c1.getSystem(), c2.getSystem(), null) && Comparison.matches(c1.getCode(), c2.getCode(), null);
    }

    public static boolean matches(Identifier i1, Identifier i2, MatchProfile profile2) {
        if (profile2 != null) {
            throw new NotImplementedException("Not Implemented Yet");
        }
        return Comparison.matches(i1.getSystem(), i2.getSystem(), null) && Comparison.matches(i1.getValue(), i2.getValue(), null);
    }

    public static void merge(Identifier dst, Identifier src) {
        if (dst.getUseElement() == null && src.getUseElement() != null) {
            dst.setUseElement(src.getUseElement());
        }
        if (dst.getType() == null && src.getType() != null) {
            dst.setType(src.getType());
        }
        if (dst.getPeriod() == null && src.getPeriod() != null) {
            dst.setPeriod(src.getPeriod());
        }
        if (dst.getAssigner() == null && src.getAssigner() != null) {
            dst.setAssigner(src.getAssigner());
        }
    }

    public static boolean matches(ContactPoint c1, ContactPoint c2, Object profile2) {
        if (profile2 != null) {
            throw new NotImplementedException("Not Implemented Yet");
        }
        return Comparison.matches(c1.getSystemElement(), c2.getSystemElement(), null) && Comparison.matches(c1.getValue(), c2.getValue(), null);
    }

    public static void merge(ContactPoint dst, ContactPoint src) {
        if (dst.getUseElement() == null && src.getUseElement() != null) {
            dst.setUseElement(src.getUseElement());
        }
        if (dst.getPeriod() == null && src.getPeriod() != null) {
            dst.setPeriod(src.getPeriod());
        }
    }

    public class MatchProfile {
    }
}

