/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ICoding;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="code", profileOf=StringType.class)
public class CodeType
extends StringType
implements Comparable<CodeType>,
ICoding {
    private static final long serialVersionUID = 3L;
    private String system;

    public CodeType() {
    }

    public CodeType(String theCode) {
        this.setValue(theCode);
    }

    @Override
    public int compareTo(CodeType theCode) {
        if (theCode == null) {
            return 1;
        }
        return StringUtils.defaultString((String)((String)this.getValue())).compareTo(StringUtils.defaultString((String)((String)theCode.getValue())));
    }

    @Override
    protected String parse(String theValue) {
        return theValue.trim();
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    @Override
    public CodeType copy() {
        CodeType ret = new CodeType((String)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "code";
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public boolean hasSystem() {
        return this.system != null;
    }

    public CodeType setSystem(String system) {
        this.system = system;
        return this;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasVersion() {
        return false;
    }

    @Override
    public String getDisplay() {
        return null;
    }

    @Override
    public boolean hasDisplay() {
        return false;
    }

    @Override
    public String getCode() {
        return this.asStringValue();
    }

    @Override
    public boolean hasCode() {
        return !Utilities.noString(this.asStringValue());
    }

    @Override
    public boolean supportsVersion() {
        return false;
    }

    @Override
    public boolean supportsDisplay() {
        return false;
    }
}

