/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResponseCode {
    OK,
    TRANSIENTERROR,
    FATALERROR,
    NULL;


    public static ResponseCode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ok".equals(codeString)) {
            return OK;
        }
        if ("transient-error".equals(codeString)) {
            return TRANSIENTERROR;
        }
        if ("fatal-error".equals(codeString)) {
            return FATALERROR;
        }
        throw new FHIRException("Unknown ResponseCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OK: {
                return "ok";
            }
            case TRANSIENTERROR: {
                return "transient-error";
            }
            case FATALERROR: {
                return "fatal-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/response-code";
    }

    public String getDefinition() {
        switch (this) {
            case OK: {
                return "The message was accepted and processed without error.";
            }
            case TRANSIENTERROR: {
                return "Some internal unexpected error occurred - wait and try again. Note - this is usually used for things like database unavailable, which may be expected to resolve, though human intervention may be required.";
            }
            case FATALERROR: {
                return "The message was rejected because of a problem with the content. There is no point in re-sending without change. The response narrative SHALL describe the issue.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OK: {
                return "OK";
            }
            case TRANSIENTERROR: {
                return "Transient Error";
            }
            case FATALERROR: {
                return "Fatal Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

