/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CompartmentType {
    PATIENT,
    ENCOUNTER,
    RELATEDPERSON,
    PRACTITIONER,
    DEVICE,
    NULL;


    public static CompartmentType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Patient".equals(codeString)) {
            return PATIENT;
        }
        if ("Encounter".equals(codeString)) {
            return ENCOUNTER;
        }
        if ("RelatedPerson".equals(codeString)) {
            return RELATEDPERSON;
        }
        if ("Practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("Device".equals(codeString)) {
            return DEVICE;
        }
        throw new FHIRException("Unknown CompartmentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENT: {
                return "Patient";
            }
            case ENCOUNTER: {
                return "Encounter";
            }
            case RELATEDPERSON: {
                return "RelatedPerson";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case DEVICE: {
                return "Device";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/compartment-type";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENT: {
                return "The compartment definition is for the patient compartment";
            }
            case ENCOUNTER: {
                return "The compartment definition is for the encounter compartment";
            }
            case RELATEDPERSON: {
                return "The compartment definition is for the related-person compartment";
            }
            case PRACTITIONER: {
                return "The compartment definition is for the practitioner compartment";
            }
            case DEVICE: {
                return "The compartment definition is for the device compartment";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENT: {
                return "Patient";
            }
            case ENCOUNTER: {
                return "Encounter";
            }
            case RELATEDPERSON: {
                return "RelatedPerson";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case DEVICE: {
                return "Device";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

